/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.study;

import com.sas.lsaf.clinical.common.BatchFileCreateInfo;
import com.sas.lsaf.clinical.common.ExportException;
import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.common.ImportException;
import com.sas.lsaf.clinical.common.UpdateAction;
import com.sas.lsaf.clinical.common.ValidationReportException;
import com.sas.lsaf.clinical.dictionary.DictionaryDescriptor;
import com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException;
import com.sas.lsaf.clinical.dictionary.ExternalDictionary;
import com.sas.lsaf.clinical.standards.StandardDescriptor;
import com.sas.lsaf.clinical.standards.StandardNotFoundException;
import com.sas.lsaf.clinical.study.ExternalDictionaryAssociationExistsException;
import com.sas.lsaf.clinical.study.ExternalDictionaryAssociationNotFoundException;
import com.sas.lsaf.clinical.study.StandardAssociationExistsException;
import com.sas.lsaf.clinical.study.StandardAssociationNotFoundException;
import com.sas.lsaf.clinical.study.Study;
import com.sas.lsaf.clinical.study.StudyCodeListUpdateException;
import com.sas.lsaf.clinical.study.StudyComponent;
import com.sas.lsaf.clinical.study.StudyComponentEditException;
import com.sas.lsaf.clinical.study.StudyComponentEditableStatus;
import com.sas.lsaf.clinical.study.StudyComponentImportInfo;
import com.sas.lsaf.clinical.study.StudyDictionaryException;
import com.sas.lsaf.clinical.study.StudyNotFoundException;
import com.sas.lsaf.clinical.study.StudySupportingDocumentUpdateException;
import com.sas.lsaf.clinical.study.StudyTableUpdateException;
import com.sas.lsaf.clinical.study.StudyTablesImportInfo;
import com.sas.lsaf.clinical.study.StudyUpdateException;
import com.sas.lsaf.clinical.study.StudyUpdateResult;
import com.sas.lsaf.clinical.study.StudyValueLevelMetadataUpdateException;
import com.sas.lsaf.clinical.tlf.TlfImportInfo;
import com.sas.lsaf.clinical.tlf.TlfUpdateException;
import com.sas.lsaf.core.SourceLocation;
import java.util.List;
import java.util.Set;

public interface StudyService {
    public Set<Study> getStudiesAssociatedWithStandard(String var1) throws StandardNotFoundException;

    public Set<Study> getStudiesAssociatedWithDictionary(String var1) throws DictionaryNotFoundException;

    public Set<Study> getStudiesAssociatedWithExternalDictionary(String var1) throws DictionaryNotFoundException;

    public void associateStandards(String var1, Set<String> var2) throws StudyNotFoundException, StandardNotFoundException, StandardAssociationExistsException;

    public void disassociateStandards(String var1, Set<String> var2) throws StudyNotFoundException, StandardAssociationNotFoundException;

    public void disassociateExternalDictionaries(String var1, Set<String> var2) throws StudyNotFoundException, ExternalDictionaryAssociationNotFoundException;

    public void associateExternalDictionaries(String var1, Set<String> var2) throws StudyNotFoundException, DictionaryNotFoundException, ExternalDictionaryAssociationExistsException;

    public void associateDictionaries(String var1, List<String> var2) throws StudyNotFoundException, DictionaryNotFoundException, StudyDictionaryException;

    public Set<StandardDescriptor> getStandardsAssociatedWithStudy(String var1) throws StudyNotFoundException;

    public List<DictionaryDescriptor> getDictionariesAssociatedWithStudy(String var1) throws StudyNotFoundException;

    public Set<ExternalDictionary> getExternalDictionariesAssociatedWithStudy(String var1) throws StudyNotFoundException;

    public StudyComponentEditableStatus getStudyComponentEditableStatus(String var1, StudyComponent var2) throws StudyNotFoundException;

    public StudyComponentEditableStatus setStudyComponentEditableByCurrentUser(String var1, StudyComponent var2) throws StudyNotFoundException, StudyComponentEditException;

    public StudyComponentEditableStatus setStudyComponentAsNotEditable(String var1, StudyComponent var2) throws StudyNotFoundException, StudyComponentEditException;

    public String exportStudyDetailsToDataSet(String var1, ExportFileCreateInfo var2) throws StudyNotFoundException, ExportException;

    public String exportStudyStandardsToDataSet(String var1, ExportFileCreateInfo var2) throws StudyNotFoundException, ExportException;

    public void importStudyDetails(String var1, StudyComponentImportInfo var2) throws StudyNotFoundException, StudyUpdateException, ImportException;

    public String exportStudyExternalDictionariesToDataSet(String var1, ExportFileCreateInfo var2) throws StudyNotFoundException, ExportException;

    public String exportStudyDictionariesToDataSet(String var1, ExportFileCreateInfo var2) throws StudyNotFoundException, ExportException;

    public String exportStudyCodeListsToDataSet(String var1, ExportFileCreateInfo var2) throws StudyNotFoundException, ExportException;

    public StudyUpdateResult importStudyCodeLists(String var1, StudyComponentImportInfo var2, ExportFileCreateInfo var3) throws StudyNotFoundException, StudyCodeListUpdateException, ImportException, ValidationReportException;

    public StudyUpdateResult importStudyTables(String var1, String var2, StudyTablesImportInfo var3, ExportFileCreateInfo var4) throws StudyNotFoundException, StandardNotFoundException, StudyTableUpdateException, ImportException, ValidationReportException;

    public String exportSupportingDocumentsToDataSet(String var1, String var2, String var3, ExportFileCreateInfo var4) throws StudyNotFoundException, ExportException;

    public StudyUpdateResult importStudySupportingDocuments(String var1, String var2, String var3, StudyComponentImportInfo var4, ExportFileCreateInfo var5) throws StudyNotFoundException, StudySupportingDocumentUpdateException, ImportException, ValidationReportException;

    public String exportValueLevelMetadataToDataSet(String var1, String var2, String var3, ExportFileCreateInfo var4) throws StudyNotFoundException, ExportException;

    public StudyUpdateResult importStudyValueLevelMetadata(String var1, String var2, String var3, StudyComponentImportInfo var4, ExportFileCreateInfo var5) throws StudyNotFoundException, StudyValueLevelMetadataUpdateException, ImportException, ValidationReportException;

    public Set<String> exportStudyTablesToDataSets(String var1, String var2, String var3, BatchFileCreateInfo var4) throws StudyNotFoundException, ExportException;

    public Set<String> exportTlfsToDataSets(String var1, String var2, String var3, BatchFileCreateInfo var4, boolean var5) throws StudyNotFoundException, ExportException;

    public StudyUpdateResult importStudyTlfs(String var1, String var2, String var3, TlfImportInfo var4, ExportFileCreateInfo var5) throws StudyNotFoundException, TlfUpdateException, ImportException, ValidationReportException;

    public String exportZeroObservationDataSetsForStudyTables(String var1, String var2, String var3, BatchFileCreateInfo var4) throws StudyNotFoundException, ExportException;

    public StudyUpdateResult importStudyFromDefine(String var1, String var2, String var3, String var4, SourceLocation var5, UpdateAction var6, ExportFileCreateInfo var7) throws StudyNotFoundException, StandardNotFoundException, StudyUpdateException, ImportException, ValidationReportException;
}

