/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.common;

import com.sas.lsaf.content.repository.VersionType;
import com.sas.lsaf.core.SourceLocation;
import java.io.Serializable;

public class BatchFileCreateInfo
implements Serializable {
    private static final long serialVersionUID = -7923405397872509015L;
    private SourceLocation location;
    private String path;
    private String description;
    private boolean overwrite = false;
    private boolean enableVersioning = false;
    private VersionType versionTypeForNewFiles = VersionType.MAJOR;
    private VersionType versionTypeForExistingFiles = VersionType.MINOR;
    private String customVersionForNewFiles;
    private String customVersionForExistingFiles;
    private String comment;

    public BatchFileCreateInfo(String path, SourceLocation location) {
        this.path = path;
        this.location = location;
    }

    public BatchFileCreateInfo(String parentPath, String name, SourceLocation location) {
        this.path = (parentPath.equals("/") ? "" : parentPath) + "/" + name;
        this.location = location;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnableVersioning() {
        return this.enableVersioning;
    }

    public void setEnableVersioning(boolean enableVersioning) {
        this.enableVersioning = enableVersioning;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public VersionType getVersionTypeForExistingFiles() {
        return this.versionTypeForExistingFiles;
    }

    public void setVersionTypeForExistingFiles(VersionType versionTypeForExistingFiles) {
        this.versionTypeForExistingFiles = versionTypeForExistingFiles;
    }

    public VersionType getVersionTypeForNewFiles() {
        return this.versionTypeForNewFiles;
    }

    public void setVersionTypeForNewFiles(VersionType versionTypeForNewFiles) {
        this.versionTypeForNewFiles = versionTypeForNewFiles;
    }

    public String getCustomVersionForNewFiles() {
        return this.customVersionForNewFiles;
    }

    public void setCustomVersionForNewFiles(String customVersionForNewFiles) {
        this.customVersionForNewFiles = customVersionForNewFiles;
    }

    public String getCustomVersionForExistingFiles() {
        return this.customVersionForExistingFiles;
    }

    public void setCustomVersionForExistingFiles(String customVersionForExistingFiles) {
        this.customVersionForExistingFiles = customVersionForExistingFiles;
    }

    public SourceLocation getLocation() {
        return this.location;
    }

    public String getPath() {
        return this.path;
    }

    public BatchFileCreateInfo comment(String comment) {
        this.comment = comment;
        return this;
    }

    public BatchFileCreateInfo enableVersioning() {
        return this.enableVersioning(true);
    }

    public BatchFileCreateInfo enableVersioning(boolean enableVersioning) {
        this.enableVersioning = enableVersioning;
        return this;
    }

    public BatchFileCreateInfo overwrite() {
        return this.overwrite(true);
    }

    public BatchFileCreateInfo overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }
}

