/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.client.utils;

import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.core.utils.impl.UriUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.util.Assert;

public abstract class RelativePathUtility {
    private static final String SEPARATOR = "/";
    private static final String BACKSLASH = "\\";
    private static final String DEFAULT_URI_ENCODING = "UTF-8";

    public static String getRelativePath(String basePath, String absolutePath) {
        Assert.hasText((String)basePath, (String)"Base path is required to get the relative path.");
        Assert.hasText((String)absolutePath, (String)"Absolute path is required to get the relative path.");
        if (!absolutePath.startsWith(SEPARATOR)) {
            return absolutePath;
        }
        if (absolutePath.equals(basePath) || absolutePath.startsWith(basePath + SEPARATOR)) {
            String relative = URI.create(RelativePathUtility.encodePath(basePath)).relativize(URI.create(RelativePathUtility.encodePath(absolutePath))).getPath();
            if (!(relative.startsWith(SEPARATOR) && relative.startsWith("./") && relative.startsWith("../"))) {
                relative = "./" + relative;
            }
            return RelativePathUtility.decode(RelativePathUtility.encodePath(relative));
        }
        Path pathBase = Paths.get(basePath, new String[0]);
        Path pathAbs = Paths.get(absolutePath, new String[0]);
        String relative = pathBase.relativize(pathAbs).toString();
        relative = relative.replace(BACKSLASH, SEPARATOR);
        return relative;
    }

    private static String encodePath(String path) {
        return RelativePathUtility.encodePath(path, DEFAULT_URI_ENCODING);
    }

    private static String encodePath(String path, String encoding) {
        return org.springframework.web.util.UriUtils.encodePath((String)path, (String)encoding);
    }

    private static String decode(String s) {
        if (s == null) {
            return s;
        }
        try {
            return URLDecoder.decode(s, DEFAULT_URI_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException("URI encoding is unsupported.", e);
        }
    }

    public static String getAbsolutePath(String basePath, String relativePath) {
        Assert.hasText((String)basePath, (String)"Base path is required to get the absolute path.");
        Assert.hasText((String)relativePath, (String)"Relative path is required to get the absolute path.");
        String basePathToUse = "";
        basePathToUse = !basePath.endsWith(SEPARATOR) ? basePath.concat(SEPARATOR) : basePath;
        return RelativePathUtility.resolvePath(basePathToUse, relativePath);
    }

    public static String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(SEPARATOR);
        String parent = null;
        parent = path.length() == 1 || index < 0 ? "" : (index == 0 ? SEPARATOR : path.substring(0, index));
        return parent;
    }

    public static String getName(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(SEPARATOR)) {
            return "";
        }
        int index = path.lastIndexOf(SEPARATOR);
        if (index < 0) {
            return "";
        }
        return path.substring(index + 1);
    }

    private static String resolvePath(String basePath, String relativePath) {
        String resolvedPath = null;
        resolvedPath = URI.create(UriUtils.encodePath(basePath)).resolve(URI.create(UriUtils.encodePath(relativePath))).getPath();
        if (!resolvedPath.equals(SEPARATOR) && resolvedPath.endsWith(SEPARATOR)) {
            resolvedPath = resolvedPath.substring(0, resolvedPath.lastIndexOf(SEPARATOR));
        }
        return resolvedPath;
    }
}

