/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.client.impl;

import com.sas.lsaf.client.ServiceManager;
import com.sas.lsaf.clinical.dictionary.DictionaryService;
import com.sas.lsaf.clinical.dictionary.ExternalDictionaryService;
import com.sas.lsaf.clinical.model.ModelService;
import com.sas.lsaf.clinical.standards.StandardsService;
import com.sas.lsaf.clinical.study.StudyService;
import com.sas.lsaf.clinical.study.tlf.StudyTlfService;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateService;
import com.sas.lsaf.content.repository.BatchRepositoryService;
import com.sas.lsaf.content.repository.RepositoryService;
import com.sas.lsaf.content.repository.impl.ClientBatchRepositoryServiceImpl;
import com.sas.lsaf.content.repository.impl.ClientRepositoryServiceImpl;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinService;
import com.sas.lsaf.content.repository.signature.SignatureService;
import com.sas.lsaf.content.utilization.ResourceUtilizationService;
import com.sas.lsaf.content.workspace.BatchWorkspaceService;
import com.sas.lsaf.content.workspace.SharedWorkspaceService;
import com.sas.lsaf.content.workspace.WorkspaceService;
import com.sas.lsaf.content.workspace.impl.ClientBatchWorkspaceServiceImpl;
import com.sas.lsaf.content.workspace.impl.ClientWorkspaceServiceImpl;
import com.sas.lsaf.core.configuration.ApplicationInformation;
import com.sas.lsaf.core.configuration.ApplicationInformationService;
import com.sas.lsaf.core.type.TypeService;
import com.sas.lsaf.execution.job.JobService;
import com.sas.lsaf.execution.job.JobSubmissionService;
import com.sas.lsaf.execution.session.SessionService;
import com.sas.lsaf.messaging.subscription.SubscriptionService;
import com.sas.lsaf.query.audit.AuditQueryService;
import com.sas.lsaf.query.repository.RepositoryQueryService;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinQueryService;
import com.sas.lsaf.query.security.membership.ContextMembershipQueryService;
import com.sas.lsaf.query.security.permissions.PermissionsQueryService;
import com.sas.lsaf.schedule.ScheduleService;
import com.sas.lsaf.security.acl.AclService;
import com.sas.lsaf.security.audit.AuditService;
import com.sas.lsaf.security.audit.impl.ClientAuditServiceImpl;
import com.sas.lsaf.security.authentication.impl.InternalAuthenticationService;
import com.sas.lsaf.security.group.GroupService;
import com.sas.lsaf.security.membership.MembershipService;
import com.sas.lsaf.security.privilege.GlobalPrivilegeService;
import com.sas.lsaf.security.privilege.ScopedPrivilegeService;
import com.sas.lsaf.security.role.RoleService;
import com.sas.lsaf.security.user.UserService;
import com.sas.lsaf.workflow.autoflow.AutoFlowService;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionService;
import com.sas.lsaf.workflow.processflow.ProcessFlowService;
import com.sas.lsaf.workflow.processflow.impl.ClientProcessFlowServiceImpl;
import com.sas.lsaf.workflow.processflow.setup.ProcessFlowSetupService;
import com.sas.lsaf.workflow.task.TaskService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class ServiceManagerImpl
implements ServiceManager {
    private static final Log LOG = LogFactory.getLog(ServiceManagerImpl.class);
    private static final String NO_DEPLOY_TEST = "lsaf.api.disableVersionCheck";
    private final ApplicationInformationService applicationInformationService;
    private final AuditService auditService;
    private final GlobalPrivilegeService globalPrivilegeService;
    private final GroupService groupService;
    private final MembershipService membershipService;
    private final RepositoryService repositoryService;
    private final RoleService roleService;
    private final ScopedPrivilegeService scopedPrivilegeService;
    private final TypeService typeService;
    private final UserService userService;
    private final WorkspaceService workspaceService;
    private final BatchWorkspaceService batchWorkspaceService;
    private final BatchRepositoryService batchRepositoryService;
    private final AclService aclService;
    private final SignatureService signatureService;
    private final RecycleBinService recyclebinService;
    private final JobService jobService;
    private final JobSubmissionService jobSubmissionService;
    private final ProcessFlowService processFlowService;
    private final ProcessDefinitionService processDefinitionService;
    private final ProcessFlowSetupService processFlowSetupService;
    private final TaskService taskService;
    private final SessionService sessionService;
    private final SubscriptionService subscriptionService;
    private final ScheduleService scheduleService;
    private final StandardsService standardsService;
    private final StudyService studyService;
    private final ModelService modelService;
    private final DictionaryService dictionaryService;
    private final ExternalDictionaryService externalDictionaryService;
    private final AuditQueryService auditQueryService;
    private final RepositoryQueryService repositoryQueryService;
    private final RecycleBinQueryService recycleBinQueryService;
    private final PermissionsQueryService permissionsQueryService;
    private final ContextMembershipQueryService membershipQueryService;
    private final AutoFlowService autoFlowService;
    private final StudyTlfService studyTlfService;
    private final ResourceUtilizationService resourceUtilizationService;
    private final TlfTemplateService tlfTemplateService;
    private final SharedWorkspaceService sharedWorkspaceService;
    private final InternalAuthenticationService internalAuthenticationService;

    public ServiceManagerImpl(ApplicationContext applicationContext) {
        this.batchRepositoryService = (BatchRepositoryService)applicationContext.getBean(ClientBatchRepositoryServiceImpl.class);
        this.batchWorkspaceService = (BatchWorkspaceService)applicationContext.getBean(ClientBatchWorkspaceServiceImpl.class);
        this.auditService = (AuditService)applicationContext.getBean(ClientAuditServiceImpl.class);
        this.repositoryService = (RepositoryService)applicationContext.getBean(ClientRepositoryServiceImpl.class);
        this.workspaceService = (WorkspaceService)applicationContext.getBean(ClientWorkspaceServiceImpl.class);
        this.processFlowService = (ProcessFlowService)applicationContext.getBean(ClientProcessFlowServiceImpl.class);
        this.aclService = (AclService)applicationContext.getBean(AclService.class);
        this.applicationInformationService = (ApplicationInformationService)applicationContext.getBean(ApplicationInformationService.class);
        this.globalPrivilegeService = (GlobalPrivilegeService)applicationContext.getBean(GlobalPrivilegeService.class);
        this.groupService = (GroupService)applicationContext.getBean(GroupService.class);
        this.jobSubmissionService = (JobSubmissionService)applicationContext.getBean(JobSubmissionService.class);
        this.jobService = (JobService)applicationContext.getBean(JobService.class);
        this.membershipService = (MembershipService)applicationContext.getBean(MembershipService.class);
        this.roleService = (RoleService)applicationContext.getBean(RoleService.class);
        this.scheduleService = (ScheduleService)applicationContext.getBean(ScheduleService.class);
        this.scopedPrivilegeService = (ScopedPrivilegeService)applicationContext.getBean(ScopedPrivilegeService.class);
        this.signatureService = (SignatureService)applicationContext.getBean(SignatureService.class);
        this.subscriptionService = (SubscriptionService)applicationContext.getBean(SubscriptionService.class);
        this.typeService = (TypeService)applicationContext.getBean(TypeService.class);
        this.userService = (UserService)applicationContext.getBean(UserService.class);
        this.recyclebinService = (RecycleBinService)applicationContext.getBean(RecycleBinService.class);
        this.processDefinitionService = (ProcessDefinitionService)applicationContext.getBean(ProcessDefinitionService.class);
        this.processFlowSetupService = (ProcessFlowSetupService)applicationContext.getBean(ProcessFlowSetupService.class);
        this.autoFlowService = (AutoFlowService)applicationContext.getBean(AutoFlowService.class);
        this.studyTlfService = (StudyTlfService)applicationContext.getBean(StudyTlfService.class);
        this.taskService = (TaskService)applicationContext.getBean(TaskService.class);
        this.sessionService = (SessionService)applicationContext.getBean(SessionService.class);
        this.standardsService = (StandardsService)applicationContext.getBean(StandardsService.class);
        this.studyService = (StudyService)applicationContext.getBean(StudyService.class);
        this.modelService = (ModelService)applicationContext.getBean(ModelService.class);
        this.dictionaryService = (DictionaryService)applicationContext.getBean(DictionaryService.class);
        this.externalDictionaryService = (ExternalDictionaryService)applicationContext.getBean(ExternalDictionaryService.class);
        this.auditQueryService = (AuditQueryService)applicationContext.getBean(AuditQueryService.class);
        this.repositoryQueryService = (RepositoryQueryService)applicationContext.getBean(RepositoryQueryService.class);
        this.recycleBinQueryService = (RecycleBinQueryService)applicationContext.getBean(RecycleBinQueryService.class);
        this.membershipQueryService = (ContextMembershipQueryService)applicationContext.getBean(ContextMembershipQueryService.class);
        this.permissionsQueryService = (PermissionsQueryService)applicationContext.getBean(PermissionsQueryService.class);
        this.resourceUtilizationService = (ResourceUtilizationService)applicationContext.getBean(ResourceUtilizationService.class);
        this.tlfTemplateService = (TlfTemplateService)applicationContext.getBean(TlfTemplateService.class);
        this.sharedWorkspaceService = (SharedWorkspaceService)applicationContext.getBean(SharedWorkspaceService.class);
        this.internalAuthenticationService = (InternalAuthenticationService)applicationContext.getBean(InternalAuthenticationService.class);
    }

    private boolean clientServerBuildIDSAreCompatible(String client, String server, boolean permissive) {
        if (client.equals(server)) {
            return true;
        }
        if (permissive) {
            String[] serverParts;
            String[] clientParts = client.split(".");
            if (clientParts.length != (serverParts = server.split(".")).length) {
                LOG.debug((Object)("Build lengths are not equal: " + client + " and " + server));
            }
            int partsTocompare = clientParts.length;
            for (int i = 0; i < partsTocompare; ++i) {
                if (clientParts[i].compareTo(serverParts[i]) <= 0) continue;
                LOG.debug((Object)"Client build is more recent than server build, this is not an allowed configuration.");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public ApplicationInformationService getApplicationInformationService() {
        return this.applicationInformationService;
    }

    @Override
    public AuditService getAuditService() {
        return this.auditService;
    }

    @Override
    public GlobalPrivilegeService getGlobalPrivilegeService() {
        return this.globalPrivilegeService;
    }

    @Override
    public GroupService getGroupService() {
        return this.groupService;
    }

    @Override
    public MembershipService getMembershipService() {
        return this.membershipService;
    }

    @Override
    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public RoleService getRoleService() {
        return this.roleService;
    }

    @Override
    public ScopedPrivilegeService getScopedPrivilegeService() {
        return this.scopedPrivilegeService;
    }

    @Override
    public TypeService getTypeService() {
        return this.typeService;
    }

    @Override
    public UserService getUserService() {
        return this.userService;
    }

    @Override
    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    @Override
    public SharedWorkspaceService getSharedWorkspaceService() {
        return this.sharedWorkspaceService;
    }

    @Override
    public BatchWorkspaceService getBatchWorkspaceService() {
        return this.batchWorkspaceService;
    }

    @Override
    public BatchRepositoryService getBatchRepositoryService() {
        return this.batchRepositoryService;
    }

    @Override
    public AclService getAclService() {
        return this.aclService;
    }

    @Override
    public SignatureService getSignatureService() {
        return this.signatureService;
    }

    @Override
    public RecycleBinService getRecycleBinService() {
        return this.recyclebinService;
    }

    @Override
    public JobService getJobService() {
        return this.jobService;
    }

    @Override
    public JobSubmissionService getJobSubmissionService() {
        return this.jobSubmissionService;
    }

    @Override
    public ProcessFlowService getProcessFlowService() {
        return this.processFlowService;
    }

    @Override
    public ProcessDefinitionService getProcessDefinitionService() {
        return this.processDefinitionService;
    }

    @Override
    public ProcessFlowSetupService getProcessFlowSetupService() {
        return this.processFlowSetupService;
    }

    @Override
    public SessionService getSessionService() {
        return this.sessionService;
    }

    @Override
    public TaskService getTaskService() {
        return this.taskService;
    }

    @Override
    public ScheduleService getScheduleService() {
        return this.scheduleService;
    }

    @Override
    public SubscriptionService getSubscriptionService() {
        return this.subscriptionService;
    }

    @Override
    public StandardsService getStandardsService() {
        return this.standardsService;
    }

    @Override
    public StudyService getStudyService() {
        return this.studyService;
    }

    @Override
    public ModelService getModelService() {
        return this.modelService;
    }

    @Override
    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    @Override
    public ExternalDictionaryService getExternalDictionaryService() {
        return this.externalDictionaryService;
    }

    @Override
    public AuditQueryService getAuditQueryService() {
        return this.auditQueryService;
    }

    @Override
    public RepositoryQueryService getRepositoryQueryService() {
        return this.repositoryQueryService;
    }

    @Override
    public RecycleBinQueryService getRecycleBinQueryService() {
        return this.recycleBinQueryService;
    }

    @Override
    public ContextMembershipQueryService getMembershipQueryService() {
        return this.membershipQueryService;
    }

    @Override
    public PermissionsQueryService getPermissionsQueryService() {
        return this.permissionsQueryService;
    }

    @Override
    public AutoFlowService getAutoFlowService() {
        return this.autoFlowService;
    }

    @Override
    public StudyTlfService getStudyTlfService() {
        return this.studyTlfService;
    }

    @Override
    public ResourceUtilizationService getResourceUtilizationService() {
        return this.resourceUtilizationService;
    }

    @Override
    public TlfTemplateService getTlfTemplateService() {
        return this.tlfTemplateService;
    }

    public boolean isDeploymentConsistent() {
        boolean disableTest = false;
        boolean permissive = false;
        String shouldDisable = System.getProperty(NO_DEPLOY_TEST, "false");
        if (shouldDisable.toLowerCase().equals("true")) {
            disableTest = true;
        }
        String out1 = "Verifying dependencies and deployment with disable and permissive values of " + disableTest + " and " + false;
        LOG.debug((Object)out1);
        ApplicationInformation info = this.applicationInformationService.getApplicationInformation();
        LOG.debug((Object)("API client version: " + info.getApiClientVersion()));
        LOG.debug((Object)("API server version: " + info.getApiServerVersion()));
        LOG.debug((Object)("LSAF server version: " + info.getAppServerVersion()));
        if (disableTest) {
            LOG.debug((Object)"DeploymentTest is disabled via system property NO_DEPLOY_TEST...returning true.");
            return true;
        }
        if (!this.clientServerBuildIDSAreCompatible(info.getApiClientVersion(), info.getApiServerVersion(), false)) {
            LOG.error((Object)("LSAF API client and server versions are not compatible. Client build is " + info.getApiClientVersion() + " while server is " + info.getApiServerVersion()));
            System.err.println("LSAF API client and server versions are not compatible. Client build is " + info.getApiClientVersion() + " while server is " + info.getApiServerVersion());
            return false;
        }
        return true;
    }

    public InternalAuthenticationService getInternalAuthenticationService() {
        return this.internalAuthenticationService;
    }
}

