/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.client.impl;

import com.sas.lsaf.client.ClientSession;
import com.sas.lsaf.client.HttpException;
import com.sas.lsaf.client.ServiceManager;
import com.sas.lsaf.client.impl.TrustedContextHolder;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;

public class ClientSessionImpl
implements ClientSession {
    private static Log LOG = LogFactory.getLog((String)ClientSessionImpl.class.getName());
    private final ServiceManager serviceManager;
    private final HttpComponentsHttpInvokerRequestExecutor chire;
    private final String logoutUrl;
    private final Exception finalizerTraceBack;
    private boolean valid = true;

    public ClientSessionImpl(ServiceManager serviceManager, HttpComponentsHttpInvokerRequestExecutor chire, String logoutUrl) {
        this.serviceManager = serviceManager;
        this.chire = chire;
        this.logoutUrl = logoutUrl;
        this.finalizerTraceBack = new IllegalStateException();
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public void logoff() {
        try {
            LOG.debug((Object)("Logging out session via " + this.logoutUrl));
            HttpGet httpGet = new HttpGet(this.logoutUrl);
            HttpClient httpClient = this.chire.getHttpClient();
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity resEntity = response.getEntity();
            EntityUtils.consume((HttpEntity)resEntity);
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() >= 300) {
                throw new HttpException(status.getStatusCode(), "[" + status.getStatusCode() + "] Server error while invocating the logout URL: " + this.logoutUrl);
            }
            this.valid = false;
            LOG.debug((Object)("[" + status + "] Logout was successful"));
        }
        catch (IOException e) {
            throw new HttpException("I/O exception while trying to logout and release session.", e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpException("Exception while trying to logout and release session.", e);
        }
    }

    protected void finalize() throws Throwable {
        TrustedContextHolder holder = new TrustedContextHolder();
        if (holder.getToken() == null) {
            super.finalize();
            if (this.valid) {
                LOG.error((Object)("ClientSession object is being garbage collected without being properly invalidated: " + this), (Throwable)this.finalizerTraceBack);
            }
        }
    }
}

