/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.client.impl;

import com.sas.lsaf.client.ClientSession;
import com.sas.lsaf.client.ConfigurationException;
import com.sas.lsaf.client.HttpConnectException;
import com.sas.lsaf.client.HttpException;
import com.sas.lsaf.client.HttpUnknownHostException;
import com.sas.lsaf.client.ProxyInfo;
import com.sas.lsaf.client.SessionStrategy;
import com.sas.lsaf.client.impl.ClientSessionImpl;
import com.sas.lsaf.client.impl.Configuration;
import com.sas.lsaf.client.impl.ServiceManagerImpl;
import com.sas.lsaf.security.authentication.AuthenticationException;
import com.sas.lsaf.security.authentication.UnknownAuthenticationException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;
import org.springframework.util.Assert;

public abstract class AbstractCommonsHttpSessionStrategyImpl
implements SessionStrategy {
    private static final Log LOG = LogFactory.getLog(AbstractCommonsHttpSessionStrategyImpl.class);
    private URL url;
    private String userId;
    private byte[] password;
    private ProxyInfo proxyInfo;

    protected ClientSession doLogon(URL url, String userId, byte[] password, ProxyInfo proxyInfo) throws AuthenticationException {
        if (url.getProtocol() == null || url.getProtocol().isEmpty()) {
            throw new IllegalArgumentException("Protocol may not be null");
        }
        if (url.getHost() == null || url.getHost().isEmpty()) {
            throw new IllegalArgumentException("Host name may not be null");
        }
        this.setUrl(url);
        this.setUserId(userId);
        this.setPassword(password);
        this.setProxyInfo(proxyInfo);
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("META-INF/lsaf/lsaf-japi-client-config.xml");
        Configuration configuration = (Configuration)applicationContext.getBean(Configuration.class);
        HttpComponentsHttpInvokerRequestExecutor executor = (HttpComponentsHttpInvokerRequestExecutor)applicationContext.getBean(HttpComponentsHttpInvokerRequestExecutor.class);
        ServiceManagerImpl dsmi = new ServiceManagerImpl((ApplicationContext)applicationContext);
        this.handleProxyInfo(executor, proxyInfo);
        byte[] pwd = this.preauthenticate((ApplicationContext)applicationContext, userId, password);
        this.authenticate(executor, configuration, userId, pwd);
        this.isDeploymentConsistent(dsmi);
        ClientSessionImpl session = new ClientSessionImpl(dsmi, executor, configuration.getLogoutUrl());
        return session;
    }

    protected void handleProxyInfo(HttpComponentsHttpInvokerRequestExecutor executor, ProxyInfo proxyInfo) {
        if (proxyInfo != null) {
            Assert.hasText((String)proxyInfo.getProxyHost(), (String)"Proxy host is required.");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting proxy information [proxyHost=" + proxyInfo.getProxyHost() + " proxyPort=" + proxyInfo.getProxyPort() + "]"));
            }
            if (proxyInfo.getProxyUserId() != null && proxyInfo.getProxyPassword() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting proxy credentials [proxyuserId=" + proxyInfo.getProxyUserId() + " proxyPassword=xxxxxxxx]"));
                }
                BasicCredentialsProvider proxyCreds = new BasicCredentialsProvider();
                proxyCreds.setCredentials(new AuthScope(proxyInfo.getProxyHost(), proxyInfo.getProxyPort()), (Credentials)new UsernamePasswordCredentials(proxyInfo.getProxyUserId(), proxyInfo.getProxyPassword()));
                HttpHost proxy = new HttpHost(proxyInfo.getProxyHost(), proxyInfo.getProxyPort());
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
                executor.setHttpClient((HttpClient)HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)proxyCreds).setRoutePlanner((HttpRoutePlanner)routePlanner).build());
            } else {
                HttpHost proxy = new HttpHost(proxyInfo.getProxyHost(), proxyInfo.getProxyPort());
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
                executor.setHttpClient((HttpClient)HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Proxy information was not provided");
        }
    }

    protected byte[] preauthenticate(ApplicationContext applicationContext, String userId, byte[] password) throws AuthenticationException {
        return password;
    }

    protected void authenticate(HttpComponentsHttpInvokerRequestExecutor executor, Configuration configuration, String userId, byte[] password) throws AuthenticationException {
        try {
            HttpClient httpClient = executor.getHttpClient();
            URI uri = new URIBuilder(configuration.getLoginUrl()).build();
            HttpPost httpPost = new HttpPost(uri);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair(configuration.getLoginUseridParameter(), userId));
            nvps.add(new BasicNameValuePair(configuration.getLoginPasswordParameter(), new String(password)));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity resEntity = response.getEntity();
            EntityUtils.consume((HttpEntity)resEntity);
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() >= 400) {
                throw new HttpException(status.getStatusCode(), "Authentication process failed [" + status + "-" + configuration.getLoginUrl() + "]");
            }
            Header[] heads = response.getHeaders("Location");
            if (heads.length > 1) {
                throw new HttpException("Received multiple Location headers on response....login failure!");
            }
        }
        catch (URISyntaxException e) {
            throw new HttpException("Authentication process failed", e);
        }
        catch (IOException e) {
            throw new HttpException("Authentication process failed", e);
        }
    }

    protected void isDeploymentConsistent(ServiceManagerImpl dsmi) {
        if (!dsmi.isDeploymentConsistent()) {
            throw new ConfigurationException("Client API version and version deployed on the server do not match.");
        }
    }

    protected void handleThrowable(Throwable t, boolean isSecured) throws AuthenticationException {
        this.handleThrowable(t, -1, isSecured);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleThrowable(Throwable t, int httpStatusCode, boolean isSecured) throws AuthenticationException {
        String connectionInfo = null;
        if (t instanceof AuthenticationException) {
            throw (AuthenticationException)t;
        }
        connectionInfo = this.proxyInfo == null ? "[" + this.getUrl().toString() + "]" : (this.proxyInfo.getProxyUserId() == null ? "[" + this.getUrl().toString() + "] using proxy information [proxyHost=" + this.proxyInfo.getProxyHost() + ", proxyPort=" + this.proxyInfo.getProxyPort() + "]" : "[" + this.getUrl().toString() + "] using proxy information [proxyHost=" + this.proxyInfo.getProxyHost() + ", proxyPort=" + this.proxyInfo.getProxyPort() + ", proxyUserId=" + this.proxyInfo.getProxyUserId() + ", proxyPassword=xxxxxxxx]");
        if (t instanceof RemoteAccessException) {
            if (t.getCause() == null) throw new UnknownAuthenticationException("Authentication process failed: " + t.getMessage());
            this.handleThrowable(t.getCause(), httpStatusCode, isSecured);
            return;
        }
        if (t instanceof RemoteConnectFailureException) {
            if (t.getCause() == null) throw new UnknownAuthenticationException("Authentication process failed: " + t.getMessage());
            this.handleThrowable(t.getCause(), httpStatusCode, isSecured);
            return;
        }
        if (t instanceof UnknownHostException) {
            throw new HttpUnknownHostException(this.getUrl(), "Could not connect to " + connectionInfo + "; unknown host: " + t.getMessage(), t);
        }
        if (t instanceof ConnectException) {
            throw new HttpConnectException(this.getUrl(), "Could not connect to " + connectionInfo + "; connection was refused: " + this.getUrl().getHost(), t);
        }
        if (t instanceof SocketException) {
            throw new HttpUnknownHostException(this.getUrl(), "Could not connect to " + connectionInfo + "; connection was refused: " + this.getUrl().getHost(), t);
        }
        if (t instanceof StreamCorruptedException) {
            throw new HttpConnectException(this.getUrl(), "Could not connect to " + connectionInfo + "; connection was refused: " + this.getUrl().getHost(), t);
        }
        if (t instanceof NoHttpResponseException) {
            if (this.proxyInfo != null) throw new HttpUnknownHostException(this.getUrl(), "Could not connect to " + connectionInfo + "; the proxy cannot reach the host.", t);
            throw new HttpUnknownHostException(this.getUrl(), "Could not connect to " + connectionInfo + ".", t);
        }
        if (!(t instanceof org.apache.http.HttpException)) throw new UnknownAuthenticationException("Authentication process failed connecting to " + connectionInfo + ": " + t.getMessage());
        org.apache.http.HttpException he = (org.apache.http.HttpException)t;
        String statusMessage = "status code = ";
        int beginIndex = t.getMessage().indexOf("status code = ");
        if (beginIndex <= 0) throw new HttpException(httpStatusCode, "Authentication process failed connecting to " + connectionInfo, (Throwable)he);
        int endIndex = t.getMessage().indexOf(",", beginIndex += "status code = ".length());
        String statusCode = t.getMessage().substring(beginIndex, endIndex);
        try {
            int status = Integer.parseInt(statusCode);
            switch (status) {
                case 403: {
                    if (isSecured || this.proxyInfo != null) throw new HttpException(status, "Could not connect to " + connectionInfo + "; connection was refused: " + this.getUrl().getHost(), t);
                    throw new HttpConnectException(this.getUrl(), "Could not connect to " + connectionInfo + "; connection was refused: " + this.getUrl().getHost() + " perhaps a proxy server is required", t);
                }
                case 404: {
                    throw new HttpException(status, "Could not connect to " + connectionInfo + "; the URL is incorrect.", (Throwable)he);
                }
                case 407: {
                    throw new HttpException(status, "Could not connect to " + connectionInfo + "; proxy authentication is required.", (Throwable)he);
                }
            }
            throw new HttpException(httpStatusCode, "Authentication process failed connecting to " + connectionInfo, (Throwable)he);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new HttpException(httpStatusCode, "Authentication process failed connecting to " + connectionInfo, (Throwable)he);
    }

    public void setUrl(URL url) {
        System.setProperty("server.base.url", url.toString());
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }

    @Override
    public ClientSession logon(URL url, String userId, byte[] password) throws AuthenticationException {
        Assert.notNull((Object)url, (String)"URL is required");
        Assert.hasText((String)userId, (String)"userId is required");
        Assert.notNull((Object)password, (String)"Password is required");
        return this.doLogon(url, userId, password, null);
    }

    @Override
    public ClientSession logon(URL url, String userId, byte[] password, ProxyInfo proxyInfo) throws AuthenticationException {
        Assert.notNull((Object)url, (String)"URL is required");
        Assert.hasText((String)userId, (String)"userId is required");
        Assert.notNull((Object)password, (String)"Password is required");
        Assert.notNull((Object)proxyInfo, (String)"Proxy information is required");
        return this.doLogon(url, userId, password, proxyInfo);
    }
}

