/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.client;

import com.sas.lsaf.client.ClientSession;
import com.sas.lsaf.client.ConfigurationException;
import com.sas.lsaf.client.ProxyInfo;
import com.sas.lsaf.client.SessionStrategy;
import com.sas.lsaf.client.impl.SessionStrategyImpl;
import com.sas.lsaf.security.authentication.AuthenticationException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SessionFactory {
    public static final String SESSION_STRATEGY_SYSTEM_PROPERTY = "session.strategy.classname";
    private static final String DEFAULT_SESSION_STRATEGY = SessionStrategyImpl.class.getName();
    private static final Log log = LogFactory.getLog(SessionFactory.class);
    private static SessionStrategy sessionStrategy;

    SessionFactory() {
    }

    private static SessionStrategy doGetSessionStrategy() {
        if (sessionStrategy == null) {
            String strategyClassName = System.getProperty(SESSION_STRATEGY_SYSTEM_PROPERTY);
            if (strategyClassName == null || strategyClassName.equals("")) {
                log.debug((Object)("Using default session strategy: " + DEFAULT_SESSION_STRATEGY));
                strategyClassName = DEFAULT_SESSION_STRATEGY;
            }
            try {
                log.debug((Object)("Using custom session strategy: " + strategyClassName));
                Object o = Class.forName(strategyClassName).newInstance();
                if (!(o instanceof SessionStrategy)) {
                    throw new ConfigurationException("Custom session strategy was found but is not of required type " + SessionStrategy.class.getName());
                }
                sessionStrategy = (SessionStrategy)o;
            }
            catch (Exception e) {
                log.error((Object)("Error initializing custom session strategy: " + strategyClassName), (Throwable)e);
                if (e instanceof ConfigurationException) {
                    throw (ConfigurationException)e;
                }
                throw new ConfigurationException("Error initializing custom session strategy: " + strategyClassName, e);
            }
        }
        return sessionStrategy;
    }

    static void clearSessionStrategy() {
        sessionStrategy = null;
    }

    public static ClientSession logon(URL url, String userid, byte[] password) throws AuthenticationException {
        return SessionFactory.doGetSessionStrategy().logon(url, userid, password);
    }

    public static ClientSession logon(URL url, String userId, byte[] password, ProxyInfo proxyInfo) throws AuthenticationException {
        return SessionFactory.doGetSessionStrategy().logon(url, userId, password, proxyInfo);
    }
}

