/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf;

import com.sas.lsaf.client.ClientSession;
import com.sas.lsaf.client.ConfigurationException;
import com.sas.lsaf.client.HttpConnectException;
import com.sas.lsaf.client.HttpException;
import com.sas.lsaf.client.ProxyInfo;
import com.sas.lsaf.client.SessionFactory;
import com.sas.lsaf.security.authentication.AuthenticationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class LsafCommand {
    private static boolean DEBUG = false;

    private static void doShowUsage() {
        System.out.println();
        System.out.println("Usage: java -jar sas.lsaf.api.client.jar [args...]");
        System.out.println();
        System.out.println("where optional arguments include (you will be prompted if they are not provided):");
        System.out.println("    -s -server -serverurl");
        System.out.println("        the LSAF server URL to connect to");
        System.out.println("    -u -user -userid");
        System.out.println("        the LSAF userId to connect with");
        System.out.println("    -p -pass -password");
        System.out.println("        the LSAF password to connect with");
        System.out.println();
        System.out.println("where optional proxy arguments include:");
        System.out.println("    -ps -proxyserver -proxyserverhost");
        System.out.println("         the proxy server host name");
        System.out.println("    -pport -proxyport");
        System.out.println("         the proxy server port");
        System.out.println("    -pu -proxyuser -proxyuserid");
        System.out.println("         the proxy userId to use if required");
        System.out.println("    -pp -proxypass -proxypassword");
        System.out.println("         the proxy password to use if required");
        System.out.println();
        System.out.println("where optional arguments include:");
        System.out.println("    -? -h -help");
        System.out.println("         display this message");
        System.out.println("    -d -debug");
        System.out.println("         include stacktraces when logging errors");
        System.out.println();
    }

    private static void doLogError(String msg) {
        LsafCommand.doLogError(msg, null);
    }

    private static void doLogError(String msg, Throwable t) {
        System.err.println();
        System.err.println("Error: " + msg);
        if (t != null) {
            if (DEBUG) {
                t.printStackTrace();
            } else {
                System.err.println("       " + t.getLocalizedMessage());
            }
        }
        LsafCommand.doExit(-1);
    }

    private static void doExit(int status) {
        if (status == 1) {
            System.out.println();
            System.out.println("CONNECTION SUCCESFUL!");
            System.out.println();
        } else if (status < 0) {
            System.err.println();
            System.err.println("** CONNECTION FAILED! **");
            System.err.println();
        }
        System.exit(status);
    }

    private static String doReadInput(String prompt) {
        String ret = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.println();
            System.out.print(prompt + ": ");
            ret = in.readLine();
            if (ret == null || ret.isEmpty()) {
                LsafCommand.doLogError(prompt + " is required.");
            }
        }
        catch (IOException e) {
            LsafCommand.doLogError("Unable to read input.", e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        System.out.println();
        System.out.println("=================================================================");
        System.out.println("  SAS Life Science Analytics Framework Java API Connection Test");
        System.out.println("=================================================================");
        URL serverURL = null;
        String serverURLString = null;
        String userid = null;
        String password = null;
        String proxyHost = null;
        String proxyPort = null;
        String proxyUserid = null;
        String proxyPassword = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equalsIgnoreCase("-s") || argv[i].equalsIgnoreCase("-server") || argv[i].equalsIgnoreCase("-serverurl")) {
                if (++i >= argv.length) continue;
                serverURLString = argv[i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-u") || argv[i].equalsIgnoreCase("-user") || argv[i].equalsIgnoreCase("-userid")) {
                if (++i >= argv.length) continue;
                userid = argv[i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-p") || argv[i].equalsIgnoreCase("-pass") || argv[i].equalsIgnoreCase("-password")) {
                if (++i >= argv.length) continue;
                password = argv[i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-ps") || argv[i].equalsIgnoreCase("-proxyserver") || argv[i].equalsIgnoreCase("-proxyserverhost")) {
                if (++i >= argv.length) continue;
                proxyHost = argv[i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-pport") || argv[i].equalsIgnoreCase("-proxyport")) {
                if (++i >= argv.length) continue;
                proxyPort = argv[i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-pu") || argv[i].equalsIgnoreCase("-proxyuser") || argv[i].equalsIgnoreCase("-proxyuserid")) {
                if (++i >= argv.length) continue;
                proxyUserid = argv[i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-pp") || argv[i].equalsIgnoreCase("-proxypass") || argv[i].equalsIgnoreCase("-proxypassword")) {
                if (++i >= argv.length) continue;
                proxyPassword = argv[i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-d") || argv[i].equalsIgnoreCase("-debug")) {
                DEBUG = true;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-h") || argv[i].equalsIgnoreCase("-help") || argv[i].equalsIgnoreCase("-?")) {
                LsafCommand.doShowUsage();
                LsafCommand.doExit(0);
                continue;
            }
            System.err.println("Error: Unrecognized parameter: " + argv[i]);
            LsafCommand.doShowUsage();
            LsafCommand.doExit(-1);
        }
        if (serverURLString == null) {
            serverURLString = String.valueOf(LsafCommand.doReadInput("Server URL"));
        }
        try {
            serverURL = new URL(serverURLString);
        }
        catch (MalformedURLException me) {
            LsafCommand.doLogError("The server URL is not valid.", me);
            LsafCommand.doExit(-1);
        }
        if (userid == null || userid.length() == 0) {
            userid = String.valueOf(LsafCommand.doReadInput("Username"));
        }
        if (password == null || String.valueOf(password).length() == 0) {
            password = LsafCommand.doReadInput("Password");
        }
        ClientSession session = null;
        try {
            System.out.println();
            System.out.println("Attempting to connect to " + serverURLString + "...");
            if (proxyHost == null) {
                session = SessionFactory.logon(serverURL, userid, String.valueOf(password).getBytes());
            } else {
                ProxyInfo proxyInfo = new ProxyInfo(proxyHost, Integer.parseInt(proxyPort));
                if (proxyUserid != null) {
                    proxyInfo.setProxyUserId(proxyUserid);
                }
                if (proxyPassword != null) {
                    proxyInfo.setProxyPassword(String.valueOf(proxyPassword));
                }
                session = SessionFactory.logon(serverURL, userid, String.valueOf(password).getBytes(), proxyInfo);
            }
            LsafCommand.doExit(1);
        }
        catch (HttpException e) {
            LsafCommand.doLogError("Could not create session", e);
        }
        catch (NumberFormatException e) {
            LsafCommand.doLogError("The proxy port is invalid", e);
        }
        catch (HttpConnectException e) {
            LsafCommand.doLogError("The server URL is invalid", e);
        }
        catch (ConfigurationException e) {
            LsafCommand.doLogError("Configuration error", e);
        }
        catch (AuthenticationException e) {
            LsafCommand.doLogError("Authentication error", e);
        }
        catch (Throwable t) {
            LsafCommand.doLogError("Unexpected error", t);
        }
        finally {
            if (session != null) {
                session.logoff();
            }
        }
    }
}

