/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf;

import com.sas.lsaf.client.ClientSession;
import com.sas.lsaf.client.LogonException;
import com.sas.lsaf.client.ProxyInfo;
import com.sas.lsaf.client.SessionFactory;
import com.sas.lsaf.clinical.dictionary.DictionaryService;
import com.sas.lsaf.clinical.dictionary.ExternalDictionaryService;
import com.sas.lsaf.clinical.model.ModelService;
import com.sas.lsaf.clinical.standards.StandardsService;
import com.sas.lsaf.clinical.study.StudyService;
import com.sas.lsaf.clinical.study.tlf.StudyTlfService;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateService;
import com.sas.lsaf.content.repository.BatchRepositoryService;
import com.sas.lsaf.content.repository.RepositoryService;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinService;
import com.sas.lsaf.content.repository.signature.SignatureService;
import com.sas.lsaf.content.utilization.ResourceUtilizationService;
import com.sas.lsaf.content.workspace.BatchWorkspaceService;
import com.sas.lsaf.content.workspace.SharedWorkspaceService;
import com.sas.lsaf.content.workspace.WorkspaceService;
import com.sas.lsaf.core.configuration.ApplicationInformationService;
import com.sas.lsaf.core.type.TypeService;
import com.sas.lsaf.execution.job.JobService;
import com.sas.lsaf.execution.job.JobSubmissionService;
import com.sas.lsaf.execution.session.SessionService;
import com.sas.lsaf.messaging.subscription.SubscriptionService;
import com.sas.lsaf.query.audit.AuditQueryService;
import com.sas.lsaf.query.repository.RepositoryQueryService;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinQueryService;
import com.sas.lsaf.query.security.membership.ContextMembershipQueryService;
import com.sas.lsaf.query.security.permissions.PermissionsQueryService;
import com.sas.lsaf.schedule.ScheduleService;
import com.sas.lsaf.security.acl.AclService;
import com.sas.lsaf.security.audit.AuditService;
import com.sas.lsaf.security.authentication.AuthenticationException;
import com.sas.lsaf.security.group.GroupService;
import com.sas.lsaf.security.membership.MembershipService;
import com.sas.lsaf.security.privilege.GlobalPrivilegeService;
import com.sas.lsaf.security.privilege.ScopedPrivilegeService;
import com.sas.lsaf.security.role.RoleService;
import com.sas.lsaf.security.user.UserService;
import com.sas.lsaf.workflow.autoflow.AutoFlowService;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionService;
import com.sas.lsaf.workflow.processflow.ProcessFlowService;
import com.sas.lsaf.workflow.processflow.setup.ProcessFlowSetupService;
import com.sas.lsaf.workflow.task.TaskService;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.util.Assert;

public class LsafClient {
    private static ClientSession currentSession = null;

    private static ClientSession doGetCurrentSession() {
        if (currentSession == null) {
            throw new IllegalStateException("Current session does not exist.  Please call logon method to establish an authenticated session with server.");
        }
        return currentSession;
    }

    public static void logon(String url, String userId, byte[] password) throws LogonException {
        Assert.hasText((String)url, (String)"url is required");
        Assert.hasText((String)userId, (String)"userId is required");
        Assert.notNull((Object)password, (String)"Password is required");
        try {
            LsafClient.logoff();
            currentSession = SessionFactory.logon(new URL(url), userId, password);
        }
        catch (MalformedURLException e) {
            throw new LogonException(e.getLocalizedMessage());
        }
        catch (AuthenticationException e) {
            throw new LogonException("Credentials are incorrect.", e);
        }
    }

    public static void logon(String url, String userId, byte[] password, ProxyInfo proxyInfo) throws LogonException {
        Assert.hasText((String)url, (String)"url is required");
        Assert.hasText((String)userId, (String)"userId is required");
        Assert.notNull((Object)password, (String)"Password is required");
        try {
            LsafClient.logoff();
            currentSession = SessionFactory.logon(new URL(url), userId, password, proxyInfo);
        }
        catch (MalformedURLException e) {
            throw new LogonException(e.getLocalizedMessage());
        }
        catch (AuthenticationException e) {
            throw new LogonException("Credentials are incorrect.", e);
        }
    }

    public static void logoff() {
        if (currentSession != null) {
            currentSession.logoff();
        }
        currentSession = null;
    }

    public static ApplicationInformationService getApplicationInformationService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getApplicationInformationService();
    }

    public static AuditService getAuditService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getAuditService();
    }

    public static GlobalPrivilegeService getGlobalPrivilegeService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getGlobalPrivilegeService();
    }

    public static GroupService getGroupService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getGroupService();
    }

    public static MembershipService getMembershipService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getMembershipService();
    }

    public static RepositoryService getRepositoryService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getRepositoryService();
    }

    public static RoleService getRoleService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getRoleService();
    }

    public static ScopedPrivilegeService getScopedPrivilegeService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getScopedPrivilegeService();
    }

    public static TypeService getTypeService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getTypeService();
    }

    public static UserService getUserService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getUserService();
    }

    public static WorkspaceService getWorkspaceService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getWorkspaceService();
    }

    public static SharedWorkspaceService getSharedWorkspaceService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getSharedWorkspaceService();
    }

    public static AclService getAclService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getAclService();
    }

    public static BatchWorkspaceService getBatchWorkspaceService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getBatchWorkspaceService();
    }

    public static BatchRepositoryService getBatchRepositoryService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getBatchRepositoryService();
    }

    public static SignatureService getSignatureService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getSignatureService();
    }

    public static RecycleBinService getRecycleBinService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getRecycleBinService();
    }

    public static JobService getJobService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getJobService();
    }

    public static JobSubmissionService getJobSubmissionService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getJobSubmissionService();
    }

    public static ProcessFlowService getProcessFlowService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getProcessFlowService();
    }

    public static ProcessDefinitionService getProcessDefinitionService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getProcessDefinitionService();
    }

    public static ProcessFlowSetupService getProcessFlowSetupService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getProcessFlowSetupService();
    }

    public static TaskService getTaskService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getTaskService();
    }

    public static SessionService getSessionService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getSessionService();
    }

    public static SubscriptionService getSubscriptionService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getSubscriptionService();
    }

    public static ScheduleService getScheduleService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getScheduleService();
    }

    public static StandardsService getStandardsService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getStandardsService();
    }

    public static StudyService getStudyService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getStudyService();
    }

    public static ModelService getModelService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getModelService();
    }

    public static DictionaryService getDictionaryService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getDictionaryService();
    }

    public static ExternalDictionaryService getExternalDictionaryService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getExternalDictionaryService();
    }

    public static AuditQueryService getAuditQueryService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getAuditQueryService();
    }

    public static RepositoryQueryService getRepositoryQueryService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getRepositoryQueryService();
    }

    public static RecycleBinQueryService getRecycleBinQueryService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getRecycleBinQueryService();
    }

    public static ContextMembershipQueryService getMembershipQueryService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getMembershipQueryService();
    }

    public static PermissionsQueryService getPermissionsQueryService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getPermissionsQueryService();
    }

    public static AutoFlowService getAutoFlowService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getAutoFlowService();
    }

    public static StudyTlfService getStudyTlfService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getStudyTlfService();
    }

    public static ResourceUtilizationService getResourceUtilizationService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getResourceUtilizationService();
    }

    public static TlfTemplateService getTlfTemplateService() {
        return LsafClient.doGetCurrentSession().getServiceManager().getTlfTemplateService();
    }
}

