/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.workflow.task.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.svcs.work.task.client.InvalidTaskAssigneeException;
import com.sas.lsaf.svcs.work.task.client.TaskRequestException;
import com.sas.lsaf.svcs.work.task.client.query.TaskSearchService;
import com.sas.lsaf.svcs.work.workflow.client.HlsWorkflowException;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException;
import com.sas.lsaf.svcs.work.workflow.client.ProcessTask;
import com.sas.lsaf.svcs.work.workflow.client.ProcessUserTask;
import com.sas.lsaf.workflow.element.CompletedElement;
import com.sas.lsaf.workflow.element.Element;
import com.sas.lsaf.workflow.processflow.DataProperty;
import com.sas.lsaf.workflow.processflow.ProcessFlowException;
import com.sas.lsaf.workflow.processflow.ProcessFlowNotFoundException;
import com.sas.lsaf.workflow.processflow.impl.WorkflowHelper;
import com.sas.lsaf.workflow.task.InvalidTaskStateException;
import com.sas.lsaf.workflow.task.TaskNotFoundException;
import com.sas.lsaf.workflow.task.TaskQuery;
import com.sas.lsaf.workflow.task.TaskSearchException;
import com.sas.lsaf.workflow.task.TaskSearchResults;
import com.sas.lsaf.workflow.task.TaskService;
import com.sas.lsaf.workflow.task.UserTask;
import com.sas.lsaf.workflow.task.UserTaskDetails;
import com.sas.lsaf.workflow.task.UserTaskUpdateInfo;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class TaskServiceImpl
implements TaskService {
    private com.sas.lsaf.svcs.work.task.client.TaskService taskService;
    private TaskSearchService taskSearchService;
    private WorkflowHelper workflowHelper;
    private int searchSizeLimit = 5000;

    @Required
    public void setTaskService(com.sas.lsaf.svcs.work.task.client.TaskService taskService) {
        this.taskService = taskService;
    }

    @Required
    public void setWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    @Required
    public void setTaskSearchService(TaskSearchService taskSearchService) {
        this.taskSearchService = taskSearchService;
    }

    public UserTaskDetails getUserTaskDetails(String id) throws TaskNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"User task id is required.");
        try {
            return WorkflowHelper.toApiUserTaskDetails(this.taskService.getUserTaskDetailsByIdentifier(id));
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.TaskNotFoundException e) {
            throw new TaskNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<UserTask> getAllCurrentUserTasks() throws ProcessFlowException {
        try {
            return WorkflowHelper.toApiUserTasks(this.taskService.getAllUserTasks());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<UserTask> getCurrentUserTasks() throws ProcessFlowException {
        try {
            return WorkflowHelper.toApiUserTasks(this.taskService.getUserTasks());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void claimTask(String taskId) throws TaskNotFoundException, com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException, InvalidTaskStateException, ProcessFlowException {
        Assert.hasText((String)taskId, (String)"Task id is required.");
        try {
            this.taskService.claimTaskById(taskId);
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.TaskNotFoundException e) {
            throw new TaskNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.task.client.InvalidTaskStateException e) {
            throw new InvalidTaskStateException(e.getLocalizedMessage());
        }
        catch (InvalidTaskAssigneeException e) {
            throw new com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException(e.getLocalizedMessage());
        }
        catch (TaskRequestException | HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<CompletedElement> getCompletedElementsByProcessFlow(String id) throws ProcessFlowException, ProcessFlowNotFoundException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        try {
            return WorkflowHelper.toApiCompletedElements(this.taskService.getCompletedFlowElementsByProcessFlow(id), this.taskService);
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (ProcessDefinitionNotFoundException | com.sas.lsaf.svcs.work.workflow.client.TaskNotFoundException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Element> getCurrentElementsByProcessFlow(String id) throws ProcessFlowException, ProcessFlowNotFoundException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        try {
            return WorkflowHelper.toApiCurrentElements(this.taskService.getCurrentFlowElementsByProcessFlow(id));
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (ProcessDefinitionNotFoundException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void startTask(String taskId) throws InvalidTaskStateException, TaskNotFoundException, ProcessFlowException {
        Assert.hasText((String)taskId, (String)"Task id is required.");
        try {
            this.taskService.startTaskById(taskId);
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.TaskNotFoundException e) {
            throw new TaskNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.task.client.InvalidTaskStateException e) {
            throw new InvalidTaskStateException(e.getLocalizedMessage());
        }
        catch (TaskRequestException | HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void assignTask(String taskId, String assigneeId) throws InvalidTaskStateException, TaskNotFoundException, com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException, ProcessFlowException {
        Assert.hasText((String)taskId, (String)"Task id is required.");
        try {
            this.taskService.assignTask(taskId, null, assigneeId);
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.TaskNotFoundException e) {
            throw new TaskNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.task.client.InvalidTaskStateException e) {
            throw new InvalidTaskStateException(e.getLocalizedMessage());
        }
        catch (InvalidTaskAssigneeException e) {
            throw new com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException(e.getLocalizedMessage());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void completeTask(String taskId, float actualHours, Set<DataProperty> taskCompletionData, String comment) throws InvalidTaskStateException, TaskNotFoundException, ProcessFlowException {
        Assert.hasText((String)taskId, (String)"Task id is required.");
        try {
            this.taskService.completeTask(taskId, Double.valueOf(actualHours), WorkflowHelper.toServerCompletionProperties(taskCompletionData, taskId), comment);
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.TaskNotFoundException e) {
            throw new TaskNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.task.client.InvalidTaskStateException e) {
            throw new InvalidTaskStateException(e.getLocalizedMessage());
        }
        catch (TaskRequestException | HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public UserTask getCurrentUserTask(String taskId) throws TaskNotFoundException, ProcessFlowException {
        Assert.hasText((String)taskId, (String)"Task id is required.");
        try {
            ProcessTask task = this.taskService.getTaskByIdentifier(taskId);
            if (task instanceof ProcessUserTask) {
                return WorkflowHelper.toApiUserTask((ProcessUserTask)task);
            }
            throw new TaskNotFoundException("Task could not be found or is not a user task.");
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.TaskNotFoundException e) {
            throw new TaskNotFoundException(e.getLocalizedMessage());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public TaskSearchResults search(TaskQuery query) throws TaskSearchException {
        Assert.notNull((Object)query, (String)"Task query is required.");
        Assert.isTrue((query.getLimit() < this.getSearchLimit() ? 1 : 0) != 0, (String)("The search limit must not exceed " + this.getSearchLimit() + "."));
        if (query.getLimit() < 0) {
            throw new IllegalArgumentException("The query limit cannot be a negative value.");
        }
        try {
            return WorkflowHelper.toApiTaskSearchResults(this.taskSearchService.search(WorkflowHelper.toServerTaskQuery(query)));
        }
        catch (com.sas.lsaf.svcs.work.task.client.query.TaskSearchException e) {
            throw new TaskSearchException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public int getSearchLimit() {
        return this.searchSizeLimit;
    }

    public UserTaskDetails updateUserTask(UserTaskUpdateInfo taskDetails) throws TaskNotFoundException, com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException, InvalidTaskStateException, ProcessFlowException {
        Assert.notNull((Object)taskDetails, (String)"User task update information is required.");
        Assert.hasText((String)taskDetails.getId(), (String)"User task identifier required for update.");
        try {
            return WorkflowHelper.toApiUserTaskDetails(this.taskService.updateUserTask(this.workflowHelper.toServerUserTaskDetails(taskDetails)));
        }
        catch (TaskRequestException | HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.task.client.InvalidTaskStateException e) {
            throw new InvalidTaskStateException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.TaskNotFoundException e) {
            throw new TaskNotFoundException(e.getLocalizedMessage());
        }
        catch (InvalidTaskAssigneeException e) {
            throw new com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

