/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.workflow.processflow.setup.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.execution.job.impl.JobHelper;
import com.sas.lsaf.svcs.execution.job.client.JobService;
import com.sas.lsaf.svcs.work.processflow.client.FlowElementSetup;
import com.sas.lsaf.svcs.work.processflow.client.ProcessFlowService;
import com.sas.lsaf.svcs.work.processflow.client.ProcessTaskDefinitionNotFoundException;
import com.sas.lsaf.svcs.work.workflow.client.HlsWorkflowException;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException;
import com.sas.lsaf.workflow.processflow.InvalidProcessFlowStateException;
import com.sas.lsaf.workflow.processflow.InvalidRecipientException;
import com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException;
import com.sas.lsaf.workflow.processflow.ProcessFlowException;
import com.sas.lsaf.workflow.processflow.ProcessFlowNotFoundException;
import com.sas.lsaf.workflow.processflow.impl.WorkflowHelper;
import com.sas.lsaf.workflow.processflow.setup.ElementSetup;
import com.sas.lsaf.workflow.processflow.setup.JobTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.ProcessFlowElementSetupException;
import com.sas.lsaf.workflow.processflow.setup.ProcessFlowElementSetupNotFoundException;
import com.sas.lsaf.workflow.processflow.setup.ProcessFlowSetupService;
import com.sas.lsaf.workflow.processflow.setup.SignalEventSetup;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ProcessFlowSetupServiceImpl
implements ProcessFlowSetupService {
    private ProcessFlowService processFlowService;
    private JobService jobService;
    private WorkflowHelper workflowHelper;

    @Required
    public void setProcessFlowService(ProcessFlowService processFlowService) {
        this.processFlowService = processFlowService;
    }

    @Required
    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }

    @Required
    public void setWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    public Set<ElementSetup> getElementSetups(String id) throws ProcessFlowNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        try {
            return WorkflowHelper.toApiProcessFlowElementDefinitions(this.processFlowService.getProcessFlowElementDefinitions(id));
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (HlsWorkflowException | ProcessDefinitionNotFoundException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ElementSetup updateElementSetup(ElementSetup elementSetup) throws InvalidProcessFlowStateException, ProcessFlowNotFoundException, com.sas.lsaf.workflow.processdefinition.ProcessDefinitionNotFoundException, InvalidTaskAssigneeException, InvalidRecipientException, ProcessFlowException, ProcessFlowElementSetupNotFoundException, ProcessFlowElementSetupException {
        Assert.notNull((Object)elementSetup, (String)"Element definition information required for update");
        Assert.hasText((String)elementSetup.getProcessFlowIdentifier(), (String)"Process flow identifier on the element definition is required.");
        try {
            this.validateElement(elementSetup);
            FlowElementSetup serverElementDef = this.processFlowService.updateProcessFlowElementDefinition(this.workflowHelper.toServerProcessFlowElementDefinition(elementSetup), elementSetup.getProcessFlowIdentifier());
            return WorkflowHelper.toApiProcessFlowElementDefinition(serverElementDef);
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.InvalidProcessFlowStateException e) {
            throw new InvalidProcessFlowStateException(e.getLocalizedMessage());
        }
        catch (ProcessTaskDefinitionNotFoundException e) {
            throw new ProcessFlowElementSetupNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (ProcessDefinitionNotFoundException e) {
            throw new com.sas.lsaf.workflow.processdefinition.ProcessDefinitionNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.task.client.InvalidTaskAssigneeException e) {
            throw new InvalidTaskAssigneeException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.task.client.InvalidRecipientException e) {
            throw new InvalidRecipientException(e.getLocalizedMessage());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowElementSetupException e) {
            throw new ProcessFlowElementSetupException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private void validateElement(ElementSetup setup) {
        SignalEventSetup apiSignal;
        if (setup instanceof JobTaskSetup) {
            JobTaskSetup jobTask = (JobTaskSetup)setup;
            JobHelper.validateJobInfo(jobTask.getJobPath(), jobTask.getJobVersion(), true, jobTask.getParameterValues(), this.jobService);
        } else if (setup instanceof SignalEventSetup && (apiSignal = (SignalEventSetup)setup).getLocations() != null && !apiSignal.getLocations().isEmpty() && (apiSignal.getLocations().contains(null) || apiSignal.getLocations().contains(""))) {
            throw new ValidationException("Location value must not be null and must start with a '/'.");
        }
    }
}

