/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.workflow.processflow.impl;

import com.sas.lsaf.content.common.FileCreateInfo;
import com.sas.lsaf.content.repository.impl.RepositoryHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.execution.job.impl.JobHelper;
import com.sas.lsaf.security.principal.impl.PrincipalHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryContext;
import com.sas.lsaf.svcs.content.resource.server.ResourceUtils;
import com.sas.lsaf.svcs.core.common.client.Context;
import com.sas.lsaf.svcs.core.utils.client.ComparableUtils;
import com.sas.lsaf.svcs.core.utils.client.DateUtils;
import com.sas.lsaf.svcs.messaging.system.client.InternalMessage;
import com.sas.lsaf.svcs.security.user.client.UserService;
import com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException;
import com.sas.lsaf.svcs.work.autoflow.client.AutoFlowProcessDefinitionInfo;
import com.sas.lsaf.svcs.work.processflow.client.FlowElementSetup;
import com.sas.lsaf.svcs.work.processflow.client.IntermediateSignalCatchEventSetup;
import com.sas.lsaf.svcs.work.processflow.client.IntermediateTimerCatchEventSetup;
import com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor;
import com.sas.lsaf.svcs.work.processflow.client.ProcessJobSetup;
import com.sas.lsaf.svcs.work.processflow.client.ProcessNotificationSetup;
import com.sas.lsaf.svcs.work.processflow.client.ProcessUserTaskSetup;
import com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowQuery;
import com.sas.lsaf.svcs.work.task.client.TaskService;
import com.sas.lsaf.svcs.work.task.client.UserTaskUpdateInfo;
import com.sas.lsaf.svcs.work.task.client.query.TaskQuery;
import com.sas.lsaf.svcs.work.task.client.query.TaskSearchResults;
import com.sas.lsaf.svcs.work.workflow.client.ActivityType;
import com.sas.lsaf.svcs.work.workflow.client.AutoFlowMappingValidationInfo;
import com.sas.lsaf.svcs.work.workflow.client.CompletedEventGateway;
import com.sas.lsaf.svcs.work.workflow.client.CompletedFlowElement;
import com.sas.lsaf.svcs.work.workflow.client.CompletedJobTask;
import com.sas.lsaf.svcs.work.workflow.client.CompletedNotificationTask;
import com.sas.lsaf.svcs.work.workflow.client.CompletedTaskFormAttribute;
import com.sas.lsaf.svcs.work.workflow.client.CompletedUserTask;
import com.sas.lsaf.svcs.work.workflow.client.CompletedUserTaskDetails;
import com.sas.lsaf.svcs.work.workflow.client.FormAttributeDefinition;
import com.sas.lsaf.svcs.work.workflow.client.HlsWorkflowException;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinition;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionDescriptor;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionMapping;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionService;
import com.sas.lsaf.svcs.work.workflow.client.ProcessFlowElement;
import com.sas.lsaf.svcs.work.workflow.client.ProcessJobTask;
import com.sas.lsaf.svcs.work.workflow.client.ProcessNotificationTask;
import com.sas.lsaf.svcs.work.workflow.client.ProcessSignalEvent;
import com.sas.lsaf.svcs.work.workflow.client.ProcessTask;
import com.sas.lsaf.svcs.work.workflow.client.ProcessTimerEvent;
import com.sas.lsaf.svcs.work.workflow.client.ProcessUserTask;
import com.sas.lsaf.svcs.work.workflow.client.ProcessVariable;
import com.sas.lsaf.svcs.work.workflow.client.SignalDefinition;
import com.sas.lsaf.svcs.work.workflow.client.SignalEventDefinition;
import com.sas.lsaf.svcs.work.workflow.client.TaskFormAttribute;
import com.sas.lsaf.svcs.work.workflow.client.TaskNotFoundException;
import com.sas.lsaf.svcs.work.workflow.client.TimerType;
import com.sas.lsaf.workflow.AttributeMapping;
import com.sas.lsaf.workflow.AutoFlowMappingMetadata;
import com.sas.lsaf.workflow.AutoFlowType;
import com.sas.lsaf.workflow.FlowAttributeType;
import com.sas.lsaf.workflow.FlowElementMapping;
import com.sas.lsaf.workflow.MappingAttributeMetadata;
import com.sas.lsaf.workflow.element.CompletedElement;
import com.sas.lsaf.workflow.element.CompletedEvent;
import com.sas.lsaf.workflow.element.CompletedSignalEvent;
import com.sas.lsaf.workflow.element.Element;
import com.sas.lsaf.workflow.element.SignalEvent;
import com.sas.lsaf.workflow.element.TimerEvent;
import com.sas.lsaf.workflow.processdefinition.FlowElementDefinition;
import com.sas.lsaf.workflow.processdefinition.FormAttributeDefinition;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionInfo;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMappingMetadata;
import com.sas.lsaf.workflow.processdefinition.TaskDefinition;
import com.sas.lsaf.workflow.processdefinition.TimerEventDefinition;
import com.sas.lsaf.workflow.processflow.CreationMethod;
import com.sas.lsaf.workflow.processflow.DataProperty;
import com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException;
import com.sas.lsaf.workflow.processflow.ProcessFlow;
import com.sas.lsaf.workflow.processflow.ProcessFlowCopyInfo;
import com.sas.lsaf.workflow.processflow.ProcessFlowDescriptor;
import com.sas.lsaf.workflow.processflow.ProcessFlowQuery;
import com.sas.lsaf.workflow.processflow.ProcessFlowSearchResultItem;
import com.sas.lsaf.workflow.processflow.setup.ElementSetup;
import com.sas.lsaf.workflow.processflow.setup.JobTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.NotificationTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.SignalEventSetup;
import com.sas.lsaf.workflow.processflow.setup.TimerEventSetup;
import com.sas.lsaf.workflow.processflow.setup.UserTaskSetup;
import com.sas.lsaf.workflow.task.JobTask;
import com.sas.lsaf.workflow.task.NotificationTask;
import com.sas.lsaf.workflow.task.Task;
import com.sas.lsaf.workflow.task.TaskQuery;
import com.sas.lsaf.workflow.task.UserTask;
import com.sas.lsaf.workflow.task.UserTaskAssignment;
import com.sas.lsaf.workflow.task.UserTaskDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;

public final class WorkflowHelper {
    private ProcessDefinitionService processDefinitionService = null;
    private UserService userService;

    @Required
    public void setProcessDefinitionService(ProcessDefinitionService processDefinitionService) {
        this.processDefinitionService = processDefinitionService;
    }

    @Required
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public ProcessFlowDescriptor toApiProcessFlowDescriptor(com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor serverProcessFlowDescriptor) {
        if (serverProcessFlowDescriptor == null) {
            return null;
        }
        ProcessDefinitionInfo pdi = null;
        try {
            ProcessDefinition pd = this.processDefinitionService.getLatestVersionOfProcessDefinitionByKey(serverProcessFlowDescriptor.getProcessDefinitionKey());
            pdi = WorkflowHelper.toApiProcessDefinitionInfo(pd);
        }
        catch (ProcessDefinitionNotFoundException pd) {
            // empty catch block
        }
        ProcessFlowDescriptor apiProcessFlow = new ProcessFlowDescriptor(serverProcessFlowDescriptor.getId(), serverProcessFlowDescriptor.getContext().getId(), serverProcessFlowDescriptor.getContext().getPath(), serverProcessFlowDescriptor.getName(), serverProcessFlowDescriptor.getDescription(), WorkflowHelper.toApiFlowStatus(serverProcessFlowDescriptor.getStatus()), serverProcessFlowDescriptor.getOwner(), pdi, serverProcessFlowDescriptor.getCreatedBy(), serverProcessFlowDescriptor.getCreated(), serverProcessFlowDescriptor.getLastModifiedBy(), serverProcessFlowDescriptor.getLastModified(), serverProcessFlowDescriptor.getRevision(), WorkflowHelper.toApiAutoFlowType(serverProcessFlowDescriptor.getAutoFlowType()));
        return apiProcessFlow;
    }

    public static ProcessFlow toApiProcessFlow(com.sas.lsaf.svcs.work.processflow.client.ProcessFlow serverProcessFlow) {
        if (serverProcessFlow == null) {
            return null;
        }
        ProcessFlow apiProcessFlow = new ProcessFlow(serverProcessFlow.getId(), serverProcessFlow.getContext().getId(), serverProcessFlow.getContext().getPath(), serverProcessFlow.getName(), serverProcessFlow.getDescription(), WorkflowHelper.toApiFlowStatus(serverProcessFlow.getStatus()), serverProcessFlow.getOwner(), WorkflowHelper.toApiProcessDefinitionInfo(serverProcessFlow.getProcessDefinition()), serverProcessFlow.getCreatedBy(), serverProcessFlow.getCreated(), serverProcessFlow.getLastModifiedBy(), serverProcessFlow.getLastModified(), serverProcessFlow.getRevision(), serverProcessFlow.getAutoFlowSource(), WorkflowHelper.toApiAutoFlowType(serverProcessFlow.getAutoFlowType()));
        apiProcessFlow.setAttributes(CoreHelper.toApiAttributes(serverProcessFlow.getAttributes()));
        apiProcessFlow.setProcessData(WorkflowHelper.toApiDataProperties(serverProcessFlow.getProcessData()));
        return apiProcessFlow;
    }

    public static com.sas.lsaf.svcs.work.processflow.client.ProcessFlow toServerProcessFlow(ProcessFlow apiProcessFlow, RepositoryContext serverContext) {
        if (apiProcessFlow == null) {
            return null;
        }
        com.sas.lsaf.svcs.work.processflow.client.ProcessFlow serverProcessFlow = new com.sas.lsaf.svcs.work.processflow.client.ProcessFlow();
        serverProcessFlow.setId(apiProcessFlow.getId());
        serverProcessFlow.setName(apiProcessFlow.getName());
        serverProcessFlow.setContext((Context)serverContext);
        serverProcessFlow.setDescription(apiProcessFlow.getDescription());
        serverProcessFlow.setOwner(apiProcessFlow.getOwner() != null ? apiProcessFlow.getOwner().trim() : null);
        serverProcessFlow.setRevision(apiProcessFlow.getRevision());
        serverProcessFlow.setProcessDefinition(new ProcessDefinition());
        serverProcessFlow.setProcessDefinitionKey(apiProcessFlow.getProcessDefinitionInfo().getId());
        serverProcessFlow.setStatus(WorkflowHelper.toServerFlowStatus(apiProcessFlow.getStatus()));
        serverProcessFlow.setAttributes(CoreHelper.toServerAttributes(apiProcessFlow.getAttributes()));
        serverProcessFlow.setProcessData(WorkflowHelper.toServerDataProperties(apiProcessFlow.getProcessData()));
        return serverProcessFlow;
    }

    public static com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor toServerProcessFlowDescriptor(ProcessFlowDescriptor apiProcessFlowDescriptor, RepositoryContext serverContext) {
        if (apiProcessFlowDescriptor == null) {
            return null;
        }
        com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor serverProcessFlow = new com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor();
        serverProcessFlow.setId(apiProcessFlowDescriptor.getId());
        serverProcessFlow.setName(apiProcessFlowDescriptor.getName());
        serverProcessFlow.setContext((Context)serverContext);
        serverProcessFlow.setDescription(apiProcessFlowDescriptor.getDescription());
        serverProcessFlow.setOwner(apiProcessFlowDescriptor.getOwner() != null ? apiProcessFlowDescriptor.getOwner().trim() : null);
        serverProcessFlow.setRevision(apiProcessFlowDescriptor.getRevision());
        if (apiProcessFlowDescriptor.getProcessDefinitionInfo() != null) {
            serverProcessFlow.setProcessDefinitionKey(apiProcessFlowDescriptor.getProcessDefinitionInfo().getId());
        }
        serverProcessFlow.setStatus(WorkflowHelper.toServerFlowStatus(apiProcessFlowDescriptor.getStatus()));
        return serverProcessFlow;
    }

    private static DataProperty toApiDataProperty(ProcessVariable serverDataProperty) {
        if (serverDataProperty == null) {
            return null;
        }
        return new DataProperty(serverDataProperty.getId(), serverDataProperty.getName(), WorkflowHelper.toApiDataPropertyType(serverDataProperty.getType()), serverDataProperty.getValue(), serverDataProperty.getValues(), serverDataProperty.getDatePattern());
    }

    private static UserTaskAssignment toApiUserTaskAssignment(com.sas.lsaf.svcs.work.task.client.UserTaskAssignment serverUserTaskAssignment) {
        if (serverUserTaskAssignment == null) {
            return null;
        }
        return new UserTaskAssignment(serverUserTaskAssignment.getId(), serverUserTaskAssignment.getTaskIdentifier(), serverUserTaskAssignment.getTaskId(), serverUserTaskAssignment.getDateStarted(), serverUserTaskAssignment.getDateAssigned(), serverUserTaskAssignment.getAssignee() != null ? PrincipalHelper.toApiPrincipal(serverUserTaskAssignment.getAssignee()) : null, serverUserTaskAssignment.getHoursWorked() != null ? Float.valueOf(serverUserTaskAssignment.getHoursWorked().toString()).floatValue() : 0.0f);
    }

    private static DataProperty toApiCompletionProperty(TaskFormAttribute serverAttr) {
        if (serverAttr == null) {
            return null;
        }
        return new DataProperty(serverAttr.getId(), serverAttr.getName(), WorkflowHelper.toApiDataPropertyType(serverAttr.getType()), serverAttr.getValue(), serverAttr.getValues(), serverAttr.getDatePattern());
    }

    public static Set<DataProperty> toApiCompletedProperties(Set<CompletedTaskFormAttribute> serverCompletionProperties) {
        HashSet<DataProperty> rval = new HashSet<DataProperty>();
        if (serverCompletionProperties != null) {
            for (CompletedTaskFormAttribute prop : serverCompletionProperties) {
                if (prop == null) continue;
                rval.add(WorkflowHelper.toApiCompletedProperty(prop.getId(), prop.getName(), prop.getType(), prop.getValue()));
            }
        }
        return rval;
    }

    private static DataProperty toApiCompletedProperty(String id, String name, FormAttributeDefinition.FormAttributeType type, Serializable value) {
        return new DataProperty(id, name, WorkflowHelper.toApiDataPropertyType(type), value);
    }

    public static Set<DataProperty> toApiUserTaskCompletionProperties(Set<TaskFormAttribute> serverCompletionProperties) {
        HashSet<DataProperty> rval = new HashSet<DataProperty>();
        if (serverCompletionProperties != null) {
            for (TaskFormAttribute prop : serverCompletionProperties) {
                if (prop == null) continue;
                rval.add(WorkflowHelper.toApiCompletionProperty(prop));
            }
        }
        return rval;
    }

    public static ProcessDefinitionInfo toApiProcessDefinitionInfo(ProcessDefinition serverProcessDefinition) {
        return new ProcessDefinitionInfo(serverProcessDefinition.getId(), serverProcessDefinition.getKey(), serverProcessDefinition.getName(), serverProcessDefinition.getDescription(), serverProcessDefinition.getVersion(), serverProcessDefinition.getSourcePath(), serverProcessDefinition.getSourceVersion(), serverProcessDefinition.getContextTypes(), WorkflowHelper.toApiProcessDefinitionStatus(serverProcessDefinition.getStatus()), serverProcessDefinition.getComments());
    }

    public static ProcessDefinitionInfo toApiProcessDefinitionInfoFromDescriptor(ProcessDefinitionDescriptor serverProcessDefinition) {
        return new ProcessDefinitionInfo(serverProcessDefinition.getId(), serverProcessDefinition.getKey(), serverProcessDefinition.getName(), serverProcessDefinition.getDescription(), serverProcessDefinition.getVersion(), serverProcessDefinition.getSourcePath(), serverProcessDefinition.getSourceVersion(), serverProcessDefinition.getContextTypes(), WorkflowHelper.toApiProcessDefinitionStatus(serverProcessDefinition.getStatus()), serverProcessDefinition.getComments());
    }

    public static ProcessDefinitionDescriptor toServerProcessDefinitionDescriptor(ProcessDefinitionInfo apiProcessDefinition) {
        ProcessDefinitionDescriptor serverItem = new ProcessDefinitionDescriptor();
        serverItem.setId(apiProcessDefinition.getId());
        serverItem.setKey(apiProcessDefinition.getProcessDefinitionKey());
        serverItem.setVersion(apiProcessDefinition.getDeployedVersion());
        return serverItem;
    }

    public static List<ProcessDefinitionInfo> toApiProcessDefinitionInfos(List<ProcessDefinition> serverProcessDefinitions) {
        ArrayList<ProcessDefinitionInfo> rval = new ArrayList<ProcessDefinitionInfo>();
        if (serverProcessDefinitions != null) {
            for (ProcessDefinition pd : serverProcessDefinitions) {
                if (pd == null) continue;
                rval.add(WorkflowHelper.toApiProcessDefinitionInfo(pd));
            }
        }
        return rval;
    }

    public static List<ProcessDefinitionInfo> toApiProcessDefinitionInfosFromDescriptors(List<ProcessDefinitionDescriptor> serverProcessDefinitions) {
        ArrayList<ProcessDefinitionInfo> rval = new ArrayList<ProcessDefinitionInfo>();
        if (serverProcessDefinitions != null) {
            for (ProcessDefinitionDescriptor pd : serverProcessDefinitions) {
                if (pd == null) continue;
                rval.add(WorkflowHelper.toApiProcessDefinitionInfoFromDescriptor(pd));
            }
        }
        return rval;
    }

    public Set<ProcessFlowDescriptor> toApiProcessFlowDescriptors(Set<com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor> serverProcessFlowDescriptors) {
        HashSet<ProcessFlowDescriptor> rval = new HashSet<ProcessFlowDescriptor>();
        if (serverProcessFlowDescriptors != null) {
            for (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor pfd : serverProcessFlowDescriptors) {
                rval.add(this.toApiProcessFlowDescriptor(pfd));
            }
        }
        return rval;
    }

    private static ProcessFlowDescriptor.FlowStatus toApiFlowStatus(ProcessFlowDescriptor.Status serverStatus) {
        if (serverStatus == null) {
            return null;
        }
        switch (serverStatus) {
            case ACTIVE: {
                return ProcessFlowDescriptor.FlowStatus.ACTIVE;
            }
            case COMPLETED: {
                return ProcessFlowDescriptor.FlowStatus.COMPLETED;
            }
            case NOT_STARTED: {
                return ProcessFlowDescriptor.FlowStatus.NOT_STARTED;
            }
            case SUSPENDED: {
                return ProcessFlowDescriptor.FlowStatus.SUSPENDED;
            }
        }
        throw new SystemException("Unmapped process flow status: " + serverStatus.name());
    }

    private static AutoFlowType toApiAutoFlowType(ProcessDefinitionMapping.AutoFlowType serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case TLF: {
                return AutoFlowType.TLF;
            }
        }
        throw new SystemException("Unmapped server autoflow type: " + serverItem.name());
    }

    private static CreationMethod toApiCreationMethod(ProcessDefinitionMapping.AutoFlowType serverItem) {
        CreationMethod rval = CreationMethod.MANUAL;
        if (serverItem != null && serverItem == ProcessDefinitionMapping.AutoFlowType.TLF) {
            rval = CreationMethod.TLF;
        }
        return rval;
    }

    public static ProcessDefinitionMapping.AutoFlowType toServerAutoFlowType(AutoFlowType apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case TLF: {
                return ProcessDefinitionMapping.AutoFlowType.TLF;
            }
        }
        throw new SystemException("Unmapped api autoflow type: " + apiItem.name());
    }

    private static ProcessFlowDescriptor.FlowStatus toApiTaskFlowStatus(ProcessTask.WorkflowStatus serverStatus) {
        if (serverStatus == null) {
            return null;
        }
        switch (serverStatus) {
            case ACTIVE: {
                return ProcessFlowDescriptor.FlowStatus.ACTIVE;
            }
            case COMPLETED: {
                return ProcessFlowDescriptor.FlowStatus.COMPLETED;
            }
            case SUSPENDED: {
                return ProcessFlowDescriptor.FlowStatus.SUSPENDED;
            }
        }
        throw new SystemException("Unmapped workflow status: " + serverStatus.name());
    }

    private static Task.TaskStatus toApiTaskStatus(ProcessTask.TaskStatus serverTaskStatus) {
        if (serverTaskStatus == null) {
            return null;
        }
        switch (serverTaskStatus) {
            case ASSIGNED: {
                return Task.TaskStatus.ASSIGNED;
            }
            case STARTED: {
                return Task.TaskStatus.STARTED;
            }
            case UNASSIGNED: {
                return Task.TaskStatus.UNASSIGNED;
            }
        }
        throw new SystemException("Unmapped task status: " + serverTaskStatus.name());
    }

    private static ProcessTask.TaskStatus toServerTaskStatus(Task.TaskStatus apiTaskStatus) {
        if (apiTaskStatus == null) {
            return null;
        }
        switch (apiTaskStatus) {
            case ASSIGNED: {
                return ProcessTask.TaskStatus.ASSIGNED;
            }
            case STARTED: {
                return ProcessTask.TaskStatus.STARTED;
            }
            case UNASSIGNED: {
                return ProcessTask.TaskStatus.UNASSIGNED;
            }
        }
        throw new SystemException("Unmapped task status: " + apiTaskStatus.name());
    }

    private static ProcessFlowDescriptor.Status toServerFlowStatus(ProcessFlowDescriptor.FlowStatus apiStatus) {
        if (apiStatus == null) {
            return null;
        }
        switch (apiStatus) {
            case ACTIVE: {
                return ProcessFlowDescriptor.Status.ACTIVE;
            }
            case COMPLETED: {
                return ProcessFlowDescriptor.Status.COMPLETED;
            }
            case NOT_STARTED: {
                return ProcessFlowDescriptor.Status.NOT_STARTED;
            }
            case SUSPENDED: {
                return ProcessFlowDescriptor.Status.SUSPENDED;
            }
        }
        throw new SystemException("Unmapped process flow status: " + apiStatus.name());
    }

    private static ProcessTask.WorkflowStatus toServerWorkflowStatus(ProcessFlowDescriptor.FlowStatus apiStatus) {
        if (apiStatus == null) {
            return null;
        }
        switch (apiStatus) {
            case ACTIVE: {
                return ProcessTask.WorkflowStatus.ACTIVE;
            }
            case COMPLETED: {
                return ProcessTask.WorkflowStatus.COMPLETED;
            }
            case SUSPENDED: {
                return ProcessTask.WorkflowStatus.SUSPENDED;
            }
        }
        throw new SystemException("Unmapped workflow status: " + apiStatus.name());
    }

    private static CompletedElement.TaskCompletedState toApiTaskCompletedState(CompletedFlowElement.FlowElementCompletedState serverTaskCompletedState) {
        if (serverTaskCompletedState == null) {
            return null;
        }
        switch (serverTaskCompletedState) {
            case COMPLETED_CANCELED: {
                return CompletedElement.TaskCompletedState.COMPLETED_CANCELED;
            }
            case COMPLETED_CHECKIN_ERROR: {
                return CompletedElement.TaskCompletedState.COMPLETED_CHECKIN_ERROR;
            }
            case COMPLETED_FAILED: {
                return CompletedElement.TaskCompletedState.COMPLETED_FAILED;
            }
            case COMPLETED_PROGRAM_ERRORS: {
                return CompletedElement.TaskCompletedState.COMPLETED_SASERRORS;
            }
            case COMPLETED_PROGRAM_ERRORS_CHECKIN_ERROR: {
                return CompletedElement.TaskCompletedState.COMPLETED_SASERRORS_CHECKIN_ERROR;
            }
            case COMPLETED_PROGRAM_WARNINGS: {
                return CompletedElement.TaskCompletedState.COMPLETED_SASWARNINGS;
            }
            case COMPLETED_PROGRAM_WARNINGS_CHECKIN_ERROR: {
                return CompletedElement.TaskCompletedState.COMPLETED_SASWARNINGS_CHECKIN_ERROR;
            }
            case COMPLETED_SUCCESSFUL: {
                return CompletedElement.TaskCompletedState.COMPLETED_SUCCESSFUL;
            }
            case NO_VALID_RECIPIENTS: {
                return CompletedElement.TaskCompletedState.NO_VALID_RECIPIENTS;
            }
            case PROCESS_FLOW_OWNER_ACCOUNT_ERROR: {
                return CompletedElement.TaskCompletedState.PROCESS_FLOW_OWNER_ACCOUNT_ERROR;
            }
            case SETUP_NOT_ENTERED: {
                return CompletedElement.TaskCompletedState.SETUP_NOT_ENTERED;
            }
            case TERMINATED: {
                return CompletedElement.TaskCompletedState.TERMINATED;
            }
            case UNKNOWN: {
                return CompletedElement.TaskCompletedState.UNKNOWN;
            }
        }
        throw new SystemException("Unmapped task completed state: " + serverTaskCompletedState.name());
    }

    private static Element.ElementType toApiActivityType(ActivityType serverActivityType) {
        if (serverActivityType == null) {
            return null;
        }
        switch (serverActivityType) {
            case EVENT_GATEWAY: {
                return Element.ElementType.EVENT_GATEWAY;
            }
            case INTERMEDIATE_CATCH_SIGNAL_EVENT: {
                return Element.ElementType.INTERMEDIATE_CATCH_SIGNAL_EVENT;
            }
            case INTERMEDIATE_CATCH_TIMER_EVENT: {
                return Element.ElementType.INTERMEDIATE_CATCH_TIMER_EVENT;
            }
            case SYSTEM_JOB_EXEC: {
                return Element.ElementType.SYSTEM_JOB_EXEC;
            }
            case SYSTEM_JOB_EXEC_NO_WAIT: {
                return Element.ElementType.SYSTEM_JOB_EXEC_NO_WAIT;
            }
            case SYSTEM_NOTIFICATION: {
                return Element.ElementType.SYSTEM_NOTIFICATION;
            }
            case USER_TASK: {
                return Element.ElementType.USER_TASK;
            }
            case TERMINATE_END: {
                return Element.ElementType.TERMINATE_END;
            }
            case START: {
                return Element.ElementType.START;
            }
            case END: {
                return Element.ElementType.END;
            }
        }
        throw new SystemException("Unmapped activity type: " + serverActivityType.name());
    }

    private static ActivityType toServerActivityType(Element.ElementType apiActivityType) {
        if (apiActivityType == null) {
            return null;
        }
        switch (apiActivityType) {
            case EVENT_GATEWAY: {
                return ActivityType.EVENT_GATEWAY;
            }
            case INTERMEDIATE_CATCH_SIGNAL_EVENT: {
                return ActivityType.INTERMEDIATE_CATCH_SIGNAL_EVENT;
            }
            case INTERMEDIATE_CATCH_TIMER_EVENT: {
                return ActivityType.INTERMEDIATE_CATCH_TIMER_EVENT;
            }
            case SYSTEM_JOB_EXEC: {
                return ActivityType.SYSTEM_JOB_EXEC;
            }
            case SYSTEM_JOB_EXEC_NO_WAIT: {
                return ActivityType.SYSTEM_JOB_EXEC_NO_WAIT;
            }
            case SYSTEM_NOTIFICATION: {
                return ActivityType.SYSTEM_NOTIFICATION;
            }
            case USER_TASK: {
                return ActivityType.USER_TASK;
            }
        }
        throw new SystemException("Unmapped activity type: " + apiActivityType.name());
    }

    private static Task.Complexity toApiComplexity(ProcessTask.Complexity serverComplexity) {
        if (serverComplexity == null) {
            return null;
        }
        switch (serverComplexity) {
            case HIGH: {
                return Task.Complexity.HIGH;
            }
            case MEDIUM: {
                return Task.Complexity.MEDIUM;
            }
            case LOW: {
                return Task.Complexity.LOW;
            }
        }
        throw new SystemException("Unmapped complexity: " + serverComplexity.name());
    }

    private static ProcessTask.Complexity toServerComplexity(Task.Complexity apiComplexity) {
        if (apiComplexity == null) {
            return null;
        }
        switch (apiComplexity) {
            case HIGH: {
                return ProcessTask.Complexity.HIGH;
            }
            case MEDIUM: {
                return ProcessTask.Complexity.MEDIUM;
            }
            case LOW: {
                return ProcessTask.Complexity.LOW;
            }
        }
        throw new SystemException("Unmapped complexity: " + apiComplexity.name());
    }

    private static TimerEventSetup.TimerType toApiTimerType(TimerType serverTimerType) {
        if (serverTimerType == null) {
            return null;
        }
        switch (serverTimerType) {
            case DATE: {
                return TimerEventSetup.TimerType.DATE;
            }
            case DURATION: {
                return TimerEventSetup.TimerType.DURATION;
            }
        }
        throw new SystemException("Unmapped timer type: " + serverTimerType.name());
    }

    private static TimerType toServerTimerType(TimerEventSetup.TimerType apiTimerType) {
        if (apiTimerType == null) {
            return null;
        }
        switch (apiTimerType) {
            case DATE: {
                return TimerType.DATE;
            }
            case DURATION: {
                return TimerType.DURATION;
            }
        }
        throw new SystemException("Unmapped timer type: " + apiTimerType.name());
    }

    private static Task.Priority toApiTaskPriority(ProcessTask.Priority serverPriority) {
        if (serverPriority == null) {
            return null;
        }
        switch (serverPriority) {
            case ALERT: {
                return Task.Priority.ALERT;
            }
            case HIGH: {
                return Task.Priority.HIGH;
            }
            case MEDIUM: {
                return Task.Priority.MEDIUM;
            }
            case LOW: {
                return Task.Priority.LOW;
            }
        }
        throw new SystemException("Unmapped task priority: " + serverPriority.name());
    }

    private static ProcessTask.Priority toServerPriority(Task.Priority apiPriority) {
        if (apiPriority == null) {
            return null;
        }
        switch (apiPriority) {
            case ALERT: {
                return ProcessTask.Priority.ALERT;
            }
            case HIGH: {
                return ProcessTask.Priority.HIGH;
            }
            case MEDIUM: {
                return ProcessTask.Priority.MEDIUM;
            }
            case LOW: {
                return ProcessTask.Priority.LOW;
            }
        }
        throw new SystemException("Unmapped task priority: " + apiPriority.name());
    }

    private static NotificationTaskSetup.MessagePriority toApiNotificationTaskPriority(InternalMessage.Priority serverMessagePriority) {
        if (serverMessagePriority == null) {
            return null;
        }
        switch (serverMessagePriority) {
            case HIGH: {
                return NotificationTaskSetup.MessagePriority.HIGH;
            }
            case MEDIUM: {
                return NotificationTaskSetup.MessagePriority.MEDIUM;
            }
            case LOW: {
                return NotificationTaskSetup.MessagePriority.LOW;
            }
        }
        throw new SystemException("Unmapped task message priority: " + serverMessagePriority.name());
    }

    private static InternalMessage.Priority toServerNotificationTaskPriority(NotificationTaskSetup.MessagePriority apiMessagePriority) {
        if (apiMessagePriority == null) {
            return null;
        }
        switch (apiMessagePriority) {
            case HIGH: {
                return InternalMessage.Priority.HIGH;
            }
            case MEDIUM: {
                return InternalMessage.Priority.MEDIUM;
            }
            case LOW: {
                return InternalMessage.Priority.LOW;
            }
        }
        throw new SystemException("Unmapped task message priority: " + apiMessagePriority.name());
    }

    private static DataProperty.Type toApiDataPropertyType(FormAttributeDefinition.FormAttributeType serverType) {
        if (serverType == null) {
            return null;
        }
        switch (serverType) {
            case BOOLEAN: {
                return DataProperty.Type.BOOLEAN;
            }
            case DATE: {
                return DataProperty.Type.DATE;
            }
            case ENUM: {
                return DataProperty.Type.ENUM;
            }
            case LONG: {
                return DataProperty.Type.LONG;
            }
            case STRING: {
                return DataProperty.Type.STRING;
            }
        }
        throw new SystemException("Unmapped data property type: " + serverType.name());
    }

    private static FormAttributeDefinition.FormAttributeType toServerDataPropertyType(DataProperty.Type apiType) {
        if (apiType == null) {
            return null;
        }
        switch (apiType) {
            case BOOLEAN: {
                return FormAttributeDefinition.FormAttributeType.BOOLEAN;
            }
            case DATE: {
                return FormAttributeDefinition.FormAttributeType.DATE;
            }
            case ENUM: {
                return FormAttributeDefinition.FormAttributeType.ENUM;
            }
            case LONG: {
                return FormAttributeDefinition.FormAttributeType.LONG;
            }
            case STRING: {
                return FormAttributeDefinition.FormAttributeType.STRING;
            }
        }
        throw new SystemException("Unmapped data property type: " + apiType.name());
    }

    public static Set<ElementSetup> toApiProcessFlowElementDefinitions(List<FlowElementSetup> processFlowElementDefinitions) {
        HashSet<ElementSetup> rval = new HashSet<ElementSetup>();
        if (processFlowElementDefinitions != null) {
            for (FlowElementSetup setup : processFlowElementDefinitions) {
                if (setup == null) continue;
                rval.add(WorkflowHelper.toApiProcessFlowElementDefinition(setup));
            }
        }
        return rval;
    }

    public static Set<UserTaskAssignment> toApiUserTaskAssignments(Set<com.sas.lsaf.svcs.work.task.client.UserTaskAssignment> serverUTAssignments) {
        ArrayList<UserTaskAssignment> rval = new ArrayList<UserTaskAssignment>();
        if (serverUTAssignments != null) {
            for (com.sas.lsaf.svcs.work.task.client.UserTaskAssignment uta : serverUTAssignments) {
                if (uta == null) continue;
                rval.add(WorkflowHelper.toApiUserTaskAssignment(uta));
            }
            rval.sort(new Comparator<UserTaskAssignment>(){

                @Override
                public int compare(UserTaskAssignment s1, UserTaskAssignment s2) {
                    return DateUtils.compareTo((Date)s1.getDateAssigned(), (Date)s2.getDateAssigned());
                }
            });
        }
        LinkedHashSet<UserTaskAssignment> rvalSet = new LinkedHashSet<UserTaskAssignment>();
        for (UserTaskAssignment e : rval) {
            rvalSet.add(e);
        }
        return rvalSet;
    }

    public static Set<DataProperty> toApiDataProperties(Set<ProcessVariable> serverDataProperties) {
        HashSet<DataProperty> rval = new HashSet<DataProperty>();
        if (serverDataProperties != null) {
            for (ProcessVariable pv : serverDataProperties) {
                if (pv == null) continue;
                rval.add(WorkflowHelper.toApiDataProperty(pv));
            }
        }
        return rval;
    }

    public static Set<ProcessVariable> toServerDataProperties(Set<DataProperty> apiDataProperties) {
        HashSet<ProcessVariable> rval = new HashSet<ProcessVariable>();
        if (apiDataProperties != null) {
            for (DataProperty pv : apiDataProperties) {
                rval.add(WorkflowHelper.toServerDataProperty(pv));
            }
        }
        return rval;
    }

    public static Set<TaskFormAttribute> toServerCompletionProperties(Set<DataProperty> apiDataProperties, String taskId) {
        HashSet<TaskFormAttribute> rval = new HashSet<TaskFormAttribute>();
        if (apiDataProperties != null) {
            for (DataProperty prop : apiDataProperties) {
                if (prop == null) continue;
                rval.add(WorkflowHelper.toServerTaskFormAttribute(prop, taskId));
            }
        }
        return rval;
    }

    private static TaskFormAttribute toServerTaskFormAttribute(DataProperty pv, String taskId) {
        if (pv != null) {
            TaskFormAttribute attr = new TaskFormAttribute();
            attr.setId(pv.getId());
            attr.setTaskIdentifier(taskId);
            attr.setName(pv.getName());
            attr.setDatePattern(pv.getDatePattern());
            attr.setType(WorkflowHelper.toServerDataPropertyType(pv.getType()));
            attr.setValue(pv.getValue());
            attr.setValues(pv.getValues());
            return attr;
        }
        return null;
    }

    private static ProcessVariable toServerDataProperty(DataProperty apiDataProp) {
        if (apiDataProp == null) {
            return null;
        }
        ProcessVariable prop = new ProcessVariable(apiDataProp.getId(), apiDataProp.getName(), apiDataProp.getValue(), WorkflowHelper.toServerDataPropertyType(apiDataProp.getType()), apiDataProp.getValues());
        prop.setDatePattern(apiDataProp.getDatePattern());
        return prop;
    }

    public static FlowElementDefinition toApiProcessDefinitionElement(com.sas.lsaf.svcs.work.workflow.client.FlowElementDefinition serverItem) {
        if (serverItem instanceof SignalEventDefinition) {
            SignalEventDefinition signalDef = (SignalEventDefinition)serverItem;
            return new com.sas.lsaf.workflow.processdefinition.SignalEventDefinition(signalDef.getId(), signalDef.getName(), signalDef.getDescription(), WorkflowHelper.toApiActivityType(signalDef.getActivityType()), signalDef.getParentId(), WorkflowHelper.toApiSignalDefinition(signalDef.getSignal()));
        }
        if (serverItem instanceof com.sas.lsaf.svcs.work.workflow.client.TimerEventDefinition) {
            com.sas.lsaf.svcs.work.workflow.client.TimerEventDefinition timerDef = (com.sas.lsaf.svcs.work.workflow.client.TimerEventDefinition)serverItem;
            return new TimerEventDefinition(timerDef.getId(), timerDef.getName(), timerDef.getDescription(), WorkflowHelper.toApiActivityType(timerDef.getActivityType()), timerDef.getParentId(), WorkflowHelper.toApiTimerType(timerDef.getTimerType()), ((com.sas.lsaf.svcs.work.workflow.client.TimerEventDefinition)serverItem).getTimerValue());
        }
        if (serverItem instanceof com.sas.lsaf.svcs.work.workflow.client.TaskDefinition) {
            com.sas.lsaf.svcs.work.workflow.client.TaskDefinition timerDef = (com.sas.lsaf.svcs.work.workflow.client.TaskDefinition)serverItem;
            return new TaskDefinition(timerDef.getId(), timerDef.getName(), timerDef.getDescription(), WorkflowHelper.toApiActivityType(timerDef.getActivityType()), timerDef.getParentId(), WorkflowHelper.toApiTaskDefinitionCompletionProperties(timerDef.getCompletionAttributes()));
        }
        return new FlowElementDefinition(serverItem.getId(), serverItem.getName(), serverItem.getDescription(), WorkflowHelper.toApiActivityType(serverItem.getActivityType()), serverItem.getParentId());
    }

    private static Set<FormAttributeDefinition> toApiTaskDefinitionCompletionProperties(Set<com.sas.lsaf.svcs.work.workflow.client.FormAttributeDefinition> serverItems) {
        HashSet<FormAttributeDefinition> rval = new HashSet<FormAttributeDefinition>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.work.workflow.client.FormAttributeDefinition serverItem : serverItems) {
                if (serverItem == null) continue;
                rval.add(WorkflowHelper.toApiTaskDefinitionCompletionPropertie(serverItem));
            }
        }
        return rval;
    }

    private static FormAttributeDefinition toApiTaskDefinitionCompletionPropertie(com.sas.lsaf.svcs.work.workflow.client.FormAttributeDefinition serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new FormAttributeDefinition(serverItem.getId(), WorkflowHelper.toApiDataPropertyType(serverItem.getType()), serverItem.getName(), serverItem.getDefaultValue(), serverItem.isRequired(), serverItem.isEditable(), serverItem.isReadable(), serverItem.getValues(), serverItem.getValueIds(), serverItem.getDatePattern(), serverItem.getVariableName(), serverItem.getExpression());
    }

    private static com.sas.lsaf.workflow.processdefinition.SignalDefinition toApiSignalDefinition(SignalDefinition signal) {
        if (signal == null) {
            return null;
        }
        return new com.sas.lsaf.workflow.processdefinition.SignalDefinition(signal.getSignalId(), signal.getSignalName());
    }

    public static Set<FlowElementDefinition> toApiProcessDefinitionElements(List<com.sas.lsaf.svcs.work.workflow.client.FlowElementDefinition> serverItems) {
        HashSet<FlowElementDefinition> rval = new HashSet<FlowElementDefinition>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.work.workflow.client.FlowElementDefinition serverItem : serverItems) {
                if (serverItem == null) continue;
                rval.add(WorkflowHelper.toApiProcessDefinitionElement(serverItem));
            }
        }
        return rval;
    }

    public static ElementSetup toApiProcessFlowElementDefinition(FlowElementSetup serverSetup) {
        if (serverSetup == null) {
            return null;
        }
        JobTaskSetup rval = null;
        if (serverSetup instanceof ProcessUserTaskSetup) {
            ProcessUserTaskSetup serverUT = (ProcessUserTaskSetup)serverSetup;
            UserTaskSetup apiUT = new UserTaskSetup(serverUT.getName(), serverUT.getDescription(), serverUT.getElementId(), WorkflowHelper.toApiActivityType(serverUT.getActivityType()), serverUT.getProcessFlowIdentifier());
            if (serverUT.getAssignee() != null) {
                apiUT.setAssignee(serverUT.getAssignee());
            }
            apiUT.setAttributes(CoreHelper.toApiAttributes(serverUT.getAttributes()));
            apiUT.setCandidates(PrincipalHelper.toApiPrincipals(serverUT.getCandidates()));
            apiUT.setComplexity(WorkflowHelper.toApiComplexity(serverUT.getComplexity()));
            apiUT.setPriority(WorkflowHelper.toApiTaskPriority(serverUT.getPriority()));
            apiUT.setDueDate(serverUT.getDueDate());
            rval = apiUT;
        } else if (serverSetup instanceof ProcessJobSetup) {
            ProcessJobSetup serverJT = (ProcessJobSetup)serverSetup;
            JobTaskSetup apiJT = new JobTaskSetup(serverJT.getName(), serverJT.getDescription(), serverJT.getElementId(), WorkflowHelper.toApiActivityType(serverJT.getActivityType()), serverJT.getProcessFlowIdentifier());
            apiJT.setAttributes(CoreHelper.toApiAttributes(serverJT.getAttributes()));
            if (serverJT.getJobUri() != null) {
                apiJT.setJobPath(ResourceUtils.getPath((String)serverJT.getJobUri()));
                apiJT.setJobVersion(ResourceUtils.getVersion((String)serverJT.getJobUri()));
            }
            apiJT.setParameterValues(JobHelper.toApiParameterValues(serverJT.getParameters()));
            rval = apiJT;
        } else if (serverSetup instanceof ProcessNotificationSetup) {
            ProcessNotificationSetup serverNT = (ProcessNotificationSetup)serverSetup;
            NotificationTaskSetup apiNT = new NotificationTaskSetup(serverNT.getName(), serverNT.getDescription(), serverNT.getElementId(), WorkflowHelper.toApiActivityType(serverNT.getActivityType()), serverNT.getProcessFlowIdentifier());
            apiNT.setAttributes(CoreHelper.toApiAttributes(serverNT.getAttributes()));
            apiNT.setMessage(serverNT.getMessageText());
            apiNT.setPriority(WorkflowHelper.toApiNotificationTaskPriority(serverNT.getMessagePriority()));
            apiNT.setSubject(serverNT.getSubject());
            apiNT.setRecipients(PrincipalHelper.toApiPrincipals(serverNT.getRecipients()));
            rval = apiNT;
        } else if (serverSetup instanceof IntermediateSignalCatchEventSetup) {
            IntermediateSignalCatchEventSetup serverSignal = (IntermediateSignalCatchEventSetup)serverSetup;
            SignalEventSetup apiSignal = new SignalEventSetup(serverSignal.getName(), serverSignal.getDescription(), serverSignal.getElementId(), WorkflowHelper.toApiActivityType(serverSignal.getActivityType()), serverSignal.getProcessFlowIdentifier(), serverSignal.getSignalName(), serverSignal.getLocations());
            apiSignal.setLocations(serverSignal.getLocations());
            rval = apiSignal;
        } else if (serverSetup instanceof IntermediateTimerCatchEventSetup) {
            IntermediateTimerCatchEventSetup serverTimer = (IntermediateTimerCatchEventSetup)serverSetup;
            TimerEventSetup apiTimer = new TimerEventSetup(serverTimer.getName(), serverTimer.getDescription(), serverTimer.getElementId(), WorkflowHelper.toApiActivityType(serverTimer.getActivityType()), serverTimer.getProcessFlowIdentifier(), WorkflowHelper.toApiTimerType(serverTimer.getTimerType()));
            apiTimer.setTimerValue(serverTimer.getTimerValue());
            rval = apiTimer;
        }
        return rval;
    }

    public FlowElementSetup toServerProcessFlowElementDefinition(ElementSetup apiSetup) {
        if (apiSetup == null) {
            return null;
        }
        ProcessJobSetup rval = null;
        if (apiSetup instanceof UserTaskSetup) {
            UserTaskSetup apiUT = (UserTaskSetup)apiSetup;
            ProcessUserTaskSetup serverUT = new ProcessUserTaskSetup();
            if (apiUT.getAssignee() != null && !apiUT.getAssignee().trim().isEmpty()) {
                serverUT.setAssignee(apiUT.getAssignee());
            }
            serverUT.setAttributes(CoreHelper.toServerAttributes(apiUT.getAttributes()));
            serverUT.setCandidates(PrincipalHelper.toServerPrincipals(apiUT.getCandidates()));
            serverUT.setComplexity(WorkflowHelper.toServerComplexity(apiUT.getComplexity()));
            serverUT.setPriority(WorkflowHelper.toServerPriority(apiUT.getPriority()));
            serverUT.setDueDate(apiUT.getDueDate());
            serverUT.setElementId(apiUT.getElementId());
            rval = serverUT;
        } else if (apiSetup instanceof JobTaskSetup) {
            JobTaskSetup apiJT = (JobTaskSetup)apiSetup;
            ProcessJobSetup serverJT = new ProcessJobSetup();
            if (apiJT.getJobPath() != null && !apiJT.getJobPath().trim().isEmpty()) {
                serverJT.setJobUri(ResourceUtils.toRepositoryUri((String)apiJT.getJobPath(), null, (String)apiJT.getJobVersion()));
            }
            serverJT.setParameters(JobHelper.toServerParameterValues(apiJT.getParameterValues()));
            serverJT.setElementId(apiJT.getElementId());
            serverJT.setAttributes(CoreHelper.toServerAttributes(apiJT.getAttributes()));
            rval = serverJT;
        } else if (apiSetup instanceof NotificationTaskSetup) {
            NotificationTaskSetup apiNT = (NotificationTaskSetup)apiSetup;
            ProcessNotificationSetup serverNT = new ProcessNotificationSetup();
            serverNT.setMessage(apiNT.getMessage());
            serverNT.setMessageText(apiNT.getMessage());
            serverNT.setMessagePriority(WorkflowHelper.toServerNotificationTaskPriority(apiNT.getPriority()));
            serverNT.setSubject(apiNT.getSubject() != null ? apiNT.getSubject().trim() : null);
            serverNT.setRecipients(PrincipalHelper.toServerPrincipals(apiNT.getRecipients()));
            serverNT.setElementId(apiNT.getElementId());
            serverNT.setAttributes(CoreHelper.toServerAttributes(apiNT.getAttributes()));
            rval = serverNT;
        } else if (apiSetup instanceof SignalEventSetup) {
            SignalEventSetup apiSignal = (SignalEventSetup)apiSetup;
            IntermediateSignalCatchEventSetup serverSignal = new IntermediateSignalCatchEventSetup();
            serverSignal.setLocations(apiSignal.getLocations());
            serverSignal.setSignalName(apiSignal.getSignalName());
            serverSignal.setDescription(apiSignal.getDescription());
            serverSignal.setElementId(apiSignal.getElementId());
            rval = serverSignal;
        } else if (apiSetup instanceof TimerEventSetup) {
            TimerEventSetup apiTimer = (TimerEventSetup)apiSetup;
            IntermediateTimerCatchEventSetup serverTimer = new IntermediateTimerCatchEventSetup();
            serverTimer.setTimerType(WorkflowHelper.toServerTimerType(apiTimer.getTimerType()));
            serverTimer.setTimerValue(apiTimer.getTimerValue());
            serverTimer.setElementId(apiTimer.getElementId());
            rval = serverTimer;
        }
        if (rval != null) {
            rval.setActivityType(WorkflowHelper.toServerActivityType(apiSetup.getType()));
            rval.setElementId(apiSetup.getElementId());
            rval.setName(apiSetup.getName());
            rval.setDescription(apiSetup.getDescription());
            rval.setProcessFlowIdentifier(apiSetup.getProcessFlowIdentifier());
        }
        return rval;
    }

    public static Set<Task> toApiTasks(Set<ProcessTask> serverTasks) {
        HashSet<Task> rval = new HashSet<Task>();
        if (serverTasks != null) {
            for (ProcessTask t : serverTasks) {
                rval.add(WorkflowHelper.toApiTask(t));
            }
        }
        return rval;
    }

    public static Set<Task> toApiTasks(List<ProcessTask> serverTasks) {
        HashSet<Task> rval = new HashSet<Task>();
        if (serverTasks != null) {
            for (ProcessTask t : serverTasks) {
                rval.add(WorkflowHelper.toApiTask(t));
            }
        }
        return rval;
    }

    public static Task toApiTask(ProcessTask serverTask) {
        if (serverTask == null) {
            return null;
        }
        UserTask task = null;
        if (serverTask instanceof ProcessUserTask) {
            task = WorkflowHelper.toApiUserTask((ProcessUserTask)serverTask);
        } else if (serverTask instanceof ProcessJobTask) {
            task = WorkflowHelper.toApiJobTask((ProcessJobTask)serverTask);
        } else if (serverTask instanceof ProcessNotificationTask) {
            task = WorkflowHelper.toApiNotificationTask((ProcessNotificationTask)serverTask);
        }
        return task;
    }

    public static Set<UserTask> toApiUserTasks(Set<ProcessUserTask> serverTasks) {
        HashSet<UserTask> rval = new HashSet<UserTask>();
        if (serverTasks != null) {
            for (ProcessTask processTask : serverTasks) {
                if (!(processTask instanceof ProcessUserTask)) continue;
                UserTask userTask = WorkflowHelper.toApiUserTask((ProcessUserTask)processTask);
                rval.add(userTask);
            }
        }
        return rval;
    }

    public static Set<Element> toApiCurrentElements(Set<ProcessFlowElement> currentElements) {
        HashSet<Element> rval = new HashSet<Element>();
        if (currentElements != null) {
            for (ProcessFlowElement e : currentElements) {
                if (e == null) continue;
                rval.add(WorkflowHelper.toApiCurrentElement(e));
            }
        }
        return rval;
    }

    public static Element toApiCurrentElement(ProcessFlowElement e) {
        if (e == null) {
            return null;
        }
        UserTask element = null;
        if (e instanceof ProcessUserTask) {
            element = WorkflowHelper.toApiUserTask((ProcessUserTask)e);
        } else if (e instanceof ProcessJobTask) {
            element = WorkflowHelper.toApiJobTask((ProcessJobTask)e);
        } else if (e instanceof ProcessNotificationTask) {
            element = WorkflowHelper.toApiNotificationTask((ProcessNotificationTask)e);
        } else if (e instanceof ProcessSignalEvent) {
            element = WorkflowHelper.toApiProcessSignalEvent((ProcessSignalEvent)e);
        } else if (e instanceof ProcessTimerEvent) {
            element = WorkflowHelper.toApiProcessTimerEvent((ProcessTimerEvent)e);
        }
        return element;
    }

    private static Element toApiProcessTimerEvent(ProcessTimerEvent serverEvent) {
        if (serverEvent == null) {
            return null;
        }
        TimerEvent rval = new TimerEvent(serverEvent.getTypeId(), serverEvent.getId(), serverEvent.getElementId(), serverEvent.getName(), serverEvent.getDescription(), WorkflowHelper.toApiActivityType(serverEvent.getActivityType()), WorkflowHelper.toApiTaskFlowStatus(serverEvent.getStatus()), serverEvent.getProcessFlow() != null ? serverEvent.getProcessFlow().getId() : null, serverEvent.getCreated());
        rval.setDueDate(serverEvent.getDueDate());
        return rval;
    }

    private static Element toApiProcessSignalEvent(ProcessSignalEvent serverEvent) {
        if (serverEvent == null) {
            return null;
        }
        return new SignalEvent(serverEvent.getTypeId(), serverEvent.getId(), serverEvent.getElementId(), serverEvent.getName(), serverEvent.getDescription(), WorkflowHelper.toApiActivityType(serverEvent.getActivityType()), WorkflowHelper.toApiTaskFlowStatus(serverEvent.getStatus()), serverEvent.getProcessFlow() != null ? serverEvent.getProcessFlow().getId() : null, serverEvent.getCreated(), serverEvent.getSignalName(), serverEvent.getLocations());
    }

    private static Task toApiJobTask(ProcessJobTask serverTask) {
        if (serverTask == null) {
            return null;
        }
        String jobPath = null;
        String jobVersion = null;
        if (serverTask.getJobUri() != null) {
            jobPath = ResourceUtils.getPath((String)serverTask.getJobUri());
            jobVersion = ResourceUtils.getVersion((String)serverTask.getJobUri());
        }
        return new JobTask(serverTask.getTypeId(), serverTask.getId(), serverTask.getElementId(), serverTask.getName(), serverTask.getDescription(), WorkflowHelper.toApiActivityType(serverTask.getActivityType()), WorkflowHelper.toApiTaskFlowStatus(serverTask.getStatus()), serverTask.getProcessFlow() != null ? serverTask.getProcessFlow().getId() : null, serverTask.getCreated(), serverTask.getStarted(), WorkflowHelper.toApiTaskStatus(serverTask.getTaskStatus()), CoreHelper.toApiAttributes(serverTask.getAttributes()), jobPath, jobVersion, JobHelper.toApiParameterValues(serverTask.getParameters()));
    }

    public static UserTask toApiUserTask(ProcessUserTask serverTask) {
        if (serverTask == null) {
            return null;
        }
        UserTask task = new UserTask(serverTask.getTypeId(), serverTask.getId(), serverTask.getElementId(), serverTask.getName(), serverTask.getDescription(), WorkflowHelper.toApiActivityType(serverTask.getActivityType()), WorkflowHelper.toApiTaskFlowStatus(serverTask.getStatus()), serverTask.getProcessFlow() != null ? serverTask.getProcessFlow().getId() : null, serverTask.getCreated(), serverTask.getStarted(), WorkflowHelper.toApiTaskStatus(serverTask.getTaskStatus()), CoreHelper.toApiAttributes(serverTask.getAttributes()), serverTask.getAssignee() != null ? serverTask.getAssignee().getUserId() : null, serverTask.getAssigned(), WorkflowHelper.toApiTaskPriority(serverTask.getPriority()), WorkflowHelper.toApiComplexity(serverTask.getComplexity()), serverTask.getDueDate(), serverTask.getHoursWorked() != null ? Float.valueOf(serverTask.getHoursWorked().toString()).floatValue() : 0.0f);
        return task;
    }

    public UserTaskUpdateInfo toServerUserTaskDetails(com.sas.lsaf.workflow.task.UserTaskUpdateInfo apiTask) throws InvalidTaskAssigneeException {
        if (apiTask == null) {
            return null;
        }
        UserTaskUpdateInfo serverTask = new UserTaskUpdateInfo();
        serverTask.setActivityType(WorkflowHelper.toServerActivityType(apiTask.getType()));
        serverTask.setHoursWorked(Double.valueOf(apiTask.getActualHours()));
        serverTask.setAssigned(apiTask.getAssigned());
        if (apiTask.getAssignee() != null && !apiTask.getAssignee().trim().isEmpty()) {
            try {
                serverTask.setAssignee(this.userService.getUserDescriptorByUserId(apiTask.getAssignee()));
            }
            catch (UserNotFoundException e) {
                throw new InvalidTaskAssigneeException(e.getLocalizedMessage());
            }
        }
        serverTask.setAttributes(CoreHelper.toServerAttributes(apiTask.getAttributes()));
        serverTask.setComplexity(WorkflowHelper.toServerComplexity(apiTask.getComplexity()));
        serverTask.setCreated(apiTask.getCreated());
        serverTask.setDescription(apiTask.getDescription());
        serverTask.setDueDate(apiTask.getDueDate());
        serverTask.setElementId(apiTask.getElementId());
        serverTask.setId(apiTask.getId());
        serverTask.setName(apiTask.getName());
        serverTask.setPriority(WorkflowHelper.toServerPriority(apiTask.getPriority()));
        serverTask.setProcessFlow(WorkflowHelper.toServerProcessFlowDescriptor(apiTask.getProcessFlowId()));
        serverTask.setStarted(apiTask.getStarted());
        serverTask.setStatus(WorkflowHelper.toServerWorkflowStatus(apiTask.getFlowStatus()));
        serverTask.setTaskStatus(WorkflowHelper.toServerTaskStatus(apiTask.getTaskStatus()));
        serverTask.setTypeId(apiTask.getTypeId());
        serverTask.setHoursWorked(Double.valueOf(apiTask.getActualHours()));
        serverTask.setCandidates(PrincipalHelper.toServerPrincipals(apiTask.getCandidates()));
        serverTask.setCompletionAttributes(WorkflowHelper.toServerCompletionProperties(apiTask.getCompletionProperties(), apiTask.getId()));
        return serverTask;
    }

    private static com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor toServerProcessFlowDescriptor(String processFlowId) {
        com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor pf = new com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor();
        pf.setId(processFlowId);
        return pf;
    }

    private static Task toApiNotificationTask(ProcessNotificationTask serverTask) {
        if (serverTask == null) {
            return null;
        }
        return new NotificationTask(serverTask.getTypeId(), serverTask.getId(), serverTask.getElementId(), serverTask.getName(), serverTask.getDescription(), WorkflowHelper.toApiActivityType(serverTask.getActivityType()), WorkflowHelper.toApiTaskFlowStatus(serverTask.getStatus()), serverTask.getProcessFlow() != null ? serverTask.getProcessFlow().getId() : null, serverTask.getCreated(), serverTask.getStarted(), WorkflowHelper.toApiTaskStatus(serverTask.getTaskStatus()), CoreHelper.toApiAttributes(serverTask.getAttributes()), PrincipalHelper.toApiPrincipals(serverTask.getRecipients()), serverTask.getSubject(), WorkflowHelper.toApiNotificationTaskPriority(serverTask.getMessagePriority()), serverTask.getMessage());
    }

    public static Set<CompletedElement> toApiCompletedElements(Set<CompletedFlowElement> completedElements, TaskService taskService) throws HlsWorkflowException, TaskNotFoundException, ProcessDefinitionNotFoundException {
        ArrayList<CompletedElement> rval = new ArrayList<CompletedElement>();
        if (completedElements != null) {
            for (CompletedFlowElement e : completedElements) {
                rval.add(WorkflowHelper.toApiCompletedElement(e, taskService));
            }
            rval.sort(new Comparator<CompletedElement>(){

                @Override
                public int compare(CompletedElement s1, CompletedElement s2) {
                    return DateUtils.compareTo((Date)s2.getCompleted(), (Date)s1.getCompleted());
                }
            });
        }
        LinkedHashSet<CompletedElement> rvalSet = new LinkedHashSet<CompletedElement>();
        for (CompletedElement e : rval) {
            rvalSet.add(e);
        }
        return rvalSet;
    }

    public static CompletedElement toApiCompletedElement(CompletedFlowElement serverCompletedElement, TaskService taskService) throws HlsWorkflowException, TaskNotFoundException, ProcessDefinitionNotFoundException {
        if (serverCompletedElement == null) {
            return null;
        }
        Object rval = null;
        if (serverCompletedElement instanceof CompletedUserTask) {
            CompletedUserTaskDetails cutd = taskService.getCompletedUserTaskDetailsByIdentifier(serverCompletedElement.getId());
            rval = cutd != null ? WorkflowHelper.toApiCompletedUserTaskDetails(cutd) : WorkflowHelper.toApiCompletedUserTask((CompletedUserTask)serverCompletedElement);
        } else if (serverCompletedElement instanceof CompletedJobTask) {
            rval = WorkflowHelper.toApiCompletedJobTask((CompletedJobTask)serverCompletedElement);
        } else if (serverCompletedElement instanceof CompletedNotificationTask) {
            rval = WorkflowHelper.toApiCompletedNotificationTask((CompletedNotificationTask)serverCompletedElement);
        } else if (serverCompletedElement instanceof CompletedEventGateway) {
            rval = WorkflowHelper.toApiCompletedEventGateway((CompletedEventGateway)serverCompletedElement);
        } else if (serverCompletedElement instanceof com.sas.lsaf.svcs.work.workflow.client.CompletedSignalEvent) {
            rval = WorkflowHelper.toApiCompletedSignalEvent((com.sas.lsaf.svcs.work.workflow.client.CompletedSignalEvent)serverCompletedElement);
        } else if (serverCompletedElement instanceof com.sas.lsaf.svcs.work.workflow.client.CompletedEvent) {
            rval = WorkflowHelper.toApiCompletedEvent((com.sas.lsaf.svcs.work.workflow.client.CompletedEvent)serverCompletedElement);
        }
        return rval;
    }

    private static com.sas.lsaf.workflow.task.CompletedUserTaskDetails toApiCompletedUserTaskDetails(CompletedUserTaskDetails serverTask) {
        return new com.sas.lsaf.workflow.task.CompletedUserTaskDetails(serverTask.getTypeId(), serverTask.getId(), serverTask.getElementId(), serverTask.getProcessFlow() != null ? serverTask.getProcessFlow().getId() : null, serverTask.getName(), serverTask.getDescription(), WorkflowHelper.toApiActivityType(serverTask.getActivityType()), serverTask.getCreated(), CoreHelper.toApiAttributes(serverTask.getAttributes()), serverTask.getCompletedBy() != null ? serverTask.getCompletedBy().getUserId() : null, serverTask.getCompleted(), WorkflowHelper.toApiTaskCompletedState(serverTask.getCompletedState()), WorkflowHelper.toApiComplexity(serverTask.getComplexity()), WorkflowHelper.toApiTaskPriority(serverTask.getPriority()), serverTask.getDueDate(), serverTask.getCompletionComment(), serverTask.getHoursWorked() != null ? Float.valueOf(serverTask.getTotalHoursWorked().toString()).floatValue() : 0.0f, WorkflowHelper.toApiCompletedProperties(serverTask.getCompletionAttributes()), WorkflowHelper.toApiUserTaskAssignments(serverTask.getTaskAssignmentHistory()));
    }

    private static com.sas.lsaf.workflow.task.CompletedUserTask toApiCompletedUserTask(CompletedUserTask serverTask) {
        if (serverTask == null) {
            return null;
        }
        return new com.sas.lsaf.workflow.task.CompletedUserTask(serverTask.getTypeId(), serverTask.getId(), serverTask.getElementId(), serverTask.getProcessFlow() != null ? serverTask.getProcessFlow().getId() : null, serverTask.getName(), serverTask.getDescription(), WorkflowHelper.toApiActivityType(serverTask.getActivityType()), serverTask.getCreated(), CoreHelper.toApiAttributes(serverTask.getAttributes()), serverTask.getCompletedBy() != null ? serverTask.getCompletedBy().getUserId() : null, serverTask.getCompleted(), WorkflowHelper.toApiTaskCompletedState(serverTask.getCompletedState()), WorkflowHelper.toApiComplexity(serverTask.getComplexity()), WorkflowHelper.toApiTaskPriority(serverTask.getPriority()), serverTask.getDueDate(), serverTask.getCompletionComment(), serverTask.getHoursWorked() != null ? Float.valueOf(serverTask.getTotalHoursWorked().toString()).floatValue() : 0.0f);
    }

    private static com.sas.lsaf.workflow.task.CompletedJobTask toApiCompletedJobTask(CompletedJobTask serverTask) {
        if (serverTask == null) {
            return null;
        }
        return new com.sas.lsaf.workflow.task.CompletedJobTask(serverTask.getTypeId(), serverTask.getId(), serverTask.getElementId(), serverTask.getProcessFlow() != null ? serverTask.getProcessFlow().getId() : null, serverTask.getName(), serverTask.getDescription(), WorkflowHelper.toApiActivityType(serverTask.getActivityType()), serverTask.getCreated(), CoreHelper.toApiAttributes(serverTask.getAttributes()), serverTask.getCompletedBy() != null ? serverTask.getCompletedBy().getUserId() : null, serverTask.getCompleted(), serverTask.getCompletedStatus(), WorkflowHelper.toApiTaskCompletedState(serverTask.getCompletedState()), serverTask.getRunAsOwner() != null ? serverTask.getRunAsOwner().getUserId() : null, ResourceUtils.getPath((String)serverTask.getJobUri()), serverTask.getJobDetails(), serverTask.getJobVersion(), JobHelper.toApiParameterValues(serverTask.getParameters()));
    }

    private static com.sas.lsaf.workflow.task.CompletedNotificationTask toApiCompletedNotificationTask(CompletedNotificationTask serverTask) {
        if (serverTask == null) {
            return null;
        }
        return new com.sas.lsaf.workflow.task.CompletedNotificationTask(serverTask.getTypeId(), serverTask.getId(), serverTask.getElementId(), serverTask.getProcessFlow() != null ? serverTask.getProcessFlow().getId() : null, serverTask.getName(), serverTask.getDescription(), WorkflowHelper.toApiActivityType(serverTask.getActivityType()), serverTask.getCreated(), CoreHelper.toApiAttributes(serverTask.getAttributes()), serverTask.getCompletedBy() != null ? serverTask.getCompletedBy().getUserId() : null, serverTask.getCompleted(), serverTask.getCompletedStatus(), WorkflowHelper.toApiTaskCompletedState(serverTask.getCompletedState()), PrincipalHelper.toApiPrincipals(serverTask.getRecipients()), serverTask.getSubject(), WorkflowHelper.toApiNotificationTaskPriority(serverTask.getMessagePriority()), serverTask.getMessageText());
    }

    private static com.sas.lsaf.workflow.element.CompletedEventGateway toApiCompletedEventGateway(CompletedEventGateway serverEvent) {
        if (serverEvent == null) {
            return null;
        }
        return new com.sas.lsaf.workflow.element.CompletedEventGateway(serverEvent.getTypeId(), serverEvent.getId(), serverEvent.getElementId(), serverEvent.getProcessFlow() != null ? serverEvent.getProcessFlow().getId() : null, serverEvent.getName(), serverEvent.getDescription(), WorkflowHelper.toApiActivityType(serverEvent.getActivityType()), serverEvent.getCreated(), serverEvent.getCompletedBy() != null ? serverEvent.getCompletedBy().getUserId() : null, serverEvent.getCompleted(), WorkflowHelper.toApiTaskCompletedState(serverEvent.getCompletedState()), WorkflowHelper.toApiCompletedEvent(serverEvent.getTriggeredEvent()));
    }

    private static CompletedSignalEvent toApiCompletedSignalEvent(com.sas.lsaf.svcs.work.workflow.client.CompletedSignalEvent serverEvent) {
        if (serverEvent == null) {
            return null;
        }
        return new CompletedSignalEvent(serverEvent.getTypeId(), serverEvent.getId(), serverEvent.getElementId(), serverEvent.getProcessFlow() != null ? serverEvent.getProcessFlow().getId() : null, serverEvent.getName(), serverEvent.getDescription(), WorkflowHelper.toApiActivityType(serverEvent.getActivityType()), serverEvent.getCreated(), serverEvent.getCompletedBy() != null ? serverEvent.getCompletedBy().getUserId() : null, serverEvent.getCompleted(), serverEvent.getSignalName(), serverEvent.getSignaledBy(), WorkflowHelper.toApiTaskCompletedState(serverEvent.getCompletedState()));
    }

    private static CompletedEvent toApiCompletedEvent(com.sas.lsaf.svcs.work.workflow.client.CompletedEvent serverCompletedEvent) {
        if (serverCompletedEvent == null) {
            return null;
        }
        if (serverCompletedEvent instanceof CompletedEventGateway) {
            return WorkflowHelper.toApiCompletedEventGateway((CompletedEventGateway)serverCompletedEvent);
        }
        if (serverCompletedEvent instanceof com.sas.lsaf.svcs.work.workflow.client.CompletedSignalEvent) {
            return WorkflowHelper.toApiCompletedSignalEvent((com.sas.lsaf.svcs.work.workflow.client.CompletedSignalEvent)serverCompletedEvent);
        }
        return new CompletedEvent(serverCompletedEvent.getTypeId(), serverCompletedEvent.getId(), serverCompletedEvent.getElementId(), serverCompletedEvent.getProcessFlow() != null ? serverCompletedEvent.getProcessFlow().getId() : null, serverCompletedEvent.getName(), serverCompletedEvent.getDescription(), WorkflowHelper.toApiActivityType(serverCompletedEvent.getActivityType()), serverCompletedEvent.getCreated(), serverCompletedEvent.getCompletedBy() != null ? serverCompletedEvent.getCompletedBy().getUserId() : null, serverCompletedEvent.getCompleted(), WorkflowHelper.toApiTaskCompletedState(serverCompletedEvent.getCompletedState()));
    }

    public static com.sas.lsaf.svcs.content.common.client.FileCreateInfo toServerFileCreateInfo(FileCreateInfo apiFileCreateInfo) {
        if (apiFileCreateInfo != null) {
            com.sas.lsaf.svcs.content.common.client.FileCreateInfo serverFileCreateInfo = new com.sas.lsaf.svcs.content.common.client.FileCreateInfo(apiFileCreateInfo.getPath());
            serverFileCreateInfo.setOverwrite(apiFileCreateInfo.isOverwrite());
            serverFileCreateInfo.setEnableVersioning(apiFileCreateInfo.isEnableVersioning());
            serverFileCreateInfo.setCustomVersion(apiFileCreateInfo.getCustomVersion());
            serverFileCreateInfo.setVersionType(RepositoryHelper.toServerVersionType(apiFileCreateInfo.getVersionType()));
            serverFileCreateInfo.setComment(apiFileCreateInfo.getComment());
            serverFileCreateInfo.setDescription(apiFileCreateInfo.getDescription());
            return serverFileCreateInfo;
        }
        return null;
    }

    public static UserTaskDetails toApiUserTaskDetails(com.sas.lsaf.svcs.work.task.client.UserTaskDetails serverTaskDetails) {
        if (serverTaskDetails == null) {
            return null;
        }
        return new UserTaskDetails(new UserTask(serverTaskDetails.getTypeId(), serverTaskDetails.getId(), serverTaskDetails.getElementId(), serverTaskDetails.getName(), serverTaskDetails.getDescription(), WorkflowHelper.toApiActivityType(serverTaskDetails.getActivityType()), WorkflowHelper.toApiTaskFlowStatus(serverTaskDetails.getStatus()), serverTaskDetails.getProcessFlow().getId(), serverTaskDetails.getCreated(), serverTaskDetails.getStarted(), WorkflowHelper.toApiTaskStatus(serverTaskDetails.getTaskStatus()), CoreHelper.toApiAttributes(serverTaskDetails.getAttributes()), serverTaskDetails.getAssignee() != null ? serverTaskDetails.getAssignee().getUserId() : null, serverTaskDetails.getAssigned(), WorkflowHelper.toApiTaskPriority(serverTaskDetails.getPriority()), WorkflowHelper.toApiComplexity(serverTaskDetails.getComplexity()), serverTaskDetails.getDueDate(), serverTaskDetails.getHoursWorked() != null ? Float.valueOf(serverTaskDetails.getHoursWorked().toString()).floatValue() : 0.0f), PrincipalHelper.toApiPrincipals(serverTaskDetails.getCandidates()), WorkflowHelper.toApiUserTaskCompletionProperties(serverTaskDetails.getCompletionAttributes()), WorkflowHelper.toApiUserTaskAssignments(serverTaskDetails.getTaskAssignmentHistory()));
    }

    private static ProcessDefinitionInfo.ProcessDefinitionStatus toApiProcessDefinitionStatus(ProcessDefinitionDescriptor.WorkflowStatus serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case ACTIVE: {
                return ProcessDefinitionInfo.ProcessDefinitionStatus.ACTIVE;
            }
            case SUSPENDED: {
                return ProcessDefinitionInfo.ProcessDefinitionStatus.SUSPENDED;
            }
        }
        throw new SystemException("Unmapped server workflow status type: " + serverItem.name());
    }

    public static com.sas.lsaf.svcs.work.processflow.client.ProcessFlowCopyInfo toServerCopyProcessFlowInfo(ProcessFlowCopyInfo apiItem) {
        if (apiItem == null) {
            return null;
        }
        com.sas.lsaf.svcs.work.processflow.client.ProcessFlowCopyInfo copyInfo = new com.sas.lsaf.svcs.work.processflow.client.ProcessFlowCopyInfo(apiItem.getName(), apiItem.getSourceProcessFlowId());
        copyInfo.setActivate(apiItem.isActivate());
        copyInfo.setIncludeAttachments(apiItem.isIncludeAttachments());
        copyInfo.setIncludeProcessData(apiItem.isIncludeProcessData());
        copyInfo.setUseSourceOwner(apiItem.isUseSourceOwner());
        return copyInfo;
    }

    public static List<ProcessFlowSearchResultItem> toApiProcessFlowSearchResultItems(List<com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowSearchResultItem> serverItems) {
        ArrayList<ProcessFlowSearchResultItem> rval = new ArrayList<ProcessFlowSearchResultItem>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowSearchResultItem serverItem : serverItems) {
                rval.add(WorkflowHelper.toApiProcessFlowSearchResultItem(serverItem));
            }
        }
        return rval;
    }

    private static ProcessFlowSearchResultItem toApiProcessFlowSearchResultItem(com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowSearchResultItem serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new ProcessFlowSearchResultItem(serverItem.getId(), serverItem.getName(), WorkflowHelper.toApiFlowStatus(serverItem.getStatus()), serverItem.getOwner(), serverItem.getProcessDefinitionKey(), serverItem.getLastModifiedBy(), serverItem.getLastModifiedDate(), serverItem.getContext(), WorkflowHelper.toApiCreationMethod(serverItem.getAutoFlowType()));
    }

    public static com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowQuery toServerProcessFlowQuery(ProcessFlowQuery apiItem, String queryToken) {
        if (apiItem == null) {
            return null;
        }
        com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowQuery serverQuery = new com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowQuery();
        serverQuery.setToken(queryToken);
        serverQuery.setContext(apiItem.getContextPath());
        serverQuery.setName(apiItem.getName());
        serverQuery.setOwner(apiItem.getOwner());
        serverQuery.setProcessDefinitionKey(apiItem.getProcessDefinitionKey());
        serverQuery.setModifiedBy(apiItem.getLastModifiedBy());
        serverQuery.setFromDateModified(apiItem.getFromLastModified());
        serverQuery.setToDateModified(apiItem.getToLastModified());
        serverQuery.setCreationMethod(WorkflowHelper.toServerCreationMethod(apiItem.getCreationMethod()));
        serverQuery.setStatus(WorkflowHelper.toServerFlowStatus(apiItem.getStatus()));
        return serverQuery;
    }

    private static ProcessFlowQuery.CreationMethod toServerCreationMethod(CreationMethod apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case MANUAL: {
                return ProcessFlowQuery.CreationMethod.MANUAL;
            }
            case TLF: {
                return ProcessFlowQuery.CreationMethod.TLF;
            }
        }
        throw new SystemException("Unmapped api process flow query creation method: " + apiItem.name());
    }

    public static com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMapping toApiProcessDefinitionMapping(ProcessDefinitionMapping serverItem) {
        if (serverItem == null) {
            return null;
        }
        com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMapping apiItem = new com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMapping(serverItem.getProcessDefinitionKey(), WorkflowHelper.toApiAutoFlowType(serverItem.getType()), serverItem.isMappingComplete(), serverItem.getMappingRevision());
        apiItem.setElementMapping(WorkflowHelper.toApiFlowElementMappings(serverItem.getElementMapping()));
        apiItem.setEnableAutoFlowMapping(serverItem.isEnableAutoFlowMapping());
        return apiItem;
    }

    private static List<FlowElementMapping> toApiFlowElementMappings(List<com.sas.lsaf.svcs.work.workflow.client.FlowElementMapping> serverItems) {
        ArrayList<FlowElementMapping> rval = new ArrayList<FlowElementMapping>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.work.workflow.client.FlowElementMapping serverItem : serverItems) {
                if (serverItem == null) continue;
                rval.add(WorkflowHelper.toApiFlowElementMapping(serverItem));
            }
        }
        return rval;
    }

    private static FlowElementMapping toApiFlowElementMapping(com.sas.lsaf.svcs.work.workflow.client.FlowElementMapping serverItem) {
        if (serverItem == null) {
            return null;
        }
        FlowElementMapping apiItem = new FlowElementMapping(serverItem.getElementId(), WorkflowHelper.toApiActivityType(serverItem.getElementType()));
        apiItem.setAttributeMapping(WorkflowHelper.toApiFlowAttributeMapping(serverItem.getAttributeMapping()));
        return apiItem;
    }

    private static List<AttributeMapping> toApiFlowAttributeMapping(List<com.sas.lsaf.svcs.work.workflow.client.AttributeMapping> serverItems) {
        ArrayList<AttributeMapping> rval = new ArrayList<AttributeMapping>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.work.workflow.client.AttributeMapping serverItem : serverItems) {
                if (serverItem == null) continue;
                rval.add(WorkflowHelper.toApiFlowAttributeMapping(serverItem));
            }
        }
        return rval;
    }

    private static AttributeMapping toApiFlowAttributeMapping(com.sas.lsaf.svcs.work.workflow.client.AttributeMapping serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new AttributeMapping(serverItem.getAttrName(), serverItem.getMapAttrName(), WorkflowHelper.toApiFlowAttributeType(serverItem.getType()));
    }

    private static FlowAttributeType toApiFlowAttributeType(com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType serverType) {
        if (serverType == null) {
            return null;
        }
        switch (serverType) {
            case BOOLEAN: {
                return FlowAttributeType.BOOLEAN;
            }
            case DATE: {
                return FlowAttributeType.DATE;
            }
            case USER: {
                return FlowAttributeType.USER;
            }
            case PRINCIPAL: {
                return FlowAttributeType.PRINCIPAL;
            }
            case FILE: {
                return FlowAttributeType.FILE;
            }
            case FOLDER: {
                return FlowAttributeType.FOLDER;
            }
            case NUMERIC: {
                return FlowAttributeType.NUMERIC;
            }
            case TEXT: {
                return FlowAttributeType.TEXT;
            }
        }
        throw new SystemException("Unmapped server flow attribute type: " + serverType.name());
    }

    public static ProcessDefinitionMapping toServerProcessDefinitionMapping(com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMapping apiItem) {
        if (apiItem == null) {
            return null;
        }
        ProcessDefinitionMapping serverItem = new ProcessDefinitionMapping();
        serverItem.setProcessDefinitionKey(apiItem.getProcessDefinitionKey());
        serverItem.setMappingRevision(apiItem.getMappingRevision());
        serverItem.setEnableAutoFlowMapping(apiItem.isEnableAutoFlowMapping());
        serverItem.setMappingComplete(apiItem.isMappingComplete());
        serverItem.setType(WorkflowHelper.toServerAutoFlowType(apiItem.getType()));
        serverItem.setElementMapping(WorkflowHelper.toServerFlowElementMappings(apiItem.getElementMapping()));
        return serverItem;
    }

    private static List<com.sas.lsaf.svcs.work.workflow.client.FlowElementMapping> toServerFlowElementMappings(List<FlowElementMapping> apiItems) {
        ArrayList<com.sas.lsaf.svcs.work.workflow.client.FlowElementMapping> rval = new ArrayList<com.sas.lsaf.svcs.work.workflow.client.FlowElementMapping>();
        if (apiItems != null) {
            for (FlowElementMapping apiItem : apiItems) {
                if (apiItem == null) continue;
                rval.add(WorkflowHelper.toServerFlowElementMapping(apiItem));
            }
        }
        return rval;
    }

    private static com.sas.lsaf.svcs.work.workflow.client.FlowElementMapping toServerFlowElementMapping(FlowElementMapping apiItem) {
        if (apiItem == null) {
            return null;
        }
        com.sas.lsaf.svcs.work.workflow.client.FlowElementMapping serverItem = new com.sas.lsaf.svcs.work.workflow.client.FlowElementMapping();
        serverItem.setElementId(apiItem.getElementId());
        serverItem.setElementType(WorkflowHelper.toServerActivityType(apiItem.getElementType()));
        serverItem.setAttributeMapping(WorkflowHelper.toServerFlowAttributeMappings(apiItem.getAttributeMapping()));
        return serverItem;
    }

    private static List<com.sas.lsaf.svcs.work.workflow.client.AttributeMapping> toServerFlowAttributeMappings(List<AttributeMapping> apiItems) {
        ArrayList<com.sas.lsaf.svcs.work.workflow.client.AttributeMapping> rval = new ArrayList<com.sas.lsaf.svcs.work.workflow.client.AttributeMapping>();
        if (apiItems != null) {
            for (AttributeMapping apiItem : apiItems) {
                if (apiItem == null) continue;
                rval.add(WorkflowHelper.toServerFlowAttributeMapping(apiItem));
            }
        }
        return rval;
    }

    private static com.sas.lsaf.svcs.work.workflow.client.AttributeMapping toServerFlowAttributeMapping(AttributeMapping apiItem) {
        if (apiItem == null) {
            return null;
        }
        return new com.sas.lsaf.svcs.work.workflow.client.AttributeMapping(apiItem.getAttrName(), apiItem.getMapAttrName(), WorkflowHelper.toServerFlowAttributeType(apiItem.getType()));
    }

    private static com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType toServerFlowAttributeType(FlowAttributeType apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case BOOLEAN: {
                return com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType.BOOLEAN;
            }
            case DATE: {
                return com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType.DATE;
            }
            case USER: {
                return com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType.USER;
            }
            case PRINCIPAL: {
                return com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType.PRINCIPAL;
            }
            case FILE: {
                return com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType.FILE;
            }
            case FOLDER: {
                return com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType.FOLDER;
            }
            case NUMERIC: {
                return com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType.NUMERIC;
            }
            case TEXT: {
                return com.sas.lsaf.svcs.work.workflow.client.FlowAttributeType.TEXT;
            }
        }
        throw new SystemException("Unmapped api flow attribute type: " + apiItem.name());
    }

    public AutoFlowProcessDefinitionInfo toServerAutoFlowProcessDefinitionInfo(ProcessDefinitionInfo pdInfo) {
        if (pdInfo == null) {
            return null;
        }
        AutoFlowProcessDefinitionInfo serverItem = new AutoFlowProcessDefinitionInfo();
        serverItem.setProcessDefinition(WorkflowHelper.toServerProcessDefinitionDescriptor(pdInfo));
        serverItem.setMappingValidationInfo(this.toServerAutoFlowMappingValidationInfo(pdInfo));
        return serverItem;
    }

    private AutoFlowMappingValidationInfo toServerAutoFlowMappingValidationInfo(ProcessDefinitionInfo apiProcessDefinitionInfo) {
        AutoFlowMappingValidationInfo mapping = new AutoFlowMappingValidationInfo();
        mapping.setProcessDefinitionMapping(this.processDefinitionService.getProcessDefinitionMappingByType(ProcessDefinitionMapping.AutoFlowType.TLF, apiProcessDefinitionInfo.getId()));
        return mapping;
    }

    public static List<ProcessDefinitionMappingMetadata> toApiProcessFlowMappingMetadatas(List<com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionMappingMetadata> serverItems) {
        ArrayList<ProcessDefinitionMappingMetadata> apiItems = new ArrayList<ProcessDefinitionMappingMetadata>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionMappingMetadata serverItem : serverItems) {
                if (serverItem == null) continue;
                apiItems.add(WorkflowHelper.toApiProcessFlowMappingMetadata(serverItem));
            }
        }
        return apiItems;
    }

    public static ProcessDefinitionMappingMetadata toApiProcessFlowMappingMetadata(com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionMappingMetadata serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new ProcessDefinitionMappingMetadata(WorkflowHelper.toApiAutoFlowType(serverItem.getType()), WorkflowHelper.toApiMappingMetadata(serverItem.getAttrMetadata()));
    }

    private static Map<Element.ElementType, List<MappingAttributeMetadata>> toApiMappingMetadata(Map<ActivityType, List<com.sas.lsaf.svcs.work.workflow.client.MappingAttributeMetadata>> serverItems) {
        if (serverItems == null) {
            return null;
        }
        HashMap<Element.ElementType, List<MappingAttributeMetadata>> apiItems = new HashMap<Element.ElementType, List<MappingAttributeMetadata>>();
        for (Map.Entry<ActivityType, List<com.sas.lsaf.svcs.work.workflow.client.MappingAttributeMetadata>> entry : serverItems.entrySet()) {
            apiItems.put(WorkflowHelper.toApiActivityType(entry.getKey()), WorkflowHelper.toApiMappingMetadata(entry.getValue()));
        }
        return apiItems;
    }

    public static List<MappingAttributeMetadata> toApiMappingMetadata(List<com.sas.lsaf.svcs.work.workflow.client.MappingAttributeMetadata> serverItems) {
        ArrayList<MappingAttributeMetadata> apiItems = new ArrayList<MappingAttributeMetadata>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.work.workflow.client.MappingAttributeMetadata serverItem : serverItems) {
                if (serverItem == null) continue;
                apiItems.add(WorkflowHelper.toApiMappingMetadata(serverItem));
            }
        }
        return apiItems;
    }

    public static MappingAttributeMetadata toApiMappingMetadata(com.sas.lsaf.svcs.work.workflow.client.MappingAttributeMetadata serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new MappingAttributeMetadata(serverItem.getAttrName(), WorkflowHelper.toApiFlowAttributeType(serverItem.getAttrType()), WorkflowHelper.toApiAutoFlowMappingMetadatas(serverItem.getMapAttrs()), serverItem.isMultiValued(), serverItem.getAttrDisplayName());
    }

    private static Set<AutoFlowMappingMetadata> toApiAutoFlowMappingMetadatas(Set<com.sas.lsaf.svcs.work.workflow.client.AutoFlowMappingMetadata> serverItems) {
        ArrayList<AutoFlowMappingMetadata> apiItems = new ArrayList<AutoFlowMappingMetadata>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.work.workflow.client.AutoFlowMappingMetadata serverItem : serverItems) {
                if (serverItem == null) continue;
                apiItems.add(WorkflowHelper.toApiAutoFlowMappingMetadata(serverItem));
            }
            apiItems.sort(new Comparator<AutoFlowMappingMetadata>(){

                @Override
                public int compare(AutoFlowMappingMetadata s1, AutoFlowMappingMetadata s2) {
                    return ComparableUtils.nullSafeCompareToIgnoreCase((Comparable)((Object)s1.getMapAttrName()), (Comparable)((Object)s2.getMapAttrName()), (boolean)true);
                }
            });
        }
        LinkedHashSet<AutoFlowMappingMetadata> rvalSet = new LinkedHashSet<AutoFlowMappingMetadata>();
        for (AutoFlowMappingMetadata e : apiItems) {
            rvalSet.add(e);
        }
        return rvalSet;
    }

    private static AutoFlowMappingMetadata toApiAutoFlowMappingMetadata(com.sas.lsaf.svcs.work.workflow.client.AutoFlowMappingMetadata serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new AutoFlowMappingMetadata(serverItem.getMapAttrName(), WorkflowHelper.toApiFlowAttributeType(serverItem.getType()), serverItem.isDerived());
    }

    public static final com.sas.lsaf.svcs.work.task.client.query.TaskQuery toServerTaskQuery(TaskQuery apiItem) {
        if (apiItem == null) {
            return null;
        }
        com.sas.lsaf.svcs.work.task.client.query.TaskQuery serverItem = new com.sas.lsaf.svcs.work.task.client.query.TaskQuery();
        serverItem.setAssignees(apiItem.getAssignees());
        serverItem.setContexts(apiItem.getContextPaths());
        serverItem.setAssigneeType(WorkflowHelper.toServerAssigneeType(apiItem.getAssigneeType()));
        serverItem.setFromDueDate(apiItem.getFromDueDate());
        serverItem.setToDueDate(apiItem.getToDueDate());
        serverItem.setId(apiItem.getElementId());
        serverItem.setName(apiItem.getName());
        serverItem.setLimit(apiItem.getLimit());
        serverItem.setPriority(WorkflowHelper.toServerPriority(apiItem.getPriority()));
        serverItem.setProcessFlowName(apiItem.getProcessFlowName());
        serverItem.setStatus(WorkflowHelper.toServerTaskStatus(apiItem.getStatus()));
        return serverItem;
    }

    private static TaskQuery.AssigneeType toServerAssigneeType(TaskQuery.AssigneeType apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case CURRENT_USER: {
                return TaskQuery.AssigneeType.CURRENT_USER;
            }
            case SPECIFIC_ASSIGNEE: {
                return TaskQuery.AssigneeType.SPECIFIC_ASSIGNEE;
            }
            case ALL: {
                return TaskQuery.AssigneeType.ALL;
            }
        }
        throw new SystemException("Unmapped task query assignee type: " + apiItem.name());
    }

    public static com.sas.lsaf.workflow.task.TaskSearchResults toApiTaskSearchResults(TaskSearchResults serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new com.sas.lsaf.workflow.task.TaskSearchResults(WorkflowHelper.toApiTasks(serverItem.getTasks()), serverItem.isLimitReached());
    }
}

