/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.workflow.processflow.impl;

import com.sas.lsaf.content.common.FileCreateInfo;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.SearchResultsInfo;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.core.type.IllegalTypeException;
import com.sas.lsaf.core.utils.impl.PathUtils;
import com.sas.lsaf.svcs.content.repository.client.RepositoryService;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.core.type.client.exception.TypeNotFoundException;
import com.sas.lsaf.svcs.security.authorization.client.exception.AccessDeniedException;
import com.sas.lsaf.svcs.work.processflow.client.ContextType;
import com.sas.lsaf.svcs.work.processflow.client.InvalidProcessFlowOwnerException;
import com.sas.lsaf.svcs.work.processflow.client.ProcessFlowActivationException;
import com.sas.lsaf.svcs.work.processflow.client.ProcessFlowContextException;
import com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowSearchService;
import com.sas.lsaf.svcs.work.workflow.client.HlsWorkflowException;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionNotFoundException;
import com.sas.lsaf.workflow.processflow.InvalidProcessFlowStateException;
import com.sas.lsaf.workflow.processflow.ProcessFlow;
import com.sas.lsaf.workflow.processflow.ProcessFlowContextNotFoundException;
import com.sas.lsaf.workflow.processflow.ProcessFlowCopyException;
import com.sas.lsaf.workflow.processflow.ProcessFlowCopyInfo;
import com.sas.lsaf.workflow.processflow.ProcessFlowDescriptor;
import com.sas.lsaf.workflow.processflow.ProcessFlowException;
import com.sas.lsaf.workflow.processflow.ProcessFlowExistsException;
import com.sas.lsaf.workflow.processflow.ProcessFlowManifestCreateException;
import com.sas.lsaf.workflow.processflow.ProcessFlowNotFoundException;
import com.sas.lsaf.workflow.processflow.ProcessFlowQuery;
import com.sas.lsaf.workflow.processflow.ProcessFlowSearchException;
import com.sas.lsaf.workflow.processflow.ProcessFlowSearchResultItem;
import com.sas.lsaf.workflow.processflow.ProcessFlowService;
import com.sas.lsaf.workflow.processflow.impl.InternalProcessFlowService;
import com.sas.lsaf.workflow.processflow.impl.WorkflowHelper;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ProcessFlowServiceImpl
implements ProcessFlowService,
InternalProcessFlowService {
    private com.sas.lsaf.svcs.work.processflow.client.ProcessFlowService processFlowService;
    private ProcessFlowSearchService processFlowSearchService;
    private RepositoryService repositoryService;
    private WorkflowHelper workflowHelper;
    private int searchPageSizeLimit = 5000;

    @Required
    public void setProcessFlowService(com.sas.lsaf.svcs.work.processflow.client.ProcessFlowService processFlowService) {
        this.processFlowService = processFlowService;
    }

    @Required
    public void setProcessFlowSearchService(ProcessFlowSearchService processFlowSearchService) {
        this.processFlowSearchService = processFlowSearchService;
    }

    @Required
    public void setWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    @Required
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setSearchPageSizeLimit(int searchPageSizeLimit) {
        this.searchPageSizeLimit = searchPageSizeLimit;
    }

    public Set<ProcessFlowDescriptor> getProcessFlowDescriptorsByContext(String contextId, boolean includeChildren) throws ProcessFlowContextNotFoundException {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        try {
            this.repositoryService.getContextById(contextId);
            return this.workflowHelper.toApiProcessFlowDescriptors(this.processFlowService.getAllProcessFlowDescriptorsByContext(contextId, includeChildren ? ContextType.ALL : ContextType.CONTEXT_ONLY));
        }
        catch (RepositoryItemNotFoundException e) {
            throw new ProcessFlowContextNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<ProcessFlowDescriptor> getAllProcessFlowDescriptors() {
        try {
            return this.workflowHelper.toApiProcessFlowDescriptors(this.processFlowService.getAllProcessFlowDescriptorsByContext("1", ContextType.ALL));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<ProcessFlowDescriptor> getMyProcessFlowDescriptors() {
        try {
            return this.workflowHelper.toApiProcessFlowDescriptors(this.processFlowService.getProcessFlowDescriptorsByContext("1", ContextType.ALL));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<ProcessFlowDescriptor> getMyProcessFlowDescriptorsByContext(String contextId, boolean includeChildren) throws ProcessFlowContextNotFoundException {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        try {
            this.repositoryService.getContextById(contextId);
            return this.workflowHelper.toApiProcessFlowDescriptors(this.processFlowService.getProcessFlowDescriptorsByContext(contextId, includeChildren ? ContextType.ALL : ContextType.CONTEXT_ONLY));
        }
        catch (RepositoryItemNotFoundException e) {
            throw new ProcessFlowContextNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessFlow createProcessFlow(String contextId, String processFlowName, String processDefinitionKey) throws ProcessFlowExistsException, ProcessDefinitionNotFoundException, ProcessFlowContextNotFoundException {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        Assert.hasText((String)processFlowName, (String)"Process flow name is required.");
        Assert.hasText((String)processDefinitionKey, (String)"Process definition id is required.");
        try {
            return WorkflowHelper.toApiProcessFlow(this.processFlowService.createProcessFlow(contextId, processFlowName, processDefinitionKey));
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowContextNotFoundException e) {
            throw new ProcessFlowContextNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowExistsException e) {
            throw new ProcessFlowExistsException(e.getLocalizedMessage());
        }
        catch (ProcessFlowContextException e) {
            throw new IllegalTypeException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessFlow getProcessFlowById(String id) throws ProcessFlowNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow identifier is required.");
        try {
            return WorkflowHelper.toApiProcessFlow(this.processFlowService.getProcessFlowByIdentifier(id));
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessFlow getProcessFlowByNameAndContext(String contextId, String processFlowName) throws ProcessFlowNotFoundException {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        Assert.hasText((String)processFlowName, (String)"Process flow name is required.");
        try {
            this.repositoryService.getContextById(contextId);
            return WorkflowHelper.toApiProcessFlow(this.processFlowService.getProcessFlowByContextAndName(contextId, processFlowName));
        }
        catch (RepositoryItemNotFoundException | com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean exists(String contextId, String processFlowName) {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        Assert.hasText((String)processFlowName, (String)"Process flow name is required.");
        try {
            com.sas.lsaf.svcs.work.processflow.client.ProcessFlowDescriptor pf = this.processFlowService.getProcessFlowDescriptorByContextAndName(contextId, processFlowName);
            if (pf != null) {
                return true;
            }
        }
        catch (AccessDeniedException | com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return false;
    }

    public ProcessFlow updateProcessFlow(ProcessFlow processFlow) throws ProcessFlowNotFoundException, InvalidProcessFlowStateException, ProcessFlowException, ProcessFlowExistsException {
        Assert.notNull((Object)processFlow, (String)"Process flow is required.");
        Assert.hasText((String)processFlow.getId(), (String)"Process flow identifier is required.");
        Assert.hasText((String)processFlow.getContextId(), (String)"Process flow context identifier is required.");
        try {
            return WorkflowHelper.toApiProcessFlow(this.processFlowService.updateProcessFlowDetails(WorkflowHelper.toServerProcessFlow(processFlow, this.repositoryService.getContextById(processFlow.getContextId()))));
        }
        catch (RepositoryItemNotFoundException | com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.InvalidProcessFlowStateException e) {
            throw new InvalidProcessFlowStateException(e.getLocalizedMessage());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowExistsException e) {
            throw new ProcessFlowExistsException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void deleteProcessFlow(String id) throws ProcessFlowNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        try {
            this.processFlowService.deleteProcessFlow(id);
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String createProcessFlowManifest(String id, FileCreateInfo manifestFileCreateInfo) throws ProcessFlowNotFoundException, ProcessFlowManifestCreateException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        Assert.notNull((Object)manifestFileCreateInfo, (String)"Process flow manifest file create information is required.");
        Assert.hasText((String)manifestFileCreateInfo.getPath(), (String)"Process flow manifest path is required.");
        try {
            PathUtils.validatePath((String)manifestFileCreateInfo.getPath());
            return this.processFlowService.createProcessFlowManifest(id, WorkflowHelper.toServerFileCreateInfo(manifestFileCreateInfo), manifestFileCreateInfo.getComment());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (ValidationException | com.sas.lsaf.svcs.work.processflow.client.ProcessFlowManifestCreateException | IOException e) {
            throw new ProcessFlowManifestCreateException(e.getLocalizedMessage());
        }
        catch (HlsWorkflowException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessFlow activateProcessFlow(String id) throws ProcessFlowNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        try {
            com.sas.lsaf.svcs.work.processflow.client.ProcessFlow serverFlow = this.processFlowService.activateProcessFlow(id);
            Thread.sleep(1000L);
            return WorkflowHelper.toApiProcessFlow(serverFlow);
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.InvalidProcessFlowStateException | ProcessFlowActivationException | HlsWorkflowException | com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessFlow suspendProcessFlow(String id) throws ProcessFlowNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        try {
            return WorkflowHelper.toApiProcessFlow(this.processFlowService.suspendProcessFlow(id));
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.InvalidProcessFlowStateException | HlsWorkflowException | com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException e) {
            throw new ProcessFlowException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessFlow copyProcessFlow(ProcessFlowCopyInfo copyInfo) throws ProcessFlowNotFoundException, ProcessFlowExistsException, ProcessFlowCopyException {
        Assert.notNull((Object)copyInfo, (String)"Copy process flow info is required.");
        Assert.hasText((String)copyInfo.getName(), (String)"Process flow name is required to copy a process flow.");
        Assert.hasText((String)copyInfo.getSourceProcessFlowId(), (String)"Source process flow id is required to copy a process flow.");
        try {
            return WorkflowHelper.toApiProcessFlow(this.processFlowService.copyProcessFlow(WorkflowHelper.toServerCopyProcessFlowInfo(copyInfo)));
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowExistsException e) {
            throw new ProcessFlowExistsException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.ProcessFlowNotFoundException e) {
            throw new ProcessFlowNotFoundException(e.getLocalizedMessage());
        }
        catch (TypeNotFoundException | InvalidProcessFlowOwnerException | com.sas.lsaf.svcs.work.processflow.client.InvalidProcessFlowStateException | ProcessFlowActivationException | HlsWorkflowException e) {
            throw new ProcessFlowCopyException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ProcessFlowSearchResultItem> internalGetSearchResults(String token, int fromRow, int toRow) throws ProcessFlowSearchException {
        Assert.hasText((String)token, (String)"Process Flow search token is required.");
        if (toRow + 1 - fromRow > this.searchPageSizeLimit) {
            throw new ProcessFlowSearchException("The number of process flow results requested exceeds the maximum limit, " + this.searchPageSizeLimit + ".  Please modify the number of rows requested.");
        }
        try {
            return WorkflowHelper.toApiProcessFlowSearchResultItems(this.processFlowSearchService.getResults(token, fromRow, toRow));
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowSearchException e) {
            throw new ProcessFlowSearchException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void internalClearSearchResults(String token) {
        Assert.hasText((String)token, (String)"Process flow search token is required.");
        try {
            this.processFlowSearchService.clearResults(token);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public SearchResultsInfo search(ProcessFlowQuery query) throws ProcessFlowSearchException {
        Assert.notNull((Object)query, (String)"Process flow query is required.");
        try {
            String queryToken = this.processFlowSearchService.getQuery().getToken();
            return CoreHelper.toApiSearchResultsInfo(this.processFlowSearchService.search(WorkflowHelper.toServerProcessFlowQuery(query, queryToken)));
        }
        catch (com.sas.lsaf.svcs.work.processflow.client.query.ProcessFlowSearchException e) {
            throw new ProcessFlowSearchException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ProcessFlowSearchResultItem> getSearchResults(int fromRow, int toRow) {
        throw new UnsupportedOperationException("This implementation does not provide this functionality.");
    }

    public void clearSearchResults() {
        throw new UnsupportedOperationException("This implementation does not provide this functionality.");
    }

    public int getSearchPageSizeLimit() {
        return this.searchPageSizeLimit;
    }
}

