/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.workflow.processdefinition.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.type.IllegalTypeException;
import com.sas.lsaf.core.utils.impl.PathUtils;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryException;
import com.sas.lsaf.svcs.core.type.client.Type;
import com.sas.lsaf.svcs.core.type.client.TypeService;
import com.sas.lsaf.svcs.core.type.client.exception.TypeNotFoundException;
import com.sas.lsaf.svcs.work.workflow.client.InvalidProcessDefinitionStateException;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinition;
import com.sas.lsaf.svcs.work.workflow.client.ProcessFlowDeploymentException;
import com.sas.lsaf.svcs.work.workflow.client.ValidationMessage;
import com.sas.lsaf.svcs.work.workflow.client.ValidationResult;
import com.sas.lsaf.workflow.AutoFlowType;
import com.sas.lsaf.workflow.processdefinition.FlowElementDefinition;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionDeploymentException;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionInfo;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMapping;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMappingMetadata;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMappingUpdateException;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionNotFoundException;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionService;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionStateException;
import com.sas.lsaf.workflow.processflow.impl.WorkflowHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ProcessDefinitionServiceImpl
implements ProcessDefinitionService {
    private com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionService processDefinitionService;
    private TypeService typeService;

    @Required
    public void setProcessDefinitionService(com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionService processDefinitionService) {
        this.processDefinitionService = processDefinitionService;
    }

    @Required
    public void setTypeService(TypeService typeService) {
        this.typeService = typeService;
    }

    public List<ProcessDefinitionInfo> getAllProcessDefinitions() {
        try {
            return WorkflowHelper.toApiProcessDefinitionInfos(this.processDefinitionService.getAllProcessDefinitions());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ProcessDefinitionInfo> getProcessDefinitionsByContextType(String contextTypeId) {
        Assert.hasText((String)contextTypeId, (String)"Context type id is required.");
        try {
            this.validateContextType(contextTypeId);
            return WorkflowHelper.toApiProcessDefinitionInfos(this.getProcessDefinitionsAtContext(contextTypeId));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessDefinitionInfo deployProcessDefinitionFromRepository(String path, String version, Set<String> contextTypeIds, String comments, boolean activate, boolean overwrite) throws ProcessDefinitionDeploymentException {
        Assert.hasText((String)path, (String)"Repository path is required.");
        Assert.notEmpty(contextTypeIds, (String)"At least one context type id is required.");
        try {
            PathUtils.validatePath((String)path);
            ValidationResult valResult = this.processDefinitionService.validateProcessDefinitionInRepository(path, version);
            if (valResult.getErrors() != null && !valResult.getErrors().isEmpty()) {
                throw new ProcessDefinitionDeploymentException("Process definition file contains validation errors - " + ((ValidationMessage)valResult.getErrors().iterator().next()).getProblem());
            }
            boolean exists = this.processDefinitionService.existsByKey(valResult.getProcessDefinitionId());
            if (exists && !overwrite) {
                throw new ProcessDefinitionDeploymentException("A process definition already exists with id " + valResult.getProcessDefinitionId() + " and the overwrite option was set to false.");
            }
            return WorkflowHelper.toApiProcessDefinitionInfo(this.processDefinitionService.deployProcessDefinitionFromRepository(path, version, contextTypeIds, comments, activate));
        }
        catch (RepositoryException | ProcessFlowDeploymentException | IOException e) {
            throw new ProcessDefinitionDeploymentException(e.getLocalizedMessage());
        }
        catch (ProcessDefinitionDeploymentException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessDefinitionInfo activateProcessDefinition(String id) throws ProcessDefinitionStateException, ProcessDefinitionNotFoundException {
        Assert.hasText((String)id, (String)"Process definition id is required.");
        try {
            this.processDefinitionService.activateProcessDefinitionByKey(id);
            return WorkflowHelper.toApiProcessDefinitionInfo(this.processDefinitionService.getLatestVersionOfProcessDefinitionByKey(id));
        }
        catch (InvalidProcessDefinitionStateException e) {
            throw new ProcessDefinitionStateException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessDefinitionInfo suspendProcessDefinition(String id) throws ProcessDefinitionStateException, ProcessDefinitionNotFoundException {
        Assert.hasText((String)id, (String)"Process definition id is required.");
        try {
            this.processDefinitionService.suspendProcessDefinitionByKey(id);
            return WorkflowHelper.toApiProcessDefinitionInfo(this.processDefinitionService.getLatestVersionOfProcessDefinitionByKey(id));
        }
        catch (InvalidProcessDefinitionStateException e) {
            throw new ProcessDefinitionStateException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessDefinitionInfo getProcessDefinitionByKey(String processDefinitionKey) throws ProcessDefinitionNotFoundException {
        Assert.hasText((String)processDefinitionKey, (String)"Process definition key is required.");
        try {
            return WorkflowHelper.toApiProcessDefinitionInfo(this.processDefinitionService.getLatestVersionOfProcessDefinitionByKey(processDefinitionKey));
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessDefinitionInfo getProcessDefinitionById(String id) throws ProcessDefinitionNotFoundException {
        Assert.hasText((String)id, (String)"Process definition id is required.");
        try {
            return WorkflowHelper.toApiProcessDefinitionInfo(this.processDefinitionService.getProcessDefinitionByIdentifier(id));
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessDefinitionMapping getProcessDefinitionMappingByType(AutoFlowType type, String processDefinitionKey) throws ProcessDefinitionNotFoundException {
        Assert.notNull((Object)type, (String)"Auto flow type is required.");
        Assert.hasText((String)processDefinitionKey, (String)"Process definition id is required.");
        try {
            this.getProcessDefinitionByKey(processDefinitionKey);
            return WorkflowHelper.toApiProcessDefinitionMapping(this.processDefinitionService.getProcessDefinitionMappingByType(WorkflowHelper.toServerAutoFlowType(type), processDefinitionKey));
        }
        catch (ProcessDefinitionNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ProcessDefinitionMapping updateProcessDefinitionMapping(ProcessDefinitionMapping mapping) throws ProcessDefinitionMappingUpdateException, ProcessDefinitionNotFoundException {
        Assert.notNull((Object)mapping, (String)"Process definition mapping is required.");
        Assert.hasText((String)mapping.getProcessDefinitionKey(), (String)"Process definition key is required.");
        Assert.notNull((Object)mapping.getType(), (String)"Autoflow type is required.");
        try {
            return WorkflowHelper.toApiProcessDefinitionMapping(this.processDefinitionService.updateProcessDefinitionMapping(WorkflowHelper.toServerProcessDefinitionMapping(mapping)));
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionMappingUpdateException e) {
            throw new ProcessDefinitionMappingUpdateException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ProcessDefinitionMappingMetadata> getProcessDefinitionMappingMetadata() {
        try {
            return WorkflowHelper.toApiProcessFlowMappingMetadatas(this.processDefinitionService.getProcessDefinitionMappingMetadata());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<FlowElementDefinition> getProcessDefinitionElements(String id) throws ProcessDefinitionNotFoundException {
        Assert.hasText((String)id, (String)"Process definition id is required.");
        try {
            ProcessDefinition serverPfd = this.processDefinitionService.getProcessDefinitionByIdentifier(id);
            return WorkflowHelper.toApiProcessDefinitionElements(this.processDefinitionService.getFlowElementDefinitions(serverPfd.getId()));
        }
        catch (com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ProcessDefinitionInfo> getProcessDefinitionsMappedForAutoFlow(String contextTypeId, AutoFlowType type, boolean activeOnly) {
        Assert.notNull((Object)type, (String)"Auto Flow type is required to get mapped process flow definitions.");
        if (contextTypeId != null) {
            this.validateContextType(contextTypeId);
        }
        try {
            return WorkflowHelper.toApiProcessDefinitionInfosFromDescriptors(this.processDefinitionService.getMappedProcessDefinitionDescriptorsByAutoflowType(contextTypeId, WorkflowHelper.toServerAutoFlowType(type), activeOnly));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private void validateContextType(String contextTypeId) {
        boolean isValidContext = true;
        try {
            Type type = this.typeService.getTypeById(contextTypeId);
            if (!type.isContextType() || !this.typeService.isTypeCapable(type.getId(), Type.Capability.WORKFLOW)) {
                isValidContext = false;
            }
        }
        catch (TypeNotFoundException e) {
            isValidContext = false;
        }
        if (!isValidContext) {
            throw new IllegalTypeException("Type is not valid or is not a context with process flow capabilities: " + contextTypeId);
        }
    }

    private List<ProcessDefinition> getProcessDefinitionsAtContext(String contextTypeId) {
        List allDefs = this.processDefinitionService.getAllProcessDefinitions();
        ArrayList<ProcessDefinition> contextDefs = new ArrayList<ProcessDefinition>();
        for (ProcessDefinition def : allDefs) {
            if (def == null || !def.getContextTypes().contains(contextTypeId)) continue;
            contextDefs.add(def);
        }
        return contextDefs;
    }
}

