/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.workflow.autoflow.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.svcs.clinical.study.client.StudyService;
import com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException;
import com.sas.lsaf.svcs.core.common.client.Context;
import com.sas.lsaf.svcs.core.utils.client.CollectionUtils;
import com.sas.lsaf.svcs.work.autoflow.client.AutoFlowLaunchable;
import com.sas.lsaf.svcs.work.autoflow.client.AutoFlowProcessDefinitionInfo;
import com.sas.lsaf.svcs.work.autoflow.client.AutoProcessFlowException;
import com.sas.lsaf.svcs.work.autoflow.server.AutoFlowSourceProvider;
import com.sas.lsaf.svcs.work.autoflow.server.AutoFlowSourceProviders;
import com.sas.lsaf.svcs.work.autoflow.server.InternalAutoFlowService;
import com.sas.lsaf.svcs.work.processflow.client.ProcessFlowContextException;
import com.sas.lsaf.svcs.work.workflow.client.AutoFlowMappingValidationInfo;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionMapping;
import com.sas.lsaf.svcs.work.workflow.client.ProcessDefinitionNotFoundException;
import com.sas.lsaf.workflow.AutoFlowType;
import com.sas.lsaf.workflow.autoflow.AutoFlowException;
import com.sas.lsaf.workflow.autoflow.AutoFlowService;
import com.sas.lsaf.workflow.autoflow.AutoFlowSetupException;
import com.sas.lsaf.workflow.processflow.ProcessFlowDescriptor;
import com.sas.lsaf.workflow.processflow.impl.WorkflowHelper;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class AutoFlowServiceImpl
implements AutoFlowService {
    private com.sas.lsaf.svcs.work.autoflow.client.AutoFlowService autoFlowService;
    private InternalAutoFlowService internalAutoFlowService;
    private AutoFlowSourceProviders autoFlowSourceProviders;
    private StudyService studyService;
    private WorkflowHelper workflowHelper;

    @Required
    public void setAutoFlowService(com.sas.lsaf.svcs.work.autoflow.client.AutoFlowService autoFlowService) {
        this.autoFlowService = autoFlowService;
    }

    @Required
    public void setInternalAutoFlowService(InternalAutoFlowService internalAutoFlowService) {
        this.internalAutoFlowService = internalAutoFlowService;
    }

    @Required
    public void setWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    @Required
    public void setAutoFlowSourceProviders(AutoFlowSourceProviders autoFlowSourceProviders) {
        this.autoFlowSourceProviders = autoFlowSourceProviders;
    }

    @Required
    public void setStudyService(StudyService service) {
        this.studyService = service;
    }

    public ProcessFlowDescriptor createAutoFlow(String contextId, String processDefinitionKey, AutoFlowType autoFlowType, String namePrefix, String sourceId) throws AutoFlowSetupException, AutoFlowException {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        Assert.hasText((String)processDefinitionKey, (String)"Process definition key is required.");
        Assert.hasText((String)sourceId, (String)"Auto flow launch source is required.");
        Assert.hasText((String)namePrefix, (String)"Prefix for auto process flow is required.");
        try {
            AutoFlowInfo autoFlowInfo = this.validateForAutoFlow(contextId, autoFlowType, processDefinitionKey, sourceId);
            return this.workflowHelper.toApiProcessFlowDescriptor(this.autoFlowService.createAutoFlow(autoFlowInfo.getContext(), autoFlowInfo.getProcessDefinitionInfo(), autoFlowInfo.getAutoFlowType(), namePrefix, autoFlowInfo.getAutoFlowLaunchable()));
        }
        catch (AutoProcessFlowException e) {
            throw new AutoFlowException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.work.autoflow.client.AutoFlowSetupException | ProcessFlowContextException | ProcessDefinitionNotFoundException e) {
            throw new AutoFlowSetupException(e.getLocalizedMessage());
        }
        catch (StudyNotFoundException e) {
            throw new AutoFlowSetupException("Context id must be to a study. " + e.getLocalizedMessage());
        }
        catch (AutoFlowSetupException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private AutoFlowInfo validateForAutoFlow(String contextId, AutoFlowType autoFlowType, String processDefinitionId, String sourceId) throws ProcessFlowContextException, AutoFlowSetupException, StudyNotFoundException {
        ProcessDefinitionMapping.AutoFlowType lsafAutoFlowType = WorkflowHelper.toServerAutoFlowType(autoFlowType);
        Context context = this.internalAutoFlowService.internalGetAutoFlowContext(contextId);
        AutoFlowProcessDefinitionInfo afDefinitionInfo = this.internalAutoFlowService.internalGetAutoFlowProcessDefinition(processDefinitionId, context.getTypeId(), lsafAutoFlowType);
        if (afDefinitionInfo != null) {
            this.studyService.getStudyById(contextId);
            AutoFlowMappingValidationInfo valInfo = afDefinitionInfo.getMappingValidationInfo();
            ProcessDefinitionMapping pdMapping = valInfo.getProcessDefinitionMapping();
            if (!pdMapping.isEnableAutoFlowMapping()) {
                throw new AutoFlowSetupException("Process flow definition " + processDefinitionId + " is not enabled for auto process flow.");
            }
            if (!pdMapping.isMappingComplete()) {
                throw new AutoFlowSetupException("Process flow definition " + processDefinitionId + " does not have the required mapping defined.");
            }
            AutoFlowSourceProvider autoFlowSourceProvider = this.autoFlowSourceProviders.getProviderByAutoFlowType(lsafAutoFlowType);
            if (!autoFlowSourceProvider.canLaunchAutoFlowAtContext(contextId)) {
                throw new AutoFlowSetupException("The process flow could not be created at this context because of insufficient authorization or a component is locked by another user.");
            }
            List existing = autoFlowSourceProvider.getSourceByIds(contextId, CollectionUtils.asSet((Object[])new String[]{sourceId}));
            AutoFlowLaunchable af = null;
            if (existing != null && !existing.isEmpty()) {
                af = (AutoFlowLaunchable)existing.iterator().next();
                if (af == null) {
                    throw new AutoFlowSetupException("Auto process flow was not created because the source is not valid or does not exist.");
                }
                if (!af.autoFlowEnabled()) {
                    throw new AutoFlowSetupException("Source object is not enabled for auto process flow creation.");
                }
                Map activeAutoFlows = this.autoFlowService.getCurrentProcessFlowsByAutoFlowSourceIds(lsafAutoFlowType, CollectionUtils.asSet((Object[])new String[]{sourceId}));
                if (activeAutoFlows.get(af.getId()) != null) {
                    throw new AutoFlowSetupException("Auto process flow was not created because source can have at most one active/suspended process flow associated with it at any time.");
                }
            } else {
                throw new AutoFlowSetupException("Auto process flow was not created because the source does not exist with id: " + sourceId + ".");
            }
            return new AutoFlowInfo(lsafAutoFlowType, context, afDefinitionInfo, af);
        }
        throw new AutoFlowSetupException("The process definition could not be found with id " + processDefinitionId + " at the context type " + context.getTypeId() + " for autoflow type " + autoFlowType.name());
    }

    public static class AutoFlowInfo {
        private ProcessDefinitionMapping.AutoFlowType autoFlowType;
        private Context context;
        private AutoFlowProcessDefinitionInfo processDefinitionInfo;
        private AutoFlowLaunchable autoFlowLaunchable;

        public AutoFlowInfo(ProcessDefinitionMapping.AutoFlowType autoFlowType, Context context, AutoFlowProcessDefinitionInfo processDefinitionInfo, AutoFlowLaunchable autoFlowLaunchable) {
            this.autoFlowType = autoFlowType;
            this.context = context;
            this.processDefinitionInfo = processDefinitionInfo;
            this.autoFlowLaunchable = autoFlowLaunchable;
        }

        public ProcessDefinitionMapping.AutoFlowType getAutoFlowType() {
            return this.autoFlowType;
        }

        public Context getContext() {
            return this.context;
        }

        public AutoFlowProcessDefinitionInfo getProcessDefinitionInfo() {
            return this.processDefinitionInfo;
        }

        public AutoFlowLaunchable getAutoFlowLaunchable() {
            return this.autoFlowLaunchable;
        }
    }
}

