/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.user.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.security.authentication.AuthenticationException;
import com.sas.lsaf.security.authentication.impl.AuthenticationHelper;
import com.sas.lsaf.security.crypto.impl.EncryptionHelper;
import com.sas.lsaf.security.user.AuthenticationProviderInfo;
import com.sas.lsaf.security.user.InternalUserService;
import com.sas.lsaf.security.user.LicenseType;
import com.sas.lsaf.security.user.User;
import com.sas.lsaf.security.user.UserCreateInfo;
import com.sas.lsaf.security.user.UserDeleteException;
import com.sas.lsaf.security.user.UserDescriptor;
import com.sas.lsaf.security.user.UserExistsException;
import com.sas.lsaf.security.user.UserLockedException;
import com.sas.lsaf.security.user.UserNotFoundException;
import com.sas.lsaf.security.user.UserPasswordException;
import com.sas.lsaf.security.user.UserService;
import com.sas.lsaf.security.user.UserUnlockedException;
import com.sas.lsaf.security.user.impl.UserHelper;
import com.sas.lsaf.svcs.core.utils.client.EqualsUtils;
import com.sas.lsaf.svcs.security.authentication.client.AuthenticationService;
import com.sas.lsaf.svcs.security.authentication.server.ServerSecurityContext;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class UserServiceImpl
implements UserService {
    private com.sas.lsaf.svcs.security.user.client.UserService userService;
    private InternalUserService internalUserService;
    private AuthenticationService authenticationService;
    private EncryptionHelper encryptionHelper;

    @Required
    public void setUserService(com.sas.lsaf.svcs.security.user.client.UserService userService) {
        this.userService = userService;
    }

    @Required
    public void setInternalUserService(InternalUserService internalUserService) {
        this.internalUserService = internalUserService;
    }

    @Required
    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @Required
    public void setEncryptionHelper(EncryptionHelper encryptionHelper) {
        this.encryptionHelper = encryptionHelper;
    }

    public User createUser(UserCreateInfo userCreateInfo) throws UserExistsException, UserPasswordException {
        Assert.notNull((Object)userCreateInfo, (String)"User creation information is required.");
        Assert.hasText((String)userCreateInfo.getPassword(), (String)"User password is required.");
        Assert.hasText((String)userCreateInfo.getUserId(), (String)"User ID is required.");
        Assert.hasText((String)userCreateInfo.getDisplayName(), (String)"User display name is required.");
        Assert.hasText((String)userCreateInfo.getEmail(), (String)"User email address is required.");
        try {
            return UserHelper.toApiUser(this.userService.createUser(UserHelper.toServerUser(userCreateInfo)));
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserExistsException e) {
            throw new UserExistsException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserPasswordException e) {
            throw new UserPasswordException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void changePassword(String oldPassword, String newPassword) throws UserPasswordException, AuthenticationException {
        Assert.hasText((String)oldPassword, (String)"Old password is required.");
        Assert.hasText((String)newPassword, (String)"New password is required.");
        try {
            this.userService.changePassword(oldPassword, newPassword);
        }
        catch (com.sas.lsaf.svcs.security.authentication.client.exception.AuthenticationException e) {
            throw AuthenticationHelper.toApiAuthenticationException(e);
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserPasswordException e) {
            throw new UserPasswordException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void resetPassword(String userId, String newPassword) throws UserNotFoundException, UserPasswordException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.hasText((String)newPassword, (String)"Password is required.");
        try {
            this.userService.resetPassword(userId, newPassword);
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserPasswordException e) {
            throw new UserPasswordException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean userExists(String userId) {
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            return this.userService.userExists(userId);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public User getUserByUserId(String userId) throws UserNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            return UserHelper.toApiUser(this.userService.getUserByUserId(userId));
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<User> getUsersByUserIds(Set<String> userIds) {
        Assert.notEmpty(userIds, (String)"User IDs are required.");
        try {
            return UserHelper.toApiUsers(this.userService.getUsersByUserIds(userIds));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public UserDescriptor getUserDescriptorByUserId(String userId) throws UserNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            return UserHelper.toApiUserDescriptor(this.userService.getUserDescriptorByUserId(userId));
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<UserDescriptor> getUserDescriptorsByUserIds(Set<String> userIds) {
        Assert.notEmpty(userIds, (String)"User IDs are required.");
        try {
            return UserHelper.toApiUserDescriptors(this.userService.getUserDescriptorsByUserIds(userIds));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void deleteUser(String userId) throws UserNotFoundException, UserDeleteException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            this.userService.deleteUser(userId);
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserDeleteException e) {
            throw new UserDeleteException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void lockUser(String userId) throws UserNotFoundException, UserLockedException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            this.userService.lockUser(userId);
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserLockedException e) {
            throw new UserLockedException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void unlockUser(String userId) throws UserNotFoundException, UserUnlockedException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            this.userService.unlockUser(userId);
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserUnlockedException e) {
            throw new UserUnlockedException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public User updateUser(User user) throws UserNotFoundException {
        Assert.notNull((Object)user, (String)"User is required.");
        Assert.hasText((String)user.getUserId(), (String)"User ID is required.");
        try {
            com.sas.lsaf.svcs.security.user.client.User u = this.userService.getUserById(user.getId());
            if (user.getAccountInfo() != null && !user.getAccountInfo().isSingleSignOnEnabled() && EqualsUtils.notEquals((Object)user.getAccountInfo().getSingleSignOnId(), (Object)u.getAccountInfo().getSamlId())) {
                throw new IllegalArgumentException("Single sign-on id cannot be updated because single sign-on is not enabled.");
            }
            return UserHelper.toApiUser(this.userService.updateUser(UserHelper.toServerUser(user)));
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<User> getAllUsers() {
        try {
            return UserHelper.toApiUsers(this.userService.getAllUsers());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<UserDescriptor> getAllUserDescriptors() {
        try {
            return UserHelper.toApiUserDescriptors(this.userService.getAllUserDescriptors());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String encryptPassword(byte[] password) {
        Assert.notNull((Object)password, (String)"Password is required.");
        return this.encryptionHelper.encrypt(password);
    }

    public List<AuthenticationProviderInfo> getAuthenticationProviderInfos() {
        return AuthenticationHelper.toApiAuthenticationProviderInfos(this.authenticationService.getAuthenticationProviderInfos());
    }

    public User setExternalAuthenticatorByUserId(String userId, String authenticator, String authenticatorUsername) throws UserNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.hasText((String)authenticator, (String)"Authenticator is required.");
        try {
            this.ensureAuthenticatorIsConfigured(authenticator);
            User u = null;
            u = authenticator.equals("saml") ? this.internalUserService.updateUserForSingleSignOn(userId, authenticatorUsername) : UserHelper.toApiUser(this.userService.setExternalAuthenticatorByUserId(userId, authenticator, authenticatorUsername));
            return u;
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public User setDefaultAuthenticatorByUserId(String userId, String newPassword) throws UserNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.hasText((String)newPassword, (String)"New password is required.");
        try {
            return UserHelper.toApiUser(this.userService.setDefaultAuthenticatorByUserId(userId, newPassword));
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserPasswordException e) {
            throw new ValidationException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<LicenseType> getLicenseTypes() {
        try {
            return UserHelper.toApiLicenseTypes(this.userService.getLicenseTypes());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String getCurrentUserId() {
        try {
            return ServerSecurityContext.getCurrentUserId();
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private void ensureAuthenticatorIsConfigured(String authenticator) {
        List authProviders = this.authenticationService.getAuthenticationProviderInfos();
        for (com.sas.lsaf.svcs.security.authentication.client.AuthenticationProviderInfo auth : authProviders) {
            if (!auth.getId().equals(authenticator)) continue;
            return;
        }
        throw new ValidationException("The authenticator provided \"" + authenticator + "\" is not valid or is not configured for the system.");
    }
}

