/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.user.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.security.user.AccountInfo;
import com.sas.lsaf.security.user.LicenseType;
import com.sas.lsaf.security.user.LockedInfo;
import com.sas.lsaf.security.user.LoginInfo;
import com.sas.lsaf.security.user.PasswordInfo;
import com.sas.lsaf.security.user.User;
import com.sas.lsaf.security.user.UserCreateInfo;
import com.sas.lsaf.security.user.UserDescriptor;
import com.sas.lsaf.svcs.core.utils.client.Assert;
import com.sas.lsaf.svcs.security.user.client.AccountInfo;
import java.util.HashSet;
import java.util.Set;

public abstract class UserHelper {
    private static AccountInfo.AccountType toApiAccountType(AccountInfo.AccountType serverItem) {
        switch (serverItem) {
            case INTERACTIVE: {
                return AccountInfo.AccountType.INTERACTIVE;
            }
            case NON_INTERACTIVE: {
                return AccountInfo.AccountType.NON_INTERACTIVE;
            }
        }
        throw new SystemException("Unmapped account type: " + serverItem.name());
    }

    private static AccountInfo.AccountType toServerAccountType(AccountInfo.AccountType apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case INTERACTIVE: {
                return AccountInfo.AccountType.INTERACTIVE;
            }
            case NON_INTERACTIVE: {
                return AccountInfo.AccountType.NON_INTERACTIVE;
            }
        }
        throw new SystemException("Unmapped account type: " + apiItem.name());
    }

    public static AccountInfo toApiAccountInfo(com.sas.lsaf.svcs.security.user.client.AccountInfo serverItem) {
        Assert.notNull((Object)serverItem, (String)"Account information is required.");
        return new AccountInfo(UserHelper.toApiAccountType(serverItem.getAccountType()), serverItem.getActivationDate(), serverItem.getDeactivationDate(), serverItem.isActive(), serverItem.getLicenseType(), serverItem.getAuthenticator(), serverItem.getAuthenticatorUsername(), serverItem.getSamlId(), serverItem.isSamlEnabled());
    }

    public static LockedInfo toApiLockedInfo(com.sas.lsaf.svcs.security.user.client.LockedInfo serverItem) {
        Assert.notNull((Object)serverItem, (String)"Account locking information is required.");
        return new LockedInfo(serverItem.isLocked(), serverItem.getLockedBy(), serverItem.getLockedDate());
    }

    public static LoginInfo toApiLoginInfo(com.sas.lsaf.svcs.security.user.client.LoginInfo serverItem) {
        Assert.notNull((Object)serverItem, (String)"Account login information is required.");
        return new LoginInfo(serverItem.getLastLogin(), serverItem.getLoginAttempts());
    }

    public static PasswordInfo toApiPasswordInfo(com.sas.lsaf.svcs.security.user.client.PasswordInfo serverItem) {
        Assert.notNull((Object)serverItem, (String)"Account password information is required.");
        return new PasswordInfo(serverItem.getCreated(), serverItem.getExpiration(), serverItem.isExpired());
    }

    public static Set<User> toApiUsers(Set<com.sas.lsaf.svcs.security.user.client.User> serverItems) {
        HashSet<User> apiItems = new HashSet<User>(serverItems.size());
        for (com.sas.lsaf.svcs.security.user.client.User serverItem : serverItems) {
            apiItems.add(UserHelper.toApiUser(serverItem));
        }
        return apiItems;
    }

    public static User toApiUser(com.sas.lsaf.svcs.security.user.client.User serverItem) {
        Assert.notNull((Object)serverItem, (String)"User account is required.");
        return new User(serverItem.getId(), serverItem.getUserId(), serverItem.getDisplayName(), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified(), serverItem.getFirstName(), serverItem.getLastName(), serverItem.getDepartment(), serverItem.getPhone(), serverItem.getEmail(), CoreHelper.toApiAttributes(serverItem.getAttributes()), UserHelper.toApiAccountInfo(serverItem.getAccountInfo()), UserHelper.toApiPasswordInfo(serverItem.getPasswordInfo()), UserHelper.toApiLockedInfo(serverItem.getLockedInfo()), UserHelper.toApiLoginInfo(serverItem.getLoginInfo()), serverItem.getRevision());
    }

    public static UserDescriptor toApiUserDescriptor(com.sas.lsaf.svcs.security.user.client.UserDescriptor serverItem) {
        Assert.notNull((Object)serverItem, (String)"User account descriptor is required.");
        return new UserDescriptor(serverItem.getId(), serverItem.getUserId(), serverItem.getDisplayName(), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified());
    }

    public static Set<UserDescriptor> toApiUserDescriptors(Set<com.sas.lsaf.svcs.security.user.client.UserDescriptor> serverItems) {
        HashSet<UserDescriptor> apiItems = new HashSet<UserDescriptor>(serverItems.size());
        for (com.sas.lsaf.svcs.security.user.client.UserDescriptor serverItem : serverItems) {
            apiItems.add(UserHelper.toApiUserDescriptor(serverItem));
        }
        return apiItems;
    }

    public static LicenseType toApiLicenseType(com.sas.lsaf.svcs.security.user.client.LicenseType serverItem) {
        return new LicenseType(serverItem.getId(), serverItem.getName(), serverItem.getDescription());
    }

    public static Set<LicenseType> toApiLicenseTypes(Set<com.sas.lsaf.svcs.security.user.client.LicenseType> serverItems) {
        HashSet<LicenseType> apiItems = new HashSet<LicenseType>(serverItems.size());
        for (com.sas.lsaf.svcs.security.user.client.LicenseType serverItem : serverItems) {
            apiItems.add(UserHelper.toApiLicenseType(serverItem));
        }
        return apiItems;
    }

    public static com.sas.lsaf.svcs.security.user.client.UserDescriptor toServerUserDescriptor(UserDescriptor apiItem) {
        Assert.notNull((Object)apiItem, (String)"User descriptor is required.");
        com.sas.lsaf.svcs.security.user.client.UserDescriptor serverItem = new com.sas.lsaf.svcs.security.user.client.UserDescriptor();
        serverItem.setDisplayName(apiItem.getDisplayName());
        serverItem.setId(apiItem.getId());
        serverItem.setUserId(apiItem.getUserId());
        return serverItem;
    }

    public static com.sas.lsaf.svcs.security.user.client.User toServerUser(User apiItem) {
        Assert.notNull((Object)apiItem, (String)"User account is required.");
        com.sas.lsaf.svcs.security.user.client.User serverItem = new com.sas.lsaf.svcs.security.user.client.User();
        serverItem.setDisplayName(apiItem.getDisplayName());
        serverItem.setEmail(apiItem.getEmail());
        serverItem.setId(apiItem.getId());
        serverItem.setUserId(apiItem.getUserId());
        serverItem.setAccountInfo(UserHelper.toServerAccountInfo(apiItem.getAccountInfo()));
        serverItem.setDepartment(apiItem.getDepartment());
        serverItem.setFirstName(apiItem.getFirstName());
        serverItem.setLastName(apiItem.getLastName());
        serverItem.setLockedInfo(UserHelper.toServerLockedInfo(apiItem.getLockedInfo()));
        serverItem.setLoginInfo(UserHelper.toServerLoginInfo(apiItem.getLoginInfo()));
        serverItem.setPasswordInfo(UserHelper.toServerPasswordInfo(apiItem.getPasswordInfo()));
        serverItem.setRevision(apiItem.getRevision());
        serverItem.setPhone(apiItem.getPhone());
        serverItem.setAttributes(CoreHelper.toServerAttributes(apiItem.getAttributes()));
        return serverItem;
    }

    public static com.sas.lsaf.svcs.security.user.client.AccountInfo toServerAccountInfo(AccountInfo apiItem) {
        Assert.notNull((Object)apiItem, (String)"Account information is required.");
        com.sas.lsaf.svcs.security.user.client.AccountInfo serverItem = new com.sas.lsaf.svcs.security.user.client.AccountInfo();
        serverItem.setAccountType(UserHelper.toServerAccountType(apiItem.getAccountType()));
        serverItem.setAuthenticator(apiItem.getAuthenticator());
        serverItem.setAuthenticatorUsername(apiItem.getAuthenticatorUsername());
        serverItem.setActivationDate(apiItem.getActivationDate());
        serverItem.setActive(apiItem.isActive());
        serverItem.setDeactivationDate(apiItem.getDeactivationDate());
        serverItem.setLicenseType(apiItem.getLicenseTypeId());
        serverItem.setSamlId(apiItem.getSingleSignOnId());
        return serverItem;
    }

    public static com.sas.lsaf.svcs.security.user.client.LockedInfo toServerLockedInfo(LockedInfo apiItem) {
        Assert.notNull((Object)apiItem, (String)"Account locking information is required.");
        com.sas.lsaf.svcs.security.user.client.LockedInfo serverItem = new com.sas.lsaf.svcs.security.user.client.LockedInfo();
        serverItem.setLocked(apiItem.isLocked());
        serverItem.setLockedBy(apiItem.getLockedBy());
        serverItem.setLockedDate(serverItem.getLockedDate());
        return serverItem;
    }

    public static com.sas.lsaf.svcs.security.user.client.PasswordInfo toServerPasswordInfo(PasswordInfo apiItem) {
        Assert.notNull((Object)apiItem, (String)"Account password information is required.");
        com.sas.lsaf.svcs.security.user.client.PasswordInfo serverItem = new com.sas.lsaf.svcs.security.user.client.PasswordInfo();
        serverItem.setCreated(apiItem.getCreated());
        serverItem.setExpiration(apiItem.getExpiration());
        serverItem.setExpired(apiItem.isExpired());
        return serverItem;
    }

    public static com.sas.lsaf.svcs.security.user.client.LoginInfo toServerLoginInfo(LoginInfo apiItem) {
        Assert.notNull((Object)apiItem, (String)"Account login information is required.");
        com.sas.lsaf.svcs.security.user.client.LoginInfo serverItem = new com.sas.lsaf.svcs.security.user.client.LoginInfo();
        serverItem.setLastLogin(apiItem.getLastLogin());
        serverItem.setLoginAttempts(apiItem.getLoginAttempts());
        return serverItem;
    }

    public static com.sas.lsaf.svcs.security.user.client.User toServerUser(UserCreateInfo apiItem) {
        Assert.notNull((Object)apiItem, (String)"User creation information is required.");
        com.sas.lsaf.svcs.security.user.client.User serverItem = new com.sas.lsaf.svcs.security.user.client.User();
        serverItem.setDisplayName(apiItem.getDisplayName());
        serverItem.setEmail(apiItem.getEmail());
        serverItem.setUserId(apiItem.getUserId());
        serverItem.setDepartment(apiItem.getDepartment());
        serverItem.setFirstName(apiItem.getFirstName());
        serverItem.setLastName(apiItem.getLastName());
        serverItem.setPhone(apiItem.getPhone());
        if (apiItem.getAccountType() != null) {
            com.sas.lsaf.svcs.security.user.client.AccountInfo ai = new com.sas.lsaf.svcs.security.user.client.AccountInfo();
            ai.setActive(true);
            ai.setAccountType(AccountInfo.AccountType.valueOf((String)apiItem.getAccountType().name()));
            serverItem.setAccountInfo(ai);
        }
        com.sas.lsaf.svcs.security.user.client.PasswordInfo pi = new com.sas.lsaf.svcs.security.user.client.PasswordInfo(apiItem.getPassword());
        serverItem.setPasswordInfo(pi);
        return serverItem;
    }
}

