/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.user.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.security.user.InternalUserService;
import com.sas.lsaf.security.user.User;
import com.sas.lsaf.security.user.UserNotFoundException;
import com.sas.lsaf.security.user.impl.UserHelper;
import com.sas.lsaf.svcs.security.user.client.UserService;
import com.sas.lsaf.svcs.security.user.client.exception.UserPasswordException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class InternalUserServiceImpl
implements InternalUserService {
    private UserService userService;

    @Required
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    @Transactional
    public User updateUserForSingleSignOn(String userId, String singleSignOnId) throws UserNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.hasText((String)singleSignOnId, (String)"Single sign-on id is required for signle sign-on authenticator.");
        try {
            com.sas.lsaf.svcs.security.user.client.User user = this.userService.getUserByUserId(userId);
            if (!user.getAccountInfo().getAuthenticator().equals("saml")) {
                user = this.userService.setExternalAuthenticatorByUserId(userId, "saml", null);
            }
            if (!user.getAccountInfo().getSamlId().equals(singleSignOnId)) {
                user.getAccountInfo().setSamlId(singleSignOnId);
                user = this.userService.updateUser(user);
            }
            return UserHelper.toApiUser(user);
        }
        catch (com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException e) {
            throw new UserNotFoundException(e.getLocalizedMessage());
        }
        catch (UserPasswordException e) {
            throw new ValidationException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

