/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.role.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.principal.impl.PrincipalHelper;
import com.sas.lsaf.security.privilege.PrivilegeNotFoundException;
import com.sas.lsaf.security.privilege.impl.PrivilegeHelper;
import com.sas.lsaf.security.role.InvalidRoleMemberException;
import com.sas.lsaf.security.role.Role;
import com.sas.lsaf.security.role.RoleContextNotFoundException;
import com.sas.lsaf.security.role.RoleDescriptor;
import com.sas.lsaf.security.role.RoleExistsException;
import com.sas.lsaf.security.role.RoleNotFoundException;
import com.sas.lsaf.security.role.RoleService;
import com.sas.lsaf.security.role.RoleUpdateException;
import com.sas.lsaf.security.role.impl.RoleHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryContext;
import com.sas.lsaf.svcs.content.repository.client.RepositoryService;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.core.utils.client.CollectionDiff;
import com.sas.lsaf.svcs.core.utils.client.EqualsUtils;
import com.sas.lsaf.svcs.security.authorization.client.AuthorizationService;
import com.sas.lsaf.svcs.security.authorization.client.Securable;
import com.sas.lsaf.svcs.security.privilege.client.Privilege;
import com.sas.lsaf.svcs.security.role.client.RoleAssignment;
import com.sas.lsaf.svcs.security.role.client.RoleAssignmentDescriptor;
import com.sas.lsaf.svcs.security.role.client.RoleAssignmentService;
import com.sas.lsaf.svcs.security.role.client.RoleDefinitionService;
import com.sas.lsaf.svcs.security.role.client.exceptions.InvalidRoleAssignmentException;
import com.sas.lsaf.svcs.security.role.client.exceptions.InvalidRolePrivilegeAssignmentException;
import com.sas.lsaf.svcs.security.role.client.exceptions.RoleAssignmentExistsException;
import com.sas.lsaf.svcs.security.role.client.exceptions.RoleAssignmentNotFoundException;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class RoleServiceImpl
implements RoleService {
    private RoleAssignmentService roleAssignmentService;
    private RoleDefinitionService roleDefinitionService;
    private RepositoryService repositoryService;
    private AuthorizationService authorizationService;

    private RepositoryContext doLookupContext(String id) {
        try {
            return this.repositoryService.getContextById(id);
        }
        catch (RepositoryItemNotFoundException e) {
            throw new RoleContextNotFoundException("Role context does not exist.");
        }
    }

    private RoleExistsException doHandleRoleExistsException(com.sas.lsaf.svcs.security.role.client.exceptions.RoleExistsException e) {
        return new RoleExistsException(e.getLocalizedMessage());
    }

    private PrivilegeNotFoundException doHandleInvalidRolePrivilegeAssignmentException(InvalidRolePrivilegeAssignmentException e) {
        return new PrivilegeNotFoundException(e.getLocalizedMessage());
    }

    private RoleExistsException doHandleRoleAssignmentExistsException(RoleAssignmentExistsException e) {
        return new RoleExistsException(e.getLocalizedMessage());
    }

    private RoleNotFoundException doHandleRoleAssignmentNotFoundException(RoleAssignmentNotFoundException e) {
        return new RoleNotFoundException(e.getLocalizedMessage());
    }

    private RoleNotFoundException doHandleRoleNotFoundException(com.sas.lsaf.svcs.security.role.client.exceptions.RoleNotFoundException e) {
        return new RoleNotFoundException(e.getLocalizedMessage());
    }

    private RoleNotFoundException doHandleInvalidRoleAssignmentException(InvalidRoleAssignmentException e) {
        return new RoleNotFoundException(e.getLocalizedMessage());
    }

    private InvalidRoleMemberException doHandleInvalidRoleMemberException(com.sas.lsaf.svcs.security.role.client.exceptions.InvalidRoleMemberException e) {
        return new InvalidRoleMemberException(PrincipalHelper.toApiPrincipals(e.getInvalidMembers()), e.getLocalizedMessage());
    }

    @Required
    public void setRoleAssignmentService(RoleAssignmentService roleAssignmentService) {
        this.roleAssignmentService = roleAssignmentService;
    }

    @Required
    public void setRoleDefinitionService(RoleDefinitionService roleDefinitionService) {
        this.roleDefinitionService = roleDefinitionService;
    }

    @Required
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Required
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Transactional(rollbackFor={InvalidRolePrivilegeAssignmentException.class, PrivilegeNotFoundException.class})
    public Role createRole(String contextId, String name, String description, Set<String> scopedPrivilegeIds, Set<Principal> members) throws RoleExistsException, PrivilegeNotFoundException, InvalidRoleMemberException {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.hasText((String)name, (String)"Role name is required.");
        try {
            com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.createRole(contextId, name, description, scopedPrivilegeIds);
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignment(contextId, serverRole.getId());
            if (members != null && !members.isEmpty()) {
                serverRoleAssignment.addMembers(PrincipalHelper.toServerPrincipals(members));
                this.roleAssignmentService.updateRoleAssignment(serverRoleAssignment);
            }
            return RoleHelper.toApiRole(serverRole, serverRoleAssignment);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleExistsException e) {
            throw this.doHandleRoleExistsException(e);
        }
        catch (InvalidRolePrivilegeAssignmentException e) {
            throw this.doHandleInvalidRolePrivilegeAssignmentException(e);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.InvalidRoleMemberException e) {
            throw this.doHandleInvalidRoleMemberException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Role addInheritedRole(String contextId, String inheritedRoleId, Set<Principal> members) throws RoleExistsException, RoleNotFoundException, InvalidRoleMemberException {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.hasText((String)inheritedRoleId, (String)"Inherited role identifier is required.");
        try {
            this.doLookupContext(contextId);
            RoleAssignment parentServerRoleAssignment = this.roleAssignmentService.getRoleAssignmentById(inheritedRoleId);
            com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(parentServerRoleAssignment.getRoleDescriptor().getId());
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.createRoleAssignment(contextId, serverRole.getId(), PrincipalHelper.toServerPrincipals(members));
            return RoleHelper.toApiRole(serverRole, serverRoleAssignment);
        }
        catch (RoleAssignmentExistsException e) {
            throw this.doHandleRoleAssignmentExistsException(e);
        }
        catch (RoleAssignmentNotFoundException e) {
            throw this.doHandleRoleAssignmentNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleNotFoundException e) {
            throw this.doHandleRoleNotFoundException(e);
        }
        catch (InvalidRoleAssignmentException e) {
            throw this.doHandleInvalidRoleAssignmentException(e);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.InvalidRoleMemberException e) {
            throw this.doHandleInvalidRoleMemberException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional
    public Role updateRole(Role role) throws RoleNotFoundException, RoleExistsException, RoleUpdateException, PrivilegeNotFoundException, InvalidRoleMemberException {
        Assert.notNull((Object)role, (String)"Role is required.");
        try {
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignmentById(role.getId());
            com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(serverRoleAssignment.getRoleDescriptor().getId());
            CollectionDiff privilegeDiff = new CollectionDiff(PrivilegeHelper.toServerPrivilegeIds(serverRole.getPrivileges()), PrivilegeHelper.toApiPrivilegeIds(role.getPrivileges()));
            if (privilegeDiff.hasChanges() || EqualsUtils.notEquals((Object)serverRole.getName(), (Object)role.getName()) || EqualsUtils.notEquals((Object)serverRole.getDescription(), (Object)role.getDescription())) {
                if (serverRoleAssignment.isAssigned()) {
                    throw new RoleUpdateException("Role name, description and privileges cannot be updated on an inherited role.");
                }
                serverRole = this.roleDefinitionService.updateRole(RoleHelper.toServerRole(serverRole, role));
            }
            serverRoleAssignment = this.roleAssignmentService.updateRoleAssignment(RoleHelper.toServerRoleAssignment(serverRole, role));
            return RoleHelper.toApiRole(serverRole, serverRoleAssignment);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleNotFoundException e) {
            throw this.doHandleRoleNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleExistsException e) {
            throw this.doHandleRoleExistsException(e);
        }
        catch (InvalidRolePrivilegeAssignmentException e) {
            throw this.doHandleInvalidRolePrivilegeAssignmentException(e);
        }
        catch (RoleAssignmentNotFoundException e) {
            throw this.doHandleRoleAssignmentNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.InvalidRoleMemberException e) {
            throw this.doHandleInvalidRoleMemberException(e);
        }
        catch (PrivilegeNotFoundException | RoleUpdateException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void deleteRole(String roleId) throws RoleNotFoundException {
        Assert.hasText((String)roleId, (String)"Role identifier is required.");
        try {
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignmentById(roleId);
            if (serverRoleAssignment.isAssigned()) {
                this.roleAssignmentService.deleteRoleAssignment(serverRoleAssignment.getId());
            } else {
                this.roleDefinitionService.deleteRole(serverRoleAssignment.getRoleDescriptor().getId());
            }
        }
        catch (RoleAssignmentNotFoundException e) {
            throw this.doHandleRoleAssignmentNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleNotFoundException e) {
            throw this.doHandleRoleNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean roleExists(String contextId, String name) {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.hasText((String)name, (String)"Role name is required.");
        try {
            return this.roleDefinitionService.roleExists(contextId, name);
        }
        catch (RoleContextNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean inheritedRoleExists(String contextId, String roleId) {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.hasText((String)roleId, (String)"Role identifier is required.");
        try {
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignmentById(roleId);
            if (contextId.equals(serverRoleAssignment.getRoleDescriptor().getId())) {
                return false;
            }
            serverRoleAssignment = this.roleAssignmentService.getRoleAssignment(contextId, serverRoleAssignment.getRoleDescriptor().getId());
            return serverRoleAssignment.isAssigned();
        }
        catch (RoleAssignmentNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Role getRoleByName(String contextId, String name) throws RoleNotFoundException {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.hasText((String)name, (String)"Role name is required.");
        try {
            com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleByName(contextId, name);
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignment(serverRole.getContext().getId(), serverRole.getId());
            return RoleHelper.toApiRole(serverRole, serverRoleAssignment);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleNotFoundException e) {
            throw this.doHandleRoleNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RoleDescriptor getRoleDescriptorByName(String contextId, String name) throws RoleNotFoundException {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.hasText((String)name, (String)"Role name is required.");
        try {
            com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleByName(contextId, name);
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignment(serverRole.getContext().getId(), serverRole.getId());
            return RoleHelper.toApiRoleDescriptor(serverRole, (RoleAssignmentDescriptor)serverRoleAssignment);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleNotFoundException e) {
            throw this.doHandleRoleNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Role getRoleById(String roleId) throws RoleNotFoundException {
        Assert.hasText((String)roleId, (String)"Role identifier is required.");
        try {
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignmentById(roleId);
            com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(serverRoleAssignment.getRoleDescriptor().getId());
            return RoleHelper.toApiRole(serverRole, serverRoleAssignment);
        }
        catch (RoleAssignmentNotFoundException e) {
            throw this.doHandleRoleAssignmentNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleNotFoundException e) {
            throw this.doHandleRoleNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RoleDescriptor getRoleDescriptorById(String roleId) throws RoleNotFoundException {
        Assert.hasText((String)roleId, (String)"Role identifier is required.");
        try {
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignmentById(roleId);
            com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(serverRoleAssignment.getRoleDescriptor().getId());
            return RoleHelper.toApiRoleDescriptor(serverRole, (RoleAssignmentDescriptor)serverRoleAssignment);
        }
        catch (RoleAssignmentNotFoundException e) {
            throw this.doHandleRoleAssignmentNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleNotFoundException e) {
            throw this.doHandleRoleNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Role> getRolesByContext(String contextId) {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        try {
            Set serverRoleAssignments = this.roleAssignmentService.getRoleAssignments(contextId);
            HashSet<Role> roles = new HashSet<Role>(serverRoleAssignments.size());
            for (RoleAssignment serverRoleAssignment : serverRoleAssignments) {
                com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(serverRoleAssignment.getRoleDescriptor().getId());
                roles.add(RoleHelper.toApiRole(serverRole, serverRoleAssignment));
            }
            return roles;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<RoleDescriptor> getRoleDescriptorsByContext(String contextId) {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        try {
            Set serverRoleAssignmentDescriptors = this.roleAssignmentService.getRoleAssignmentDescriptors(contextId);
            HashSet<RoleDescriptor> roles = new HashSet<RoleDescriptor>(serverRoleAssignmentDescriptors.size());
            for (RoleAssignmentDescriptor serverRoleAssignmentDescriptor : serverRoleAssignmentDescriptors) {
                com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(serverRoleAssignmentDescriptor.getRoleDescriptor().getId());
                roles.add(RoleHelper.toApiRoleDescriptor(serverRole, serverRoleAssignmentDescriptor));
            }
            return roles;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Role> getRolesByIds(Set<String> roleIds) {
        Assert.notEmpty(roleIds, (String)"Role identifiers are required.");
        try {
            HashSet<Role> roles = new HashSet<Role>(roleIds.size());
            for (String roleId : roleIds) {
                try {
                    RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignmentById(roleId);
                    com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(serverRoleAssignment.getRoleDescriptor().getId());
                    roles.add(RoleHelper.toApiRole(serverRole, serverRoleAssignment));
                }
                catch (RoleAssignmentNotFoundException roleAssignmentNotFoundException) {}
            }
            return roles;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<RoleDescriptor> getRoleDescriptorsByContextAndPrivilege(String contextId, String scopedPrivilegeId) throws PrivilegeNotFoundException {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.hasText((String)scopedPrivilegeId, (String)"Scoped privilege identifier is required.");
        try {
            Privilege serverPrivilege = PrivilegeHelper.toServerScopedPrivilege(scopedPrivilegeId);
            Set serverRoleAssignments = this.roleAssignmentService.getRoleAssignments(contextId);
            HashSet<RoleDescriptor> roleDescriptors = new HashSet<RoleDescriptor>();
            for (RoleAssignment serverRoleAssignment : serverRoleAssignments) {
                com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(serverRoleAssignment.getRoleDescriptor().getId());
                if (!serverRole.getPrivileges().contains(serverPrivilege)) continue;
                roleDescriptors.add(RoleHelper.toApiRoleDescriptor(serverRole, (RoleAssignmentDescriptor)serverRoleAssignment));
            }
            return roleDescriptors;
        }
        catch (PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void removePrincipalFromRoles(String contextId, Principal member) {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.notNull((Object)member, (String)"Principal is required.");
        try {
            this.roleAssignmentService.removeMemberByContext(contextId, PrincipalHelper.toServerPrincipal(member));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void removePrincipalsFromRoles(String contextId, Set<Principal> members) {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.notEmpty(members, (String)"Principals are required.");
        try {
            this.roleAssignmentService.removeMembersByContext(contextId, PrincipalHelper.toServerPrincipals(members));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean isPrincipalInRole(String roleId, Principal principal) {
        Assert.hasText((String)roleId, (String)"Role identifier is required.");
        Assert.notNull((Object)principal, (String)"Principal is required.");
        try {
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignmentById(roleId);
            return serverRoleAssignment.getMembers().contains(PrincipalHelper.toServerPrincipal(principal));
        }
        catch (RoleContextNotFoundException | RoleAssignmentNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<RoleDescriptor> getInheritedRoleDescriptorsByRole(String roleId) throws RoleNotFoundException {
        Assert.hasText((String)roleId, (String)"Role identifier is required.");
        try {
            RoleAssignment serverRoleAssignment = this.roleAssignmentService.getRoleAssignmentById(roleId);
            com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(serverRoleAssignment.getRoleDescriptor().getId());
            Set serverRoleAssignmentDescriptors = this.roleAssignmentService.getRoleAssignmentDescriptorsByRole(serverRole.getId());
            HashSet<RoleDescriptor> roleDescriptors = new HashSet<RoleDescriptor>(serverRoleAssignmentDescriptors.size());
            for (RoleAssignmentDescriptor serverRoleAssignmentDescriptor : serverRoleAssignmentDescriptors) {
                if (!serverRoleAssignmentDescriptor.isAssigned()) continue;
                roleDescriptors.add(RoleHelper.toApiRoleDescriptor(serverRole, serverRoleAssignmentDescriptor));
            }
            return roleDescriptors;
        }
        catch (com.sas.lsaf.svcs.security.role.client.exceptions.RoleNotFoundException e) {
            throw this.doHandleRoleNotFoundException(e);
        }
        catch (RoleAssignmentNotFoundException e) {
            throw this.doHandleRoleAssignmentNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<RoleDescriptor> getRoleDescriptorsByContextAndPrincipal(String contextId, Principal member) {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.notNull((Object)member, (String)"Principal is required.");
        try {
            Set serverRoleAssignmentDescriptors = this.roleAssignmentService.getRoleAssignmentDescriptorsByContextAndMember(contextId, PrincipalHelper.toServerPrincipal(member));
            HashSet<RoleDescriptor> roles = new HashSet<RoleDescriptor>(serverRoleAssignmentDescriptors.size());
            for (RoleAssignmentDescriptor serverRoleAssignmentDescriptor : serverRoleAssignmentDescriptors) {
                com.sas.lsaf.svcs.security.role.client.Role serverRole = this.roleDefinitionService.getRoleById(serverRoleAssignmentDescriptor.getRoleDescriptor().getId());
                roles.add(RoleHelper.toApiRoleDescriptor(serverRole, serverRoleAssignmentDescriptor));
            }
            return roles;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean hasPrivilege(String contextId, String scopedPrivilegeId, Principal member) {
        Assert.hasText((String)contextId, (String)"Role context identifier is required.");
        Assert.hasText((String)scopedPrivilegeId, (String)"Scoped privilege identifier is required.");
        Assert.notNull((Object)member, (String)"Principal is required.");
        try {
            return this.authorizationService.principalHasPrivilege((Securable)this.doLookupContext(contextId), PrincipalHelper.toServerPrincipal(member), PrivilegeHelper.toServerScopedPrivilege(scopedPrivilegeId));
        }
        catch (PrivilegeNotFoundException | RoleContextNotFoundException | IllegalArgumentException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

