/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.privilege.impl;

import com.sas.lsaf.security.privilege.GlobalPrivilege;
import com.sas.lsaf.security.privilege.GlobalPrivileges;
import com.sas.lsaf.security.privilege.Privilege;
import com.sas.lsaf.security.privilege.PrivilegeNotFoundException;
import com.sas.lsaf.security.privilege.ScopedPrivilege;
import com.sas.lsaf.security.privilege.ScopedPrivileges;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class PrivilegeHelper {
    private static com.sas.lsaf.svcs.security.privilege.client.Privilege toServerPrivilege(Privilege apiItem) {
        return new com.sas.lsaf.svcs.security.privilege.client.Privilege(apiItem.getId(), apiItem.getName(), null);
    }

    public static GlobalPrivilege toApiGlobalPrivilege(com.sas.lsaf.svcs.security.privilege.client.Privilege serverItem) {
        return new GlobalPrivilege(serverItem.getId(), serverItem.getName());
    }

    public static Set<GlobalPrivilege> toApiGlobalPrivileges(Collection<com.sas.lsaf.svcs.security.privilege.client.Privilege> serverItems) {
        HashSet<GlobalPrivilege> apiItems = new HashSet<GlobalPrivilege>();
        for (com.sas.lsaf.svcs.security.privilege.client.Privilege serverItem : serverItems) {
            apiItems.add(PrivilegeHelper.toApiGlobalPrivilege(serverItem));
        }
        return apiItems;
    }

    public static ScopedPrivilege toApiScopedPrivilege(com.sas.lsaf.svcs.security.privilege.client.Privilege serverItem) {
        return new ScopedPrivilege(serverItem.getId(), serverItem.getName());
    }

    public static Set<ScopedPrivilege> toApiScopedPrivileges(Collection<com.sas.lsaf.svcs.security.privilege.client.Privilege> serverItems) {
        HashSet<ScopedPrivilege> apiItems = new HashSet<ScopedPrivilege>();
        for (com.sas.lsaf.svcs.security.privilege.client.Privilege serverItem : serverItems) {
            apiItems.add(PrivilegeHelper.toApiScopedPrivilege(serverItem));
        }
        return apiItems;
    }

    public static com.sas.lsaf.svcs.security.privilege.client.Privilege toServerScopedPrivilege(String apiItem) throws PrivilegeNotFoundException {
        for (ScopedPrivilege scopedPrivilege : ScopedPrivileges.ALL_SCOPED_PRIVILEGES) {
            if (!scopedPrivilege.getId().equals(apiItem)) continue;
            return PrivilegeHelper.toServerPrivilege((Privilege)scopedPrivilege);
        }
        throw new PrivilegeNotFoundException("Invalid scoped privilege specified: " + apiItem);
    }

    public static Set<com.sas.lsaf.svcs.security.privilege.client.Privilege> toServerScopedPrivileges(Collection<String> apiItems) throws PrivilegeNotFoundException {
        HashSet<com.sas.lsaf.svcs.security.privilege.client.Privilege> serverItems = new HashSet<com.sas.lsaf.svcs.security.privilege.client.Privilege>();
        if (apiItems != null) {
            for (String apiItem : apiItems) {
                serverItems.add(PrivilegeHelper.toServerScopedPrivilege(apiItem));
            }
        }
        return serverItems;
    }

    public static com.sas.lsaf.svcs.security.privilege.client.Privilege toServerGlobalPrivilege(String apiItem) throws PrivilegeNotFoundException {
        for (GlobalPrivilege globalPrivilege : GlobalPrivileges.ALL_GLOBAL_PRIVILEGES) {
            if (!globalPrivilege.getId().equals(apiItem)) continue;
            return PrivilegeHelper.toServerPrivilege((Privilege)globalPrivilege);
        }
        throw new PrivilegeNotFoundException("Invalid global privilege specified: " + apiItem);
    }

    public static Set<com.sas.lsaf.svcs.security.privilege.client.Privilege> toServerGlobalPrivileges(Collection<String> apiItems) throws PrivilegeNotFoundException {
        HashSet<com.sas.lsaf.svcs.security.privilege.client.Privilege> serverItems = new HashSet<com.sas.lsaf.svcs.security.privilege.client.Privilege>();
        if (apiItems != null) {
            for (String apiItem : apiItems) {
                serverItems.add(PrivilegeHelper.toServerGlobalPrivilege(apiItem));
            }
        }
        return serverItems;
    }

    public static Set<String> toServerPrivilegeIds(Set<com.sas.lsaf.svcs.security.privilege.client.Privilege> serverItems) {
        HashSet<String> ids = new HashSet<String>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.security.privilege.client.Privilege serverItem : serverItems) {
                ids.add(serverItem.getId());
            }
        }
        return ids;
    }

    public static Set<String> toApiPrivilegeIds(Set<ScopedPrivilege> apiItems) {
        HashSet<String> ids = new HashSet<String>();
        if (apiItems != null) {
            for (ScopedPrivilege apiItem : apiItems) {
                ids.add(apiItem == null ? null : apiItem.getId());
            }
        }
        return ids;
    }
}

