/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.privilege.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.security.principal.PrincipalNotFoundException;
import com.sas.lsaf.security.principal.impl.PrincipalHelper;
import com.sas.lsaf.security.privilege.GlobalPrivilege;
import com.sas.lsaf.security.privilege.GlobalPrivilegeService;
import com.sas.lsaf.security.privilege.PrivilegeNotFoundException;
import com.sas.lsaf.security.privilege.impl.PrivilegeHelper;
import com.sas.lsaf.security.user.UserDescriptor;
import com.sas.lsaf.svcs.content.tenant.client.Tenant;
import com.sas.lsaf.svcs.content.tenant.client.TenantService;
import com.sas.lsaf.svcs.core.common.client.Context;
import com.sas.lsaf.svcs.security.principal.client.Principal;
import com.sas.lsaf.svcs.security.privilege.client.Privilege;
import com.sas.lsaf.svcs.security.privilege.client.PrivilegeService;
import com.sas.lsaf.svcs.security.user.client.UserService;
import com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class GlobalPrivilegeServiceImpl
implements GlobalPrivilegeService,
InitializingBean {
    private final Map<String, GlobalPrivilege> apiPrivileges = new HashMap<String, GlobalPrivilege>();
    private final Map<String, Privilege> serverPrivileges = new HashMap<String, Privilege>();
    private PrivilegeService privilegeService;
    private UserService userService;
    private TenantService tenantService;
    private Tenant currentTenant;

    private Privilege toServerPrivilege(String globalPrivilegeId) throws PrivilegeNotFoundException {
        Privilege serverItem = this.serverPrivileges.get(globalPrivilegeId);
        if (serverItem == null) {
            throw new PrivilegeNotFoundException("Global privilege does not exist: " + globalPrivilegeId);
        }
        return serverItem;
    }

    private Set<Privilege> toServerPrivileges(Set<String> globalPrivilegeIds) throws PrivilegeNotFoundException {
        HashSet<Privilege> serverItems = new HashSet<Privilege>(globalPrivilegeIds.size());
        for (String globalPrivilegeId : globalPrivilegeIds) {
            serverItems.add(this.toServerPrivilege(globalPrivilegeId));
        }
        return serverItems;
    }

    private com.sas.lsaf.svcs.security.user.client.UserDescriptor toServerUserDescriptor(String userId) throws PrincipalNotFoundException {
        try {
            return this.userService.getUserDescriptorByUserId(userId);
        }
        catch (UserNotFoundException e) {
            throw new PrincipalNotFoundException(e.getLocalizedMessage());
        }
    }

    private Set<com.sas.lsaf.svcs.security.user.client.UserDescriptor> toServerUserDescriptors(Set<String> userIds) throws PrincipalNotFoundException {
        HashSet<com.sas.lsaf.svcs.security.user.client.UserDescriptor> serverItems = new HashSet<com.sas.lsaf.svcs.security.user.client.UserDescriptor>(userIds.size());
        for (String userId : userIds) {
            serverItems.add(this.toServerUserDescriptor(userId));
        }
        return serverItems;
    }

    @Required
    public void setPrivilegeService(PrivilegeService privilegeService) {
        this.privilegeService = privilegeService;
    }

    @Required
    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Required
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void afterPropertiesSet() throws Exception {
        this.currentTenant = this.tenantService.getCurrentTenant();
        try {
            Set serverItems = this.privilegeService.getAvailablePrivileges((Context)this.currentTenant);
            for (Privilege serverItem : serverItems) {
                this.serverPrivileges.put(serverItem.getId(), serverItem);
                this.apiPrivileges.put(serverItem.getId(), PrivilegeHelper.toApiGlobalPrivilege(serverItem));
            }
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void grantPrivilege(String userId, String globalPrivilegeId) throws PrincipalNotFoundException, PrivilegeNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.hasText((String)globalPrivilegeId, (String)"Global privilege identifier is required.");
        try {
            com.sas.lsaf.svcs.security.user.client.UserDescriptor serverUser = this.toServerUserDescriptor(userId);
            Privilege serverPrivilege = this.toServerPrivilege(globalPrivilegeId);
            this.privilegeService.grantPrivilege((Context)this.currentTenant, (Principal)serverUser, serverPrivilege);
        }
        catch (PrincipalNotFoundException | PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void grantPrivileges(String userId, Set<String> globalPrivilegeIds) throws PrincipalNotFoundException, PrivilegeNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.notEmpty(globalPrivilegeIds, (String)"Global privilege identifiers are required.");
        try {
            com.sas.lsaf.svcs.security.user.client.UserDescriptor serverUser = this.toServerUserDescriptor(userId);
            Set<Privilege> serverPrivileges = this.toServerPrivileges(globalPrivilegeIds);
            this.privilegeService.grantPrivileges((Context)this.currentTenant, (Principal)serverUser, serverPrivileges);
        }
        catch (PrincipalNotFoundException | PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void grantPrivilegesToUsers(Set<String> userIds, Set<String> globalPrivilegeIds) throws PrincipalNotFoundException, PrivilegeNotFoundException {
        Assert.notEmpty(userIds, (String)"User IDs are required.");
        Assert.notEmpty(globalPrivilegeIds, (String)"Global privilege identifiers are required.");
        try {
            Set<com.sas.lsaf.svcs.security.user.client.UserDescriptor> serverUsers = this.toServerUserDescriptors(userIds);
            Set<Privilege> serverPrivileges = this.toServerPrivileges(globalPrivilegeIds);
            this.privilegeService.grantPrivilegesToPrincipals((Context)this.currentTenant, serverUsers, serverPrivileges);
        }
        catch (PrincipalNotFoundException | PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void revokePrivilege(String userId, String globalPrivilegeId) throws PrincipalNotFoundException, PrivilegeNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.hasText((String)globalPrivilegeId, (String)"Global privilege identifier is required.");
        try {
            com.sas.lsaf.svcs.security.user.client.UserDescriptor serverUser = this.toServerUserDescriptor(userId);
            Privilege serverPrivilege = this.toServerPrivilege(globalPrivilegeId);
            this.privilegeService.revokePrivilege((Context)this.currentTenant, (Principal)serverUser, serverPrivilege);
        }
        catch (PrincipalNotFoundException | PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void revokePrivileges(String userId, Set<String> globalPrivilegeIds) throws PrincipalNotFoundException, PrivilegeNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.notEmpty(globalPrivilegeIds, (String)"Global privilege identifiers are required.");
        try {
            com.sas.lsaf.svcs.security.user.client.UserDescriptor serverUser = this.toServerUserDescriptor(userId);
            Set<Privilege> serverPrivileges = this.toServerPrivileges(globalPrivilegeIds);
            this.privilegeService.revokePrivileges((Context)this.currentTenant, (Principal)serverUser, serverPrivileges);
        }
        catch (PrincipalNotFoundException | PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void revokePrivilegesFromUsers(Set<String> userIds, Set<String> globalPrivilegeIds) throws PrincipalNotFoundException, PrivilegeNotFoundException {
        Assert.notEmpty(userIds, (String)"User IDs are required.");
        Assert.notEmpty(globalPrivilegeIds, (String)"Global privilege identifiers are required.");
        try {
            Set<com.sas.lsaf.svcs.security.user.client.UserDescriptor> serverUsers = this.toServerUserDescriptors(userIds);
            Set<Privilege> serverPrivileges = this.toServerPrivileges(globalPrivilegeIds);
            this.privilegeService.revokePrivilegesFromPrincipals((Context)this.currentTenant, serverUsers, serverPrivileges);
        }
        catch (PrincipalNotFoundException | PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void revokeAllPrivileges(String userId) throws PrincipalNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            com.sas.lsaf.svcs.security.user.client.UserDescriptor serverUser = this.toServerUserDescriptor(userId);
            this.privilegeService.revokeAllPrivileges((Context)this.currentTenant, (Principal)serverUser);
        }
        catch (PrincipalNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void setPrivileges(String userId, Set<String> globalPrivilegeIds) throws PrincipalNotFoundException, PrivilegeNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.notEmpty(globalPrivilegeIds, (String)"Global privilege identifiers are required.");
        try {
            com.sas.lsaf.svcs.security.user.client.UserDescriptor serverUser = this.toServerUserDescriptor(userId);
            Set<Privilege> serverPrivileges = this.toServerPrivileges(globalPrivilegeIds);
            this.privilegeService.setPrivileges((Context)this.currentTenant, (Principal)serverUser, serverPrivileges);
        }
        catch (PrincipalNotFoundException | PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<GlobalPrivilege> getGrantedPrivileges(String userId) throws PrincipalNotFoundException {
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            return PrivilegeHelper.toApiGlobalPrivileges(this.privilegeService.getGrantedPrivileges((Context)this.currentTenant, (Principal)this.toServerUserDescriptor(userId)));
        }
        catch (PrincipalNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<UserDescriptor> getGrantees(String globalPrivilegeId) throws PrivilegeNotFoundException {
        Assert.hasText((String)globalPrivilegeId, (String)"Global privilege identifier is required.");
        try {
            return PrincipalHelper.toApiUserDescriptors(this.privilegeService.getGrantees((Context)this.currentTenant, this.toServerPrivilege(globalPrivilegeId)));
        }
        catch (PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<UserDescriptor> getAllGrantees(Set<String> globalPrivilegeIds) throws PrivilegeNotFoundException {
        Assert.notEmpty(globalPrivilegeIds, (String)"Global privilege identifiers are required.");
        try {
            return PrincipalHelper.toApiUserDescriptors(this.privilegeService.getAllGrantees((Context)this.currentTenant, this.toServerPrivileges(globalPrivilegeIds)));
        }
        catch (PrivilegeNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean hasPrivilege(String userId, String globalPrivilegeId) {
        Assert.hasText((String)userId, (String)"User ID is required.");
        Assert.hasText((String)globalPrivilegeId, (String)"Global privilege identifier is required.");
        try {
            return this.privilegeService.hasPrivilege((Context)this.currentTenant, (Principal)this.toServerUserDescriptor(userId), this.toServerPrivilege(globalPrivilegeId));
        }
        catch (PrincipalNotFoundException | PrivilegeNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<GlobalPrivilege> getAvailablePrivileges() {
        return new HashSet<GlobalPrivilege>(this.apiPrivileges.values());
    }
}

