/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.membership.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.security.membership.InvalidMemberException;
import com.sas.lsaf.security.membership.MemberExistsException;
import com.sas.lsaf.security.membership.MemberNotFoundException;
import com.sas.lsaf.security.membership.Membership;
import com.sas.lsaf.security.membership.MembershipContextNotFoundException;
import com.sas.lsaf.security.membership.MembershipDescriptor;
import com.sas.lsaf.security.membership.MembershipService;
import com.sas.lsaf.security.membership.impl.MembershipHelper;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.principal.impl.PrincipalHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryContext;
import com.sas.lsaf.svcs.content.repository.client.RepositoryService;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.core.common.client.Context;
import com.sas.lsaf.svcs.security.membership.client.exception.InvalidMemberRemovalException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class MembershipServiceImpl
implements MembershipService {
    private com.sas.lsaf.svcs.security.membership.client.MembershipService membershipService;
    private RepositoryService repositoryService;

    private MemberExistsException doHandleMemberExistsException(com.sas.lsaf.svcs.security.membership.client.exception.MemberExistsException e) {
        return new MemberExistsException(PrincipalHelper.toApiPrincipals(e.getExistingMembers()), e.getLocalizedMessage());
    }

    private InvalidMemberException doHandleInvalidMemberException(com.sas.lsaf.svcs.security.membership.client.exception.InvalidMemberException e) {
        return new InvalidMemberException(PrincipalHelper.toApiPrincipals(e.getInvalidMembers()), e.getLocalizedMessage());
    }

    private MemberNotFoundException doHandleMemberNotFoundException(com.sas.lsaf.svcs.security.membership.client.exception.MemberNotFoundException e) {
        return new MemberNotFoundException(PrincipalHelper.toApiPrincipals(e.getNonMembers()), e.getLocalizedMessage());
    }

    private RepositoryContext doLookupContext(String id) {
        try {
            return this.repositoryService.getContextById(id);
        }
        catch (RepositoryItemNotFoundException e) {
            throw new MembershipContextNotFoundException("Membership context does not exist.");
        }
    }

    private RepositoryContext doLookupContextByPath(String path) {
        try {
            return this.repositoryService.getContextByPath(path);
        }
        catch (RepositoryItemNotFoundException e) {
            throw new MembershipContextNotFoundException("Membership context does not exist.");
        }
    }

    @Required
    public void setMembershipService(com.sas.lsaf.svcs.security.membership.client.MembershipService membershipService) {
        this.membershipService = membershipService;
    }

    @Required
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void addMember(String contextId, Principal member) throws MemberExistsException, InvalidMemberException {
        Assert.hasText((String)contextId, (String)"Membership context identifier is required.");
        Assert.notNull((Object)member, (String)"Member is required.");
        try {
            this.membershipService.addMember((Context)this.doLookupContext(contextId), PrincipalHelper.toServerPrincipal(member));
        }
        catch (com.sas.lsaf.svcs.security.membership.client.exception.MemberExistsException e) {
            throw this.doHandleMemberExistsException(e);
        }
        catch (com.sas.lsaf.svcs.security.membership.client.exception.InvalidMemberException e) {
            throw this.doHandleInvalidMemberException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void addMembers(String contextId, Set<Principal> members) throws MemberExistsException, InvalidMemberException {
        Assert.hasText((String)contextId, (String)"Membership context identifier is required.");
        Assert.notEmpty(members, (String)"Members are required.");
        try {
            this.membershipService.addMembers((Context)this.doLookupContext(contextId), PrincipalHelper.toServerPrincipals(members));
        }
        catch (com.sas.lsaf.svcs.security.membership.client.exception.MemberExistsException e) {
            throw this.doHandleMemberExistsException(e);
        }
        catch (com.sas.lsaf.svcs.security.membership.client.exception.InvalidMemberException e) {
            throw this.doHandleInvalidMemberException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void removeMember(String contextId, Principal member) throws MemberNotFoundException, InvalidMemberException {
        Assert.hasText((String)contextId, (String)"Membership context identifier is required.");
        Assert.notNull((Object)member, (String)"Member is required.");
        try {
            this.membershipService.removeMember((Context)this.doLookupContext(contextId), PrincipalHelper.toServerPrincipal(member));
        }
        catch (com.sas.lsaf.svcs.security.membership.client.exception.MemberNotFoundException e) {
            throw this.doHandleMemberNotFoundException(e);
        }
        catch (InvalidMemberRemovalException e) {
            throw this.doHandleInvalidMemberException((com.sas.lsaf.svcs.security.membership.client.exception.InvalidMemberException)((Object)e));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void removeMembers(String contextId, Set<Principal> members) throws MemberNotFoundException, InvalidMemberException {
        Assert.hasText((String)contextId, (String)"Membership context identifier is required.");
        Assert.notEmpty(members, (String)"Members are required.");
        try {
            this.membershipService.removeMembers((Context)this.doLookupContext(contextId), PrincipalHelper.toServerPrincipals(members));
        }
        catch (com.sas.lsaf.svcs.security.membership.client.exception.MemberNotFoundException e) {
            throw this.doHandleMemberNotFoundException(e);
        }
        catch (InvalidMemberRemovalException e) {
            throw this.doHandleInvalidMemberException((com.sas.lsaf.svcs.security.membership.client.exception.InvalidMemberException)((Object)e));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean isMember(String contextId, Principal member, boolean includeImplicit) {
        Assert.hasText((String)contextId, (String)"Membership context identifier is required.");
        Assert.notNull((Object)member, (String)"Member is required.");
        try {
            return this.membershipService.isMember((Context)this.doLookupContext(contextId), PrincipalHelper.toServerPrincipal(member), includeImplicit);
        }
        catch (MembershipContextNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Membership getMembership(String contextId) {
        Assert.hasText((String)contextId, (String)"Membership context identifier is required.");
        try {
            return MembershipHelper.toApiMembership(this.membershipService.getMembership((Context)this.doLookupContext(contextId)));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Membership getMembershipByPath(String path) {
        Assert.hasText((String)path, (String)"Membership context path is required.");
        try {
            return MembershipHelper.toApiMembership(this.membershipService.getMembership((Context)this.doLookupContextByPath(path)));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Membership updateMembership(Membership membership) throws InvalidMemberException {
        Assert.notNull((Object)membership, (String)"Membership is required.");
        try {
            return MembershipHelper.toApiMembership(this.membershipService.updateMembership(MembershipHelper.toServerMembership(membership)));
        }
        catch (com.sas.lsaf.svcs.security.membership.client.exception.InvalidMemberException e) {
            throw this.doHandleInvalidMemberException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Principal> getPotentialMembers(String contextId, boolean checkParentsIfRequired) {
        Assert.hasText((String)contextId, (String)"Membership context identifier is required.");
        try {
            return PrincipalHelper.toApiPrincipals(this.membershipService.getPotentialMembers((Context)this.doLookupContext(contextId), checkParentsIfRequired));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Principal> getAssignedMembers(String contextId) {
        Assert.hasText((String)contextId, (String)"Membership context identifier is required.");
        try {
            return PrincipalHelper.toApiPrincipals(this.membershipService.getAssignedMembers((Context)this.doLookupContext(contextId)));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<MembershipDescriptor> getMemberships(Principal member) {
        Assert.notNull((Object)member, (String)"Member is required.");
        try {
            return MembershipHelper.toApiMembershipDescriptors(this.membershipService.getMembershipsByMember(PrincipalHelper.toServerPrincipal(member)));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

