/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.group.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.security.group.Group;
import com.sas.lsaf.security.group.GroupContextNotFoundException;
import com.sas.lsaf.security.group.GroupDescriptor;
import com.sas.lsaf.security.group.GroupExistsException;
import com.sas.lsaf.security.group.GroupNotFoundException;
import com.sas.lsaf.security.group.GroupService;
import com.sas.lsaf.security.group.InvalidGroupMemberException;
import com.sas.lsaf.security.group.impl.GroupHelper;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.principal.impl.PrincipalHelper;
import com.sas.lsaf.svcs.security.group.client.exception.GroupCycleDetectedException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class GroupServiceImpl
implements GroupService {
    private com.sas.lsaf.svcs.security.group.client.GroupService groupService;

    private GroupExistsException doHandleGroupExistsException(com.sas.lsaf.svcs.security.group.client.exception.GroupExistsException e) {
        return new GroupExistsException(e.getContext().getId(), e.getName(), e.getLocalizedMessage());
    }

    private InvalidGroupMemberException doHandleInvalidGroupMemberException(com.sas.lsaf.svcs.security.group.client.exception.InvalidGroupMemberException e) {
        return new InvalidGroupMemberException(PrincipalHelper.toApiPrincipals(e.getInvalidMembers()), e.getLocalizedMessage());
    }

    private InvalidGroupMemberException doHandleGroupCycleDetectedException(GroupCycleDetectedException e) {
        return new InvalidGroupMemberException(null, e.getLocalizedMessage());
    }

    private GroupNotFoundException doHandleGroupNotFoundException(com.sas.lsaf.svcs.security.group.client.exception.GroupNotFoundException e) {
        return new GroupNotFoundException(e.getLocalizedMessage());
    }

    @Required
    public void setGroupService(com.sas.lsaf.svcs.security.group.client.GroupService groupService) {
        this.groupService = groupService;
    }

    public Group createGroup(String contextId, String name, String description, Set<Principal> members) throws GroupExistsException, InvalidGroupMemberException {
        Assert.hasText((String)contextId, (String)"Group context identifier is required.");
        Assert.hasText((String)name, (String)"Group name is required.");
        try {
            return GroupHelper.toApiGroup(this.groupService.createGroup(contextId, name, description, PrincipalHelper.toServerPrincipals(members)));
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.GroupExistsException e) {
            throw this.doHandleGroupExistsException(e);
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.InvalidGroupMemberException e) {
            throw this.doHandleInvalidGroupMemberException(e);
        }
        catch (GroupCycleDetectedException e) {
            throw this.doHandleGroupCycleDetectedException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Group updateGroup(Group group) throws GroupNotFoundException, GroupExistsException, InvalidGroupMemberException {
        Assert.notNull((Object)group, (String)"Group is required.");
        try {
            return GroupHelper.toApiGroup(this.groupService.updateGroup(GroupHelper.toServerGroup(group)));
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.GroupNotFoundException e) {
            throw this.doHandleGroupNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.GroupExistsException e) {
            throw this.doHandleGroupExistsException(e);
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.InvalidGroupMemberException e) {
            throw this.doHandleInvalidGroupMemberException(e);
        }
        catch (GroupCycleDetectedException e) {
            throw this.doHandleGroupCycleDetectedException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void deleteGroup(String groupId) throws GroupNotFoundException {
        Assert.hasText((String)groupId, (String)"Group identifier is required.");
        try {
            this.groupService.deleteGroup(groupId);
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.GroupNotFoundException e) {
            throw this.doHandleGroupNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Group getGroupById(String groupId) throws GroupNotFoundException {
        Assert.hasText((String)groupId, (String)"Group identifier is required.");
        try {
            return GroupHelper.toApiGroup(this.groupService.getGroupById(groupId));
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.GroupNotFoundException e) {
            throw this.doHandleGroupNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Group getGroupByName(String contextId, String name) throws GroupNotFoundException {
        Assert.hasText((String)contextId, (String)"Group context identifier is required.");
        Assert.hasText((String)name, (String)"Group name is required.");
        try {
            return GroupHelper.toApiGroup(this.groupService.getGroupByName(contextId, name));
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.GroupNotFoundException e) {
            throw this.doHandleGroupNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public GroupDescriptor getGroupDescriptorById(String groupId) throws GroupNotFoundException {
        Assert.hasText((String)groupId, (String)"Group identifier is required.");
        try {
            return GroupHelper.toApiGroupDescriptor(this.groupService.getGroupDescriptorById(groupId));
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.GroupNotFoundException e) {
            throw this.doHandleGroupNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public GroupDescriptor getGroupDescriptorByName(String contextId, String name) throws GroupNotFoundException {
        Assert.hasText((String)contextId, (String)"Group context identifier is required.");
        Assert.hasText((String)name, (String)"Group name is required.");
        try {
            return GroupHelper.toApiGroupDescriptor(this.groupService.getGroupDescriptorByName(contextId, name));
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.GroupNotFoundException e) {
            throw this.doHandleGroupNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean isMember(String groupId, Principal member, boolean includeImplicit) {
        Assert.hasText((String)groupId, (String)"Group identifier is required.");
        Assert.notNull((Object)member, (String)"Principal is required.");
        try {
            return this.groupService.isMember(groupId, PrincipalHelper.toServerPrincipal(member), includeImplicit);
        }
        catch (com.sas.lsaf.svcs.security.group.client.exception.GroupNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean groupExists(String contextId, String name) {
        Assert.hasText((String)contextId, (String)"Group context identifier is required.");
        Assert.hasText((String)name, (String)"Group name is required.");
        try {
            return this.groupService.groupExists(contextId, name);
        }
        catch (GroupContextNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Group> getGroups(String contextId) {
        Assert.hasText((String)contextId, (String)"Group context identifier is required.");
        try {
            return GroupHelper.toApiGroups(this.groupService.getGroups(contextId));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<GroupDescriptor> getGroupDescriptors(String contextId) {
        Assert.hasText((String)contextId, (String)"Group context identifier is required.");
        try {
            return GroupHelper.toApiGroupDescriptors(this.groupService.getGroupDescriptors(contextId));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Group> getGroupsByIds(Set<String> groupIds) {
        Assert.notEmpty(groupIds, (String)"Group identifiers are required.");
        try {
            return GroupHelper.toApiGroups(this.groupService.getGroupsByIds(groupIds));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<GroupDescriptor> getGroupDescriptorsByIds(Set<String> groupIds) {
        Assert.notEmpty(groupIds, (String)"Group identifiers are required.");
        try {
            return GroupHelper.toApiGroupDescriptors(this.groupService.getGroupDescriptorsByIds(groupIds));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<GroupDescriptor> getAllGroupsByMember(Principal member) {
        Assert.notNull((Object)member, (String)"Principal is required.");
        try {
            return GroupHelper.toApiGroupDescriptors(this.groupService.getAllGroupDescriptorsByMember(PrincipalHelper.toServerPrincipal(member)));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<GroupDescriptor> getGroupsByMember(String contextId, Principal member) {
        Assert.hasText((String)contextId, (String)"Group context identifier is required.");
        Assert.notNull((Object)member, (String)"Principal is required.");
        try {
            return GroupHelper.toApiGroupDescriptors(this.groupService.getGroupDescriptorsByContextAndMember(contextId, PrincipalHelper.toServerPrincipal(member)));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<GroupDescriptor> getAllReachableGroupsByMember(Principal member) {
        Assert.notNull((Object)member, (String)"Principal is required.");
        try {
            return GroupHelper.toApiGroupDescriptors(this.groupService.getAllReachableGroupDescriptorsByMember(PrincipalHelper.toServerPrincipal(member)));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<GroupDescriptor> getReachableGroupsByMember(String contextId, Principal member) {
        Assert.hasText((String)contextId, (String)"Group context identifier is required.");
        Assert.notNull((Object)member, (String)"Principal is required.");
        try {
            return GroupHelper.toApiGroupDescriptors(this.groupService.getReachableGroupDescriptorsByContextAndMember(contextId, PrincipalHelper.toServerPrincipal(member)));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void removeFromAllGroups(Principal member) {
        Assert.notNull((Object)member, (String)"Principal is required.");
        try {
            this.groupService.removeFromAllGroups(PrincipalHelper.toServerPrincipal(member));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void removeFromGroups(String contextId, Set<Principal> members) {
        Assert.hasText((String)contextId, (String)"Group context identifier is required.");
        Assert.notEmpty(members, (String)"Principals are required.");
        try {
            this.groupService.removeFromGroups(contextId, PrincipalHelper.toServerPrincipals(members));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

