/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.group.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.security.group.Group;
import com.sas.lsaf.security.group.GroupDescriptor;
import com.sas.lsaf.security.principal.impl.PrincipalHelper;
import java.util.HashSet;
import java.util.Set;

public abstract class GroupHelper {
    public static GroupDescriptor toApiGroupDescriptor(com.sas.lsaf.svcs.security.group.client.GroupDescriptor serverItem) {
        return new GroupDescriptor(serverItem.getId(), CoreHelper.toApiObjectIdentity(serverItem.getContext()), serverItem.getName(), serverItem.getDescription());
    }

    public static Set<GroupDescriptor> toApiGroupDescriptors(Set<com.sas.lsaf.svcs.security.group.client.GroupDescriptor> serverItems) {
        HashSet<GroupDescriptor> apiItems = new HashSet<GroupDescriptor>(serverItems.size());
        for (com.sas.lsaf.svcs.security.group.client.GroupDescriptor serverItem : serverItems) {
            apiItems.add(GroupHelper.toApiGroupDescriptor(serverItem));
        }
        return apiItems;
    }

    public static Group toApiGroup(com.sas.lsaf.svcs.security.group.client.Group serverItem) {
        return new Group(serverItem.getId(), CoreHelper.toApiObjectIdentity(serverItem.getContext()), serverItem.getName(), serverItem.getDescription(), serverItem.getRevision(), PrincipalHelper.toApiPrincipals(serverItem.getMembers()));
    }

    public static Set<Group> toApiGroups(Set<com.sas.lsaf.svcs.security.group.client.Group> serverItems) {
        HashSet<Group> apiItems = new HashSet<Group>(serverItems.size());
        for (com.sas.lsaf.svcs.security.group.client.Group serverItem : serverItems) {
            apiItems.add(GroupHelper.toApiGroup(serverItem));
        }
        return apiItems;
    }

    public static com.sas.lsaf.svcs.security.group.client.GroupDescriptor toServerGroupDescriptor(GroupDescriptor apiItem) {
        com.sas.lsaf.svcs.security.group.client.GroupDescriptor serverItem = new com.sas.lsaf.svcs.security.group.client.GroupDescriptor();
        serverItem.setContext(CoreHelper.toServerObjectIdentity(apiItem.getContext()));
        serverItem.setDescription(apiItem.getDescription());
        serverItem.setId(apiItem.getId());
        serverItem.setName(apiItem.getName());
        serverItem.setRevision(-1L);
        return serverItem;
    }

    public static com.sas.lsaf.svcs.security.group.client.Group toServerGroup(Group apiItem) {
        com.sas.lsaf.svcs.security.group.client.Group serverItem = new com.sas.lsaf.svcs.security.group.client.Group();
        serverItem.setContext(CoreHelper.toServerObjectIdentity(apiItem.getContext()));
        serverItem.setDescription(apiItem.getDescription());
        serverItem.setId(apiItem.getId());
        serverItem.setName(apiItem.getName());
        serverItem.setRevision(apiItem.getRevision());
        serverItem.setMembers(PrincipalHelper.toServerPrincipals(apiItem.getMembers()));
        return serverItem;
    }
}

