/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.crypto.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.svcs.security.crypto.client.exception.EncryptionException;
import com.sas.lsaf.svcs.security.crypto.server.Encryptor;
import org.springframework.util.Assert;

public class EncryptionHelper {
    public static final String ENCRYPTED_PASSWORD_PREFIX = "{P21}";
    private Encryptor encryptor;

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
        this.encryptor.setPapa(new String(new byte[]{83, 110, 111, 111, 112, 68, 111, 103, 33}).toCharArray());
        this.encryptor.setSalt(new byte[]{108, 117, 100, 97, 99, 114, 105, 115, 33});
    }

    public String encrypt(byte[] password) {
        Assert.notNull((Object)password, (String)"Password is required.");
        String encrypted = this.encryptor.encrypt(password);
        encrypted = ENCRYPTED_PASSWORD_PREFIX + encrypted;
        return encrypted;
    }

    public String decrypt(String password) {
        Assert.hasText((String)password, (String)"Password is required.");
        String decrypted = password;
        try {
            if (password.startsWith(ENCRYPTED_PASSWORD_PREFIX) || password.startsWith(ENCRYPTED_PASSWORD_PREFIX.toLowerCase())) {
                decrypted = decrypted.substring(ENCRYPTED_PASSWORD_PREFIX.length());
                decrypted = this.encryptor.decrypt(decrypted);
            }
        }
        catch (EncryptionException encryptionException) {
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return decrypted;
    }
}

