/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.authentication.impl;

import com.sas.lsaf.security.authentication.AuthenticationException;
import com.sas.lsaf.security.authentication.impl.AuthenticationHelper;
import com.sas.lsaf.security.authentication.impl.InternalAuthenticationService;
import com.sas.lsaf.security.crypto.impl.EncryptionHelper;
import java.util.Date;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class InternalAuthenticationServiceImpl
implements InternalAuthenticationService {
    private com.sas.lsaf.svcs.security.authentication.server.InternalAuthenticationService internalAuthenticationService;
    private EncryptionHelper encryptionHelper;

    @Required
    public void setInternalAuthenticationService(com.sas.lsaf.svcs.security.authentication.server.InternalAuthenticationService internalAuthenticationService) {
        this.internalAuthenticationService = internalAuthenticationService;
    }

    @Required
    public void setEncryptionHelper(EncryptionHelper encryptionHelper) {
        this.encryptionHelper = encryptionHelper;
    }

    public String authenticate(String userId, String password) throws AuthenticationException {
        Assert.hasText((String)userId, (String)"User id is required.");
        Assert.hasText((String)password, (String)"Password is required.");
        try {
            String decrypted = this.encryptionHelper.decrypt(password);
            this.internalAuthenticationService.internalAuthenticate(userId, decrypted, false);
            return decrypted;
        }
        catch (com.sas.lsaf.svcs.security.authentication.client.exception.AuthenticationException e) {
            throw AuthenticationHelper.toApiAuthenticationException(e);
        }
    }

    public Date getCurrentServerTimestamp() {
        return new Date();
    }
}

