/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.authentication.impl;

import com.sas.lsaf.security.authentication.AccountDeactivatedException;
import com.sas.lsaf.security.authentication.AccountExpiredException;
import com.sas.lsaf.security.authentication.AccountLockedException;
import com.sas.lsaf.security.authentication.AccountNotFoundException;
import com.sas.lsaf.security.authentication.AuthenticationException;
import com.sas.lsaf.security.authentication.CredentialsExpiredException;
import com.sas.lsaf.security.authentication.CredentialsIncorrectException;
import com.sas.lsaf.security.authentication.UnknownAuthenticationException;
import com.sas.lsaf.security.user.AuthenticationProviderInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class AuthenticationHelper {
    public static AuthenticationException toApiAuthenticationException(com.sas.lsaf.svcs.security.authentication.client.exception.AuthenticationException e) {
        if (e instanceof com.sas.lsaf.svcs.security.authentication.client.exception.AccountDeactivatedException) {
            return new AccountDeactivatedException(e.getLocalizedMessage());
        }
        if (e instanceof com.sas.lsaf.svcs.security.authentication.client.exception.AccountExpiredException) {
            return new AccountExpiredException(e.getLocalizedMessage());
        }
        if (e instanceof com.sas.lsaf.svcs.security.authentication.client.exception.AccountLockedException) {
            return new AccountLockedException(e.getLocalizedMessage());
        }
        if (e instanceof com.sas.lsaf.svcs.security.authentication.client.exception.AccountNotFoundException) {
            return new AccountNotFoundException(e.getLocalizedMessage());
        }
        if (e instanceof com.sas.lsaf.svcs.security.authentication.client.exception.CredentialsExpiredException) {
            return new CredentialsExpiredException(e.getLocalizedMessage());
        }
        if (e instanceof com.sas.lsaf.svcs.security.authentication.client.exception.CredentialsIncorrectException) {
            return new CredentialsIncorrectException("The credentials are incorrect.");
        }
        return new UnknownAuthenticationException(e.getLocalizedMessage());
    }

    public static AuthenticationProviderInfo toApiAuthenticationProviderInfo(com.sas.lsaf.svcs.security.authentication.client.AuthenticationProviderInfo serverItem) {
        return new AuthenticationProviderInfo(serverItem.getId(), serverItem.getName(), serverItem.getDescription(), serverItem.isPrimary());
    }

    public static List<AuthenticationProviderInfo> toApiAuthenticationProviderInfos(List<com.sas.lsaf.svcs.security.authentication.client.AuthenticationProviderInfo> serverItems) {
        ArrayList<AuthenticationProviderInfo> apiItems = new ArrayList<AuthenticationProviderInfo>(serverItems.size());
        for (com.sas.lsaf.svcs.security.authentication.client.AuthenticationProviderInfo serverItem : serverItems) {
            apiItems.add(AuthenticationHelper.toApiAuthenticationProviderInfo(serverItem));
        }
        return apiItems;
    }
}

