/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.audit.impl.dao;

import com.sas.lsaf.security.audit.impl.dao.AuditDao;
import com.sas.lsaf.svcs.core.dao.server.jdbc.AbstractJdbcDao;
import com.sas.lsaf.svcs.core.logging.server.Logger;
import com.sas.lsaf.svcs.core.logging.server.LoggerFactory;
import com.sas.lsaf.svcs.core.search.client.query.Order;
import com.sas.lsaf.svcs.core.search.server.SearchJdbcUtils;
import com.sas.lsaf.svcs.core.utils.client.StringUtils;
import com.sas.lsaf.svcs.core.utils.server.JdbcUtils;
import com.sas.lsaf.svcs.security.audit.client.AuditEntry;
import com.sas.lsaf.svcs.security.audit.client.AuditEntryDetail;
import com.sas.lsaf.svcs.security.audit.client.AuditQuery;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameterValue;

public class JdbcAuditDao
extends AbstractJdbcDao
implements AuditDao {
    private static final Logger LOG = LoggerFactory.getLogger();
    private final RowMapper<AuditEntry> auditEntryMapper = new AuditEntryMapper();
    private final RowMapper<Integer> rowCountMapper = new RowCountMapper();
    private static final String ENTRY_TABLE = "(SELECT * FROM SAS_AUDIT UNION SELECT * FROM SAS_SEC_AUDIT)";
    private static final String ENTRY_COLUMNS = "id, stamp, userid, umode, action, source_type, source_id, source_name, source_location";
    private static final String ENTRY_COLUMN_SOURCE_TYPE = "source_type";
    private static final String ENTRY_COLUMN_SOURCE_LOCATION = "source_location";
    private static final String ENTRY_COLUMN_SOURCE_NAME = "source_name";
    private static final String ENTRY_COLUMN_ACTION = "action";
    private static final String ENTRY_COLUMN_USERID = "userid";
    private static final String ENTRY_COLUMN_UMODE = "umode";
    private static final String ENTRY_COLUMN_STAMP = "stamp";
    private static final String DETAIL_TABLE = "(SELECT * FROM SAS_AUDIT_DETAIL UNION SELECT * FROM SAS_SEC_AUDIT_DETAIL)";
    private static final String DETAIL_COLUMNS = "audit_id, detail_id, attribute_type, attribute_id, attribute, old_value, new_value, chunk";
    private static final String SQL_SELECT_DETAIL_BY_ID = "select audit_id, detail_id, attribute_type, attribute_id, attribute, old_value, new_value, chunk from (SELECT * FROM SAS_AUDIT_DETAIL UNION SELECT * FROM SAS_SEC_AUDIT_DETAIL) where audit_id = ? order by detail_id, chunk";
    private static final String COUNT = "count";
    private int batchSize = 1000;

    private String toJdbcQuery(AuditQuery aq, List<SqlParameterValue> spvs, boolean countOnly) {
        ArrayList<SqlParameterValue> pvs;
        String encodedValue;
        StringBuffer query = !countOnly ? new StringBuffer("select id, stamp, userid, umode, action, source_type, source_id, source_name, source_location from (SELECT * FROM SAS_AUDIT UNION SELECT * FROM SAS_SEC_AUDIT)") : new StringBuffer("select count(1) as count from (SELECT * FROM SAS_AUDIT UNION SELECT * FROM SAS_SEC_AUDIT)");
        StringBuffer where = new StringBuffer();
        if (JdbcUtils.isWildcardFieldSet((String)aq.getUserId())) {
            encodedValue = JdbcUtils.handleWildcards((String)aq.getUserId().toLowerCase());
            JdbcUtils.buildStringWhereClause((StringBuffer)where, spvs, (String)"lower(userid)", (SqlParameterValue)new SqlParameterValue(12, (Object)encodedValue));
        }
        if (aq.getMode() != null) {
            JdbcUtils.buildWhereClause((StringBuffer)where, spvs, (String)ENTRY_COLUMN_UMODE, (String)"=", (SqlParameterValue)new SqlParameterValue(4, (Object)JdbcAuditDao.doModeToInt(aq.getMode())));
        }
        if (aq.getActions() != null && !aq.getActions().isEmpty()) {
            pvs = new ArrayList<SqlParameterValue>();
            for (String s : aq.getActions()) {
                pvs.add(new SqlParameterValue(12, (Object)s.toLowerCase()));
            }
            JdbcUtils.buildStringWhereClause((StringBuffer)where, spvs, (String)"lower(action)", pvs);
        }
        if (aq.getSourceTypes() != null && !aq.getSourceTypes().isEmpty()) {
            pvs = new ArrayList();
            for (String s : aq.getSourceTypes()) {
                pvs.add(new SqlParameterValue(12, (Object)s));
            }
            JdbcUtils.buildStringWhereClause((StringBuffer)where, spvs, (String)ENTRY_COLUMN_SOURCE_TYPE, pvs);
        }
        if (aq.getSourceId() != null) {
            JdbcUtils.buildStringWhereClause((StringBuffer)where, spvs, (String)"source_id", (SqlParameterValue)new SqlParameterValue(12, (Object)aq.getSourceId()));
        }
        if (JdbcUtils.isWildcardFieldSet((String)aq.getSourceName())) {
            encodedValue = JdbcUtils.handleWildcards((String)StringUtils.toLowerCase((String)aq.getSourceName()));
            JdbcUtils.buildStringWhereClause((StringBuffer)where, spvs, (String)"lower(source_name)", (SqlParameterValue)new SqlParameterValue(12, (Object)encodedValue));
        }
        if (JdbcUtils.isWildcardFieldSet((String)aq.getSourceLocation())) {
            encodedValue = JdbcUtils.handleWildcards((String)StringUtils.toLowerCase((String)aq.getSourceLocation()));
            if (aq.getSourceLocation().endsWith("/*")) {
                if (where.length() > 0) {
                    where.append(" and");
                }
                where.append(" (lower(source_location) like ? escape '\\' or lower(source_location) like ? escape '\\' ) ");
                spvs.add(new SqlParameterValue(12, (Object)encodedValue.substring(0, encodedValue.length() - 2)));
                spvs.add(new SqlParameterValue(12, (Object)encodedValue));
            } else {
                JdbcUtils.buildStringWhereClause((StringBuffer)where, spvs, (String)"lower(source_location)", (SqlParameterValue)new SqlParameterValue(12, (Object)encodedValue));
            }
        }
        if (aq.getFromDate() != null) {
            JdbcUtils.buildWhereClause((StringBuffer)where, spvs, (String)ENTRY_COLUMN_STAMP, (String)">=", (SqlParameterValue)new SqlParameterValue(2, (Object)aq.getFromDate().getTime()));
        }
        if (aq.getToDate() != null) {
            JdbcUtils.buildWhereClause((StringBuffer)where, spvs, (String)ENTRY_COLUMN_STAMP, (String)"<=", (SqlParameterValue)new SqlParameterValue(2, (Object)aq.getToDate().getTime()));
        }
        if (!where.toString().isEmpty()) {
            query.append(" where");
            query.append(where);
        }
        if (!countOnly) {
            if (aq.getSort() == null || aq.getSort().isEmpty()) {
                aq.addOrder(AuditQuery.Column.TIMESTAMP, false, false);
            }
            ArrayList<Order> dbSort = new ArrayList<Order>(aq.getSort().size());
            for (Order order : aq.getSort()) {
                AuditQuery.Column c = AuditQuery.Column.valueOf((String)order.getOperand());
                Order dbOrder = new Order(order);
                dbSort.add(dbOrder);
                switch (c) {
                    case SOURCETYPE: {
                        dbOrder.setOperand(ENTRY_COLUMN_SOURCE_TYPE);
                        break;
                    }
                    case SOURCENAME: {
                        dbOrder.setOperand(ENTRY_COLUMN_SOURCE_NAME);
                        break;
                    }
                    case SOURCELOCATION: {
                        dbOrder.setOperand(ENTRY_COLUMN_SOURCE_LOCATION);
                        break;
                    }
                    case ACTION: {
                        dbOrder.setOperand(ENTRY_COLUMN_ACTION);
                        break;
                    }
                    case USERID: {
                        dbOrder.setOperand(ENTRY_COLUMN_USERID);
                        break;
                    }
                    case MODE: {
                        dbOrder.setOperand(ENTRY_COLUMN_UMODE);
                        dbOrder.setCaseSensitive(false);
                        break;
                    }
                    case TIMESTAMP: {
                        dbOrder.setOperand(ENTRY_COLUMN_STAMP);
                        dbOrder.setCaseSensitive(false);
                        break;
                    }
                }
            }
            query.append(SearchJdbcUtils.buildOrderByClause(dbSort));
        }
        if (LOG.isDebugEnabled()) {
            ArrayList<Object> os = new ArrayList<Object>(spvs.size());
            for (SqlParameterValue spv : spvs) {
                os.add(spv.getValue());
            }
            LOG.atDebug().log("Executing adhoc audit query [%s] with parameters [%s].", (Object)query, (Object)StringUtils.collectionToCommaDelimitedString(os));
        }
        return query.toString();
    }

    protected static int doModeToInt(AuditEntry.Mode mode) {
        switch (mode) {
            case USER: {
                return 0;
            }
            case SYSTEM: {
                return 1;
            }
            case ADMIN: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unmapped audit mode value " + mode);
    }

    protected static AuditEntry.Mode doIntToMode(int i) {
        switch (i) {
            case 0: {
                return AuditEntry.Mode.USER;
            }
            case 1: {
                return AuditEntry.Mode.SYSTEM;
            }
            case 2: {
                return AuditEntry.Mode.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unmapped persisted audit mode value " + i);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int findRowCountByQuery(AuditQuery aq) {
        boolean countOnly = true;
        final ArrayList<SqlParameterValue> spvs = new ArrayList<SqlParameterValue>();
        String query = this.toJdbcQuery(aq, spvs, true);
        List rowCounts = this.jdbcTemplate.query(query, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                for (int i = 0; i < spvs.size(); ++i) {
                    JdbcUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)((SqlParameterValue)spvs.get(i)).getSqlType(), spvs.get(i));
                }
            }
        }, this.rowCountMapper);
        return (Integer)rowCounts.get(0);
    }

    @Override
    public List<AuditEntryDetail> findAuditEntryDetails(String id) {
        AuditEntryDetailRowCallbackHandler aedrch = new AuditEntryDetailRowCallbackHandler();
        String sqlText = SQL_SELECT_DETAIL_BY_ID;
        this.jdbcTemplate.query(sqlText, new Object[]{id}, (RowCallbackHandler)aedrch);
        return aedrch.getAuditEntryDetails();
    }

    @Override
    public List<AuditEntry> findByQueryAndRows(AuditQuery aq, int fromRow, int toRow) {
        boolean countOnly = false;
        final ArrayList<SqlParameterValue> spvs = new ArrayList<SqlParameterValue>();
        String query = this.toJdbcQuery(aq, spvs, false);
        ((AuditEntryMapper)this.auditEntryMapper).setType(AuditEntry.AuditType.GENERAL);
        String queryWithRowNum = JdbcUtils.buildPagedQuery((String)query, (int)fromRow, (int)toRow);
        ArrayList<Object> os = new ArrayList<Object>(spvs.size());
        for (SqlParameterValue spv : spvs) {
            os.add(spv.getValue());
        }
        LOG.atDebug().log("Executing audit query [%s] with parameters [%s].", (Object)queryWithRowNum, (Object)StringUtils.collectionToCommaDelimitedString(os));
        long start = System.currentTimeMillis();
        List ret = this.jdbcTemplate.query(queryWithRowNum, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                for (int i = 0; i < spvs.size(); ++i) {
                    JdbcUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)((SqlParameterValue)spvs.get(i)).getSqlType(), (Object)((SqlParameterValue)spvs.get(i)).getValue());
                }
            }
        }, this.auditEntryMapper);
        LOG.atDebug().log("Query took %dms.", (Object)(System.currentTimeMillis() - start));
        return ret;
    }

    protected static AuditEntry toAuditEntry(ResultSet rs, AuditEntry.AuditType type) throws SQLException {
        AuditEntry ae = new AuditEntry();
        ae.setId(rs.getString("id"));
        ae.setTimestamp(new Date(rs.getLong(ENTRY_COLUMN_STAMP)));
        ae.setUserId(rs.getString(ENTRY_COLUMN_USERID));
        ae.setMode(JdbcAuditDao.doIntToMode(rs.getInt(ENTRY_COLUMN_UMODE)));
        ae.setAuditType(type);
        ae.setAction(rs.getString(ENTRY_COLUMN_ACTION));
        ae.setSourceTypeId(rs.getString(ENTRY_COLUMN_SOURCE_TYPE));
        ae.setSourceId(rs.getString("source_id"));
        ae.setSourceName(rs.getString(ENTRY_COLUMN_SOURCE_NAME));
        ae.setSourceLocation(rs.getString(ENTRY_COLUMN_SOURCE_LOCATION));
        return ae;
    }

    private static final class AuditEntryDetailRowCallbackHandler
    implements RowCallbackHandler {
        private final List<AuditEntryDetail> auditEntryDetails = new ArrayList<AuditEntryDetail>();
        private AuditEntryDetail aed;

        public void processRow(ResultSet rs) throws SQLException {
            int detailId = rs.getInt("detail_id");
            int chunk = rs.getInt("chunk");
            if (this.aed == null || this.auditEntryDetails.size() != detailId) {
                LOG.atDebug().log("Processing audit entry detail #%d", (Object)detailId);
                LOG.atDebug().log("  processing chunk %d", (Object)chunk);
                this.aed = new AuditEntryDetail();
                this.aed.setAuditEntryId(rs.getString("audit_id"));
                this.aed.setAttributeType(rs.getString("attribute_type"));
                this.aed.setAttributeId(rs.getString("attribute_id"));
                this.aed.setAttributeName(rs.getString("attribute"));
                this.aed.setOldValue(rs.getString("old_value"));
                this.aed.setNewValue(rs.getString("new_value"));
                this.auditEntryDetails.add(this.aed);
            } else {
                LOG.atDebug().log("  processing chunk %d", (Object)chunk);
                String nextOldValueChunk = rs.getString("old_value");
                String nextNewValueChunk = rs.getString("new_value");
                if (nextOldValueChunk != null) {
                    this.aed.setOldValue(this.aed.getOldValue() + rs.getString("old_value"));
                }
                if (nextNewValueChunk != null) {
                    this.aed.setNewValue(this.aed.getNewValue() + rs.getString("new_value"));
                }
            }
        }

        public List<AuditEntryDetail> getAuditEntryDetails() {
            return this.auditEntryDetails;
        }
    }

    private static final class RowCountMapper
    implements RowMapper<Integer> {
        public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
            return this.toInteger(rs);
        }

        private Integer toInteger(ResultSet rs) throws SQLException {
            return rs.getInt(JdbcAuditDao.COUNT);
        }
    }

    private static final class AuditEntryMapper
    implements RowMapper<AuditEntry> {
        private AuditEntry.AuditType type = AuditEntry.AuditType.GENERAL;

        public AuditEntry mapRow(ResultSet rs, int rowNum) throws SQLException {
            return JdbcAuditDao.toAuditEntry(rs, this.type);
        }

        public void setType(AuditEntry.AuditType type) {
            this.type = type;
        }
    }
}

