/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.audit.impl;

import com.sas.lsaf.core.AccessDeniedException;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.SearchResultsInfo;
import com.sas.lsaf.security.audit.AuditAction;
import com.sas.lsaf.security.audit.AuditEntry;
import com.sas.lsaf.security.audit.AuditEntryDetail;
import com.sas.lsaf.security.audit.AuditQuery;
import com.sas.lsaf.security.audit.AuditSearchException;
import com.sas.lsaf.security.audit.AuditService;
import com.sas.lsaf.security.audit.impl.AuditHelper;
import com.sas.lsaf.security.audit.impl.InternalAuditService;
import com.sas.lsaf.security.audit.impl.dao.AuditDao;
import com.sas.lsaf.svcs.content.repository.client.RepositoryContext;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.content.repository.server.InternalRepositoryService;
import com.sas.lsaf.svcs.core.event.server.Event;
import com.sas.lsaf.svcs.core.event.server.EventListener;
import com.sas.lsaf.svcs.core.type.client.Type;
import com.sas.lsaf.svcs.core.type.server.InternalTypeService;
import com.sas.lsaf.svcs.security.audit.client.AuditActionInfo;
import com.sas.lsaf.svcs.security.audit.client.AuditEntry;
import com.sas.lsaf.svcs.security.audit.client.AuditPrivileges;
import com.sas.lsaf.svcs.security.authorization.client.AuthorizationService;
import com.sas.lsaf.svcs.security.authorization.client.Securable;
import com.sas.lsaf.svcs.security.authorization.server.AuthorizationPrivileges;
import com.sas.lsaf.svcs.security.session.server.ApplicationSession;
import com.sas.lsaf.svcs.security.session.server.event.ApplicationSessionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class AuditServiceImpl
implements AuditService,
InternalAuditService,
EventListener {
    private com.sas.lsaf.svcs.security.audit.client.AuditService auditService;
    private AuthorizationService authorizationService;
    private InternalRepositoryService internalRepositoryService;
    private InternalTypeService internalTypeService;
    private int searchPageSizeLimit = 5000;
    private AuditDao apiAuditDao;
    private final Map<String, String> sessionTokenMap = new ConcurrentHashMap<String, String>();
    private final Map<String, AuditQueryInfo> queriesById = new ConcurrentHashMap<String, AuditQueryInfo>();

    @Required
    public void setAuditService(com.sas.lsaf.svcs.security.audit.client.AuditService auditService) {
        this.auditService = auditService;
    }

    @Required
    public void setApiAuditDao(AuditDao apiAuditDao) {
        this.apiAuditDao = apiAuditDao;
    }

    @Required
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Required
    public void setInternalRepositoryService(InternalRepositoryService internalRepositoryService) {
        this.internalRepositoryService = internalRepositoryService;
    }

    @Required
    public void setInternalTypeService(InternalTypeService internalTypeService) {
        this.internalTypeService = internalTypeService;
    }

    public void setSearchPageSizeLimit(int searchPageSizeLimit) {
        this.searchPageSizeLimit = searchPageSizeLimit;
    }

    @Transactional(readOnly=true)
    public SearchResultsInfo search(AuditQuery query) {
        Assert.notNull((Object)query, (String)"Audit query is required.");
        List sourceTypeIds = query.getSourceTypeIds();
        if (sourceTypeIds != null && !sourceTypeIds.isEmpty()) {
            Assert.isTrue((!sourceTypeIds.contains(null) ? 1 : 0) != 0, (String)"Audit query source type id cannot be null.");
        }
        this.checkPrivileges();
        if (query.getSourceId() != null) {
            Assert.hasText((String)query.getSourceId(), (String)"Audit query source identifier must be null or contain a non-empty value.");
        }
        if (query.getSourceName() != null) {
            Assert.hasText((String)query.getSourceName(), (String)"Audit query source name must be null or contain a non-empty value.");
        }
        if (query.getSourceLocation() != null) {
            Assert.hasText((String)query.getSourceLocation(), (String)"Audit query source location must be null or contain a non-empty value.");
        }
        if (query.getUserId() != null) {
            Assert.hasText((String)query.getUserId(), (String)"Audit query user ID must be null or contain a non-empty value.");
        }
        if (query.getActions() != null) {
            for (String action : query.getActions()) {
                Assert.hasText((String)action, (String)"Audit query actions list contains an empty value.  Please make sure each type has a non-empty value.");
            }
        }
        if (query.getToDate() == null || query.getToDate().getTime() > System.currentTimeMillis()) {
            query.setToDate(new Date());
        }
        if (query.getSourceTypeIds() != null && !query.getSourceTypeIds().isEmpty()) {
            query.setSourceTypeIds(new ArrayList(query.getSourceTypeIds()));
            for (String typeId : query.getSourceTypeIds()) {
                Assert.hasText((String)typeId, (String)"Audit query source types list contains an empty value.  Please make sure each type has a non-empty value.");
                if (!typeId.equals("sas:file")) continue;
                for (Type fileType : this.internalTypeService.internalGetSubTypes("sas:file")) {
                    query.getSourceTypeIds().add(fileType.getId());
                }
            }
            for (String typeId : query.getSourceTypeIds()) {
                if (!typeId.equals("sas:context")) continue;
                for (Type contextType : this.internalTypeService.internalGetSubTypes("sas:context")) {
                    query.getSourceTypeIds().add(contextType.getId());
                }
            }
        }
        try {
            com.sas.lsaf.svcs.core.search.client.SearchResultsInfo ret = new com.sas.lsaf.svcs.core.search.client.SearchResultsInfo();
            ret.setToken(UUID.randomUUID().toString());
            ret.setLimitReached(false);
            com.sas.lsaf.svcs.security.audit.client.AuditQuery serverAq = AuditHelper.toServerAuditQuery(query);
            int rowCount = this.apiAuditDao.findRowCountByQuery(serverAq);
            ret.setRowCount(rowCount);
            this.queriesById.put(ret.getToken(), new AuditQueryInfo(serverAq, rowCount));
            return CoreHelper.toApiSearchResultsInfo(ret);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<AuditEntry> getSearchResults(int fromRow, int toRow) {
        throw new UnsupportedOperationException("This implementation does not provide this functionality.");
    }

    @Transactional(readOnly=true)
    public List<AuditEntryDetail> getDetails(String id) {
        Assert.hasText((String)id, (String)"Audit entry identifier is required.");
        try {
            return AuditHelper.toApiAuditEntryDetails(this.apiAuditDao.findAuditEntryDetails(id));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void clearSearchResults() {
        throw new UnsupportedOperationException("This implementation does not provide this functionality.");
    }

    public int getSearchPageSizeLimit() {
        return this.searchPageSizeLimit;
    }

    public Set<AuditAction> getAuditActions() {
        try {
            HashSet<AuditAction> apiAuditActions = new HashSet();
            HashSet<AuditActionInfo> allActions = new HashSet<AuditActionInfo>();
            allActions.addAll(this.auditService.getAuditActionInfos(AuditEntry.AuditType.GENERAL));
            Set securityAuditActions = this.auditService.getAuditActionInfos(AuditEntry.AuditType.SECURITY);
            allActions.addAll(securityAuditActions);
            apiAuditActions = AuditHelper.toApiAuditActions(allActions);
            for (AuditActionInfo auditAction : securityAuditActions) {
                if (!auditAction.getAction().equals("downloaded")) continue;
                List subTypes = this.internalTypeService.internalGetSubTypes(auditAction.getTypeId());
                for (Type subType : subTypes) {
                    if (!subType.isFileType()) continue;
                    apiAuditActions.add(new AuditAction(subType.getId(), auditAction.getAction(), auditAction.getDisplayName()));
                }
            }
            return apiAuditActions;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(readOnly=true)
    public List<AuditEntry> internalGetSearchResults(String token, int fromRow, int toRow) throws AuditSearchException {
        Assert.hasText((String)token, (String)"Audit search token is required.");
        Assert.isTrue((fromRow > 0 ? 1 : 0) != 0, (String)"Starting row requested must be greater than 0");
        Assert.isTrue((toRow >= fromRow ? 1 : 0) != 0, (String)"Ending row requested must be greater than or equal to the starting row requested");
        if (toRow + 1 - fromRow > this.searchPageSizeLimit) {
            throw new AuditSearchException("The number of audit entries requested exceeds the maximum limit, " + this.searchPageSizeLimit + ".  Please modify the number of rows requested.");
        }
        this.checkPrivileges();
        try {
            AuditQueryInfo aqInfo = this.queriesById.get(token);
            if (aqInfo == null) {
                throw new AuditSearchException("Audit entries search results no longer exist with id " + token);
            }
            com.sas.lsaf.svcs.security.audit.client.AuditQuery aq = aqInfo.getAuditEntryQuery();
            List<com.sas.lsaf.svcs.security.audit.client.AuditEntry> aes = new ArrayList<com.sas.lsaf.svcs.security.audit.client.AuditEntry>(0);
            int realToRow = toRow;
            if (realToRow > aqInfo.getRowCount()) {
                realToRow = aqInfo.getRowCount();
            }
            if (fromRow <= aqInfo.getRowCount()) {
                aes = this.apiAuditDao.findByQueryAndRows(aq, fromRow, realToRow);
            }
            return AuditHelper.toApiAuditEntries(aes);
        }
        catch (AuditSearchException e) {
            throw new AuditSearchException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void internalClearSearchResults(String token) {
        Assert.hasText((String)token, (String)"Audit search token is required.");
        try {
            this.queriesById.remove(token);
            this.sessionTokenMap.remove(token);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void onEvent(Event<?> event) {
        if (ApplicationSessionEvent.AuthenticatedApplicationSessionDestroyedEvent.class.isAssignableFrom(event.getClass())) {
            ApplicationSessionEvent.AuthenticatedApplicationSessionDestroyedEvent authSessionDestroyedEvent = (ApplicationSessionEvent.AuthenticatedApplicationSessionDestroyedEvent)event;
            ApplicationSession applicationSession = (ApplicationSession)authSessionDestroyedEvent.getSource();
            for (Map.Entry<String, String> e : this.sessionTokenMap.entrySet()) {
                if (e.getValue() == null || !e.getValue().equals(applicationSession.getId())) continue;
                this.sessionTokenMap.remove(e.getKey());
                this.queriesById.remove(e.getKey());
            }
        }
    }

    private void checkPrivileges() {
        try {
            RepositoryContext tenant = this.internalRepositoryService.internalGetContextByPath("/");
            if (!this.authorizationService.hasPrivilege((Securable)tenant, AuditPrivileges.PRIVILEGE_AUDIT_REPORTING) && !this.authorizationService.hasPrivilege((Securable)tenant, AuthorizationPrivileges.PRIVILEGE_ADMINISTRATIVE_MODE)) {
                String message = "User does not have authorization to get audit records";
                throw new AccessDeniedException("User does not have authorization to get audit records");
            }
        }
        catch (RepositoryItemNotFoundException repositoryItemNotFoundException) {
            // empty catch block
        }
    }

    private static class AuditQueryInfo {
        private final com.sas.lsaf.svcs.security.audit.client.AuditQuery auditEntryQuery;
        private final int rowCount;

        AuditQueryInfo(com.sas.lsaf.svcs.security.audit.client.AuditQuery aq, int rowCount) {
            this.auditEntryQuery = aq;
            this.rowCount = rowCount;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public com.sas.lsaf.svcs.security.audit.client.AuditQuery getAuditEntryQuery() {
            return this.auditEntryQuery;
        }
    }
}

