/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.audit.impl;

import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.security.audit.AuditAction;
import com.sas.lsaf.security.audit.AuditEntry;
import com.sas.lsaf.security.audit.AuditEntryDetail;
import com.sas.lsaf.security.audit.AuditQuery;
import com.sas.lsaf.svcs.security.audit.client.AuditActionInfo;
import com.sas.lsaf.svcs.security.audit.client.AuditEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AuditHelper {
    private static AuditEntry.Mode toApiMode(AuditEntry.Mode serverItem) {
        switch (serverItem) {
            case USER: {
                return AuditEntry.Mode.USER;
            }
            case ADMIN: {
                return AuditEntry.Mode.ADMIN;
            }
            case SYSTEM: {
                return AuditEntry.Mode.SYSTEM;
            }
        }
        throw new SystemException("Unmapped audit mode type: " + serverItem.name());
    }

    private static AuditEntry.Mode toServerMode(AuditEntry.Mode apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case USER: {
                return AuditEntry.Mode.USER;
            }
            case ADMIN: {
                return AuditEntry.Mode.ADMIN;
            }
            case SYSTEM: {
                return AuditEntry.Mode.SYSTEM;
            }
        }
        throw new SystemException("Unmapped audit mode type: " + apiItem.name());
    }

    public static List<AuditEntry> toApiAuditEntries(List<com.sas.lsaf.svcs.security.audit.client.AuditEntry> serverItems) {
        ArrayList<AuditEntry> apiItems = new ArrayList<AuditEntry>(serverItems.size());
        for (com.sas.lsaf.svcs.security.audit.client.AuditEntry serverItem : serverItems) {
            apiItems.add(AuditHelper.toApiAuditEntry(serverItem));
        }
        return apiItems;
    }

    public static AuditEntry toApiAuditEntry(com.sas.lsaf.svcs.security.audit.client.AuditEntry serverItem) {
        return new AuditEntry(serverItem.getId(), serverItem.getTimestamp(), serverItem.getUserId(), serverItem.getAction(), serverItem.getSourceTypeId(), serverItem.getSourceId(), serverItem.getSourceName(), serverItem.getSourceLocation(), AuditHelper.toApiMode(serverItem.getMode()));
    }

    public static List<AuditEntryDetail> toApiAuditEntryDetails(List<com.sas.lsaf.svcs.security.audit.client.AuditEntryDetail> serverItems) {
        ArrayList<AuditEntryDetail> apiItems = new ArrayList<AuditEntryDetail>(serverItems.size());
        for (com.sas.lsaf.svcs.security.audit.client.AuditEntryDetail serverItem : serverItems) {
            apiItems.add(AuditHelper.toApiAuditEntryDetail(serverItem));
        }
        return apiItems;
    }

    public static AuditEntryDetail toApiAuditEntryDetail(com.sas.lsaf.svcs.security.audit.client.AuditEntryDetail serverItem) {
        return new AuditEntryDetail(serverItem.getAuditEntryId(), serverItem.getAttributeType(), serverItem.getAttributeId(), serverItem.getAttributeName(), serverItem.getOldValue(), serverItem.getNewValue());
    }

    public static Set<AuditAction> toApiAuditActions(Set<AuditActionInfo> serverItems) {
        HashSet<AuditAction> apiItems = new HashSet<AuditAction>(serverItems.size());
        for (AuditActionInfo serverItem : serverItems) {
            apiItems.add(AuditHelper.toApiAuditAction(serverItem));
        }
        return apiItems;
    }

    public static AuditAction toApiAuditAction(AuditActionInfo serverItem) {
        return new AuditAction(serverItem.getTypeId(), serverItem.getAction(), serverItem.getDisplayName());
    }

    public static com.sas.lsaf.svcs.security.audit.client.AuditQuery toServerAuditQuery(AuditQuery apiItem) {
        com.sas.lsaf.svcs.security.audit.client.AuditQuery serverItem = new com.sas.lsaf.svcs.security.audit.client.AuditQuery();
        serverItem.setUserId(apiItem.getUserId());
        serverItem.setActions(apiItem.getActions());
        serverItem.setSourceTypes((List)(apiItem.getSourceTypeIds() != null ? new ArrayList(apiItem.getSourceTypeIds()) : null));
        serverItem.setSourceName(apiItem.getSourceName());
        serverItem.setSourceLocation(apiItem.getSourceLocation());
        serverItem.setFromDate(apiItem.getFromDate());
        serverItem.setToDate(apiItem.getToDate());
        serverItem.setSourceId(apiItem.getSourceId());
        serverItem.setMode(AuditHelper.toServerMode(apiItem.getMode()));
        return serverItem;
    }
}

