/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.acl.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.type.IllegalTypeException;
import com.sas.lsaf.security.acl.AbstractAcl;
import com.sas.lsaf.security.acl.Acl;
import com.sas.lsaf.security.acl.AclEntry;
import com.sas.lsaf.security.acl.AclMembers;
import com.sas.lsaf.security.acl.AclNotFoundException;
import com.sas.lsaf.security.acl.AclOwner;
import com.sas.lsaf.security.acl.AclService;
import com.sas.lsaf.security.acl.AclUpdateException;
import com.sas.lsaf.security.acl.DefaultAcl;
import com.sas.lsaf.security.acl.impl.AclHelper;
import com.sas.lsaf.security.group.GroupDescriptor;
import com.sas.lsaf.security.group.impl.GroupHelper;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.user.impl.UserHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryContainer;
import com.sas.lsaf.svcs.content.repository.client.RepositoryItem;
import com.sas.lsaf.svcs.content.repository.client.RepositoryService;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.security.acl.client.AclGroup;
import com.sas.lsaf.svcs.security.acl.client.AclPrincipal;
import com.sas.lsaf.svcs.security.acl.client.AclSecurable;
import com.sas.lsaf.svcs.security.acl.client.AclUser;
import com.sas.lsaf.svcs.security.acl.client.DefaultAclSecurable;
import com.sas.lsaf.svcs.security.group.client.GroupService;
import com.sas.lsaf.svcs.security.group.client.exception.GroupNotFoundException;
import com.sas.lsaf.svcs.security.user.client.UserDescriptor;
import com.sas.lsaf.svcs.security.user.client.UserService;
import com.sas.lsaf.svcs.security.user.client.exception.UserNotFoundException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class AclServiceImpl
implements AclService {
    private com.sas.lsaf.svcs.security.acl.client.AclService aclService;
    private UserService userService;
    private GroupService groupService;
    private RepositoryService repositoryService;

    private Acl toApiAcl(com.sas.lsaf.svcs.security.acl.client.Acl serverAcl) throws UserNotFoundException, GroupNotFoundException {
        if (serverAcl == null) {
            return null;
        }
        Acl apiAcl = new Acl(CoreHelper.toApiObjectIdentity(serverAcl.getOwningObjectIdentity()));
        apiAcl.setOwner(UserHelper.toApiUserDescriptor(this.userService.getUserDescriptorByUserId(serverAcl.getOwner().getPrincipalId())));
        apiAcl.setEntries(this.toApiAclEntries(serverAcl.getEntries()));
        return apiAcl;
    }

    private DefaultAcl toApiDefaultAcl(com.sas.lsaf.svcs.security.acl.client.DefaultAcl serverAcl) throws UserNotFoundException, GroupNotFoundException {
        if (serverAcl == null) {
            return null;
        }
        DefaultAcl apiAcl = new DefaultAcl(CoreHelper.toApiObjectIdentity(serverAcl.getOwningObjectIdentity()));
        if (serverAcl.getOwner() != null) {
            apiAcl.setOwner(UserHelper.toApiUserDescriptor(this.userService.getUserDescriptorByUserId(serverAcl.getOwner().getPrincipalId())));
        }
        apiAcl.setEntries(this.toApiAclEntries(serverAcl.getEntries()));
        apiAcl.setOwnerPropagation(AclHelper.toApiOwnerPropagation(serverAcl.getOwnerPropagation()));
        return apiAcl;
    }

    private Set<AclEntry> toApiAclEntries(List<com.sas.lsaf.svcs.security.acl.client.AclEntry> serverAclEntries) throws UserNotFoundException, GroupNotFoundException {
        LinkedHashSet<AclEntry> apiAclEntries = new LinkedHashSet<AclEntry>();
        for (com.sas.lsaf.svcs.security.acl.client.AclEntry serverAclEntry : serverAclEntries) {
            apiAclEntries.add(this.toApiAclEntry(serverAclEntry));
        }
        return apiAclEntries;
    }

    private Principal toApiAclPrincipal(AclPrincipal serverPrincipal) throws UserNotFoundException, GroupNotFoundException {
        com.sas.lsaf.security.user.UserDescriptor apiPrincipal = null;
        UserDescriptor user = null;
        com.sas.lsaf.svcs.security.group.client.GroupDescriptor group = null;
        if (serverPrincipal instanceof com.sas.lsaf.svcs.security.acl.client.AclMembers) {
            com.sas.lsaf.svcs.security.acl.client.AclMembers members = (com.sas.lsaf.svcs.security.acl.client.AclMembers)serverPrincipal;
            AclMembers apiAclMembers = new AclMembers(members.getPrincipalId());
            return apiAclMembers;
        }
        if (serverPrincipal instanceof com.sas.lsaf.svcs.security.acl.client.AclOwner) {
            com.sas.lsaf.svcs.security.acl.client.AclOwner owner = (com.sas.lsaf.svcs.security.acl.client.AclOwner)serverPrincipal;
            AclOwner apiAclOwner = new AclOwner(owner.getPrincipalId());
            return apiAclOwner;
        }
        if (serverPrincipal instanceof AclUser) {
            AclUser aclUser = (AclUser)serverPrincipal;
            user = this.userService.getUserDescriptorByUserId(aclUser.getPrincipalId());
            apiPrincipal = UserHelper.toApiUserDescriptor(user);
        } else if (serverPrincipal instanceof AclGroup) {
            group = this.groupService.getGroupDescriptorById(serverPrincipal.getPrincipalId());
            apiPrincipal = GroupHelper.toApiGroupDescriptor(group);
        }
        return apiPrincipal;
    }

    private com.sas.lsaf.svcs.security.acl.client.Acl toServerAcl(Acl apiAcl) {
        com.sas.lsaf.svcs.security.acl.client.Acl serverAcl = new com.sas.lsaf.svcs.security.acl.client.Acl();
        serverAcl.setOwner((AclUser)UserHelper.toServerUserDescriptor(apiAcl.getOwner()));
        serverAcl.setEntries(this.toServerAclEntries(apiAcl.getEntries()));
        serverAcl.setOwningObjectIdentity(CoreHelper.toServerObjectIdentity(apiAcl.getOwningObjectIdentity()));
        return serverAcl;
    }

    private com.sas.lsaf.svcs.security.acl.client.DefaultAcl toServerDefaultAcl(DefaultAcl apiDefaultAcl) {
        com.sas.lsaf.svcs.security.acl.client.DefaultAcl serverDefaultAcl = new com.sas.lsaf.svcs.security.acl.client.DefaultAcl();
        if (apiDefaultAcl.getOwnerPropagation() != DefaultAcl.OwnerPropagation.CREATOR) {
            serverDefaultAcl.setOwner((AclUser)UserHelper.toServerUserDescriptor(apiDefaultAcl.getOwner()));
        }
        serverDefaultAcl.setOwnerPropagation(AclHelper.toServerOwnerPropagation(apiDefaultAcl.getOwnerPropagation()));
        serverDefaultAcl.setEntries(this.toServerAclEntries(apiDefaultAcl.getEntries()));
        serverDefaultAcl.setOwningObjectIdentity(CoreHelper.toServerObjectIdentity(apiDefaultAcl.getOwningObjectIdentity()));
        return serverDefaultAcl;
    }

    private List<com.sas.lsaf.svcs.security.acl.client.AclEntry> toServerAclEntries(Set<AclEntry> apiEntries) {
        if (apiEntries == null) {
            return null;
        }
        ArrayList<com.sas.lsaf.svcs.security.acl.client.AclEntry> serverAclEntries = new ArrayList<com.sas.lsaf.svcs.security.acl.client.AclEntry>();
        for (AclEntry apiAclEntry : apiEntries) {
            serverAclEntries.add(this.toServerAclEntry(apiAclEntry));
        }
        return serverAclEntries;
    }

    private com.sas.lsaf.svcs.security.acl.client.AclEntry toServerAclEntry(AclEntry apiAclEntry) {
        if (apiAclEntry == null) {
            return null;
        }
        AclPrincipal aclPrincipal = this.toServerAclPrincipal(apiAclEntry.getPrincipal());
        return new com.sas.lsaf.svcs.security.acl.client.AclEntry(aclPrincipal, AclHelper.toServerPermValue(apiAclEntry.getReadPermission()), AclHelper.toServerPermValue(apiAclEntry.getWritePropertiesPermission()), AclHelper.toServerPermValue(apiAclEntry.getWriteContentPermission()), AclHelper.toServerPermValue(apiAclEntry.getDeletePermission()), AclHelper.toServerPermValue(apiAclEntry.getAdminPermission()));
    }

    private AclEntry toApiAclEntry(com.sas.lsaf.svcs.security.acl.client.AclEntry serverAclEntry) throws UserNotFoundException, GroupNotFoundException {
        if (serverAclEntry == null) {
            return null;
        }
        Principal apiAclPrincipal = this.toApiAclPrincipal(serverAclEntry.getPrincipal());
        return new AclEntry(apiAclPrincipal, AclHelper.toApiPermValue(serverAclEntry.getAdminPermission()), AclHelper.toApiPermValue(serverAclEntry.getReadPermission()), AclHelper.toApiPermValue(serverAclEntry.getWriteMetadataPermission()), AclHelper.toApiPermValue(serverAclEntry.getWriteContentPermission()), AclHelper.toApiPermValue(serverAclEntry.getDeletePermission()));
    }

    private AclPrincipal toServerAclPrincipal(Principal principal) {
        UserDescriptor serverAclPrincipal = null;
        if (principal instanceof com.sas.lsaf.security.user.UserDescriptor) {
            com.sas.lsaf.security.user.UserDescriptor user = (com.sas.lsaf.security.user.UserDescriptor)principal;
            serverAclPrincipal = UserHelper.toServerUserDescriptor(user);
        } else if (principal instanceof GroupDescriptor) {
            GroupDescriptor group = (GroupDescriptor)principal;
            serverAclPrincipal = GroupHelper.toServerGroupDescriptor(group);
        } else if (principal instanceof AclMembers) {
            serverAclPrincipal = new com.sas.lsaf.svcs.security.acl.client.AclMembers(((AclMembers)principal).getPrincipalId());
        } else if (principal instanceof AclOwner) {
            serverAclPrincipal = new com.sas.lsaf.svcs.security.acl.client.AclOwner(((AclOwner)principal).getPrincipalId());
        }
        return serverAclPrincipal;
    }

    private RepositoryItem validateItemForAcl(String id, boolean isDefaultAcl) throws RepositoryItemNotFoundException, AclNotFoundException {
        String contextId = id;
        RepositoryItem lsafRepoItem = this.repositoryService.getById(contextId);
        if (isDefaultAcl && !(lsafRepoItem instanceof RepositoryContainer)) {
            throw new IllegalTypeException("Path must be to a container.");
        }
        if (lsafRepoItem.getPath().startsWith("/Users")) {
            throw new AclNotFoundException("Acl not available for repository items in the Users folder.");
        }
        return lsafRepoItem;
    }

    private void validateAcl(AbstractAcl acl) {
        if (acl.getEntries() != null) {
            for (AclEntry ace : acl.getEntries()) {
                if (ace == null || ace.getPrincipal() instanceof AclOwner || ace.getPrincipal() instanceof AclMembers || ace.getAdminPermission() == null || !ace.getAdminPermission().equals((Object)AclEntry.PermissionValue.FALSE) || ace.getReadPermission() == null || !ace.getReadPermission().equals((Object)AclEntry.PermissionValue.FALSE) || ace.getWritePropertiesPermission() == null || !ace.getWritePropertiesPermission().equals((Object)AclEntry.PermissionValue.FALSE) || ace.getWriteContentPermission() == null || !ace.getWriteContentPermission().equals((Object)AclEntry.PermissionValue.FALSE) || ace.getDeletePermission() == null || !ace.getDeletePermission().equals((Object)AclEntry.PermissionValue.FALSE)) continue;
                throw new IllegalArgumentException("Permissions cannot all be set to FALSE. This is equivalent to a principal not having an acl entry.");
            }
        }
    }

    @Required
    public void setAclService(com.sas.lsaf.svcs.security.acl.client.AclService aclService) {
        this.aclService = aclService;
    }

    @Required
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Required
    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    @Required
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public Acl getAcl(String id) throws AclNotFoundException {
        Assert.hasText((String)id, (String)"Id is required.");
        try {
            RepositoryItem repoItem = this.validateItemForAcl(id, false);
            return this.toApiAcl(this.aclService.getAcl((AclSecurable)repoItem));
        }
        catch (RepositoryItemNotFoundException | com.sas.lsaf.svcs.security.acl.client.exception.AclNotFoundException e) {
            throw new AclNotFoundException(e.getLocalizedMessage());
        }
        catch (IllegalTypeException | AclNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public DefaultAcl getDefaultAcl(String id) throws AclNotFoundException {
        Assert.hasText((String)id, (String)"Id is required.");
        try {
            RepositoryItem repoItem = this.validateItemForAcl(id, true);
            return this.toApiDefaultAcl(this.aclService.getDefaultAcl((DefaultAclSecurable)((RepositoryContainer)repoItem)));
        }
        catch (RepositoryItemNotFoundException | com.sas.lsaf.svcs.security.acl.client.exception.AclNotFoundException e) {
            throw new AclNotFoundException(e.getLocalizedMessage());
        }
        catch (IllegalTypeException | AclNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Acl updateAcl(Acl acl) throws AclUpdateException, AclNotFoundException {
        Assert.notNull((Object)acl, (String)"Acl is required to update an acl, null value specified");
        Assert.notNull((Object)acl.getOwningObjectIdentity(), (String)"Owning object identity is required.");
        Assert.hasText((String)acl.getOwningObjectIdentity().getId(), (String)"Id on Owning object identity is required.");
        this.validateAcl((AbstractAcl)acl);
        try {
            this.validateItemForAcl(acl.getOwningObjectIdentity().getId(), false);
            return this.toApiAcl(this.aclService.updateAcl(this.toServerAcl(acl)));
        }
        catch (com.sas.lsaf.svcs.security.acl.client.exception.AclUpdateException | GroupNotFoundException | UserNotFoundException e) {
            throw new AclUpdateException(e.getLocalizedMessage());
        }
        catch (RepositoryItemNotFoundException | com.sas.lsaf.svcs.security.acl.client.exception.AclNotFoundException e) {
            throw new AclNotFoundException(e.getLocalizedMessage());
        }
        catch (IllegalTypeException | AclNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public DefaultAcl updateDefaultAcl(DefaultAcl acl) throws AclUpdateException, AclNotFoundException {
        Assert.notNull((Object)acl, (String)"Acl is required to update an acl, null value specified");
        Assert.notNull((Object)acl.getOwningObjectIdentity(), (String)"Owning object identity is required.");
        Assert.hasText((String)acl.getOwningObjectIdentity().getId(), (String)"Id on Owning object identity is required.");
        this.validateAcl((AbstractAcl)acl);
        try {
            this.validateItemForAcl(acl.getOwningObjectIdentity().getId(), true);
            return this.toApiDefaultAcl(this.aclService.updateDefaultAcl(this.toServerDefaultAcl(acl)));
        }
        catch (com.sas.lsaf.svcs.security.acl.client.exception.AclUpdateException | GroupNotFoundException | UserNotFoundException e) {
            throw new AclUpdateException(e.getLocalizedMessage());
        }
        catch (RepositoryItemNotFoundException | com.sas.lsaf.svcs.security.acl.client.exception.AclNotFoundException e) {
            throw new AclNotFoundException(e.getLocalizedMessage());
        }
        catch (IllegalTypeException | AclNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

