/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.acl.impl;

import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.security.acl.AclEntry;
import com.sas.lsaf.security.acl.DefaultAcl;
import com.sas.lsaf.svcs.security.acl.client.AclEntry;
import com.sas.lsaf.svcs.security.acl.client.DefaultAcl;

public abstract class AclHelper {
    public static AclEntry.PermissionValue toApiPermValue(AclEntry.PermissionValue serverPermissionValue) {
        switch (serverPermissionValue) {
            case TRUE: {
                return AclEntry.PermissionValue.TRUE;
            }
            case FALSE: {
                return AclEntry.PermissionValue.FALSE;
            }
            case DENY: {
                return AclEntry.PermissionValue.DENY;
            }
        }
        throw new SystemException("Unmapped server acl entry permission type: " + serverPermissionValue.name());
    }

    public static AclEntry.PermissionValue toServerPermValue(AclEntry.PermissionValue apiPermissionValue) {
        if (apiPermissionValue == null) {
            return null;
        }
        switch (apiPermissionValue) {
            case TRUE: {
                return AclEntry.PermissionValue.TRUE;
            }
            case FALSE: {
                return AclEntry.PermissionValue.FALSE;
            }
            case DENY: {
                return AclEntry.PermissionValue.DENY;
            }
        }
        throw new SystemException("Unmapped acl entry permission type: " + apiPermissionValue.name());
    }

    public static DefaultAcl.OwnerPropagation toApiOwnerPropagation(DefaultAcl.OwnerPropagation serverItem) {
        switch (serverItem) {
            case CREATOR: {
                return DefaultAcl.OwnerPropagation.CREATOR;
            }
            case USER: {
                return DefaultAcl.OwnerPropagation.USER;
            }
        }
        throw new SystemException("Unmapped owner propagation type: " + serverItem.name());
    }

    public static DefaultAcl.OwnerPropagation toServerOwnerPropagation(DefaultAcl.OwnerPropagation apiItem) {
        switch (apiItem) {
            case CREATOR: {
                return DefaultAcl.OwnerPropagation.CREATOR;
            }
            case USER: {
                return DefaultAcl.OwnerPropagation.USER;
            }
        }
        throw new SystemException("Unmapped owner propagation type: " + apiItem.name());
    }
}

