/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.schedule.impl;

import com.sas.lsaf.core.AccessDeniedException;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.ResourceUtils;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.execution.job.impl.JobHelper;
import com.sas.lsaf.schedule.Schedulable;
import com.sas.lsaf.schedule.Schedule;
import com.sas.lsaf.schedule.ScheduleDescriptor;
import com.sas.lsaf.schedule.ScheduleException;
import com.sas.lsaf.schedule.ScheduleJobInfo;
import com.sas.lsaf.schedule.ScheduleNotFoundException;
import com.sas.lsaf.schedule.ScheduleService;
import com.sas.lsaf.schedule.ScheduleTrigger;
import com.sas.lsaf.schedule.impl.ScheduleHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryContext;
import com.sas.lsaf.svcs.content.repository.server.InternalRepositoryService;
import com.sas.lsaf.svcs.core.common.client.exception.ObjectNotFoundException;
import com.sas.lsaf.svcs.execution.job.client.JobService;
import com.sas.lsaf.svcs.scheduler.client.ScheduleManagementService;
import com.sas.lsaf.svcs.scheduler.client.SchedulerPrivileges;
import com.sas.lsaf.svcs.security.authentication.server.ServerSecurityContext;
import com.sas.lsaf.svcs.security.authorization.client.AuthorizationService;
import com.sas.lsaf.svcs.security.authorization.client.Securable;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ScheduleServiceImpl
implements ScheduleService {
    private ScheduleManagementService scheduleManagementService;
    private JobService jobService;
    private AuthorizationService authorizationService;
    private InternalRepositoryService internalRepositoryService;

    @Required
    public void setScheduleManagementService(ScheduleManagementService scheduleManagementService) {
        this.scheduleManagementService = scheduleManagementService;
    }

    @Required
    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }

    @Required
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Required
    public void setInternalRepositoryService(InternalRepositoryService internalRepositoryService) {
        this.internalRepositoryService = internalRepositoryService;
    }

    public Schedule createSchedule(String name, String description, Schedulable schedulable, ScheduleTrigger trigger) throws ScheduleException {
        Assert.hasText((String)name, (String)"Schedule name is required.");
        Assert.notNull((Object)schedulable, (String)"Schedulable is required.");
        Assert.notNull((Object)trigger, (String)"Trigger is required.");
        try {
            this.validateSchedulable(schedulable);
            return ScheduleHelper.toApiSchedule(this.scheduleManagementService.createSchedule(ScheduleHelper.toServerSchedule(name, description, schedulable, trigger)));
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            throw new ScheduleException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Schedule updateSchedule(Schedule schedule) throws ScheduleException, ScheduleNotFoundException {
        Assert.notNull((Object)schedule, (String)"Schedule is required.");
        Assert.notNull((Object)schedule.getSchedulable(), (String)"Schedulable is required.");
        Assert.isTrue((boolean)(schedule.getSchedulable() instanceof ScheduleJobInfo), (String)"Schedulable must be of type ScheduleJobInfo.");
        Assert.notNull((Object)schedule.getTrigger(), (String)"Trigger is required.");
        try {
            this.validateSchedulable(schedule.getSchedulable());
            return ScheduleHelper.toApiSchedule(this.scheduleManagementService.updateSchedule(ScheduleHelper.toServerSchedule(schedule)));
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            throw new ScheduleException(e.getLocalizedMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ScheduleNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void deleteSchedule(String id) throws ScheduleException, ScheduleNotFoundException {
        Assert.hasText((String)id, (String)"Schedule id is required .");
        try {
            this.scheduleManagementService.deleteScheduleById(id);
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            throw new ScheduleException(e.getLocalizedMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ScheduleNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Schedule getSchedule(String id) throws ScheduleException, ScheduleNotFoundException {
        Assert.hasText((String)id, (String)"Schedule id is required.");
        try {
            com.sas.lsaf.svcs.scheduler.client.Schedule sched = this.scheduleManagementService.getScheduleById(id);
            this.checkPrivileges(sched.getOwner());
            return ScheduleHelper.toApiSchedule(sched);
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            throw new ScheduleException(e.getLocalizedMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ScheduleNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<ScheduleDescriptor> getAllSchedules() throws ScheduleException {
        try {
            this.checkManageAllPrivilege();
            return ScheduleHelper.toApiScheduleDescriptors(this.scheduleManagementService.getAllSchedules());
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            throw new ScheduleException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<ScheduleDescriptor> getCurrentUserSchedules() throws ScheduleException {
        try {
            return ScheduleHelper.toApiScheduleDescriptors(this.scheduleManagementService.getSchedules());
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            throw new ScheduleException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void pauseSchedule(String id) throws ScheduleException, ScheduleNotFoundException {
        Assert.hasText((String)id, (String)"Schedule id is required.");
        try {
            this.scheduleManagementService.pauseScheduleById(id);
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            throw new ScheduleException(e.getLocalizedMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ScheduleNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void resumeSchedule(String id) throws ScheduleException, ScheduleNotFoundException {
        Assert.hasText((String)id, (String)"Schedule id is required.");
        try {
            this.scheduleManagementService.resumeScheduleById(id);
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            throw new ScheduleException(e.getLocalizedMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ScheduleNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean scheduleExists(String scheduleName) {
        Assert.hasText((String)scheduleName, (String)"Schedule name is required to look up a schedule, blank value specified");
        boolean exists = false;
        try {
            List schedules = null;
            try {
                schedules = this.scheduleManagementService.getAllSchedules();
            }
            catch (com.sas.lsaf.svcs.security.authorization.client.exception.AccessDeniedException e) {
                schedules = this.scheduleManagementService.getSchedules();
            }
            for (com.sas.lsaf.svcs.scheduler.client.ScheduleDescriptor schedule : schedules) {
                if (!schedule.getName().equals(scheduleName)) continue;
                exists = true;
                break;
            }
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            return false;
        }
        catch (com.sas.lsaf.svcs.security.authorization.client.exception.AccessDeniedException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return exists;
    }

    public boolean isRepositoryJobScheduled(String jobPath) {
        Assert.hasText((String)jobPath, (String)"Job path is required to determine if a job is scheduled, blank value specified");
        try {
            List schedules = null;
            try {
                schedules = this.scheduleManagementService.getAllSchedules();
            }
            catch (com.sas.lsaf.svcs.security.authorization.client.exception.AccessDeniedException e) {
                schedules = this.scheduleManagementService.getSchedules();
            }
            for (com.sas.lsaf.svcs.scheduler.client.ScheduleDescriptor schedule : schedules) {
                String jobUri = schedule.getJob().getUri();
                if (!ResourceUtils.isRepositoryFile(jobUri) || !ResourceUtils.getPath(jobUri, true).equals(jobPath)) continue;
                return true;
            }
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            return false;
        }
        catch (com.sas.lsaf.svcs.security.authorization.client.exception.AccessDeniedException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return false;
    }

    public boolean isWorkspaceJobScheduled(String jobPath) {
        Assert.hasText((String)jobPath, (String)"Job path is required to determine if a job is scheduled, blank value specified.");
        try {
            List schedules = null;
            try {
                schedules = this.scheduleManagementService.getAllSchedules();
            }
            catch (com.sas.lsaf.svcs.security.authorization.client.exception.AccessDeniedException e) {
                schedules = this.scheduleManagementService.getSchedules();
            }
            for (com.sas.lsaf.svcs.scheduler.client.ScheduleDescriptor schedule : schedules) {
                String jobUri = schedule.getJob().getUri();
                if (!ResourceUtils.isWorkspaceFile(jobUri) || !ResourceUtils.getPath(jobUri, true).equals(jobPath)) continue;
                return true;
            }
        }
        catch (com.sas.lsaf.svcs.scheduler.client.ScheduleException e) {
            return false;
        }
        catch (com.sas.lsaf.svcs.security.authorization.client.exception.AccessDeniedException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return false;
    }

    private void checkPrivileges(String owner) throws Exception {
        String currentUserId = ServerSecurityContext.getCurrentUserId();
        RepositoryContext tenant = this.internalRepositoryService.internalGetContextByPath("/");
        if (!owner.equals(currentUserId)) {
            if (!this.authorizationService.hasPrivilege((Securable)tenant, SchedulerPrivileges.PRIVILEGE_MANAGE_ALL_SCHEDULES)) {
                throw new AccessDeniedException("You cannot perform this action. You have not been granted the privilege " + SchedulerPrivileges.PRIVILEGE_MANAGE_ALL_SCHEDULES.getName() + ".");
            }
        } else if (!this.authorizationService.hasPrivilege((Securable)tenant, SchedulerPrivileges.PRIVILEGE_MANAGE_ALL_SCHEDULES) && !this.authorizationService.hasPrivilege((Securable)tenant, SchedulerPrivileges.PRIVILEGE_MANAGE_SCHEDULES)) {
            throw new AccessDeniedException("You cannot perform this action. You have not been granted the privilege " + SchedulerPrivileges.PRIVILEGE_MANAGE_ALL_SCHEDULES.getName() + " or " + SchedulerPrivileges.PRIVILEGE_MANAGE_SCHEDULES.getName() + ".");
        }
    }

    private void checkManageAllPrivilege() throws Exception {
        RepositoryContext tenant = this.internalRepositoryService.internalGetContextByPath("/");
        if (!this.authorizationService.hasPrivilege((Securable)tenant, SchedulerPrivileges.PRIVILEGE_MANAGE_ALL_SCHEDULES)) {
            throw new AccessDeniedException("You cannot perform this action. You have not been granted the privilege " + SchedulerPrivileges.PRIVILEGE_MANAGE_ALL_SCHEDULES.getName() + ".");
        }
    }

    private void validateSchedulable(Schedulable schedulable) {
        Assert.isTrue((boolean)(schedulable instanceof ScheduleJobInfo), (String)"Schedulable must be of type ScheduleJobInfo.");
        ScheduleJobInfo scheduleJobInfo = (ScheduleJobInfo)schedulable;
        Assert.hasText((String)scheduleJobInfo.getPath(), (String)"Job path is required on ScheduleJobInfo.");
        Assert.notNull((Object)scheduleJobInfo.getSourceLocation(), (String)"Job SourceLocation is required on ScheduleJobInfo.");
        JobHelper.validateJobInfo(scheduleJobInfo.getPath(), scheduleJobInfo.getVersion(), SourceLocation.REPOSITORY.equals((Object)scheduleJobInfo.getSourceLocation()), scheduleJobInfo.getParameterValues(), this.jobService);
    }
}

