/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.schedule.impl;

import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.execution.job.Job;
import com.sas.lsaf.execution.job.impl.JobHelper;
import com.sas.lsaf.schedule.Schedulable;
import com.sas.lsaf.schedule.Schedule;
import com.sas.lsaf.schedule.ScheduleDescriptor;
import com.sas.lsaf.schedule.ScheduleJobInfo;
import com.sas.lsaf.schedule.ScheduleTrigger;
import com.sas.lsaf.svcs.content.resource.server.ResourceUtils;
import com.sas.lsaf.svcs.scheduler.client.ScheduleDescriptor;
import com.sas.lsaf.svcs.scheduler.client.ScheduleTrigger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ScheduleHelper {
    public static com.sas.lsaf.svcs.scheduler.client.Schedule toServerSchedule(String name, String description, Schedulable apiSchedulable, ScheduleTrigger trigger) {
        com.sas.lsaf.svcs.scheduler.client.Schedule serverSched = new com.sas.lsaf.svcs.scheduler.client.Schedule();
        serverSched.setName(name);
        serverSched.setDescription(description);
        serverSched.setSchedulable(ScheduleHelper.toServerSchedulable(apiSchedulable));
        serverSched.setTrigger(ScheduleHelper.toServerTrigger(trigger));
        return serverSched;
    }

    public static com.sas.lsaf.svcs.scheduler.client.Schedule toServerSchedule(Schedule apiSchedule) {
        com.sas.lsaf.svcs.scheduler.client.Schedule serverSched = new com.sas.lsaf.svcs.scheduler.client.Schedule();
        serverSched.setName(apiSchedule.getName());
        serverSched.setDescription(apiSchedule.getDescription());
        serverSched.setId(apiSchedule.getId());
        serverSched.setOwner(apiSchedule.getOwner());
        serverSched.setSchedulable(ScheduleHelper.toServerSchedulable(apiSchedule.getSchedulable()));
        serverSched.setTrigger(ScheduleHelper.toServerTrigger(apiSchedule.getTrigger()));
        serverSched.setStatus(ScheduleHelper.toServerScheduleStatus(apiSchedule.getStatus()));
        return serverSched;
    }

    public static com.sas.lsaf.svcs.scheduler.client.ScheduleTrigger toServerTrigger(ScheduleTrigger apiTrigger) {
        if (apiTrigger == null) {
            return null;
        }
        com.sas.lsaf.svcs.scheduler.client.ScheduleTrigger serverTrigger = new com.sas.lsaf.svcs.scheduler.client.ScheduleTrigger();
        serverTrigger.setTriggerType(ScheduleHelper.toServerTriggerType(apiTrigger.getTriggerType()));
        serverTrigger.setDaysOfWeek(ScheduleHelper.toServerDaysOfWeek(apiTrigger.getDaysOfWeek()));
        serverTrigger.setEndDate(apiTrigger.getEndDate());
        serverTrigger.setInterval(apiTrigger.getInterval());
        serverTrigger.setNumOccurrences(apiTrigger.getNumOccurrences());
        serverTrigger.setRepeatForever(apiTrigger.getRepeatForever());
        serverTrigger.setStartDate(apiTrigger.getStartDate());
        return serverTrigger;
    }

    public static ScheduleTrigger toApiTrigger(com.sas.lsaf.svcs.scheduler.client.ScheduleTrigger serverTrigger) {
        ScheduleTrigger apiTrigger = new ScheduleTrigger();
        apiTrigger.setTriggerType(ScheduleHelper.toApiTriggerType(serverTrigger.getTriggerType()));
        apiTrigger.setDaysOfWeek(ScheduleHelper.toApiDaysOfWeek(serverTrigger.getDaysOfWeek()));
        apiTrigger.setEndDate(serverTrigger.getEndDate());
        apiTrigger.setInterval(serverTrigger.getInterval());
        apiTrigger.setNumOccurrences(serverTrigger.getNumOccurrences());
        apiTrigger.setRepeatForever(serverTrigger.isRepeatForever());
        apiTrigger.setStartDate(serverTrigger.getStartDate());
        return apiTrigger;
    }

    public static Schedule toApiSchedule(com.sas.lsaf.svcs.scheduler.client.Schedule serverSchedule) {
        if (serverSchedule == null) {
            return null;
        }
        return new Schedule(serverSchedule.getId(), serverSchedule.getName(), serverSchedule.getDescription(), serverSchedule.getOwner(), ScheduleHelper.toApiScheduleStatus(serverSchedule.getStatus()), serverSchedule.getJob() != null ? serverSchedule.getJob().getUri() : null, serverSchedule.getScheduledDate(), ScheduleHelper.toApiSchedulable(serverSchedule.getSchedulable()), ScheduleHelper.toApiTrigger(serverSchedule.getTrigger()));
    }

    public static ScheduleDescriptor toApiScheduleDescriptor(com.sas.lsaf.svcs.scheduler.client.ScheduleDescriptor serverSchedule) {
        if (serverSchedule == null) {
            return null;
        }
        return new ScheduleDescriptor(serverSchedule.getId(), serverSchedule.getName(), serverSchedule.getDescription(), serverSchedule.getOwner(), ScheduleHelper.toApiScheduleStatus(serverSchedule.getStatus()), serverSchedule.getJob() != null ? serverSchedule.getJob().getUri() : null, serverSchedule.getScheduledDate());
    }

    public static Schedulable toApiSchedulable(com.sas.lsaf.svcs.scheduler.client.Schedulable serverSchedulable) {
        com.sas.lsaf.svcs.execution.job.client.ScheduleJobInfo serverScheduleJobInfo = (com.sas.lsaf.svcs.execution.job.client.ScheduleJobInfo)serverSchedulable;
        String uri = null;
        String path = null;
        String version = null;
        SourceLocation sourceLocation = null;
        if (serverScheduleJobInfo.getJobUri() != null) {
            uri = serverScheduleJobInfo.getJobUri();
            path = ResourceUtils.getPath((String)uri);
            version = ResourceUtils.getVersion((String)uri);
            sourceLocation = ResourceUtils.isRepositoryFile((String)uri) ? SourceLocation.REPOSITORY : SourceLocation.WORKSPACE;
        }
        Job job = new Job(path, version);
        job.setSourceLocation(sourceLocation);
        ScheduleJobInfo apiSchedJobInfo = new ScheduleJobInfo(job);
        apiSchedJobInfo.setParameterValues(JobHelper.toApiParameterValues(serverScheduleJobInfo.getParamValues()));
        return apiSchedJobInfo;
    }

    private static com.sas.lsaf.svcs.scheduler.client.Schedulable toServerSchedulable(Schedulable apiSchedulable) {
        if (apiSchedulable == null) {
            return null;
        }
        com.sas.lsaf.svcs.execution.job.client.ScheduleJobInfo serverScheduleJobInfo = new com.sas.lsaf.svcs.execution.job.client.ScheduleJobInfo();
        ScheduleJobInfo apiScheduleJobInfo = (ScheduleJobInfo)apiSchedulable;
        String jobUri = null;
        jobUri = apiScheduleJobInfo.getSourceLocation() == SourceLocation.REPOSITORY ? ResourceUtils.toRepositoryUri((String)apiScheduleJobInfo.getPath(), null, apiScheduleJobInfo.getVersion() != null ? apiScheduleJobInfo.getVersion().trim() : null) : ResourceUtils.toWorkspaceUri((String)apiScheduleJobInfo.getPath(), null);
        serverScheduleJobInfo.setJobUri(jobUri);
        List parmValues = null;
        if (apiSchedulable instanceof ScheduleJobInfo) {
            parmValues = ((ScheduleJobInfo)apiSchedulable).getParameterValues();
        }
        serverScheduleJobInfo.setParamValues(JobHelper.toServerParameterValues(parmValues));
        return serverScheduleJobInfo;
    }

    public static Set<ScheduleDescriptor> toApiScheduleDescriptors(List<com.sas.lsaf.svcs.scheduler.client.ScheduleDescriptor> serverScheduleDescriptors) {
        LinkedHashSet<ScheduleDescriptor> apiSchedDescs = new LinkedHashSet<ScheduleDescriptor>();
        for (com.sas.lsaf.svcs.scheduler.client.ScheduleDescriptor serverSchedDesc : serverScheduleDescriptors) {
            apiSchedDescs.add(ScheduleHelper.toApiScheduleDescriptor(serverSchedDesc));
        }
        return apiSchedDescs;
    }

    private static ScheduleTrigger.DayOfWeek toServerDayOfWeek(ScheduleTrigger.DayOfWeek apiDayOfWeek) {
        if (apiDayOfWeek == null) {
            return null;
        }
        switch (apiDayOfWeek) {
            case MON: {
                return ScheduleTrigger.DayOfWeek.MON;
            }
            case TUE: {
                return ScheduleTrigger.DayOfWeek.TUE;
            }
            case WED: {
                return ScheduleTrigger.DayOfWeek.WED;
            }
            case THU: {
                return ScheduleTrigger.DayOfWeek.THU;
            }
            case FRI: {
                return ScheduleTrigger.DayOfWeek.FRI;
            }
            case SAT: {
                return ScheduleTrigger.DayOfWeek.SAT;
            }
            case SUN: {
                return ScheduleTrigger.DayOfWeek.SUN;
            }
        }
        throw new SystemException("Unmapped api day of week: " + apiDayOfWeek.name());
    }

    private static List<ScheduleTrigger.DayOfWeek> toServerDaysOfWeek(Set<ScheduleTrigger.DayOfWeek> apiDaysOfWeek) {
        if (apiDaysOfWeek == null) {
            return null;
        }
        ArrayList<ScheduleTrigger.DayOfWeek> serverDaysOfWeek = new ArrayList<ScheduleTrigger.DayOfWeek>();
        for (ScheduleTrigger.DayOfWeek apiDayOfWeek : apiDaysOfWeek) {
            serverDaysOfWeek.add(ScheduleHelper.toServerDayOfWeek(apiDayOfWeek));
        }
        return serverDaysOfWeek;
    }

    private static ScheduleTrigger.DayOfWeek toApiDayOfWeek(ScheduleTrigger.DayOfWeek serverDayOfWeek) {
        if (serverDayOfWeek == null) {
            return null;
        }
        switch (serverDayOfWeek) {
            case MON: {
                return ScheduleTrigger.DayOfWeek.MON;
            }
            case TUE: {
                return ScheduleTrigger.DayOfWeek.TUE;
            }
            case WED: {
                return ScheduleTrigger.DayOfWeek.WED;
            }
            case THU: {
                return ScheduleTrigger.DayOfWeek.THU;
            }
            case FRI: {
                return ScheduleTrigger.DayOfWeek.FRI;
            }
            case SAT: {
                return ScheduleTrigger.DayOfWeek.SAT;
            }
            case SUN: {
                return ScheduleTrigger.DayOfWeek.SUN;
            }
        }
        throw new SystemException("Unmapped server day of week: " + serverDayOfWeek.name());
    }

    private static Set<ScheduleTrigger.DayOfWeek> toApiDaysOfWeek(List<ScheduleTrigger.DayOfWeek> serverDaysOfWeek) {
        if (serverDaysOfWeek == null) {
            return null;
        }
        LinkedHashSet<ScheduleTrigger.DayOfWeek> apiDaysOfWeek = new LinkedHashSet<ScheduleTrigger.DayOfWeek>();
        for (ScheduleTrigger.DayOfWeek serverDayOfWeek : serverDaysOfWeek) {
            apiDaysOfWeek.add(ScheduleHelper.toApiDayOfWeek(serverDayOfWeek));
        }
        return apiDaysOfWeek;
    }

    private static ScheduleTrigger.TriggerType toServerTriggerType(ScheduleTrigger.TriggerType apiTriggerType) {
        if (apiTriggerType == null) {
            return null;
        }
        switch (apiTriggerType) {
            case ONCE: {
                return ScheduleTrigger.TriggerType.ONCE;
            }
            case DAILY: {
                return ScheduleTrigger.TriggerType.DAILY;
            }
            case HOURLY: {
                return ScheduleTrigger.TriggerType.HOURLY;
            }
            case MINUTELY: {
                return ScheduleTrigger.TriggerType.MINUTELY;
            }
            case WEEKLY: {
                return ScheduleTrigger.TriggerType.WEEKLY;
            }
        }
        throw new SystemException("Unmapped api trigger type: " + apiTriggerType.name());
    }

    private static ScheduleTrigger.TriggerType toApiTriggerType(ScheduleTrigger.TriggerType serverTriggerType) {
        if (serverTriggerType == null) {
            return null;
        }
        switch (serverTriggerType) {
            case ONCE: {
                return ScheduleTrigger.TriggerType.ONCE;
            }
            case DAILY: {
                return ScheduleTrigger.TriggerType.DAILY;
            }
            case HOURLY: {
                return ScheduleTrigger.TriggerType.HOURLY;
            }
            case MINUTELY: {
                return ScheduleTrigger.TriggerType.MINUTELY;
            }
            case WEEKLY: {
                return ScheduleTrigger.TriggerType.WEEKLY;
            }
        }
        throw new SystemException("Unmapped server trigger type: " + serverTriggerType.name());
    }

    private static ScheduleDescriptor.ScheduleStatus toApiScheduleStatus(ScheduleDescriptor.ScheduleStatus serverScheduleStatus) {
        if (serverScheduleStatus == null) {
            return null;
        }
        switch (serverScheduleStatus) {
            case NORMAL: {
                return ScheduleDescriptor.ScheduleStatus.NORMAL;
            }
            case PAUSED: {
                return ScheduleDescriptor.ScheduleStatus.PAUSED;
            }
            case JOB_NOT_AVAILABLE: {
                return ScheduleDescriptor.ScheduleStatus.JOB_NOT_AVAILABLE;
            }
            case ERROR: {
                return ScheduleDescriptor.ScheduleStatus.ERROR;
            }
        }
        throw new SystemException("Unmapped server schedule status: " + serverScheduleStatus.name());
    }

    private static ScheduleDescriptor.ScheduleStatus toServerScheduleStatus(ScheduleDescriptor.ScheduleStatus apiScheduleStatus) {
        if (apiScheduleStatus == null) {
            return null;
        }
        switch (apiScheduleStatus) {
            case NORMAL: {
                return ScheduleDescriptor.ScheduleStatus.NORMAL;
            }
            case PAUSED: {
                return ScheduleDescriptor.ScheduleStatus.PAUSED;
            }
            case JOB_NOT_AVAILABLE: {
                return ScheduleDescriptor.ScheduleStatus.JOB_NOT_AVAILABLE;
            }
            case ERROR: {
                return ScheduleDescriptor.ScheduleStatus.ERROR;
            }
        }
        throw new SystemException("Unmapped api schedule status: " + apiScheduleStatus.name());
    }
}

