/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.security.permissions.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.ExtractFileCreateInfo;
import com.sas.lsaf.query.Query;
import com.sas.lsaf.query.QueryException;
import com.sas.lsaf.query.impl.ExtractHelper;
import com.sas.lsaf.query.impl.SqlColumn;
import com.sas.lsaf.query.impl.SqlQuery;
import com.sas.lsaf.query.impl.SqlQueryHelper;
import com.sas.lsaf.query.security.permissions.PermissionsQuery;
import com.sas.lsaf.query.security.permissions.PermissionsQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class PermissionsQueryServiceImpl
implements PermissionsQueryService {
    private static final List<SqlColumn> PERMISSIONS_COLUMNS = new ArrayList<SqlColumn>();
    private static final List<SqlColumn> PERMISSIONS_MV_COLUMNS = new ArrayList<SqlColumn>();
    private static final String CURRENT_PERM_MV = "CURRENT_PERM_MV";
    private static final String DEFAULT_PERM_MV = "DEFAULT_PERM_MV";
    private ExtractHelper extractHelper;
    private SqlQueryHelper sqlQueryHelper;
    private boolean useMaterializedView;
    private static String currentPermissionsSql;
    private static final String currentPermissionsMvSql = " (select * from CURRENT_PERM_MV ) ";
    private static String defaultPermissionsSql;
    private static final String defaultPermissionsMvSql = " (select * from DEFAULT_PERM_MV ) ";

    @Required
    public void setExtractHelper(ExtractHelper extractHelper) {
        this.extractHelper = extractHelper;
    }

    @Required
    public void setSqlQueryHelper(SqlQueryHelper sqlQueryHelper) {
        this.sqlQueryHelper = sqlQueryHelper;
    }

    public void setUseMaterializedView(boolean useMaterializedView) {
        this.useMaterializedView = useMaterializedView;
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeCurrentPermissionsQuery(PermissionsQuery query, ExtractFileCreateInfo file) throws QueryException {
        this.assertPermissionsQueryArguments(query, file);
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        SqlQueryHelper.assertValidQuery((Query)query, true);
        try {
            PermissionsQuery q = (PermissionsQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, PermissionsQuery.TYPE);
            SqlQuery sqlQuery = new SqlQuery("createCurrentPermissionsExtract", (Query)q, this.getCurrentPermSqlTemplate());
            sqlQuery.addSqlColumns(this.useMaterializedView ? PERMISSIONS_MV_COLUMNS : PERMISSIONS_COLUMNS);
            if (!this.useMaterializedView) {
                sqlQuery.getParameters().add(new SqlParameterValue(1, (Object)this.sqlQueryHelper.getPropertyDefinitionId("identifier")));
                sqlQuery.getParameters().add(new SqlParameterValue(1, (Object)this.sqlQueryHelper.getPropertyDefinitionId("type")));
            }
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeDefaultPermissionsQuery(PermissionsQuery query, ExtractFileCreateInfo file) throws QueryException {
        this.assertPermissionsQueryArguments(query, file);
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        SqlQueryHelper.assertValidQuery((Query)query, true);
        try {
            PermissionsQuery q = (PermissionsQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, PermissionsQuery.TYPE);
            SqlQuery sqlQuery = new SqlQuery("createDefaultPermissionsExtract", (Query)q, this.getDefaultPermSqlTemplate());
            sqlQuery.addSqlColumns(this.useMaterializedView ? PERMISSIONS_MV_COLUMNS : PERMISSIONS_COLUMNS);
            if (!this.useMaterializedView) {
                sqlQuery.getParameters().add(new SqlParameterValue(1, (Object)this.sqlQueryHelper.getPropertyDefinitionId("identifier")));
                sqlQuery.getParameters().add(new SqlParameterValue(1, (Object)this.sqlQueryHelper.getPropertyDefinitionId("type")));
            }
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private void assertPermissionsQueryArguments(PermissionsQuery query, ExtractFileCreateInfo file) {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        Set<Column> constraintColumns = SqlQueryHelper.getColumnsFromConstraints(query.getConstraint());
        if (!constraintColumns.isEmpty()) {
            Assert.isTrue((constraintColumns.contains(PermissionsQuery.PATH) || constraintColumns.contains(PermissionsQuery.USERID) || constraintColumns.contains(PermissionsQuery.TYPE) || constraintColumns.contains(PermissionsQuery.OWNER) ? 1 : 0) != 0, (String)"Permissions query can only be subset by path, type, owner or user column.");
        }
    }

    private String getCurrentPermSqlTemplate() {
        String sqlTemplate = null;
        sqlTemplate = this.useMaterializedView ? "SELECT @SELECT FROM  (select * from CURRENT_PERM_MV ) WHERE @WHERE " : "SELECT @SELECT FROM " + currentPermissionsSql + "WHERE @WHERE )";
        return sqlTemplate;
    }

    private String getDefaultPermSqlTemplate() {
        String sqlTemplate = null;
        sqlTemplate = this.useMaterializedView ? "SELECT @SELECT FROM  (select * from DEFAULT_PERM_MV ) WHERE @WHERE " : "SELECT @SELECT FROM " + defaultPermissionsSql + "WHERE @WHERE ) ";
        return sqlTemplate;
    }

    static {
        PERMISSIONS_COLUMNS.add(new SqlColumn(PermissionsQuery.ID, 12, "ID"));
        PERMISSIONS_COLUMNS.add(new SqlColumn(PermissionsQuery.PATH, 12, "nvl(substr(path, 6), '/')", "PATH"));
        PERMISSIONS_COLUMNS.add(new SqlColumn(PermissionsQuery.USERID, 12, "USERID"));
        PERMISSIONS_COLUMNS.add(new SqlColumn(PermissionsQuery.PERMISSIONS, 12, "PERMISSIONS"));
        PERMISSIONS_COLUMNS.add(new SqlColumn(PermissionsQuery.TYPE, 12, "TYPE"));
        PERMISSIONS_COLUMNS.add(new SqlColumn(PermissionsQuery.OWNER, 12, "OWNER"));
        PERMISSIONS_MV_COLUMNS.add(new SqlColumn(PermissionsQuery.ID, 12, "ID"));
        PERMISSIONS_MV_COLUMNS.add(new SqlColumn(PermissionsQuery.PATH, 12, "PATH"));
        PERMISSIONS_MV_COLUMNS.add(new SqlColumn(PermissionsQuery.USERID, 12, "USERID"));
        PERMISSIONS_MV_COLUMNS.add(new SqlColumn(PermissionsQuery.PERMISSIONS, 12, "PERMISSIONS"));
        PERMISSIONS_MV_COLUMNS.add(new SqlColumn(PermissionsQuery.TYPE, 12, "TYPE"));
        PERMISSIONS_MV_COLUMNS.add(new SqlColumn(PermissionsQuery.OWNER, 12, "OWNER"));
        currentPermissionsSql = "--  CURRENT perms -pivot the summary ACE records to path, userid and concatenated permission flags\r\n( select sace.id, sace.path, sace.type, sace.owner, sace.userid,\r\n    decode(nvl(sace.DA, 0) + nvl(sace.A, 0), -16, 'x', 0, '-', 16, 'A') ||\r\n    decode(nvl(sace.DR, 0) + nvl(sace.R, 0), -1, 'x', 0, '-', 1, 'R') ||\r\n    decode(nvl(sace.DP, 0) + nvl(sace.P, 0), -2, 'x', 0, '-', 2, 'P') ||\r\n    decode(nvl(sace.DC, 0) + nvl(sace.C, 0), -4, 'x', 0, '-', 4, 'C') ||\r\n    decode(nvl(sace.DD, 0) + nvl(sace.D, 0), -8, 'x', 0, '-', 8, 'D') as permissions\r\n  from (\r\n    \r\n    -- build summary ACE records by path, userid which enforces weighted permission scheme values for O/U/G/M ACES\r\n    select wace.id id, wace.path path, wace.type type, wace.owner owner, wace.userid userid, decode(mod(max(wace.wmask),2), 0, wace.mask, 0 - wace.mask) mask\r\n      from (\r\n        \r\n        -- build ACE records per userid by concatenating the userids found from individual O/U/G/M ACES\r\n        select ace.id, ace.path, ace.type, ace.owner, ace.o_uid || svg.userid || svm.userid || ace.u_uid userid, ace.mask, ace.wmask\r\n          from\r\n            -- recursive group resolution\r\n           (select connect_by_root group_id group_id, su.userid \r\n              from sas_group_member sgm, sas_user su \r\n             where principal_type = 'sas:user' \r\n               and su.id (+)= principal_id \r\n           connect by prior sgm.principal_id = sgm.group_id) svg,\r\n            \r\n            -- membership resolution\r\n           (select distinct smm.membership_id membership_id, svg.userid || su.userid userid\r\n              from sas_membership_member smm, sas_user su, (\r\n              \r\n                -- recursive group resolution for membership\r\n                select connect_by_root group_id group_id, su.userid \r\n                  from sas_group_member sgm, sas_user su \r\n                 where principal_type = 'sas:user' \r\n                   and su.id (+)= principal_id \r\n                   and su.userid is not null \r\n               connect by prior sgm.principal_id = sgm.group_id) svg\r\n               \r\n             where su.id (+)= smm.principal_id\r\n               and svg.group_id (+)= smm.principal_id                and (svg.userid || su.userid) is not null) svm, (\r\n            -- core SQL which pulls id, path and raw ACE data\r\n            select svp.id id, o_asid.sid owner, svp.path path, svp.type type, \r\n                   decode(substr(asid.sid, 1, 6), 'OWNER_', substr(asid.sid, 7), null) o_uid, -- parse owner userid (no lookup)\r\n                   decode(substr(asid.sid, 1, 6), 'GROUP_', substr(asid.sid, 7), null) gid, -- parse group ids \r\n                   decode(substr(asid.sid, 1, 6), 'MEMBER', substr(asid.sid, 9), null) mid, -- parse membership id\r\n                   decode(substr(asid.sid, 1, 6), 'OWNER_', null, 'GROUP_', null, 'MEMBER', null, asid.sid) u_uid, -- not owner, group or membership so explicit user id\r\n                   mask, granting,\r\n                   decode(substr(asid.sid, 1, 6), 'OWNER_', decode(granting, 1, 6, 7), 'GROUP_', decode(granting, 1, 2, 3), 'MEMBER', decode(granting, 1, 0, 1), decode(granting, 1, 4, 5)) wmask -- determine weighted mask values based on O/U/G/M ACES\r\n              from acl_object_identity aoi, acl_entry ae, acl_sid asid, acl_sid o_asid,\r\n              \r\n                   -- maps repository ids with paths\r\n                   (select xp_id.string_value id,\r\n                           xu.full_path path,\r\n                           xp_typeid.string_value type \r\n                      from xyf_urls xu,\r\n                           xyf_files xf,\r\n                           xyf_properties xp_id, \r\n                           xyf_properties xp_typeid \r\n                     where xu.file_id = xf.file_id\r\n                       AND XU.FULL_PATH NOT LIKE '%/.trashcan%' \r\n                       AND XU.FULL_PATH NOT LIKE '/root/Users/%' \r\n                       -- idx2/3 use all columns from UK index \r\n                       AND   xp_id.property_owner_type (+) = 0 \r\n                       AND   xp_id.property_owner_id (+) = xf.file_id  \r\n                       AND   xp_id.version_number (+) = 1 \r\n                       AND   xp_id.property_definition_id (+) = ? \r\n                       AND   xp_id.value_position (+) = 0  \r\n                        -- idx2/3 use all columns from UK index \r\n                       AND   xp_typeid.property_owner_type (+) = 0 \r\n                       AND   xp_typeid.property_owner_id (+) = xf.file_id \r\n                       AND   xp_typeid.version_number (+) = 1 \r\n                        AND   xp_typeid.property_definition_id (+) = ? \r\n                       AND   xp_typeid.value_position (+) = 0) svp  \r\n             where to_char(svp.id) = aoi.object_id_identity\r\n               and ae.acl_object_identity = aoi.id\r\n               and ae.mask <> 256\r\n               and ae.sid = asid.id\r\n               and aoi.owner_sid = o_asid.id \r\n               ) ace -- raw ACEs\r\n               \r\n         where svg.group_id (+)= gid\r\n           and svm.membership_id (+)= mid\r\n           ) wace -- weighted ACEs \r\n           \r\n     group by wace.id, wace.path, wace.type, wace.owner, wace.userid, wace.mask order by wace.userid, wace.mask\r\n\r\n    ) pivot ( \r\n      max(mask)\r\n      for mask in ( -1 DR, 1 R, -2 DP, 2 P, -4 DC, 4 C, -8 DD, 8 D, -16 DA, 16 A)\r\n    ) sace -- summary ACEs\r\n";
        defaultPermissionsSql = "-- DEFAULT perms - pivot the summary ACE records to path, userid and concatenated permission flags\r\n( select sace.id, sace.path, sace.type, sace.owner, sace.userid,\r\n    decode(nvl(sace.DA, 0) + nvl(sace.A, 0), -16, 'x', 0, '-', 16, 'A') ||\r\n    decode(nvl(sace.DR, 0) + nvl(sace.R, 0), -1, 'x', 0, '-', 1, 'R') ||\r\n    decode(nvl(sace.DP, 0) + nvl(sace.P, 0), -2, 'x', 0, '-', 2, 'P') ||\r\n    decode(nvl(sace.DC, 0) + nvl(sace.C, 0), -4, 'x', 0, '-', 4, 'C') ||\r\n    decode(nvl(sace.DD, 0) + nvl(sace.D, 0), -8, 'x', 0, '-', 8, 'D') as permissions \r\n  from (\r\n    \r\n    -- build summary ACE records by path, userid which enforces weighted permission scheme values for O/U/G/M ACES\r\n    select wace.id id, wace.path path, wace.type type, wace.owner owner, wace.userid userid, decode(mod(max(wace.wmask),2), 0, wace.mask, 0 - wace.mask) mask\r\n      from (\r\n        \r\n        -- build ACE records per userid by concatenating the userids found from individual O/U/G/M ACES\r\n        select ace.id, ace.path, ace.type, ace.owner, ace.o_uid || svg.userid || svm.userid || ace.u_uid userid, ace.mask, ace.wmask\r\n          from\r\n            -- recursive group resolution\r\n           (select connect_by_root group_id group_id, su.userid \r\n              from sas_group_member sgm, sas_user su \r\n             where principal_type = 'sas:user' \r\n               and su.id (+)= principal_id \r\n               and su.userid is not null \r\n           connect by prior sgm.principal_id = sgm.group_id) svg,\r\n            \r\n            -- membership resolution\r\n           (select distinct smm.membership_id membership_id, svg.userid || su.userid userid\r\n              from sas_membership_member smm, sas_user su, (\r\n              \r\n                -- recursive group resolution for membership\r\n                select connect_by_root group_id group_id, su.userid \r\n                  from sas_group_member sgm, sas_user su \r\n                 where principal_type = 'sas:user' \r\n                   and su.id (+)= principal_id \r\n                   and su.userid IS NOT NULL \r\n               connect by prior sgm.principal_id = sgm.group_id) svg\r\n               \r\n             where su.id (+)= smm.principal_id\r\n               and svg.group_id (+)= smm.principal_id                and (svg.userid || su.userid) is not null) svm, (\r\n            -- core SQL which pulls id, path and raw ACE data\r\n            select svp.id id, o_asid.sid owner, svp.path path, svp.type type, \r\n                   decode(substr(asid.sid, 1, 6), 'OWNER_', o_asid.sid, null) o_uid, -- owner userid (no lookup)\r\n                   decode(substr(asid.sid, 1, 6), 'GROUP_', substr(asid.sid, 7), null) gid, -- parse group ids \r\n                   decode(substr(asid.sid, 1, 6), 'MEMBER', substr(asid.sid, 9), null) mid, -- parse membership id\r\n                   decode(substr(asid.sid, 1, 6), 'OWNER_', null, 'GROUP_', null, 'MEMBER', null, asid.sid) u_uid, -- not owner, group or membership so explicit user id\r\n                   mask, granting,\r\n                   decode(substr(asid.sid, 1, 6), 'OWNER_', decode(granting, 1, 6, 7), 'GROUP_', decode(granting, 1, 2, 3), 'MEMBER', decode(granting, 1, 0, 1), decode(granting, 1, 4, 5)) wmask -- determine weighted mask values based on O/U/G/M ACES\r\n              from acl_object_identity aoi, acl_entry ae, acl_sid asid, acl_sid o_asid,\r\n              \r\n                   -- maps repository ids with paths\r\n                   (select xp_id.string_value id,\r\n                           xu.full_path path,\r\n                           xp_typeid.string_value type \r\n                      from xyf_urls xu,\r\n                           xyf_files xf,\r\n                           xyf_properties xp_id, \r\n                           xyf_properties xp_typeid \r\n                     where xu.file_id = xf.file_id\r\n                       AND XU.FULL_PATH NOT LIKE '%/.trashcan%' \r\n                       AND XU.FULL_PATH NOT LIKE '/root/Users/%' \r\n                       -- idx2/3 use all columns from UK index \r\n                       AND   xp_id.property_owner_type (+) = 0 \r\n                       AND   xp_id.property_owner_id (+) = xf.file_id  \r\n                       AND   xp_id.version_number (+) = 1 \r\n                       AND   xp_id.property_definition_id (+) = ? \r\n                       AND   xp_id.value_position (+) = 0  \r\n                        -- idx2/3 use all columns from UK index \r\n                       AND   xp_typeid.property_owner_type (+) = 0 \r\n                       AND   xp_typeid.property_owner_id (+) = xf.file_id \r\n                       AND   xp_typeid.version_number (+) = 1 \r\n                        AND   xp_typeid.property_definition_id (+) = ? \r\n                       AND   xp_typeid.value_position (+) = 0) svp  \r\n             -- idx4 cast nvarchar2 column to varchar \r\n             where ('DEFAULT_' || to_char(svp.id)) = aoi.object_id_identity\r\n               and ae.acl_object_identity = aoi.id\r\n               and ae.mask <> 256\r\n               and ae.sid = asid.id\r\n               and aoi.owner_sid = o_asid.id\r\n               ) ace -- raw ACEs\r\n               \r\n         where svg.group_id (+)= gid\r\n           and svm.membership_id (+)= mid\r\n           ) wace -- weighted ACEs \r\n           \r\n     group by wace.id, wace.path, wace.type, wace.owner, wace.userid, wace.mask order by wace.userid, wace.mask\r\n\r\n    ) pivot ( \r\n      max(mask)\r\n      for mask in ( -1 DR, 1 R, -2 DP, 2 P, -4 DC, 4 C, -8 DD, 8 D, -16 DA, 16 A)\r\n    ) sace -- summary ACEs\r\n";
    }
}

