/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.security.membership.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.ExtractFileCreateInfo;
import com.sas.lsaf.query.Query;
import com.sas.lsaf.query.QueryException;
import com.sas.lsaf.query.impl.ExtractHelper;
import com.sas.lsaf.query.impl.SqlColumn;
import com.sas.lsaf.query.impl.SqlQuery;
import com.sas.lsaf.query.impl.SqlQueryHelper;
import com.sas.lsaf.query.security.membership.ContextMembershipQuery;
import com.sas.lsaf.query.security.membership.ContextMembershipQueryService;
import com.sas.lsaf.query.security.membership.DistinctContextMembershipQuery;
import com.sas.lsaf.query.security.membership.MembershipQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class ContextMembershipQueryServiceImpl
implements ContextMembershipQueryService {
    private static final List<SqlColumn> MEMBERSHIP_COLUMNS = new ArrayList<SqlColumn>();
    private static final List<SqlColumn> DISTINCT_MEMBERSHIP_COLUMNS = new ArrayList<SqlColumn>();
    private static String contextPath = null;
    private ExtractHelper extractHelper;
    private static String contextMembershipSql;
    private static String distinctContextMembershipSql;

    @Required
    public void setExtractHelper(ExtractHelper extractHelper) {
        this.extractHelper = extractHelper;
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeContextMembershipQuery(ContextMembershipQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.hasText((String)query.getContextPath(), (String)"Context path is required on the query.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        SqlQueryHelper.assertValidQuery((Query)query, false);
        try {
            contextPath = query.getContextPath();
            String sqlTemplate = "SELECT @SELECT FROM " + contextMembershipSql + (query.getConstraint() == null ? "" : " WHERE @WHERE");
            SqlQuery sqlQuery = new SqlQuery("createMembershipByContextExtract", (Query)query, sqlTemplate);
            sqlQuery.addSqlColumns(MEMBERSHIP_COLUMNS);
            sqlQuery.getParameters().addAll(this.getSqlParameterValues(contextPath, query.getMembershipScope()));
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeDistinctContextMembershipQuery(DistinctContextMembershipQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.hasText((String)query.getContextPath(), (String)"Context path is required on the query.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        Set<Column> constraintColumns = SqlQueryHelper.getColumnsFromConstraints(query.getConstraint());
        Assert.isTrue((!constraintColumns.contains(MembershipQuery.EXPLICIT) && !constraintColumns.contains(DistinctContextMembershipQuery.IMPLICIT) ? 1 : 0) != 0, (String)"Distinct context membership query cannot be subset by the IMPLICIT or EXPLICIT column.");
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        SqlQueryHelper.assertValidQuery((Query)query, false);
        try {
            contextPath = query.getContextPath();
            String sqlTemplate = "SELECT @SELECT FROM " + distinctContextMembershipSql + (query.getConstraint() == null ? "" : " WHERE @WHERE");
            SqlQuery sqlQuery = new SqlQuery("createMembershipByContextExtract", (Query)query, sqlTemplate);
            sqlQuery.addSqlColumns(DISTINCT_MEMBERSHIP_COLUMNS);
            sqlQuery.getParameters().addAll(this.getSqlParameterValues(contextPath, query.getMembershipScope()));
            String groupBy = "CONTEXT_QUERIED, PRINCIPAL_NAME, PRINCIPAL_TYPE";
            SqlQueryHelper.parse(sqlQuery, groupBy);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private List<SqlParameterValue> getSqlParameterValues(String contextPath, ContextMembershipQuery.MembershipScope membershipScope) {
        ArrayList<SqlParameterValue> sqlParmValues = new ArrayList<SqlParameterValue>();
        sqlParmValues.add(new SqlParameterValue(12, (Object)contextPath));
        sqlParmValues.add(new SqlParameterValue(2, (Object)this.getAssignedScope(membershipScope)));
        sqlParmValues.add(new SqlParameterValue(12, (Object)("/root" + contextPath)));
        sqlParmValues.add(new SqlParameterValue(12, (Object)contextPath));
        sqlParmValues.add(new SqlParameterValue(2, (Object)this.getAssignedScope(membershipScope)));
        sqlParmValues.add(new SqlParameterValue(12, (Object)("/root" + contextPath)));
        return sqlParmValues;
    }

    private int getAssignedScope(ContextMembershipQuery.MembershipScope membershipScope) {
        int assignedSql = -1;
        if (membershipScope.equals((Object)ContextMembershipQuery.MembershipScope.ASSIGNED)) {
            assignedSql = 0;
        } else if (membershipScope.equals((Object)ContextMembershipQuery.MembershipScope.DEFINED)) {
            assignedSql = 1;
        }
        return assignedSql;
    }

    static {
        MEMBERSHIP_COLUMNS.add(new SqlColumn(MembershipQuery.CONTEXT_QUERIED, 12, "CONTEXT_QUERIED"));
        MEMBERSHIP_COLUMNS.add(new SqlColumn(MembershipQuery.PRINCIPAL_NAME, 12, "PRINCIPAL_NAME"));
        MEMBERSHIP_COLUMNS.add(new SqlColumn(ContextMembershipQuery.LINEAGE, 12, "LINEAGE"));
        MEMBERSHIP_COLUMNS.add(new SqlColumn(ContextMembershipQuery.LEVEL, 12, "LEV"));
        MEMBERSHIP_COLUMNS.add(new SqlColumn(MembershipQuery.PRINCIPAL_TYPE, 12, "PRINCIPAL_TYPE"));
        MEMBERSHIP_COLUMNS.add(new SqlColumn(MembershipQuery.EXPLICIT, 12, "EXPLICIT"));
        MEMBERSHIP_COLUMNS.add(new SqlColumn(ContextMembershipQuery.GROUP_CONTEXT, 12, "GROUP_CONTEXT"));
        MEMBERSHIP_COLUMNS.add(new SqlColumn(ContextMembershipQuery.PARENT_GROUP, 12, "PARENT_GROUP"));
        MEMBERSHIP_COLUMNS.add(new SqlColumn(ContextMembershipQuery.PARENT_GROUP_CONTEXT, 12, "PARENT_GROUP_CONTEXT"));
        DISTINCT_MEMBERSHIP_COLUMNS.add(new SqlColumn(MembershipQuery.CONTEXT_QUERIED, 12, "CONTEXT_QUERIED"));
        DISTINCT_MEMBERSHIP_COLUMNS.add(new SqlColumn(MembershipQuery.PRINCIPAL_NAME, 12, "PRINCIPAL_NAME"));
        DISTINCT_MEMBERSHIP_COLUMNS.add(new SqlColumn(MembershipQuery.PRINCIPAL_TYPE, 12, "PRINCIPAL_TYPE"));
        DISTINCT_MEMBERSHIP_COLUMNS.add(new SqlColumn(MembershipQuery.EXPLICIT, 12, "CASE sum(EXIMPLICIT) when 1 then 'N' else 'Y' end ", "EXPLICIT"));
        DISTINCT_MEMBERSHIP_COLUMNS.add(new SqlColumn(DistinctContextMembershipQuery.IMPLICIT, 12, "CASE sum(EXIMPLICIT) when 2 then 'N' else 'Y' end ", "IMPLICIT"));
        contextMembershipSql = " (select ? as context_queried, \r\n       sg.name || su.userid as \"PRINCIPAL_NAME\",\r\n       '0' as \"LEV\",\r\n       case smm.principal_type when 'sas:user' then TO_NCHAR(su.userid) else (sg.name || '(' || substr(xu_context.full_path, 6) || ')') end as \"LINEAGE\", \r\n       case smm.principal_type when 'sas:user' then 'User' else 'Group' end as \"PRINCIPAL_TYPE\",\r\n       'Y' as \"EXPLICIT\",\r\n     CASE WHEN smm.assigned = 0 THEN 'Y' ELSE 'N' END as DEFINED,\r\n       substr(xu.full_path, 6) \"GROUP_CONTEXT\",\r\n       null as \"PARENT_GROUP\",\r\n       null \"PARENT_GROUP_CONTEXT\"\r\n  from sas_membership sm,\r\n       sas_membership_member smm,\r\n       sas_group sg,\r\n       sas_user su,\r\n       xyf_properties xp,\r\n       xyf_urls xu,\r\n       xyf_properties xp_context,\r\n       xyf_urls xu_context\r\nwhere sm.context_id = smm.membership_id\r\n   and smm.assigned <>  ? \r\n   and sg.id (+)= smm.principal_id\r\n   and su.id (+)= smm.principal_id\r\n   and xp.string_value (+)= sg.context_id\r\n   and xu.file_id (+)= xp.property_owner_id\r\n   and xp_context.string_value = sm.context_id\r\n   and xu_context.file_id = xp_context.property_owner_id\r\n   and xu_context.full_path = ? \r\nUNION ALL\r\nselect --group_member.name || user_member.userid as \"PRINCIPAL_NAME\",\r\n? as context_queried, \r\n       group_member.name || user_member.userid \"PRINCIPAL_NAME\", \r\n       TO_CHAR(LEVEL) as \"LEV\", \r\nSUBSTR(SYS_CONNECT_BY_PATH(sg.name || '(' || substr(xu_group.full_path, 6) || ')', ' -> '), 5) || ' -> ' ||  case sgm.principal_type \r\n when 'sas:user' then TO_NCHAR(user_member.userid) \r\n  else group_member.name || '(' || substr(xu_group_member.full_path, 6) || ')' \r\n end \"LINEAGE\",\r\n        case sgm.principal_type when 'sas:user' then 'User' else 'Group' end as \"PRINCIPAL_TYPE\",\r\n       'N' as \"EXPLICIT\",\r\n       'N' as \"DEFINED\",\r\n       substr(xu_group_member.full_path, 6) \"GROUP_CONTEXT\",\r\n       sg.name as \"PARENT_GROUP\",\r\n       substr(xu_group.full_path, 6) \"PARENT_GROUP_CONTEXT\"\r\n  from sas_group sg, \r\n       sas_group_member sgm,\r\n       sas_group group_member,\r\n       sas_user user_member,\r\n       xyf_properties xp_group_member,\r\n       xyf_urls xu_group_member,\r\n       xyf_properties xp_group,\r\n       xyf_urls xu_group\r\nwhere sg.id = sgm.group_id\r\n   and group_member.id (+)= sgm.principal_id\r\n   and user_member.id (+)= sgm.principal_id\r\n   and xp_group_member.string_value (+)= group_member.context_id\r\n   and xu_group_member.file_id (+)= xp_group_member.property_owner_id\r\n   and xp_group.string_value (+)= sg.context_id\r\n   and xu_group.file_id (+)= xp_group.property_owner_id\r\nstart with sg.id in\r\n    (select smm.principal_id\r\n       from sas_membership sm,\r\n            sas_membership_member smm,\r\n            xyf_properties xp_context,\r\n            xyf_urls xu_context\r\n      where sm.context_id = smm.membership_id \r\n   and smm.assigned <>  ? \r\n        and xp_context.string_value = sm.context_id\r\n        and xu_context.file_id = xp_context.property_owner_id\r\n        and xu_context.full_path = ? )\r\n connect by prior sgm.principal_id = sg.id) ";
        distinctContextMembershipSql = " (select ? as context_queried, \r\n       sg.name || su.userid as \"PRINCIPAL_NAME\",\r\n       case smm.principal_type when 'sas:user' then 'User' else 'Group' end as \"PRINCIPAL_TYPE\",\r\n 2 as \"EXIMPLICIT\"\r\n  from sas_membership sm,\r\n       sas_membership_member smm,\r\n       sas_group sg,\r\n       sas_user su,\r\n       xyf_properties xp,\r\n       xyf_urls xu,\r\n       xyf_properties xp_context,\r\n       xyf_urls xu_context\r\nwhere sm.context_id = smm.membership_id\r\n   and smm.assigned <>  ? \r\n   and sg.id (+)= smm.principal_id\r\n   and su.id (+)= smm.principal_id\r\n   and xp.string_value (+)= sg.context_id\r\n   and xu.file_id (+)= xp.property_owner_id\r\n   and xp_context.string_value = sm.context_id\r\n   and xu_context.file_id = xp_context.property_owner_id\r\n   and xu_context.full_path = ? \r\nUNION \r\nselect --group_member.name || user_member.userid as \"PRINCIPAL_NAME\",\r\n? as context_queried, \r\n       group_member.name || user_member.userid \"PRINCIPAL_NAME\", \r\n       case sgm.principal_type when 'sas:user' then 'User' else 'Group' end as \"PRINCIPAL_TYPE\",\r\n 1 as \"EXIMPLICIT\"\r\n  from sas_group sg, \r\n       sas_group_member sgm,\r\n       sas_group group_member,\r\n       sas_user user_member,\r\n       xyf_properties xp_group_member,\r\n       xyf_urls xu_group_member,\r\n       xyf_properties xp_group,\r\n       xyf_urls xu_group\r\nwhere sg.id = sgm.group_id\r\n   and group_member.id (+)= sgm.principal_id\r\n   and user_member.id (+)= sgm.principal_id\r\n   and xp_group_member.string_value (+)= group_member.context_id\r\n   and xu_group_member.file_id (+)= xp_group_member.property_owner_id\r\n   and xp_group.string_value (+)= sg.context_id\r\n   and xu_group.file_id (+)= xp_group.property_owner_id\r\nstart with sg.id in\r\n    (select smm.principal_id\r\n       from sas_membership sm,\r\n            sas_membership_member smm,\r\n            xyf_properties xp_context,\r\n            xyf_urls xu_context\r\n      where sm.context_id = smm.membership_id\r\n   and smm.assigned <>  ? \r\n        and smm.principal_type = 'sas:group'\r\n        and xp_context.string_value = sm.context_id\r\n        and xu_context.file_id = xp_context.property_owner_id\r\n        and xu_context.full_path = ? )\r\n connect by prior sgm.principal_id = sg.id) ";
    }
}

