/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.repository.recyclebin.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.query.ExtractFileCreateInfo;
import com.sas.lsaf.query.Query;
import com.sas.lsaf.query.QueryException;
import com.sas.lsaf.query.impl.ExtractHelper;
import com.sas.lsaf.query.impl.SqlColumn;
import com.sas.lsaf.query.impl.SqlQuery;
import com.sas.lsaf.query.impl.SqlQueryHelper;
import com.sas.lsaf.query.repository.SqlPropertyColumn;
import com.sas.lsaf.query.repository.SqlVersionedPropertyColumn;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinContainerQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinFileQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinFileVersionQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinItemQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinQueryService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class RecycleBinQueryServiceImpl
implements RecycleBinQueryService {
    private static final List<SqlColumn> RECYCLEBIN_ITEM_COLUMNS = new ArrayList<SqlColumn>();
    private static final List<SqlColumn> RECYCLEBIN_CONTAINER_COLUMNS = new ArrayList<SqlColumn>();
    private static final List<SqlColumn> RECYCLEBIN_FILE_COLUMNS = new ArrayList<SqlColumn>();
    private static final List<SqlColumn> RECYCLEBIN_FILE_VERSION_COLUMNS = new ArrayList<SqlColumn>();
    private static final String RECYCLEBIN_ITEM_SQL = "SELECT @SELECT FROM XYF_URLS XU, XYF_FILES XF @FROM WHERE XU.FILE_ID = XF.FILE_ID AND XU.PARENT_ID <> 0 AND XU.FULL_PATH LIKE '%/.trashcan/%' @WHERE";
    private static final String RECYCLEBIN_CONTAINER_SQL = "SELECT @SELECT FROM XYF_URLS XU, XYF_FILES XF, XYF_FILE_VERSIONS XFV, XYF_BLOBS XB @FROM WHERE XU.FILE_ID = XF.FILE_ID AND XU.PARENT_ID <> 0 AND XU.FULL_PATH LIKE '%/.trashcan/%' AND XF.FILE_TYPE_CODE = 'D' AND XFV.FILE_ID (+)= XF.FILE_ID AND XFV.VERSION (+)> 0 AND XFV.VERSION (+)= XF.LATEST_VERSION AND XB.BLOB_ID (+)= XFV.BLOB_ID @WHERE";
    private static final String RECYCLEBIN_FILE_SQL = "SELECT @SELECT FROM XYF_URLS XU, XYF_FILES XF, XYF_FILE_VERSIONS XFV, XYF_BLOBS XB @FROM WHERE XU.FILE_ID = XF.FILE_ID AND XU.PARENT_ID <> 0 AND XU.FULL_PATH LIKE '%/.trashcan/%' AND XF.FILE_TYPE_CODE = 'F' AND XFV.FILE_ID (+)= XF.FILE_ID AND XFV.VERSION (+)> 0 AND XFV.VERSION (+)= XF.LATEST_VERSION AND XB.BLOB_ID (+)= XFV.BLOB_ID @WHERE";
    private static final String RECYCLEBIN_FILE_VERSION_SQL = "SELECT @SELECT FROM XYF_URLS XU, XYF_FILES XF, XYF_FILE_VERSIONS XFV, XYF_BLOBS XB @FROM WHERE XU.FILE_ID = XF.FILE_ID AND XF.REVISIONABLE_FLAG = 'Y' AND XU.PARENT_ID <> 0 AND XU.FULL_PATH LIKE '%/.trashcan/%' AND XF.FILE_TYPE_CODE = 'F' AND XFV.FILE_ID (+)= XF.FILE_ID AND XFV.VERSION (+)> 0 AND XB.BLOB_ID (+)= XFV.BLOB_ID @WHERE";
    private ExtractHelper extractHelper;
    private SqlQueryHelper sqlQueryHelper;
    private boolean initialized = false;

    private synchronized void doInitialize() {
        if (this.initialized) {
            return;
        }
        RECYCLEBIN_ITEM_COLUMNS.add(new SqlPropertyColumn(RecycleBinItemQuery.ID, 12, "XP_ID.STRING_VALUE", "XP_ID", this.sqlQueryHelper.getPropertyDefinitionId("identifier")));
        RECYCLEBIN_ITEM_COLUMNS.add(new SqlPropertyColumn(RecycleBinItemQuery.TYPE_ID, 12, "XP_TYPEID.STRING_VALUE", "XP_TYPEID", this.sqlQueryHelper.getPropertyDefinitionId("type")));
        RECYCLEBIN_ITEM_COLUMNS.add(new SqlPropertyColumn(RecycleBinItemQuery.PATH, 12, "XP_DELETEDPATH.STRING_VALUE", "XP_DELETEDPATH", this.sqlQueryHelper.getPropertyDefinitionId("deletedPath")));
        RECYCLEBIN_ITEM_COLUMNS.add(new SqlPropertyColumn(RecycleBinItemQuery.DELETED_BY, 12, "XP_DELETEDBY.STRING_VALUE", "XP_DELETEDBY", this.sqlQueryHelper.getPropertyDefinitionId("deletedBy")));
        RECYCLEBIN_ITEM_COLUMNS.add(new SqlPropertyColumn(RecycleBinItemQuery.DELETED_DATE, 12, "XP_DELETEDDATE.DATE_VALUE", "XP_DELETEDDATE", this.sqlQueryHelper.getPropertyDefinitionId("deletedDate")));
        RECYCLEBIN_ITEM_COLUMNS.add(new SqlPropertyColumn(RecycleBinItemQuery.LAST_MODIFIED_BY, 12, "XP_LASTMODBY.STRING_VALUE", "XP_LASTMODBY", this.sqlQueryHelper.getPropertyDefinitionId("lastModifiedBy")));
        RECYCLEBIN_ITEM_COLUMNS.add(new SqlPropertyColumn(RecycleBinItemQuery.LAST_MODIFIED, 12, "XP_LASTMOD.DATE_VALUE", "XP_LASTMOD", this.sqlQueryHelper.getPropertyDefinitionId("lastModified")));
        RECYCLEBIN_ITEM_COLUMNS.add(new SqlColumn(RecycleBinItemQuery.TOTAL_FILE_SIZE, 2, "CASE WHEN XF.FILE_TYPE_CODE = 'F' THEN (SELECT SUM(XB2.BLOB_SIZE) FROM XYF_FILE_VERSIONS XFV2, XYF_BLOBS XB2 WHERE XF.FILE_ID = XFV2.FILE_ID AND XFV2.VERSION > 0 AND XFV2.BLOB_ID = XB2.BLOB_ID) END", "TOTAL_FILE_SIZE"));
        RECYCLEBIN_ITEM_COLUMNS.add(new SqlColumn(RecycleBinItemQuery.TOTAL_CONTAINER_SIZE, 2, "CASE WHEN XF.FILE_TYPE_CODE = 'D' THEN (XF.FILE_SIZE) END", "TOTAL_CONTAINER_SIZE"));
        RECYCLEBIN_CONTAINER_COLUMNS.add(new SqlColumn(RecycleBinContainerQuery.SIZE, 2, "XF.FILE_SIZE"));
        RECYCLEBIN_FILE_COLUMNS.add(new SqlColumn(RecycleBinFileQuery.SIZE, 2, "XB.BLOB_SIZE"));
        RECYCLEBIN_FILE_COLUMNS.add(new SqlVersionedPropertyColumn(RecycleBinFileQuery.VERSION, 12, "CASE WHEN XP_VERSION.STRING_VALUE IS NULL OR XP_VERSION.STRING_VALUE = '0.0' THEN '-' ELSE TO_CHAR(XP_VERSION.STRING_VALUE) END", "XP_VERSION", this.sqlQueryHelper.getPropertyDefinitionId("version")));
        RECYCLEBIN_FILE_VERSION_COLUMNS.addAll(RECYCLEBIN_FILE_COLUMNS);
        RECYCLEBIN_FILE_COLUMNS.add(new SqlColumn(RecycleBinFileQuery.TOTAL_VERSIONS, 2, "CASE WHEN XF.REVISIONABLE_FLAG = 'N' THEN 0 ELSE (SELECT COUNT(FILE_ID) FROM XYF_FILE_VERSIONS XFV2 WHERE XFV.FILE_ID = XFV2.FILE_ID AND XFV2.VERSION > 0) END", "TOTALVERSIONS"));
        RECYCLEBIN_FILE_COLUMNS.add(new SqlColumn(RecycleBinFileQuery.TOTAL_SIZE, 2, "(SELECT SUM(XB2.BLOB_SIZE) FROM XYF_FILE_VERSIONS XFV2, XYF_BLOBS XB2 WHERE XF.FILE_ID = XFV2.FILE_ID AND XFV2.VERSION > 0 AND XFV2.BLOB_ID = XB2.BLOB_ID)", "TOTALSIZE"));
        RECYCLEBIN_FILE_VERSION_COLUMNS.add(new SqlColumn(RecycleBinFileVersionQuery.TOTAL_VERSIONS, 2, "CASE WHEN XF.REVISIONABLE_FLAG = 'N' THEN 0 ELSE (SELECT COUNT(FILE_ID) FROM XYF_FILE_VERSIONS XFV2 WHERE XFV.FILE_ID = XFV2.FILE_ID AND XFV2.VERSION > 0) END", "TOTALVERSIONS"));
        this.initialized = true;
    }

    @Required
    public void setExtractHelper(ExtractHelper extractHelper) {
        this.extractHelper = extractHelper;
    }

    @Required
    public void setSqlQueryHelper(SqlQueryHelper sqlQueryHelper) {
        this.sqlQueryHelper = sqlQueryHelper;
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeRecycleBinItemQuery(RecycleBinItemQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        this.doInitialize();
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        try {
            RecycleBinItemQuery q = (RecycleBinItemQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, RecycleBinItemQuery.TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createRecycleBinItemExtract", (Query)q, RECYCLEBIN_ITEM_SQL);
            sqlQuery.addSqlColumns(RECYCLEBIN_ITEM_COLUMNS);
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeRecycleBinContainerQuery(RecycleBinContainerQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        this.doInitialize();
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        try {
            RecycleBinContainerQuery q = (RecycleBinContainerQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, RecycleBinItemQuery.TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createRecycleBinContainerExtract", (Query)q, RECYCLEBIN_CONTAINER_SQL);
            sqlQuery.addSqlColumns(RECYCLEBIN_ITEM_COLUMNS);
            sqlQuery.addSqlColumns(RECYCLEBIN_CONTAINER_COLUMNS);
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeRecycleBinFileQuery(RecycleBinFileQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        this.doInitialize();
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        try {
            RecycleBinFileQuery q = (RecycleBinFileQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, RecycleBinItemQuery.TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createRecycleBinFileExtract", (Query)q, RECYCLEBIN_FILE_SQL);
            sqlQuery.addSqlColumns(RECYCLEBIN_ITEM_COLUMNS);
            sqlQuery.addSqlColumns(RECYCLEBIN_FILE_COLUMNS);
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeRecycleBinFileVersionQuery(RecycleBinFileVersionQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        this.doInitialize();
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        try {
            RecycleBinFileVersionQuery q = (RecycleBinFileVersionQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, RecycleBinItemQuery.TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createRecycleBinFileVersionExtract", (Query)q, RECYCLEBIN_FILE_VERSION_SQL);
            sqlQuery.addSqlColumns(RECYCLEBIN_ITEM_COLUMNS);
            sqlQuery.addSqlColumns(RECYCLEBIN_FILE_VERSION_COLUMNS);
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

