/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.repository.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.query.ExtractFileCreateInfo;
import com.sas.lsaf.query.Query;
import com.sas.lsaf.query.QueryException;
import com.sas.lsaf.query.impl.ExtractHelper;
import com.sas.lsaf.query.impl.SqlColumn;
import com.sas.lsaf.query.impl.SqlQuery;
import com.sas.lsaf.query.impl.SqlQueryHelper;
import com.sas.lsaf.query.repository.RepositoryContainerQuery;
import com.sas.lsaf.query.repository.RepositoryFileQuery;
import com.sas.lsaf.query.repository.RepositoryFileVersionQuery;
import com.sas.lsaf.query.repository.RepositoryItemQuery;
import com.sas.lsaf.query.repository.RepositoryQueryService;
import com.sas.lsaf.query.repository.SqlPropertyColumn;
import com.sas.lsaf.query.repository.SqlUnversionedPropertyColumn;
import com.sas.lsaf.query.repository.SqlVersionedPropertyColumn;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class RepositoryQueryServiceImpl
implements RepositoryQueryService {
    private static final List<SqlColumn> REPOSITORY_ITEM_COLUMNS = new ArrayList<SqlColumn>();
    private static final List<SqlColumn> REPOSITORY_CONTAINER_COLUMNS = new ArrayList<SqlColumn>();
    private static final List<SqlColumn> REPOSITORY_FILE_COLUMNS = new ArrayList<SqlColumn>();
    private static final List<SqlColumn> REPOSITORY_FILE_VERSION_COLUMNS = new ArrayList<SqlColumn>();
    private static final String REPOSITORY_ITEM_SQL = "SELECT @SELECT FROM XYF_URLS XU, XYF_FILES XF @FROM WHERE XU.FILE_ID = XF.FILE_ID AND XU.PARENT_ID <> 0 AND XU.FULL_PATH NOT LIKE '%/.trashcan%' @WHERE";
    private static final String REPOSITORY_CONTAINER_SQL = "SELECT @SELECT FROM XYF_URLS XU, XYF_FILES XF @FROM WHERE XU.FILE_ID = XF.FILE_ID AND XU.PARENT_ID <> 0 AND XU.FULL_PATH NOT LIKE '%/.trashcan%' AND XF.FILE_TYPE_CODE = 'D' @WHERE";
    private static final String REPOSITORY_FILE_SQL = "SELECT @SELECT FROM XYF_URLS XU, XYF_FILES XF, XYF_FILE_VERSIONS XFV, XYF_BLOBS XB @FROM WHERE XU.FILE_ID = XF.FILE_ID AND XU.PARENT_ID <> 0 AND XU.FULL_PATH NOT LIKE '%/.trashcan%' AND XF.FILE_TYPE_CODE = 'F' AND XF.FILE_ID = XFV.FILE_ID AND XFV.VERSION > 0 AND XF.LATEST_VERSION = XFV.VERSION AND XFV.BLOB_ID = XB.BLOB_ID @WHERE";
    private static final String REPOSITORY_FILE_VERSION_SQL = "SELECT @SELECT FROM XYF_URLS XU, XYF_FILES XF, XYF_FILE_VERSIONS XFV, XYF_BLOBS XB @FROM WHERE XU.FILE_ID = XF.FILE_ID AND XF.REVISIONABLE_FLAG = 'Y' AND XU.PARENT_ID <> 0 AND XU.FULL_PATH NOT LIKE '%/.trashcan%' AND XF.FILE_TYPE_CODE = 'F' AND XF.FILE_ID = XFV.FILE_ID AND XFV.VERSION > 0 AND XFV.BLOB_ID = XB.BLOB_ID @WHERE";
    private ExtractHelper extractHelper;
    private SqlQueryHelper sqlQueryHelper;
    private boolean initialized = false;

    private synchronized void doInitialize() {
        if (this.initialized) {
            return;
        }
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.ID, 12, "XP_ID.STRING_VALUE", "XP_ID", this.sqlQueryHelper.getPropertyDefinitionId("identifier")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.TYPE_ID, 12, "XP_TYPEID.STRING_VALUE", "XP_TYPEID", this.sqlQueryHelper.getPropertyDefinitionId("type")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlColumn(RepositoryItemQuery.NAME, 12, "XU.FILE_NAME"));
        REPOSITORY_ITEM_COLUMNS.add(new SqlColumn(RepositoryItemQuery.PATH, 12, "SUBSTR(XU.FULL_PATH, 6)"));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.CREATED_BY, 12, "XP_CREATEDBY.STRING_VALUE", "XP_CREATEDBY", this.sqlQueryHelper.getPropertyDefinitionId("createdBy")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.CREATED, 12, "XP_CREATED.DATE_VALUE", "XP_CREATED", this.sqlQueryHelper.getPropertyDefinitionId("created")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.LAST_MODIFIED_BY, 12, "XP_LASTMODBY.STRING_VALUE", "XP_LASTMODBY", this.sqlQueryHelper.getPropertyDefinitionId("lastModifiedBy")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.LAST_MODIFIED, 12, "XP_LASTMOD.DATE_VALUE", "XP_LASTMOD", this.sqlQueryHelper.getPropertyDefinitionId("lastModified")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.PROPERTIES_LAST_MODIFIED_BY, 12, "XP_PROPLASTMODBY.STRING_VALUE", "XP_PROPLASTMODBY", this.sqlQueryHelper.getPropertyDefinitionId("propertiesLastModifiedBy")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.PROPERTIES_LAST_MODIFIED, 12, "XP_PROPLASTMOD.DATE_VALUE", "XP_PROPLASTMOD", this.sqlQueryHelper.getPropertyDefinitionId("propertiesLastModified")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.STATE, 12, "NVL(XP_STATE.STRING_VALUE, 'ACTIVE')", "XP_STATE", this.sqlQueryHelper.getPropertyDefinitionId("state")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.DESCRIPTION, 12, "XP_DESCRIPTION.STRING_VALUE", "XP_DESCRIPTION", this.sqlQueryHelper.getPropertyDefinitionId("description")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlPropertyColumn(RepositoryItemQuery.SYNCABLE, 12, "NVL(XP_SYNCABLE.STRING_VALUE, 'ALLOW')", "XP_SYNCABLE", this.sqlQueryHelper.getPropertyDefinitionId("syncable")));
        REPOSITORY_ITEM_COLUMNS.add(new SqlColumn(RepositoryItemQuery.TOTAL_FILE_SIZE, 2, "CASE WHEN XF.FILE_TYPE_CODE = 'F' THEN (SELECT SUM(XB2.BLOB_SIZE) FROM XYF_FILE_VERSIONS XFV2, XYF_BLOBS XB2 WHERE XF.FILE_ID = XFV2.FILE_ID AND XFV2.VERSION > 0 AND XFV2.BLOB_ID = XB2.BLOB_ID) END", "TOTAL_FILE_SIZE"));
        REPOSITORY_ITEM_COLUMNS.add(new SqlColumn(RepositoryItemQuery.TOTAL_CONTAINER_SIZE, 2, "CASE WHEN XF.FILE_TYPE_CODE = 'D' THEN (XF.FILE_SIZE) END", "TOTAL_CONTAINER_SIZE"));
        REPOSITORY_CONTAINER_COLUMNS.add(new SqlColumn(RepositoryContainerQuery.SIZE, 2, "XF.FILE_SIZE"));
        REPOSITORY_CONTAINER_COLUMNS.add(new SqlPropertyColumn(RepositoryContainerQuery.DEFAULT_MAJOR_VERSION_LIMIT, 2, "CASE WHEN XP_DEF_MAJORLIMIT.NUMBER_VALUE IS NOT NULL THEN (XP_DEF_MAJORLIMIT.NUMBER_VALUE) END", "XP_DEF_MAJORLIMIT", this.sqlQueryHelper.getPropertyDefinitionId("defaultMajorLimit")));
        REPOSITORY_CONTAINER_COLUMNS.add(new SqlPropertyColumn(RepositoryContainerQuery.DEFAULT_MINOR_VERSION_LIMIT, 2, "CASE WHEN XP_DEF_MINORLIMIT.NUMBER_VALUE IS NOT NULL THEN (XP_DEF_MINORLIMIT.NUMBER_VALUE) END", "XP_DEF_MINORLIMIT", this.sqlQueryHelper.getPropertyDefinitionId("defaultMinorLimit")));
        REPOSITORY_FILE_COLUMNS.add(new SqlColumn(RepositoryFileQuery.SIZE, 2, "XB.BLOB_SIZE"));
        REPOSITORY_FILE_COLUMNS.add(new SqlColumn(RepositoryFileQuery.VERSIONED, 12, "XF.REVISIONABLE_FLAG"));
        REPOSITORY_FILE_COLUMNS.add(new SqlColumn(RepositoryFileQuery.DIGEST, 12, "XB.DIGEST"));
        REPOSITORY_FILE_COLUMNS.add(new SqlPropertyColumn(RepositoryFileQuery.CHECKEDOUT, 12, "CASE WHEN XP_CHECKEDOUT.STRING_VALUE IS NULL THEN 'N' ELSE 'Y' END", "XP_CHECKEDOUT", this.sqlQueryHelper.getPropertyDefinitionId("checkedOutBy")));
        REPOSITORY_FILE_COLUMNS.add(new SqlPropertyColumn(RepositoryFileQuery.CHECKEDOUT_BY, 12, "XP_CHECKEDOUTBY.STRING_VALUE", "XP_CHECKEDOUTBY", this.sqlQueryHelper.getPropertyDefinitionId("checkedOutBy")));
        REPOSITORY_FILE_COLUMNS.add(new SqlPropertyColumn(RepositoryFileQuery.CHECKEDOUT_DATE, 12, "XP_CHECKEDOUTDATE.DATE_VALUE", "XP_CHECKEDOUTDATE", this.sqlQueryHelper.getPropertyDefinitionId("checkedOutDate")));
        REPOSITORY_FILE_COLUMNS.add(new SqlVersionedPropertyColumn(RepositoryFileQuery.VERSION, 12, "CASE WHEN XP_VERSION.STRING_VALUE IS NULL OR XP_VERSION.STRING_VALUE = '0.0' THEN '-' ELSE TO_CHAR(XP_VERSION.STRING_VALUE) END", "XP_VERSION", this.sqlQueryHelper.getPropertyDefinitionId("version")));
        REPOSITORY_FILE_COLUMNS.add(new SqlColumn(RepositoryFileQuery.COMMENT, 12, "XFV.VER_COMMENT"));
        REPOSITORY_FILE_COLUMNS.add(new SqlPropertyColumn(RepositoryFileQuery.LOCKED, 12, "XP_LOCKED.SHORT_STRING_VALUE", "XP_LOCKED", this.sqlQueryHelper.getPropertyDefinitionId("lock")));
        REPOSITORY_FILE_COLUMNS.add(new SqlUnversionedPropertyColumn(RepositoryFileQuery.SIGNING_STATUS, 12, "CASE WHEN XP_SIGNINGSTATUS.STRING_VALUE IS NULL THEN 'NONE' WHEN XP_SIGNINGSTATUS.STRING_VALUE = 'BOTH' THEN 'CURRENT_AND_PREVIOUS' ELSE TO_CHAR(XP_SIGNINGSTATUS.STRING_VALUE) END", "XP_SIGNINGSTATUS", this.sqlQueryHelper.getPropertyDefinitionId("signingStatus")));
        REPOSITORY_FILE_COLUMNS.add(new SqlPropertyColumn(RepositoryFileQuery.MAJOR_VERSION_LIMIT, 2, "CASE WHEN XP_MAJORLIMIT.NUMBER_VALUE IS NOT NULL THEN (XP_MAJORLIMIT.NUMBER_VALUE) END", "XP_MAJORLIMIT", this.sqlQueryHelper.getPropertyDefinitionId("majorLimit")));
        REPOSITORY_FILE_COLUMNS.add(new SqlPropertyColumn(RepositoryFileQuery.MINOR_VERSION_LIMIT, 2, "CASE WHEN XP_MINORLIMIT.NUMBER_VALUE IS NOT NULL THEN (XP_MINORLIMIT.NUMBER_VALUE) END", "XP_MINORLIMIT", this.sqlQueryHelper.getPropertyDefinitionId("minorLimit")));
        REPOSITORY_FILE_COLUMNS.add(new SqlVersionedPropertyColumn(RepositoryFileQuery.RUNAS_OWNER, 12, "NVL(XP_RUNASOWNER.SHORT_STRING_VALUE, 'N')", "XP_RUNASOWNER", this.sqlQueryHelper.getPropertyDefinitionId("runAsOwner")));
        REPOSITORY_FILE_VERSION_COLUMNS.addAll(REPOSITORY_FILE_COLUMNS);
        REPOSITORY_FILE_VERSION_COLUMNS.add(new SqlPropertyColumn(RepositoryFileVersionQuery.SIGNED, 12, " CASE WHEN (select COUNT(reason) FROM SAS_SIGNATURE WHERE SAS_SIGNATURE.OBJECTID = XP_ID.STRING_VALUE AND SAS_SIGNATURE.VERSION = XP_VERSION.STRING_VALUE) >= 1 THEN 'Y' ELSE 'N' END ", "XP_ID", this.sqlQueryHelper.getPropertyDefinitionId("identifier")));
        REPOSITORY_FILE_VERSION_COLUMNS.add(new SqlColumn(RepositoryFileVersionQuery.VERSION_CREATED, 12, "CASE WHEN XP_VERSION.STRING_VALUE IS NULL THEN NULL ELSE XFV.CREATION_DATE END"));
        REPOSITORY_FILE_VERSION_COLUMNS.add(new SqlColumn(RepositoryFileVersionQuery.VERSION_CREATED_BY, 12, "CASE WHEN XP_VERSION.STRING_VALUE IS NULL THEN NULL ELSE (SELECT PRINCIPAL_ID FROM XYF_PRINCIPAL_LOOKUPS XPL WHERE XPL.INTERNAL_PRINCIPAL_ID = XFV.CREATED_BY) END"));
        REPOSITORY_FILE_COLUMNS.add(new SqlColumn(RepositoryFileQuery.TOTAL_VERSIONS, 2, "CASE WHEN XF.REVISIONABLE_FLAG = 'N' THEN 0 ELSE (SELECT COUNT(FILE_ID) FROM XYF_FILE_VERSIONS XFV2 WHERE XFV.FILE_ID = XFV2.FILE_ID AND XFV2.VERSION > 0) END", "TOTALVERSIONS"));
        REPOSITORY_FILE_COLUMNS.add(new SqlColumn(RepositoryFileQuery.TOTAL_SIZE, 2, "(SELECT SUM(XB2.BLOB_SIZE) FROM XYF_FILE_VERSIONS XFV2, XYF_BLOBS XB2 WHERE XF.FILE_ID = XFV2.FILE_ID AND XFV2.VERSION > 0 AND XFV2.BLOB_ID = XB2.BLOB_ID)", "TOTALSIZE"));
        REPOSITORY_FILE_VERSION_COLUMNS.add(new SqlColumn(RepositoryFileVersionQuery.TOTAL_VERSIONS, 2, "CASE WHEN XF.REVISIONABLE_FLAG = 'N' THEN 0 ELSE (SELECT COUNT(FILE_ID) FROM XYF_FILE_VERSIONS XFV2 WHERE XFV.FILE_ID = XFV2.FILE_ID AND XFV2.VERSION > 0) END", "TOTALVERSIONS"));
        this.initialized = true;
    }

    @Required
    public void setExtractHelper(ExtractHelper extractHelper) {
        this.extractHelper = extractHelper;
    }

    @Required
    public void setSqlQueryHelper(SqlQueryHelper sqlQueryHelper) {
        this.sqlQueryHelper = sqlQueryHelper;
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeRepositoryItemQuery(RepositoryItemQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        this.doInitialize();
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        try {
            RepositoryItemQuery q = (RepositoryItemQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, RepositoryItemQuery.TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createRepositoryItemExtract", (Query)q, REPOSITORY_ITEM_SQL);
            sqlQuery.addSqlColumns(REPOSITORY_ITEM_COLUMNS);
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeRepositoryContainerQuery(RepositoryContainerQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        this.doInitialize();
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        try {
            RepositoryContainerQuery q = (RepositoryContainerQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, RepositoryItemQuery.TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createRepositoryContainerExtract", (Query)q, REPOSITORY_CONTAINER_SQL);
            sqlQuery.addSqlColumns(REPOSITORY_ITEM_COLUMNS);
            sqlQuery.addSqlColumns(REPOSITORY_CONTAINER_COLUMNS);
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeRepositoryFileQuery(RepositoryFileQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        this.doInitialize();
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        try {
            RepositoryFileQuery q = (RepositoryFileQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, RepositoryItemQuery.TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createRepositoryFileExtract", (Query)q, REPOSITORY_FILE_SQL);
            sqlQuery.addSqlColumns(REPOSITORY_ITEM_COLUMNS);
            sqlQuery.addSqlColumns(REPOSITORY_FILE_COLUMNS);
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeRepositoryFileVersionQuery(RepositoryFileVersionQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        if ((query.getColumns().contains(RepositoryFileVersionQuery.SIGNED) || query.getColumns().contains(RepositoryFileVersionQuery.VERSION_CREATED) || query.getColumns().contains(RepositoryFileVersionQuery.VERSION_CREATED_BY)) && !query.getColumns().contains(RepositoryFileVersionQuery.VERSION)) {
            throw new ValidationException("RepositoryFileVersionQuery VERSION column must be included in the query based on the selected columns.");
        }
        this.doInitialize();
        this.extractHelper.checkCurrentUserIsAdministrativeModeUser();
        try {
            RepositoryFileVersionQuery q = (RepositoryFileVersionQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, RepositoryItemQuery.TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createRepositoryFileVersionExtract", (Query)q, REPOSITORY_FILE_VERSION_SQL);
            sqlQuery.addSqlColumns(REPOSITORY_ITEM_COLUMNS);
            sqlQuery.addSqlColumns(REPOSITORY_FILE_VERSION_COLUMNS);
            SqlQueryHelper.parse(sqlQuery);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

