/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.impl.dao;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class ResultSetHelper {
    private static final String DEFAULT_VALUE = "";

    private String doGetColumnValue(ResultSet rs, int colType, int colIndex, int precision) throws SQLException {
        String value;
        switch (colType) {
            case 16: {
                value = Objects.toString(rs.getBoolean(colIndex));
                break;
            }
            case -5: {
                BigDecimal d = rs.getBigDecimal(colIndex);
                value = Objects.toString(d != null ? d.toBigInteger() : null);
                break;
            }
            case 3: 
            case 7: {
                value = Objects.toString(rs.getBigDecimal(colIndex), DEFAULT_VALUE);
                break;
            }
            case 2: {
                if (precision == 13) {
                    value = this.doHandleEpochTimestamp(rs, colIndex);
                    break;
                }
                value = Objects.toString(rs.getLong(colIndex), DEFAULT_VALUE);
                break;
            }
            case 8: {
                value = Objects.toString(rs.getDouble(colIndex));
                break;
            }
            case 6: {
                value = Objects.toString(Float.valueOf(rs.getFloat(colIndex)));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                value = Objects.toString(rs.getInt(colIndex));
                break;
            }
            case 91: {
                value = this.doHandleDate(rs, colIndex);
                break;
            }
            case 92: {
                value = Objects.toString(rs.getTime(colIndex), DEFAULT_VALUE);
                break;
            }
            case 93: {
                value = this.doHandleTimestamp(rs, colIndex);
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                value = this.doHandleNVarChar(rs, colIndex);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                value = this.doHandleVarChar(rs, colIndex);
                break;
            }
            default: {
                value = Objects.toString(rs.getObject(colIndex), DEFAULT_VALUE);
            }
        }
        if (rs.wasNull() || value == null) {
            value = DEFAULT_VALUE;
        }
        return value;
    }

    private String doHandleVarChar(ResultSet rs, int colIndex) throws SQLException {
        return rs.getString(colIndex);
    }

    private String doHandleNVarChar(ResultSet rs, int colIndex) throws SQLException {
        return rs.getNString(colIndex);
    }

    private String doHandleDate(ResultSet rs, int colIndex) throws SQLException {
        Date date = rs.getDate(colIndex);
        return date == null ? null : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
    }

    private String doHandleTimestamp(ResultSet rs, int colIndex) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(colIndex);
        return timestamp == null ? null : ZonedDateTime.ofInstant(timestamp.toInstant(), ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
    }

    private String doHandleEpochTimestamp(ResultSet rs, int colIndex) throws SQLException {
        Long timestamp = rs.getLong(colIndex);
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
    }

    public String[] getColumnValues(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        String[] valueArray = new String[metadata.getColumnCount()];
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            valueArray[i - 1] = this.doGetColumnValue(rs, metadata.getColumnType(i), i, metadata.getPrecision(i));
        }
        return valueArray;
    }
}

