/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.impl.dao;

import com.sas.lsaf.core.dao.jdbc.AbstractJdbcDao;
import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.QueryLimitException;
import com.sas.lsaf.query.impl.SqlQuery;
import com.sas.lsaf.query.impl.dao.ExtractDao;
import com.sas.lsaf.query.impl.dao.ResultSetHelper;
import com.sas.lsaf.svcs.core.dao.client.exception.UncategorizedDataAccessException;
import com.sas.lsaf.svcs.core.utils.server.JdbcUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.SqlParameterValue;

public class JdbcExtractDao
extends AbstractJdbcDao
implements ExtractDao {
    private static final Log LOG = LogFactory.getLog(JdbcExtractDao.class);
    private int rowLimit = 10000000;

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Override
    public File extractByQuery(final SqlQuery query) {
        try {
            long start = System.currentTimeMillis();
            File f = File.createTempFile(query.getName() + "-", ".csv");
            f.deleteOnExit();
            try (FileWriter writer = new FileWriter(f);){
                String sql = query.generateSql();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)sql);
                    for (SqlParameterValue parmVal : query.getParameters()) {
                        LOG.info((Object)(" SqlParameterValue: " + parmVal.getValue() + "\n"));
                    }
                }
                FileRowCallbackHandler fileRowHandler = new FileRowCallbackHandler(writer, new ResultSetHelper(), this.rowLimit);
                if (query.getQuery().isIncludeColumnNames()) {
                    try {
                        for (int i = 0; i < query.getQuery().getColumns().size(); ++i) {
                            writer.append("\"");
                            writer.append(((Column)query.getQuery().getColumns().get(i)).getName().toUpperCase());
                            writer.append("\"");
                            if (i >= query.getQuery().getColumns().size()) continue;
                            writer.append(",");
                        }
                        writer.append("\r\n");
                    }
                    catch (IOException e) {
                        throw new UncategorizedDataAccessException("998", "Error writing data extract.", (Throwable)e);
                    }
                }
                this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

                    public void setValues(PreparedStatement ps) throws SQLException {
                        for (int i = 0; i < query.getParameters().size(); ++i) {
                            JdbcUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)query.getParameters().get(i).getSqlType(), (Object)query.getParameters().get(i));
                        }
                    }
                }, (RowCallbackHandler)fileRowHandler);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Extraction written to " + f.getPath() + " [" + (System.currentTimeMillis() - start) + "ms]"));
            }
            return f;
        }
        catch (UncategorizedDataAccessException | IOException e) {
            throw new DataAccessResourceFailureException("Error writing data extract.", e);
        }
    }

    public static class FileRowCallbackHandler
    implements RowCallbackHandler {
        private final FileWriter writer;
        private final ResultSetHelper helper;
        private int cnt = 0;
        private int rowLimit = 10000000;

        public FileRowCallbackHandler(FileWriter writer, ResultSetHelper helper, int rowLimit) {
            this.writer = writer;
            this.helper = helper;
            this.rowLimit = rowLimit;
        }

        public void processRow(ResultSet rs) throws SQLException {
            String[] values = this.helper.getColumnValues(rs);
            if (this.cnt > this.rowLimit) {
                throw new QueryLimitException("Query results exceeded the maximum row limit of " + this.rowLimit + ".  Please refine your query.");
            }
            ++this.cnt;
            try {
                for (int i = 0; i < values.length; ++i) {
                    this.writer.append(StringEscapeUtils.escapeCsv((String)values[i]));
                    if (i >= values.length - 1) continue;
                    this.writer.append(",");
                }
                this.writer.append("\r\n");
            }
            catch (IOException e) {
                throw new UncategorizedDataAccessException("999", "Error writing data extract.", (Throwable)e);
            }
        }

        public int getCount() {
            return this.cnt;
        }
    }
}

