/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.impl;

import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.Comparison;
import com.sas.lsaf.query.Condition;
import com.sas.lsaf.query.Constraint;
import com.sas.lsaf.query.Order;
import com.sas.lsaf.query.Query;
import com.sas.lsaf.query.QueryException;
import com.sas.lsaf.query.audit.AuditEntryQuery;
import com.sas.lsaf.query.impl.SqlColumn;
import com.sas.lsaf.query.impl.SqlQuery;
import com.sas.lsaf.query.repository.RepositoryFileQuery;
import com.sas.lsaf.query.repository.RepositoryItemQuery;
import com.sas.lsaf.security.audit.AuditEntry;
import com.sas.lsaf.svcs.content.repository.impl.xythos.XythosPropertyDefinitionManager;
import com.sas.lsaf.svcs.core.type.client.Type;
import com.sas.lsaf.svcs.core.type.client.TypeService;
import com.sas.lsaf.svcs.core.utils.client.DateUtils;
import com.sas.lsaf.svcs.core.utils.client.StringUtils;
import com.sas.lsaf.svcs.core.utils.server.JdbcUtils;
import com.sas.lsaf.svcs.core.validation.server.ValidationUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.util.Assert;

public class SqlQueryHelper {
    public static final String SPACE = " ";
    public static final String COMMA = ", ";
    public static final String OPEN_PARENTHESIS = "(";
    public static final String CLOSE_PARENTHESIS = ")";
    public static final String SELECT = "SELECT";
    public static final String FROM = "FROM";
    public static final String WHERE = "WHERE";
    public static final String ORDERBY = " ORDER BY ";
    public static final String GROUPBY = " GROUP BY ";
    public static final String ORDER_BY_ASC = " ASC";
    public static final String ORDER_BY_DESC = " DESC";
    public static final String EQ = " = ";
    public static final String NEQ = " <> ";
    public static final String GT = " > ";
    public static final String GTE = " >= ";
    public static final String LT = " < ";
    public static final String LTE = " <= ";
    public static final String LIKE = " LIKE ";
    public static final String NOTLIKE = " NOT LIKE ";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final int ROW_LIMIT = 10000000;
    private TypeService typeService;
    private XythosPropertyDefinitionManager xythosPropertyDefinitionManager;
    private Constraint rootConstraint = null;
    private boolean typeConstraintNeedsUpdating = false;

    @Required
    public void setTypeService(TypeService typeService) {
        this.typeService = typeService;
    }

    @Required
    public void setXythosPropertyDefinitionManager(XythosPropertyDefinitionManager xythosPropertyDefinitionManager) {
        this.xythosPropertyDefinitionManager = xythosPropertyDefinitionManager;
    }

    private static void doParseSelect(SqlQuery query) throws QueryException {
        Iterator it = query.getQuery().getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            SqlColumn sqlColumn = query.getSqlColumn(column);
            if (sqlColumn.getSqlAlias() != null) {
                query.getSqlSelect().append(sqlColumn.getSqlSelect());
                query.getSqlSelect().append(SPACE);
                query.getSqlSelect().append(sqlColumn.getSqlAlias());
            } else {
                query.getSqlSelect().append(sqlColumn.getSqlSelect());
            }
            if (!it.hasNext()) continue;
            query.getSqlSelect().append(COMMA);
        }
    }

    private static void doParseFrom(SqlQuery query) throws QueryException {
        HashSet<String> froms = new HashSet<String>();
        for (Object name : query.getQuery().getColumns()) {
            Column column = (Column)name;
            SqlColumn sqlColumn = query.getSqlColumn(column);
            String from = sqlColumn.getSqlFrom();
            if (from == null || froms.contains(from)) continue;
            froms.add(from);
            if (query.getSqlFrom().length() > 0) {
                query.getSqlFrom().append(COMMA);
            }
            query.getSqlFrom().append(from);
        }
    }

    private static void doParseWhere(SqlQuery query, boolean duplicate) throws QueryException {
        HashSet<String> wheres = new HashSet<String>();
        for (Object name : query.getQuery().getColumns()) {
            Column column = (Column)name;
            SqlColumn sqlColumn = query.getSqlColumn(column);
            String where = sqlColumn.getSqlWhere();
            if (where == null || wheres.contains(where)) continue;
            wheres.add(where);
            if (query.getSqlWhere().length() > 0) {
                query.getSqlWhere().append(AND);
            }
            query.getSqlWhere().append(where);
        }
        if (query.getQuery().getConstraint() != null) {
            if (query.getSqlWhere().length() > 0) {
                query.getSqlWhere().append(AND);
            }
            SqlQueryHelper.doParseConstraint(query.getQuery().getConstraint(), query);
        }
        if (duplicate) {
            query.getParameters().addAll(query.getParameters());
        }
    }

    private static void doParseOrderBy(SqlQuery query) throws QueryException {
        if (query.getQuery().getOrder() != null && !query.getQuery().getOrder().isEmpty()) {
            Iterator it = query.getQuery().getOrder().iterator();
            while (it.hasNext()) {
                Order order = (Order)it.next();
                SqlColumn sqlColumn = query.getSqlColumn(order.getColumn());
                int type = sqlColumn.getSqlType();
                if (sqlColumn.getSqlAlias() != null) {
                    query.getSqlOrderBy().append(SqlQueryHelper.doBuildOrderByClause(order, type, sqlColumn.getSqlAlias()));
                } else {
                    query.getSqlOrderBy().append(SqlQueryHelper.doBuildOrderByClause(order, type, sqlColumn.getSqlSelect()));
                }
                if (!it.hasNext()) continue;
                query.getSqlOrderBy().append(COMMA);
            }
        }
    }

    private static void doParseGroupBy(SqlQuery query, String groupBy) {
        if (groupBy != null && !groupBy.isEmpty()) {
            query.getSqlGroupBy().append(groupBy);
        }
    }

    private static String doBuildOrderByClause(Order order, int type, String selectCol) {
        Assert.notNull((Object)order, (String)"Order is required.");
        StringBuffer orderBy = new StringBuffer();
        boolean isCaseSensitive = order.isCaseSensitive();
        boolean isAscending = order.isAscending();
        if (type == 91 || type == 93 || isCaseSensitive) {
            orderBy.append(selectCol);
        } else {
            orderBy.append("lower(" + selectCol + ") ");
        }
        if (isAscending) {
            orderBy.append(ORDER_BY_ASC);
        } else {
            orderBy.append(ORDER_BY_DESC);
        }
        return orderBy.toString();
    }

    private static void doParseConstraint(Constraint c, SqlQuery query) throws QueryException {
        Assert.notNull((Object)c, (String)"Constraint cannot be null");
        if (c instanceof Condition) {
            SqlQueryHelper.doParseCondition((Condition)c, query);
        } else if (c instanceof Comparison) {
            SqlQueryHelper.doParseComparison((Comparison)c, query);
        } else {
            throw new IllegalStateException("Unhandled constraint type " + c.getClass().getName());
        }
    }

    private static void doParseCondition(Condition p, SqlQuery query) throws QueryException {
        if (p.getOperator() == null) {
            throw new QueryException("Condition operator is required.");
        }
        if (p.getConstraints() == null) {
            throw new QueryException("Condition constraints are required.");
        }
        if (p.getConstraints().isEmpty()) {
            throw new QueryException("Condition constraints are required.");
        }
        query.getSqlWhere().append(OPEN_PARENTHESIS);
        Iterator it = p.getConstraints().iterator();
        while (it.hasNext()) {
            Constraint c = (Constraint)it.next();
            SqlQueryHelper.doParseConstraint(c, query);
            if (!it.hasNext()) continue;
            if (p.getOperator() == Condition.Operator.AND) {
                query.getSqlWhere().append(AND);
                continue;
            }
            query.getSqlWhere().append(OR);
        }
        query.getSqlWhere().append(CLOSE_PARENTHESIS);
    }

    private static void doParseComparison(Comparison c, SqlQuery query) throws QueryException {
        String val;
        if (c.getOperator() == null) {
            throw new QueryException("Comparison operator is required.");
        }
        if (c.getColumn() == null) {
            throw new QueryException("Comparison column is required.");
        }
        SqlColumn sqlColumn = query.getSqlColumn(c.getColumn());
        if (c.isCaseSensitive() || c.getColumn().getType().equals((Object)Column.Type.DATE)) {
            query.getSqlWhere().append(sqlColumn.getSqlSelect());
        } else {
            query.getSqlWhere().append("lower(" + sqlColumn.getSqlSelect() + ") ");
        }
        if (c.getValue() == null) {
            if (c.getOperator() == Comparison.Operator.EQUAL) {
                query.getSqlWhere().append(" IS NULL");
                return;
            }
            if (c.getOperator() == Comparison.Operator.NOT_EQUAL) {
                if (c.getOperator() == Comparison.Operator.NOT_EQUAL) {
                    query.getSqlWhere().append(" IS NOT NULL");
                    return;
                }
                return;
            }
            throw new QueryException("Comparison value is required with operator " + c.getOperator().name() + ".");
        }
        switch (c.getOperator()) {
            case EQUAL: {
                query.getSqlWhere().append(EQ);
                break;
            }
            case NOT_EQUAL: {
                query.getSqlWhere().append(NEQ);
                break;
            }
            case GREATER_THAN: {
                query.getSqlWhere().append(GT);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                query.getSqlWhere().append(GTE);
                break;
            }
            case LESS_THAN: {
                query.getSqlWhere().append(LT);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                query.getSqlWhere().append(LTE);
                break;
            }
            case LIKE: {
                query.getSqlWhere().append(LIKE);
                break;
            }
            case NOT_LIKE: {
                query.getSqlWhere().append(NOTLIKE);
                break;
            }
        }
        if ((c.getColumn().getQueryClass().startsWith("Repository") || c.getColumn().getQueryClass().startsWith("RecycleBin")) && c.getColumn().getType().equals((Object)Column.Type.DATE)) {
            query.getSqlWhere().append(" TO_DATE(?, 'YYYY-MM-DD HH24:MI:SS')");
        } else {
            query.getSqlWhere().append("?");
        }
        String string = val = c.getValue() != null ? JdbcUtils.replaceWildcards((String)c.getValue().toString()) : null;
        if (val != null) {
            if ((c.getColumn().getQueryClass().startsWith("Repository") || c.getColumn().getQueryClass().startsWith("RecycleBin")) && c.getColumn().getType().equals((Object)Column.Type.DATE)) {
                long dateTime = Long.valueOf(val.toString());
                SimpleDateFormat gmtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                gmtFormat.setTimeZone(DateUtils.TIMEZONE_GMT);
                val = gmtFormat.format(new Date(dateTime));
            }
            if (c.getColumn().getType().equals((Object)Column.Type.BOOLEAN)) {
                val = Boolean.parseBoolean(val.toString()) ? "Y" : "N";
            }
            if (!c.isCaseSensitive()) {
                val = val.toString().toLowerCase();
            }
        }
        query.getParameters().add(new SqlParameterValue(sqlColumn.getSqlType(), (Object)val));
    }

    private Condition getContextTypesCondition(Column column, Comparison.Operator operator, boolean caseSensitive) {
        Condition contextTypesCondition = new Condition(Condition.Operator.OR);
        List contextTypes = this.typeService.getContextTypes();
        for (Type contextType : contextTypes) {
            if ("sas:tenant".equals(contextType.getId())) continue;
            contextTypesCondition.addConstraint((Constraint)Comparison.comparison((Column)column, (Comparison.Operator)operator, (Serializable)((Object)contextType.getId()), (boolean)caseSensitive));
        }
        return contextTypesCondition;
    }

    private Condition getFileTypesCondition(Column column, Comparison.Operator operator, boolean caseSensitive) {
        Condition fileTypesCondition = new Condition(Condition.Operator.OR);
        List types = this.typeService.getTypes();
        for (Type type : types) {
            if (!type.isFileType()) continue;
            fileTypesCondition.addConstraint((Constraint)Comparison.comparison((Column)column, (Comparison.Operator)operator, (Serializable)((Object)type.getId()), (boolean)caseSensitive));
        }
        return fileTypesCondition;
    }

    private void doUpdateConstraintForType(Constraint c, Constraint p, Column typeColumn) {
        if (c instanceof Condition) {
            this.doUpdateConditionForType((Condition)c, p, typeColumn);
        } else if (c instanceof Comparison) {
            this.doUpdateComparisonForType((Comparison)c, p, typeColumn);
        }
    }

    private void doUpdateConditionForType(Condition p, Constraint parentConstraint, Column typeColumn) {
        Condition newParent = null;
        if (parentConstraint == null) {
            this.rootConstraint = new Condition(p.getOperator());
            newParent = (Condition)this.rootConstraint;
        } else if (parentConstraint instanceof Condition) {
            newParent = new Condition(p.getOperator());
            ((Condition)parentConstraint).addConstraint((Constraint)newParent);
        }
        Iterator it = p.getConstraints().iterator();
        while (it.hasNext()) {
            Constraint c = (Constraint)it.next();
            this.doUpdateConstraintForType(c, (Constraint)newParent, typeColumn);
            if (it.hasNext()) continue;
            return;
        }
    }

    private void doUpdateComparisonForType(Comparison comparison, Constraint parentConstraint, Column column) {
        Comparison c = comparison;
        if (comparison.getColumn().equals((Object)column) && (comparison.getOperator().equals((Object)Comparison.Operator.EQUAL) || comparison.getOperator().equals((Object)Comparison.Operator.NOT_EQUAL)) && comparison.getValue() != null) {
            c = this.getUpdatedConstraint(comparison);
        }
        if (parentConstraint == null) {
            this.rootConstraint = this.getUpdatedConstraint(comparison);
        }
        if (parentConstraint instanceof Condition) {
            ((Condition)parentConstraint).addConstraint((Constraint)c);
        }
    }

    private Constraint getUpdatedConstraint(Comparison comparison) {
        Comparison ret = comparison;
        if (comparison.getValue() != null) {
            if (comparison.getValue().equals("sas:context")) {
                this.typeConstraintNeedsUpdating = true;
                ret = this.getContextTypesCondition(comparison.getColumn(), comparison.getOperator(), comparison.isCaseSensitive());
            } else if (comparison.getValue().equals("sas:file")) {
                ret = this.getFileTypesCondition(comparison.getColumn(), comparison.getOperator(), comparison.isCaseSensitive());
                this.typeConstraintNeedsUpdating = true;
            }
        }
        return ret;
    }

    private static List<Comparison> doGetComparisonsFromConstraint(Constraint constraint, List<Comparison> comparisons) {
        if (constraint == null) {
            return comparisons;
        }
        if (constraint instanceof Comparison) {
            comparisons.add((Comparison)constraint);
        } else if (constraint instanceof Condition) {
            Condition condition = (Condition)constraint;
            List constraints = condition.getConstraints();
            for (Constraint c : constraints) {
                comparisons.addAll(SqlQueryHelper.doGetComparisonsFromConstraint(c, comparisons));
            }
        }
        return comparisons;
    }

    private static void validateNumericValue(Comparison c) {
        try {
            ValidationUtils.getValidNumericAttributeValue((String)c.getColumn().getName(), (Object)c.getValue());
        }
        catch (com.sas.lsaf.svcs.core.validation.client.ValidationException ve) {
            String intro = "A " + c.getValue().getClass().getName() + " value";
            if (c.getValue() instanceof String) {
                intro = "The String value '" + (String)((Object)c.getValue()) + "'";
            }
            throw new ValidationException(intro + " is not a valid comparison value for " + c.getColumn().getQueryClass() + " column " + c.getColumn().getName().toUpperCase() + " which is of type " + c.getColumn().getType() + ".");
        }
    }

    private static void validateBooleanValue(Comparison c) {
        Serializable val = c.getValue();
        if (!(val instanceof Boolean)) {
            String intro = "A " + c.getValue().getClass().getName() + " value";
            if (val instanceof String && !SqlQueryHelper.isValidBooleanString((String)((Object)val))) {
                intro = "The String value '" + (String)((Object)val) + "'";
            }
            throw new ValidationException(intro + " is not a valid comparison value for " + c.getColumn().getQueryClass() + " column " + c.getColumn().getName().toUpperCase() + " which is of type BOOLEAN.");
        }
    }

    private static boolean isValidBooleanString(String val) {
        return "true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val);
    }

    private static void validateEnumValue(Comparison c) {
        Serializable val = c.getValue();
        if (!(val instanceof Enum) && !(val instanceof String)) {
            throw new ValidationException("A " + val.getClass().getName() + " value is not a valid comparison value for " + c.getColumn().getQueryClass() + " column " + c.getColumn().getName().toUpperCase() + " which is of type Enum.");
        }
        SqlQueryHelper.validateEnumColumnValues(c, val);
    }

    private static void validateEnumColumnValues(Comparison c, Serializable sVal) {
        String val = sVal.toString();
        boolean enumValueValid = false;
        if (c.getColumn().equals((Object)RepositoryFileQuery.SIGNING_STATUS)) {
            Object[] values;
            for (RepositoryFile.SigningStatus signingStatus : values = RepositoryFile.SigningStatus.values()) {
                if (!val.toUpperCase().equals(signingStatus.name())) continue;
                enumValueValid = true;
                break;
            }
            if (!enumValueValid) {
                throw new ValidationException("The String value '" + c.getValue() + "' is not a valid enum value for " + c.getColumn().getQueryClass() + " column " + c.getColumn().getName().toUpperCase() + ".  The valid values are: " + StringUtils.arrayToCommaDelimitedString((Object[])values));
            }
        } else if (c.getColumn().equals((Object)RepositoryItemQuery.STATE)) {
            Object[] values;
            for (RepositoryItem.State state : values = RepositoryItem.State.values()) {
                if (!val.toUpperCase().equals(state.name())) continue;
                enumValueValid = true;
                break;
            }
            if (!enumValueValid) {
                throw new ValidationException("The String value '" + c.getValue() + "' is not a valid enum value for " + c.getColumn().getQueryClass() + " column " + c.getColumn().getName().toUpperCase() + ".  The valid values are: " + StringUtils.arrayToCommaDelimitedString((Object[])values));
            }
        } else if (c.getColumn().equals((Object)AuditEntryQuery.AUDIT_ENTRY_MODE)) {
            Object[] values;
            for (AuditEntry.Mode mode : values = AuditEntry.Mode.values()) {
                if (!val.toUpperCase().equals(mode.name())) continue;
                enumValueValid = true;
                break;
            }
            if (!enumValueValid) {
                throw new ValidationException("The String value '" + c.getValue() + "' is not a valid enum value for " + c.getColumn().getQueryClass() + " column " + c.getColumn().getName().toUpperCase() + ".  The valid values are: " + StringUtils.arrayToCommaDelimitedString((Object[])values));
            }
        }
    }

    public static void parse(SqlQuery query) throws QueryException {
        SqlQueryHelper.doParseSelect(query);
        SqlQueryHelper.doParseFrom(query);
        SqlQueryHelper.doParseWhere(query, false);
        SqlQueryHelper.doParseOrderBy(query);
    }

    public static void parse(SqlQuery query, String groupBy) throws QueryException {
        SqlQueryHelper.doParseSelect(query);
        SqlQueryHelper.doParseFrom(query);
        SqlQueryHelper.doParseWhere(query, false);
        SqlQueryHelper.doParseGroupBy(query, groupBy);
        SqlQueryHelper.doParseOrderBy(query);
    }

    public static void parse(SqlQuery query, boolean duplicate) throws QueryException {
        SqlQueryHelper.doParseSelect(query);
        SqlQueryHelper.doParseFrom(query);
        SqlQueryHelper.doParseWhere(query, duplicate);
        SqlQueryHelper.doParseOrderBy(query);
    }

    public static void assertValidQuery(Query query) {
        SqlQueryHelper.assertValidQuery(query, true);
    }

    public static void assertValidQuery(Query query, boolean checkConstraints) {
        if (query != null) {
            Assert.notEmpty((Collection)query.getColumns(), (String)"Query columns are required.");
            if (checkConstraints) {
                Assert.notNull((Object)query.getConstraint(), (String)"Query constraint is required.");
            }
            if (query.getOrder() != null) {
                List order = query.getOrder();
                for (Order o : order) {
                    if (query.getColumns().contains(o.getColumn())) continue;
                    throw new ValidationException("Order column " + o.getColumn().getName().toUpperCase() + " must be one of the selected query columns.");
                }
            }
            Constraint constraint = query.getConstraint();
            List<Comparison> comparisons = new ArrayList<Comparison>();
            comparisons = SqlQueryHelper.doGetComparisonsFromConstraint(constraint, comparisons);
            for (Comparison comparison : comparisons) {
                if (!query.getColumns().contains(comparison.getColumn())) {
                    throw new ValidationException("Constraint column " + comparison.getColumn().getName().toUpperCase() + " must be one of the selected query columns.");
                }
                SqlQueryHelper.validateComparisonValues(comparison);
            }
        }
    }

    public List<Column> getConstraintColumnsNotInSelect(Query query) {
        ArrayList<Column> hideCols = new ArrayList<Column>();
        List<Comparison> comparisons = new ArrayList<Comparison>();
        comparisons = SqlQueryHelper.doGetComparisonsFromConstraint(query.getConstraint(), comparisons);
        for (Comparison constraint : comparisons) {
            if (query.getColumns().contains(constraint.getColumn())) continue;
            hideCols.add(constraint.getColumn());
        }
        return hideCols;
    }

    public Query resolveTypesInQuery(Query query, Column typeColumn) {
        Query ret = query;
        this.rootConstraint = null;
        this.typeConstraintNeedsUpdating = false;
        this.doUpdateConstraintForType(query.getConstraint(), null, typeColumn);
        if (this.typeConstraintNeedsUpdating && this.rootConstraint != null) {
            ret.setConstraint(this.rootConstraint);
        }
        return ret;
    }

    public static List<Comparison> getComparisonsFromConstraint(Constraint constraint) {
        ArrayList<Comparison> comparisons = new ArrayList<Comparison>();
        if (constraint == null) {
            return comparisons;
        }
        if (constraint instanceof Comparison) {
            comparisons.add((Comparison)constraint);
        } else if (constraint instanceof Condition) {
            Condition condition = (Condition)constraint;
            List constraints = condition.getConstraints();
            for (Constraint c : constraints) {
                comparisons.addAll(SqlQueryHelper.doGetComparisonsFromConstraint(c, comparisons));
            }
        }
        return comparisons;
    }

    public static Set<Column> getColumnsFromConstraints(Constraint constraint) {
        HashSet<Column> columns = new HashSet<Column>();
        if (constraint != null) {
            List<Comparison> comparisons = SqlQueryHelper.doGetComparisonsFromConstraint(constraint, new ArrayList<Comparison>());
            for (Comparison comparison : comparisons) {
                columns.add(comparison.getColumn());
            }
        }
        return columns;
    }

    public static void validateComparisonValues(Comparison c) {
        if (c != null && c.getValue() != null) {
            if (c.getColumn() != null) {
                Column.Type type = c.getColumn().getType();
                if (Column.Type.DATE.equals((Object)type) || Column.Type.LONG.equals((Object)type) || Column.Type.INTEGER.equals((Object)type)) {
                    SqlQueryHelper.validateNumericValue(c);
                } else if (Column.Type.BOOLEAN.equals((Object)c.getColumn().getType())) {
                    SqlQueryHelper.validateBooleanValue(c);
                } else if (Column.Type.ENUM.equals((Object)c.getColumn().getType())) {
                    SqlQueryHelper.validateEnumValue(c);
                }
            }
            if (!Comparison.Operator.LIKE.equals((Object)c.getOperator()) && !Comparison.Operator.NOT_LIKE.equals((Object)c.getOperator()) && (c.getValue().toString().contains("*") || c.getValue().toString().contains("?"))) {
                throw new ValidationException("Wildcards are only supported when using operator LIKE or NOT_LIKE.");
            }
        }
    }

    public int getPropertyDefinitionId(String id) {
        return this.xythosPropertyDefinitionManager.getPropertyDefinitionIdentifier(id);
    }
}

