/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.impl;

import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.Query;
import com.sas.lsaf.query.QueryException;
import com.sas.lsaf.query.impl.SqlColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.SqlParameterValue;

public class SqlQuery {
    private static final String DEFAULT_TEMPLATE_SQL = "SELECT @SELECT FROM @FROM WHERE @WHERE";
    private final Query query;
    private final Map<Column, SqlColumn> sqlColumns = new HashMap<Column, SqlColumn>();
    private final List<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
    private final StringBuilder sqlSelect = new StringBuilder();
    private final StringBuilder sqlFrom = new StringBuilder();
    private final StringBuilder sqlWhere = new StringBuilder();
    private final StringBuilder sqlGroupBy = new StringBuilder();
    private final StringBuilder sqlOrderBy = new StringBuilder();
    private final String name;
    private final String sqlTemplate;

    public SqlQuery(String name, Query query) {
        this.name = name;
        this.query = query;
        this.sqlTemplate = DEFAULT_TEMPLATE_SQL;
    }

    public SqlQuery(String name, Query query, String sqlTemplate) {
        this.name = name;
        this.query = query;
        this.sqlTemplate = sqlTemplate;
    }

    public void addSqlColumns(List<SqlColumn> sqlColumns) {
        for (SqlColumn sqlColumn : sqlColumns) {
            this.sqlColumns.put(sqlColumn.getColumn(), sqlColumn);
        }
    }

    public String getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public SqlColumn getSqlColumn(Column column) throws QueryException {
        SqlColumn sqlColumn = this.sqlColumns.get(column);
        if (sqlColumn == null) {
            throw new QueryException("The column '" + column.getName() + "' from query class '" + column.getQueryClass() + "' is being referenced in this query but is not a supported column for this query.");
        }
        return sqlColumn;
    }

    public List<SqlParameterValue> getParameters() {
        return this.parameters;
    }

    public StringBuilder getSqlSelect() {
        return this.sqlSelect;
    }

    public StringBuilder getSqlFrom() {
        return this.sqlFrom;
    }

    public StringBuilder getSqlWhere() {
        return this.sqlWhere;
    }

    public StringBuilder getSqlOrderBy() {
        return this.sqlOrderBy;
    }

    public StringBuilder getSqlGroupBy() {
        return this.sqlGroupBy;
    }

    public String generateSql() {
        String sql = new String(this.sqlTemplate);
        if (sql.contains("SELECT @SELECT")) {
            sql = this.sqlTemplate.replace("@SELECT", this.sqlSelect.toString());
            sql = sql.replace("SELECT ", "SELECT /*+ PARALLEL */ ");
        } else {
            sql = this.sqlSelect.length() > 0 ? this.sqlTemplate.replace(" @SELECT", ", " + this.sqlSelect.toString()) : this.sqlTemplate.replace(" @SELECT", this.sqlSelect.toString());
        }
        sql = sql.contains("FROM @FROM") ? sql.replace("@FROM", this.sqlFrom.toString()) : (this.sqlFrom.length() > 0 ? sql.replace(" @FROM", ", " + this.sqlFrom.toString()) : sql.replace(" @FROM", this.sqlFrom.toString()));
        sql = sql.contains("WHERE @WHERE") ? sql.replace("@WHERE", this.sqlWhere.toString()) : (this.sqlSelect.length() > 0 ? sql.replace(" @WHERE", " AND " + this.sqlWhere.toString()) : sql.replace(" @WHERE", this.sqlWhere.toString()));
        StringBuilder sb = new StringBuilder(sql);
        if (this.sqlGroupBy.length() > 0) {
            sb.append(" GROUP BY ");
            sb.append(this.sqlGroupBy.toString());
        }
        if (this.sqlOrderBy.length() > 0) {
            sb.append(" ORDER BY ");
            sb.append(this.sqlOrderBy.toString());
        }
        return sb.toString();
    }
}

