/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.impl;

import com.sas.lsaf.clinical.common.ClinicalHelper;
import com.sas.lsaf.content.repository.impl.RepositoryHelper;
import com.sas.lsaf.core.AccessDeniedException;
import com.sas.lsaf.query.ExtractFileCreateInfo;
import com.sas.lsaf.query.QueryException;
import com.sas.lsaf.query.impl.SqlQuery;
import com.sas.lsaf.query.impl.dao.ExtractDao;
import com.sas.lsaf.svcs.clinical.common.client.ExportFileCreateInfo;
import com.sas.lsaf.svcs.clinical.common.impl.ExportHelper;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryException;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceException;
import com.sas.lsaf.svcs.core.utils.client.IOUtils;
import com.sas.lsaf.svcs.core.utils.server.FileUtils;
import com.sas.lsaf.svcs.core.validation.server.ValidationUtils;
import com.sas.lsaf.svcs.security.authorization.client.AdministrativeModeService;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Required;

public final class ExtractHelper {
    private ExportHelper exportHelper;
    private AdministrativeModeService administrativeModeService;
    private ExtractDao extractDao;

    @Required
    public void setExportHelper(ExportHelper exportHelper) {
        this.exportHelper = exportHelper;
    }

    @Required
    public void setAdministrativeModeService(AdministrativeModeService administrativeModeService) {
        this.administrativeModeService = administrativeModeService;
    }

    @Required
    public void setExtractDao(ExtractDao extractDao) {
        this.extractDao = extractDao;
    }

    public String extract(SqlQuery query, ExtractFileCreateInfo info) throws QueryException {
        String string;
        FileInputStream in;
        block5: {
            ValidationUtils.validatePath((String)info.getPath());
            in = null;
            File f = null;
            try {
                f = this.extractDao.extractByQuery(query);
                in = new FileInputStream(f);
                string = this.exportHelper.createFile((InputStream)in, ExtractHelper.toServerExportFileCreateInfo(info), ".csv");
                if (f == null) break block5;
            }
            catch (RepositoryException | WorkspaceException | IOException e) {
                try {
                    throw new QueryException(e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    if (f != null) {
                        FileUtils.deleteQuietly((File)f);
                    }
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            FileUtils.deleteQuietly((File)f);
        }
        IOUtils.closeQuietly((Closeable)in);
        return string;
    }

    public String extract(InputStream in, ExtractFileCreateInfo info) throws RepositoryException, WorkspaceException, IOException {
        return this.exportHelper.createFile(in, ExtractHelper.toServerExportFileCreateInfo(info), ".csv");
    }

    public static ExportFileCreateInfo toServerExportFileCreateInfo(ExtractFileCreateInfo apiExtractInfo) {
        if (apiExtractInfo == null) {
            return null;
        }
        ExportFileCreateInfo info = new ExportFileCreateInfo(apiExtractInfo.getPath(), ClinicalHelper.toServerSourceLocation(apiExtractInfo.getLocation()));
        info.setEnableVersioning(apiExtractInfo.isEnableVersioning());
        info.setOverwrite(apiExtractInfo.isOverwrite());
        info.setComment(apiExtractInfo.getComment());
        info.setVersionType(RepositoryHelper.toServerVersionType(apiExtractInfo.getVersionType()));
        info.setCustomVersion(apiExtractInfo.getCustomVersion());
        info.setDescription(apiExtractInfo.getDescription());
        return info;
    }

    public void checkCurrentUserIsAdministrativeModeUser() {
        if (!this.administrativeModeService.isCurrentUserAdministrativeModeUser()) {
            throw new AccessDeniedException("You cannot perform this action.  The current user must be an administrative mode user.");
        }
    }
}

