/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query.audit.impl;

import com.sas.lsaf.core.AccessDeniedException;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.query.ExtractFileCreateInfo;
import com.sas.lsaf.query.Query;
import com.sas.lsaf.query.QueryException;
import com.sas.lsaf.query.audit.AuditEntryDetailQuery;
import com.sas.lsaf.query.audit.AuditEntryQuery;
import com.sas.lsaf.query.audit.AuditQueryService;
import com.sas.lsaf.query.impl.ExtractHelper;
import com.sas.lsaf.query.impl.SqlColumn;
import com.sas.lsaf.query.impl.SqlQuery;
import com.sas.lsaf.query.impl.SqlQueryHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryContext;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.content.repository.server.InternalRepositoryService;
import com.sas.lsaf.svcs.security.audit.client.AuditPrivileges;
import com.sas.lsaf.svcs.security.authorization.client.AuthorizationService;
import com.sas.lsaf.svcs.security.authorization.client.Securable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class AuditQueryServiceImpl
implements AuditQueryService {
    public static final List<SqlColumn> AUDIT_ENTRY_COLUMNS = new ArrayList<SqlColumn>();
    public static final List<SqlColumn> AUDIT_ENTRY_DETAIL_COLUMNS = new ArrayList<SqlColumn>();
    private ExtractHelper extractHelper;
    private SqlQueryHelper sqlQueryHelper;
    private AuthorizationService authorizationService;
    private InternalRepositoryService internalRepositoryService;
    public static final String AUDIT_ENTRY_SQL = "SELECT @SELECT FROM ((SELECT * FROM SAS_AUDIT WHERE @WHERE) UNION (SELECT * FROM SAS_SEC_AUDIT WHERE @WHERE))";
    public static final String AUDIT_ENTRY_DETAIL_SQL = "SELECT @SELECT FROM ((SELECT * FROM SAS_AUDIT SA  LEFT OUTER JOIN SAS_AUDIT_DETAIL SAD ON SA.ID=SAD.AUDIT_ID WHERE @WHERE) UNION (SELECT * FROM SAS_SEC_AUDIT SSA  LEFT OUTER JOIN SAS_SEC_AUDIT_DETAIL SSAD ON SSA.ID=SSAD.AUDIT_ID WHERE @WHERE))";

    @Required
    public void setExtractHelper(ExtractHelper extractHelper) {
        this.extractHelper = extractHelper;
    }

    @Required
    public void setSqlQueryHelper(SqlQueryHelper sqlQueryHelper) {
        this.sqlQueryHelper = sqlQueryHelper;
    }

    @Required
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Required
    public void setInternalRepositoryService(InternalRepositoryService internalRepositoryService) {
        this.internalRepositoryService = internalRepositoryService;
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeAuditEntryQuery(AuditEntryQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        try {
            this.checkAuditPrivilege();
            AuditEntryQuery q = (AuditEntryQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, AuditEntryQuery.AUDIT_ENTRY_SOURCE_TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createAuditEntryExtract", (Query)q, AUDIT_ENTRY_SQL);
            sqlQuery.addSqlColumns(AUDIT_ENTRY_COLUMNS);
            SqlQueryHelper.parse(sqlQuery, true);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    @Transactional(rollbackFor={QueryException.class})
    public String executeAuditEntryDetailQuery(AuditEntryDetailQuery query, ExtractFileCreateInfo file) throws QueryException {
        Assert.notNull((Object)query, (String)"Query is required.");
        Assert.notNull((Object)file, (String)"File information is required.");
        Assert.notNull((Object)file.getLocation(), (String)"Source location is required.");
        Assert.hasText((String)file.getPath(), (String)"Path is required.");
        SqlQueryHelper.assertValidQuery((Query)query);
        try {
            this.checkAuditPrivilege();
            AuditEntryDetailQuery q = (AuditEntryDetailQuery)this.sqlQueryHelper.resolveTypesInQuery((Query)query, AuditEntryQuery.AUDIT_ENTRY_SOURCE_TYPE_ID);
            SqlQuery sqlQuery = new SqlQuery("createAuditEntryDetailExtract", (Query)q, AUDIT_ENTRY_DETAIL_SQL);
            sqlQuery.addSqlColumns(AUDIT_ENTRY_COLUMNS);
            sqlQuery.addSqlColumns(AUDIT_ENTRY_DETAIL_COLUMNS);
            SqlQueryHelper.parse(sqlQuery, true);
            return this.extractHelper.extract(sqlQuery, file);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private void checkAuditPrivilege() throws RepositoryItemNotFoundException {
        RepositoryContext tenant = this.internalRepositoryService.internalGetContextByPath("/");
        if (!this.authorizationService.hasPrivilege((Securable)tenant, AuditPrivileges.PRIVILEGE_AUDIT_REPORTING)) {
            throw new AccessDeniedException("You cannot perform this action. You have not been granted the privilege " + AuditPrivileges.PRIVILEGE_AUDIT_REPORTING.getName() + ".");
        }
    }

    static {
        AUDIT_ENTRY_COLUMNS.add(new SqlColumn(AuditEntryQuery.AUDIT_ENTRY_ID, 12, "ID"));
        AUDIT_ENTRY_COLUMNS.add(new SqlColumn(AuditEntryQuery.AUDIT_ENTRY_TIMESTAMP, 2, "STAMP"));
        AUDIT_ENTRY_COLUMNS.add(new SqlColumn(AuditEntryQuery.AUDIT_ENTRY_USERID, 12, "USERID"));
        AUDIT_ENTRY_COLUMNS.add(new SqlColumn(AuditEntryQuery.AUDIT_ENTRY_ACTION, 12, "ACTION"));
        AUDIT_ENTRY_COLUMNS.add(new SqlColumn(AuditEntryQuery.AUDIT_ENTRY_SOURCE_TYPE_ID, 12, "SOURCE_TYPE"));
        AUDIT_ENTRY_COLUMNS.add(new SqlColumn(AuditEntryQuery.AUDIT_ENTRY_SOURCE_ID, 12, "SOURCE_ID"));
        AUDIT_ENTRY_COLUMNS.add(new SqlColumn(AuditEntryQuery.AUDIT_ENTRY_SOURCE_NAME, 12, "SOURCE_NAME"));
        AUDIT_ENTRY_COLUMNS.add(new SqlColumn(AuditEntryQuery.AUDIT_ENTRY_SOURCE_LOCATION, 12, "SOURCE_LOCATION"));
        AUDIT_ENTRY_COLUMNS.add(new SqlColumn(AuditEntryQuery.AUDIT_ENTRY_MODE, 12, "CASE UMODE WHEN 0 THEN 'USER' WHEN 1 THEN 'SYSTEM' ELSE 'ADMIN' END"));
        AUDIT_ENTRY_DETAIL_COLUMNS.add(new SqlColumn(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_ID, 2, "DETAIL_ID"));
        AUDIT_ENTRY_DETAIL_COLUMNS.add(new SqlColumn(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_ATTRIBUTE_ID, 12, "ATTRIBUTE_ID"));
        AUDIT_ENTRY_DETAIL_COLUMNS.add(new SqlColumn(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_ATTRIBUTE_TYPE, 12, "ATTRIBUTE_TYPE"));
        AUDIT_ENTRY_DETAIL_COLUMNS.add(new SqlColumn(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_ATTRIBUTE_NAME, 12, "ATTRIBUTE"));
        AUDIT_ENTRY_DETAIL_COLUMNS.add(new SqlColumn(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_OLD_VALUE, 12, "OLD_VALUE"));
        AUDIT_ENTRY_DETAIL_COLUMNS.add(new SqlColumn(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_NEW_VALUE, 12, "NEW_VALUE"));
    }
}

