/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.messaging.subscription.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.messaging.subscription.Subscription;
import com.sas.lsaf.messaging.subscription.SubscriptionEvent;
import com.sas.lsaf.messaging.subscription.SubscriptionException;
import com.sas.lsaf.messaging.subscription.SubscriptionService;
import com.sas.lsaf.messaging.subscription.impl.SubscriptionHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryService;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryPathNotFoundException;
import com.sas.lsaf.svcs.core.utils.client.CollectionUtils;
import java.io.Serializable;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class SubscriptionServiceImpl
implements SubscriptionService {
    private com.sas.lsaf.svcs.messaging.subscription.client.SubscriptionService subscriptionService;
    private RepositoryService repositoryService;

    @Required
    public void setSubscriptionService(com.sas.lsaf.svcs.messaging.subscription.client.SubscriptionService service) {
        this.subscriptionService = service;
    }

    @Required
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public Set<Subscription> getSubscriptionsByPath(String path) throws SubscriptionException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.repositoryService.getByPath(path);
            return SubscriptionHelper.toApiSubscriptions(this.subscriptionService.getSubscriptionsByPaths(CollectionUtils.asSet((Object[])new String[]{path})));
        }
        catch (RepositoryItemNotFoundException e) {
            throw new SubscriptionException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Subscription> setSubscriptions(String path, Set<SubscriptionEvent> events) throws SubscriptionException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.repositoryService.getByPath(path);
            return SubscriptionHelper.toApiSubscriptions(CollectionUtils.asSerializableList((Serializable[])new com.sas.lsaf.svcs.messaging.subscription.client.Subscription[]{this.subscriptionService.setSubscriptionByPathAndEvents(path, SubscriptionHelper.toServerSubscribableEvents(events))}));
        }
        catch (RepositoryPathNotFoundException e) {
            throw new SubscriptionException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Subscription> getSubscriptions() {
        try {
            return SubscriptionHelper.toApiSubscriptions(this.subscriptionService.getSubscriptions());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

