/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.messaging.subscription.impl;

import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.messaging.subscription.Subscription;
import com.sas.lsaf.messaging.subscription.SubscriptionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SubscriptionHelper {
    private static SubscriptionEvent toApiSubscriptionEvent(String serverSubscribableEvent) {
        if (serverSubscribableEvent != null) {
            if (serverSubscribableEvent.equals("JobScheduledExecuteStartPostEvent")) {
                return SubscriptionEvent.SCHEDULED_JOB_START_EVENT;
            }
            if (serverSubscribableEvent.equals("JobExecuteStartPostEvent")) {
                return SubscriptionEvent.JOB_START_EVENT;
            }
            if (serverSubscribableEvent.equals("JobExecuteFailedPostEvent")) {
                return SubscriptionEvent.JOB_FAILED_EVENT;
            }
            if (serverSubscribableEvent.equals("RepositoryFileSignPostEvent")) {
                return SubscriptionEvent.SIGN_EVENT;
            }
            if (serverSubscribableEvent.equals("RepositoryFileLockPostEvent")) {
                return SubscriptionEvent.LOCK_EVENT;
            }
            if (serverSubscribableEvent.equals("RepositoryFileUnlockPostEvent")) {
                return SubscriptionEvent.UNLOCK_EVENT;
            }
        }
        return null;
    }

    private static String toServerSubscribableEvent(SubscriptionEvent apiSubscribableEvent) {
        if (apiSubscribableEvent == null) {
            return null;
        }
        switch (apiSubscribableEvent) {
            case JOB_FAILED_EVENT: {
                return "JobExecuteFailedPostEvent";
            }
            case JOB_START_EVENT: {
                return "JobExecuteStartPostEvent";
            }
            case SCHEDULED_JOB_START_EVENT: {
                return "JobScheduledExecuteStartPostEvent";
            }
            case LOCK_EVENT: {
                return "RepositoryFileLockPostEvent";
            }
            case UNLOCK_EVENT: {
                return "RepositoryFileUnlockPostEvent";
            }
            case SIGN_EVENT: {
                return "RepositoryFileSignPostEvent";
            }
        }
        throw new SystemException("Unmapped subscribable event: " + apiSubscribableEvent.name());
    }

    public static Set<String> toServerSubscribableEvents(Set<SubscriptionEvent> apiEvents) {
        if (apiEvents != null) {
            HashSet<String> serverSubscribableEvents = new HashSet<String>();
            for (SubscriptionEvent apiEvent : apiEvents) {
                serverSubscribableEvents.add(SubscriptionHelper.toServerSubscribableEvent(apiEvent));
            }
            return serverSubscribableEvents;
        }
        return null;
    }

    private static Set<Subscription> toApiSubscriptionsFromSubscription(com.sas.lsaf.svcs.messaging.subscription.client.Subscription serverSubscription) {
        HashSet<Subscription> apiSubs = new HashSet<Subscription>();
        if (serverSubscription != null) {
            for (String serverEvent : serverSubscription.getEvents()) {
                apiSubs.add(new Subscription(serverSubscription.getLocation(), SubscriptionHelper.toApiSubscriptionEvent(serverEvent)));
            }
            return apiSubs;
        }
        return apiSubs;
    }

    public static Set<Subscription> toApiSubscriptions(List<com.sas.lsaf.svcs.messaging.subscription.client.Subscription> serverSubscriptions) {
        HashSet<Subscription> apiSubscriptions = new HashSet<Subscription>();
        for (com.sas.lsaf.svcs.messaging.subscription.client.Subscription serverSub : serverSubscriptions) {
            apiSubscriptions.addAll(SubscriptionHelper.toApiSubscriptionsFromSubscription(serverSub));
        }
        return apiSubscriptions;
    }
}

