/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.session.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.execution.session.EngineType;
import com.sas.lsaf.execution.session.Session;
import com.sas.lsaf.execution.session.SessionException;
import com.sas.lsaf.execution.session.SessionNotFoundException;
import com.sas.lsaf.execution.session.SessionQuery;
import com.sas.lsaf.execution.session.SessionSearchException;
import com.sas.lsaf.execution.session.SessionSearchResults;
import com.sas.lsaf.execution.session.SessionService;
import com.sas.lsaf.execution.session.impl.SessionHelper;
import com.sas.lsaf.svcs.content.workspace.client.WorkspaceFile;
import com.sas.lsaf.svcs.content.workspace.client.WorkspaceService;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemCopyException;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemExistsException;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException;
import com.sas.lsaf.svcs.execution.session.client.Session;
import com.sas.lsaf.svcs.execution.session.client.SessionFileViewerService;
import com.sas.lsaf.svcs.execution.session.client.exception.SessionReleaseException;
import com.sas.lsaf.svcs.execution.session.client.query.SessionSearchService;
import com.sas.lsaf.svcs.execution.session.server.InternalSessionService;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class SessionServiceImpl
implements SessionService {
    private com.sas.lsaf.svcs.execution.session.client.SessionService sessionService;
    private SessionSearchService sessionSearchService;
    private InternalSessionService internalSessionService;
    private SessionFileViewerService sessionFileViewerService;
    private WorkspaceService workspaceService;
    public static int FILE_SIZE_CONTENTS_LIMIT = 0x500000;

    private String getSessionIdForEngine(String id, EngineType engineType) throws SessionException {
        try {
            com.sas.lsaf.svcs.execution.session.client.Session session = this.sessionService.getSession(id);
            if (session.getEngine() != Session.SessionEngine.COMPOSITE) {
                if (engineType == EngineType.R && session.getEngine() == Session.SessionEngine.R || engineType == EngineType.SAS && session.getEngine() == Session.SessionEngine.SAS) {
                    return session.getId();
                }
                throw new SessionException("Session engine specified, " + engineType + ", is not valid for the session id.");
            }
            Set<Session> childSessions = SessionHelper.toApiSessions(this.internalSessionService.internalGetChildSessions(id));
            for (Session childSession : childSessions) {
                if ((engineType != EngineType.R || childSession.getEngine() != Session.SessionEngine.R) && (engineType != EngineType.SAS || childSession.getEngine() != Session.SessionEngine.SAS)) continue;
                return childSession.getId();
            }
            return null;
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
    }

    @Required
    public void setSessionService(com.sas.lsaf.svcs.execution.session.client.SessionService sessionService) {
        this.sessionService = sessionService;
    }

    @Required
    public void setSessionSearchService(SessionSearchService sessionSearchService) {
        this.sessionSearchService = sessionSearchService;
    }

    @Required
    public void setInternalSessionService(InternalSessionService internalSessionService) {
        this.internalSessionService = internalSessionService;
    }

    @Required
    public void setSessionFileViewerService(SessionFileViewerService sessionFileViewerService) {
        this.sessionFileViewerService = sessionFileViewerService;
    }

    @Required
    public void setWorkspaceService(WorkspaceService workspaceService) {
        this.workspaceService = workspaceService;
    }

    public Session endSession(String id) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        try {
            return SessionHelper.toApiSession(this.sessionService.endSession(id));
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void deleteSession(String id) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        try {
            this.sessionService.releaseSession(id);
            try {
                com.sas.lsaf.svcs.execution.session.client.Session s = this.sessionService.getSession(id);
                if (s != null) {
                    this.sessionService.terminateSessionInEndingState(s.getId(), true);
                }
            }
            catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException s) {}
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (SessionReleaseException e) {
            throw new SessionException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void deleteSessions(Set<String> ids) {
        Assert.notNull(ids, (String)"Session ids are required.");
        try {
            for (String id : ids) {
                try {
                    this.deleteSession(id);
                }
                catch (SessionException sessionException) {}
            }
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Session getSession(String id) throws SessionNotFoundException {
        Assert.hasText((String)id, (String)"Session id is required.");
        try {
            return SessionHelper.toApiSession(this.sessionService.getSession(id));
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Session> getAllSessions() {
        HashSet<Session> sessions = new HashSet();
        try {
            sessions = SessionHelper.toApiSessions(this.sessionService.getAllSessions());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return sessions;
    }

    public Set<Session> getCurrentUserSessions() {
        HashSet<Session> sessions = new HashSet();
        try {
            sessions = SessionHelper.toApiSessions(this.sessionService.getCurrentUserSessions());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return sessions;
    }

    public String getLogFileContents(String id) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        try {
            WorkspaceFile wf = this.sessionService.getLogFile(id);
            if (wf.getSize() > (long)FILE_SIZE_CONTENTS_LIMIT) {
                throw new IllegalArgumentException("File string methods are limited to contents that are less than or equal to 5 megabytes.");
            }
            return new String(this.sessionFileViewerService.getLogFileBytes(id, 0L, FILE_SIZE_CONTENTS_LIMIT));
        }
        catch (WorkspaceItemNotFoundException e) {
            throw new SessionException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String getLogFileContentsForEngine(String id, EngineType engineType) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        Assert.notNull((Object)engineType, (String)"Engine type is required.");
        try {
            String sessionId = this.getSessionIdForEngine(id, engineType);
            if (sessionId != null) {
                return this.getLogFileContents(sessionId);
            }
            throw new SessionException("Session could not be found with the id and engine specified.");
        }
        catch (SessionNotFoundException e) {
            throw e;
        }
        catch (SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String getResultsFileContents(String id) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        try {
            WorkspaceFile wf = this.sessionService.getResultsFile(id);
            if (wf.getSize() > (long)FILE_SIZE_CONTENTS_LIMIT) {
                throw new IllegalArgumentException("File string methods are limited to contents that are less than or equal to 5 megabytes.");
            }
            return new String(this.sessionFileViewerService.getResultsFileBytes(id, 0L, FILE_SIZE_CONTENTS_LIMIT));
        }
        catch (WorkspaceItemNotFoundException e) {
            throw new SessionException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getLogFileSize(String id) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        try {
            WorkspaceFile wf = this.sessionService.getLogFile(id);
            return wf.getSize();
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (WorkspaceItemNotFoundException e) {
            throw new SessionException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getLogFileSizeForEngine(String id, EngineType engineType) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        Assert.notNull((Object)engineType, (String)"Engine type is required.");
        try {
            String sessionId = this.getSessionIdForEngine(id, engineType);
            if (sessionId != null) {
                WorkspaceFile wf = this.sessionService.getLogFile(sessionId);
                return wf.getSize();
            }
            throw new SessionException("Session could not be found with the id and engine specified.");
        }
        catch (SessionNotFoundException e) {
            throw e;
        }
        catch (SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String getResultsFileContentsForEngine(String id, EngineType engineType) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        Assert.notNull((Object)engineType, (String)"Engine type is required.");
        try {
            String sessionId = this.getSessionIdForEngine(id, engineType);
            if (sessionId != null) {
                return this.getResultsFileContents(sessionId);
            }
            throw new SessionException("Session could not be found with the id and engine specified.");
        }
        catch (SessionNotFoundException e) {
            throw e;
        }
        catch (SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getResultsFileSizeForEngine(String id, EngineType engineType) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        Assert.notNull((Object)engineType, (String)"Engine type is required.");
        try {
            String sessionId = this.getSessionIdForEngine(id, engineType);
            if (sessionId != null) {
                WorkspaceFile wf = this.sessionService.getResultsFile(sessionId);
                return wf.getSize();
            }
            throw new SessionException("Session could not be found with the id and engine specified.");
        }
        catch (SessionNotFoundException e) {
            throw e;
        }
        catch (SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getResultsFileSize(String id) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        try {
            WorkspaceFile wf = this.sessionService.getResultsFile(id);
            return wf.getSize();
        }
        catch (WorkspaceItemNotFoundException e) {
            throw new SessionException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Session> getSessionsByUser(String userId) {
        Assert.hasText((String)userId, (String)"Userid is required.");
        try {
            return SessionHelper.toApiSessions(this.sessionService.getSessionsByUser(userId));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String saveLogFileToCurrentUserWorkspace(String id, String logPath) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        Assert.hasText((String)logPath, (String)"Log path is required.");
        try {
            if (this.workspaceService.existsByPath(this.workspaceService.getCurrentUserWorkspace().getId(), logPath)) {
                throw new SessionException("Log file exists at the specified location.");
            }
            return this.sessionFileViewerService.saveLogFileAs(id, logPath).getPath();
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (WorkspaceItemCopyException | WorkspaceItemExistsException | WorkspaceItemNotFoundException e) {
            throw new SessionException(e.getLocalizedMessage());
        }
        catch (SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String saveLogFileForEngineToCurrentUserWorkspace(String id, EngineType engineType, String logPath) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        Assert.notNull((Object)engineType, (String)"Engine type is required.");
        Assert.hasText((String)logPath, (String)"Log path is required.");
        try {
            if (this.workspaceService.existsByPath(this.workspaceService.getCurrentUserWorkspace().getId(), logPath)) {
                throw new SessionException("Log file exists at the specified location.");
            }
            String sessionId = this.getSessionIdForEngine(id, engineType);
            if (sessionId != null) {
                return this.sessionFileViewerService.saveLogFileAs(sessionId, logPath).getPath();
            }
            throw new SessionException("Session could not be found with the id and engine specified.");
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (WorkspaceItemCopyException | WorkspaceItemExistsException | WorkspaceItemNotFoundException e) {
            throw new SessionException(e.getLocalizedMessage());
        }
        catch (SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String saveResultsFileToCurrentUserWorkspace(String id, String resultsPath) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        Assert.hasText((String)resultsPath, (String)"Listing path is required.");
        try {
            if (this.workspaceService.existsByPath(this.workspaceService.getCurrentUserWorkspace().getId(), resultsPath)) {
                throw new SessionException("Results file exists at the specified location.");
            }
            return this.sessionFileViewerService.saveResultsFileAs(id, resultsPath).getPath();
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (WorkspaceItemCopyException | WorkspaceItemExistsException | WorkspaceItemNotFoundException e) {
            throw new SessionException(e.getLocalizedMessage());
        }
        catch (SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String saveResultsFileForEngineToCurrentUserWorkspace(String id, EngineType engineType, String resultsPath) throws SessionNotFoundException, SessionException {
        Assert.hasText((String)id, (String)"Session id is required.");
        Assert.notNull((Object)engineType, (String)"Engine type is required.");
        Assert.hasText((String)resultsPath, (String)"Results path is required.");
        try {
            if (this.workspaceService.existsByPath(this.workspaceService.getCurrentUserWorkspace().getId(), resultsPath)) {
                throw new SessionException("Results file exists at the specified location.");
            }
            String sessionId = this.getSessionIdForEngine(id, engineType);
            if (sessionId != null) {
                return this.sessionFileViewerService.saveResultsFileAs(sessionId, resultsPath).getPath();
            }
            throw new SessionException("Session could not be found with the id and engine specified.");
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException e) {
            throw new SessionNotFoundException(e.getLocalizedMessage());
        }
        catch (WorkspaceItemCopyException | WorkspaceItemExistsException | WorkspaceItemNotFoundException e) {
            throw new SessionException(e.getLocalizedMessage());
        }
        catch (SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public SessionSearchResults search(SessionQuery query) throws SessionSearchException {
        Assert.notNull((Object)query, (String)"Session query is required.");
        try {
            return SessionHelper.toApiSessionSearchResults(this.sessionSearchService.search(SessionHelper.toServerSessionQuery(query)));
        }
        catch (com.sas.lsaf.svcs.execution.session.client.exception.SessionSearchException e) {
            throw new SessionSearchException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

