/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.session.impl;

import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.execution.session.Session;
import com.sas.lsaf.execution.session.SessionQuery;
import com.sas.lsaf.execution.session.SessionSearchResults;
import com.sas.lsaf.svcs.execution.session.client.Session;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SessionHelper {
    public static Session toApiSession(com.sas.lsaf.svcs.execution.session.client.Session serverSession) {
        if (serverSession == null) {
            return null;
        }
        Session sasSession = new Session(serverSession.getTypeId(), serverSession.getId(), serverSession.getDateStarted(), serverSession.getDateEnded(), SessionHelper.toApiSessionType(serverSession.getType()), SessionHelper.toApiSessionState(serverSession.getState()), serverSession.getUserId(), serverSession.getSubmissionName(), serverSession.getClientId(), SessionHelper.toApiSessionEngine(serverSession.getEngine()), serverSession.getLogErrors(), serverSession.getLogWarnings());
        return sasSession;
    }

    public static Set<Session> toApiSessions(List<com.sas.lsaf.svcs.execution.session.client.Session> serverSessions) {
        if (serverSessions == null) {
            return null;
        }
        HashSet<Session> sessions = new HashSet<Session>();
        for (com.sas.lsaf.svcs.execution.session.client.Session serverSession : serverSessions) {
            sessions.add(SessionHelper.toApiSession(serverSession));
        }
        return sessions;
    }

    private static Session.SessionType toApiSessionType(Session.SessionType serverSessionType) {
        if (serverSessionType == null) {
            return null;
        }
        switch (serverSessionType) {
            case BATCH_PUBLISHED: {
                return Session.SessionType.PUBLISHED_JOB;
            }
            case BATCH: {
                return Session.SessionType.WORKSPACE_JOB;
            }
            case INTERACTIVE: {
                return Session.SessionType.INTERACTIVE;
            }
            case BATCH_SYSTEM: {
                return Session.SessionType.SYSTEM;
            }
            case BATCH_TEST: {
                return Session.SessionType.TEST_JOB;
            }
            case UNKNOWN: {
                return Session.SessionType.UNKNOWN;
            }
        }
        throw new SystemException("Unmapped server session type: " + serverSessionType.name());
    }

    private static Session.SessionType toServerSessionType(Session.SessionType apiSessionType) {
        if (apiSessionType == null) {
            return null;
        }
        switch (apiSessionType) {
            case PUBLISHED_JOB: {
                return Session.SessionType.BATCH_PUBLISHED;
            }
            case WORKSPACE_JOB: {
                return Session.SessionType.BATCH;
            }
            case INTERACTIVE: {
                return Session.SessionType.INTERACTIVE;
            }
            case SYSTEM: {
                return Session.SessionType.BATCH_SYSTEM;
            }
            case TEST_JOB: {
                return Session.SessionType.BATCH_TEST;
            }
            case UNKNOWN: {
                return Session.SessionType.UNKNOWN;
            }
        }
        throw new SystemException("Unmapped api session type: " + apiSessionType.name());
    }

    private static Session.SessionEngine toApiSessionEngine(Session.SessionEngine serverSessionEngine) {
        if (serverSessionEngine == null) {
            return null;
        }
        switch (serverSessionEngine) {
            case SAS: {
                return Session.SessionEngine.SAS;
            }
            case R: {
                return Session.SessionEngine.R;
            }
            case COMPOSITE: {
                return Session.SessionEngine.COMPOSITE;
            }
        }
        throw new SystemException("Unmapped server session engine: " + serverSessionEngine.name());
    }

    private static Session.SessionEngine toServerSessionEngine(Session.SessionEngine apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case SAS: {
                return Session.SessionEngine.SAS;
            }
            case R: {
                return Session.SessionEngine.R;
            }
            case COMPOSITE: {
                return Session.SessionEngine.COMPOSITE;
            }
        }
        throw new SystemException("Unmapped api session engine: " + apiItem.name());
    }

    public static Session.SessionState toApiSessionState(Session.SessionState serverState) {
        if (serverState == null) {
            return null;
        }
        switch (serverState) {
            case ACTIVE: {
                return Session.SessionState.ACTIVE;
            }
            case BROKEN: {
                return Session.SessionState.BROKEN;
            }
            case ENDED: {
                return Session.SessionState.ENDED;
            }
            case ENDING: {
                return Session.SessionState.ENDING;
            }
            case IDLE: {
                return Session.SessionState.IDLE;
            }
        }
        throw new SystemException("Unmapped server session state: " + serverState.name());
    }

    private static Session.SessionState toServerSessionState(Session.SessionState apiState) {
        if (apiState == null) {
            return null;
        }
        switch (apiState) {
            case ACTIVE: {
                return Session.SessionState.ACTIVE;
            }
            case BROKEN: {
                return Session.SessionState.BROKEN;
            }
            case ENDED: {
                return Session.SessionState.ENDED;
            }
            case ENDING: {
                return Session.SessionState.ENDING;
            }
            case IDLE: {
                return Session.SessionState.IDLE;
            }
        }
        throw new SystemException("Unmapped api session state: " + apiState.name());
    }

    public static com.sas.lsaf.svcs.execution.session.client.query.SessionQuery toServerSessionQuery(SessionQuery apiItem) {
        if (apiItem == null) {
            return null;
        }
        com.sas.lsaf.svcs.execution.session.client.query.SessionQuery serverQuery = new com.sas.lsaf.svcs.execution.session.client.query.SessionQuery();
        serverQuery.setEngine(SessionHelper.toServerSessionEngine(apiItem.getEngine()));
        serverQuery.setFromDateEnded(apiItem.getFromDateEnded());
        serverQuery.setToDateEnded(apiItem.getToDateEnded());
        serverQuery.setLimit(apiItem.getLimit());
        serverQuery.setState(SessionHelper.toServerSessionState(apiItem.getState()));
        serverQuery.setSubmissionName(apiItem.getSubmissionLabel());
        serverQuery.setToDateStarted(apiItem.getToDateStarted());
        serverQuery.setFromDateStarted(apiItem.getFromDateStarted());
        serverQuery.setType(SessionHelper.toServerSessionType(apiItem.getType()));
        serverQuery.setUserId(apiItem.getUserId());
        return serverQuery;
    }

    public static SessionSearchResults toApiSessionSearchResults(com.sas.lsaf.svcs.execution.session.client.query.SessionSearchResults serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new SessionSearchResults(SessionHelper.toApiSessions(serverItem.getSessions()), serverItem.isLimitReached());
    }
}

