/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.job.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.execution.job.JobSubmission;
import com.sas.lsaf.execution.job.JobSubmissionNotFoundException;
import com.sas.lsaf.execution.job.JobSubmissionService;
import com.sas.lsaf.execution.job.JobSubmissionStatus;
import com.sas.lsaf.execution.job.Manifest;
import com.sas.lsaf.execution.job.ParameterValue;
import com.sas.lsaf.execution.job.ResultsNotFoundException;
import com.sas.lsaf.execution.job.impl.JobHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryService;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.content.resource.server.ResourceUtils;
import com.sas.lsaf.svcs.core.utils.client.Assert;
import com.sas.lsaf.svcs.core.validation.server.ValidationUtils;
import com.sas.lsaf.svcs.execution.job.client.JobManifest;
import com.sas.lsaf.svcs.execution.job.client.exception.JobResultsFormatException;
import com.sas.lsaf.svcs.execution.job.client.exception.JobResultsNotFoundException;
import com.sas.lsaf.svcs.execution.session.client.SessionService;
import com.sas.lsaf.svcs.execution.session.client.exception.SessionNotFoundException;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;

public class JobSubmissionServiceImpl
implements JobSubmissionService {
    private com.sas.lsaf.svcs.execution.job.client.JobSubmissionService jobSubmissionService;
    private SessionService sessionService;
    private RepositoryService repositoryService;

    @Required
    public void setJobSubmissionService(com.sas.lsaf.svcs.execution.job.client.JobSubmissionService jobSubmissionService) {
        this.jobSubmissionService = jobSubmissionService;
    }

    @Required
    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    @Required
    public void setRepositoryService(RepositoryService service) {
        this.repositoryService = service;
    }

    private void doCheckRead(String jobPath) {
        try {
            this.repositoryService.getByPath(jobPath);
        }
        catch (RepositoryItemNotFoundException repositoryItemNotFoundException) {
            // empty catch block
        }
    }

    public JobSubmission submitWorkspaceJob(String jobPath, List<ParameterValue> parameterValues) {
        Assert.hasText((String)jobPath, (String)"Job path is required.");
        try {
            return JobHelper.toApiJobSubmission(this.jobSubmissionService.submitJobByUri(ResourceUtils.toWorkspaceUri((String)jobPath, null), JobHelper.toServerParameterValues(parameterValues)));
        }
        catch (ValidationException t) {
            throw new IllegalArgumentException(t.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public JobSubmission submitTestJob(String jobPath, List<ParameterValue> parameterValues) {
        Assert.hasText((String)jobPath, (String)"Job path is required.");
        try {
            return JobHelper.toApiJobSubmission(this.jobSubmissionService.submitTestJobByUri(ResourceUtils.toWorkspaceUri((String)jobPath, null), JobHelper.toServerParameterValues(parameterValues)));
        }
        catch (ValidationException t) {
            throw new IllegalArgumentException(t.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public JobSubmission submitRepositoryJob(String jobPath, String version, List<ParameterValue> parameterValues) {
        Assert.hasText((String)jobPath, (String)"Job path is required.");
        try {
            ValidationUtils.validateVersion((String)version, (boolean)false);
            return JobHelper.toApiJobSubmission(this.jobSubmissionService.submitJobByUri(ResourceUtils.toRepositoryUri((String)jobPath, null, (String)version), JobHelper.toServerParameterValues(parameterValues)));
        }
        catch (ValidationException t) {
            throw new IllegalArgumentException(t.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public JobSubmission getJobSubmission(String jobSubmissionId) throws JobSubmissionNotFoundException {
        Assert.hasText((String)jobSubmissionId, (String)"Job submission id is required.");
        try {
            return JobHelper.toApiJobSubmission(this.jobSubmissionService.getJobSubmission(jobSubmissionId));
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobSubmissionNotFoundException e) {
            throw new JobSubmissionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public JobSubmissionStatus getJobSubmissionStatus(String jobSubmissionId) throws JobSubmissionNotFoundException {
        Assert.hasText((String)jobSubmissionId, (String)"Job submission id is required.");
        try {
            return JobHelper.toApiJobSubmission(this.jobSubmissionService.getJobSubmission(jobSubmissionId)).getJobSubmissionStatus();
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobSubmissionNotFoundException e) {
            throw new JobSubmissionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public JobSubmission submitAndPopulateWorkspaceJob(String jobPath, List<ParameterValue> params, boolean useRelativePaths) {
        Assert.hasText((String)jobPath, (String)"Job path is required.");
        try {
            return JobHelper.toApiJobSubmission(this.jobSubmissionService.submitJobAndPopulate(ResourceUtils.toWorkspaceUri((String)jobPath, null), JobHelper.toServerParameterValues(params), useRelativePaths));
        }
        catch (ValidationException t) {
            throw new IllegalArgumentException(t.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public JobSubmission getJobSubmissionBySession(String sessionId) throws JobSubmissionNotFoundException {
        Assert.hasText((String)sessionId, (String)"Session id is required.");
        try {
            this.sessionService.getSession(sessionId);
            return JobHelper.toApiJobSubmission(this.jobSubmissionService.getJobSubmissionBySessionId(sessionId));
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobSubmissionNotFoundException | SessionNotFoundException e) {
            throw new JobSubmissionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Manifest getManifestByRepositoryPath(String path, String version) throws ResultsNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            JobHelper.validateManifestPathAndVersion(path, version);
            return JobHelper.toApiManifest(this.jobSubmissionService.getManifestByUri(ResourceUtils.toRepositoryUri((String)path, null, (String)(version != null ? version.trim() : null))));
        }
        catch (JobResultsFormatException | JobResultsNotFoundException e) {
            throw new ResultsNotFoundException(e.getLocalizedMessage());
        }
        catch (ValidationException t) {
            throw new IllegalArgumentException(t.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Manifest getManifestByWorkspacePath(String path) throws ResultsNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            JobHelper.validateManifestPath(path);
            return JobHelper.toApiManifest(this.jobSubmissionService.getManifestByUri(ResourceUtils.toWorkspaceUri((String)path, null)));
        }
        catch (JobResultsFormatException | JobResultsNotFoundException e) {
            throw new ResultsNotFoundException(e.getLocalizedMessage());
        }
        catch (ValidationException t) {
            throw new IllegalArgumentException(t.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public JobSubmission getLatestJobSubmissionByJobPath(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.doCheckRead(path);
            return JobHelper.toApiJobSubmission(this.jobSubmissionService.getLatestCompletedJobSubmissionByPath(path));
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobSubmissionNotFoundException e) {
            return null;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<JobSubmission> getJobSubmissionsByJobPath(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.doCheckRead(path);
            return JobHelper.toApiJobSubmissions(this.jobSubmissionService.getJobSubmissionsByPath(path));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Manifest getManifestByJobSubmission(String jobSubmissionId) throws ResultsNotFoundException {
        Assert.hasText((String)jobSubmissionId, (String)"JobSubmission id is required.");
        try {
            com.sas.lsaf.svcs.execution.job.client.JobSubmission js = this.jobSubmissionService.getJobSubmission(jobSubmissionId);
            if (js.getManifestUri() == null) {
                return null;
            }
            JobManifest serverMnf = this.jobSubmissionService.getManifestByUri(js.getManifestUri());
            return JobHelper.toApiManifest(serverMnf);
        }
        catch (JobResultsNotFoundException | com.sas.lsaf.svcs.execution.job.client.exception.JobSubmissionNotFoundException e) {
            throw new ResultsNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

