/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.job.impl;

import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.execution.job.InternalJobService;
import com.sas.lsaf.execution.job.Job;
import com.sas.lsaf.execution.job.JobCreateException;
import com.sas.lsaf.execution.job.JobExistsException;
import com.sas.lsaf.execution.job.JobFormatException;
import com.sas.lsaf.execution.job.JobNotFoundException;
import com.sas.lsaf.execution.job.JobParameter;
import com.sas.lsaf.execution.job.JobProgram;
import com.sas.lsaf.execution.job.JobService;
import com.sas.lsaf.execution.job.JobUpdateException;
import com.sas.lsaf.execution.job.impl.JobHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryExecutableFile;
import com.sas.lsaf.svcs.content.repository.client.RepositoryItem;
import com.sas.lsaf.svcs.content.repository.client.RepositoryService;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.content.resource.server.ResourceUtils;
import com.sas.lsaf.svcs.core.utils.client.Assert;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;

public class JobServiceImpl
implements JobService {
    private com.sas.lsaf.svcs.execution.job.client.JobService jobService;
    private InternalJobService internalJobService;
    private RepositoryService repositoryService;

    @Required
    public void setJobService(com.sas.lsaf.svcs.execution.job.client.JobService jobService) {
        this.jobService = jobService;
    }

    @Required
    public void setInternalJobService(InternalJobService internalJobService) {
        this.internalJobService = internalJobService;
    }

    @Required
    public void setRepositoryService(RepositoryService service) {
        this.repositoryService = service;
    }

    public Job getWorkspaceJob(String path) throws JobNotFoundException, JobFormatException {
        Assert.hasText((String)path, (String)"Job path is required.");
        try {
            JobHelper.validateJobPath(path);
            return JobHelper.toApiJob(this.jobService.loadJob(ResourceUtils.toWorkspaceUri((String)path, null)));
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobNotFoundException e) {
            throw new JobNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobFormatException e) {
            throw new JobFormatException(e.getLocalizedMessage());
        }
        catch (ValidationException t) {
            throw new IllegalArgumentException(t.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Job getRepositoryJob(String path, String version) throws JobNotFoundException, JobFormatException {
        Assert.hasText((String)path, (String)"Job path is required.");
        try {
            JobHelper.validateJobPathAndVersion(path, version);
            return JobHelper.toApiJob(this.jobService.loadJob(ResourceUtils.toRepositoryUri((String)path, null, (String)(version != null ? version.trim() : null))));
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobNotFoundException e) {
            throw new JobNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobFormatException e) {
            throw new JobFormatException(e.getLocalizedMessage());
        }
        catch (ValidationException t) {
            throw new IllegalArgumentException(t.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Job createWorkspaceJob(String parentPath, String name, List<JobProgram> programs, List<JobParameter> parameters, boolean createParents, boolean useRelativePaths) throws JobExistsException, JobCreateException {
        Assert.hasText((String)name, (String)"Job name is required.");
        Assert.hasText((String)parentPath, (String)"Parent path is required.");
        Assert.isTrue((boolean)parentPath.startsWith("/"), (String)"Path must start with slash.");
        Job job = new Job();
        job.setPath(parentPath + "/" + name);
        job.setPrograms(programs);
        job.setParameters(parameters);
        job.setSourceLocation(SourceLocation.WORKSPACE);
        return this.createWorkspaceJob(job, createParents, useRelativePaths);
    }

    public Job createWorkspaceJob(Job job, boolean createParents, boolean useRelativePaths) throws JobExistsException, JobCreateException {
        Assert.notNull((Object)job, (String)"Job is required.");
        Assert.hasText((String)job.getPath(), (String)"Job path is required.");
        Assert.isTrue((boolean)job.getPath().startsWith("/"), (String)"Path must start with slash.");
        try {
            return JobHelper.toApiJob(this.jobService.createJob(JobHelper.toServerCreateJob(job, null), createParents, useRelativePaths));
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobCreateException e) {
            throw new JobCreateException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobExistsException e) {
            throw new JobExistsException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Job createRepositoryJob(Job job, RepositoryCheckinSpecification spec, boolean createParents, boolean useRelativePaths) throws JobExistsException, JobCreateException {
        Assert.notNull((Object)job, (String)"Job is required.");
        Assert.hasText((String)job.getPath(), (String)"Job path is required.");
        Assert.isTrue((boolean)job.getPath().startsWith("/"), (String)"Path must start with slash.");
        try {
            job.setSourceLocation(SourceLocation.REPOSITORY);
            return JobHelper.toApiJob(this.jobService.createJob(JobHelper.toServerCreateJob(job, spec), createParents, useRelativePaths));
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobExistsException e) {
            throw new JobExistsException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobCreateException e) {
            throw new JobCreateException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Job updateRepositoryJob(Job job, RepositoryCheckinSpecification spec) throws JobNotFoundException, JobUpdateException {
        Assert.notNull((Object)job, (String)"Job is required.");
        try {
            String jobUri = this.internalJobService.internalUpdateJob(job, spec);
            return JobHelper.toApiJob(this.jobService.loadJob(jobUri));
        }
        catch (ValidationException | JobNotFoundException | JobUpdateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Job updateWorkspaceJob(Job job) throws JobNotFoundException, JobUpdateException {
        Assert.notNull((Object)job, (String)"Job  is required.");
        try {
            return JobHelper.toApiJob(this.jobService.updateJob(JobHelper.toServerJob(job, false)));
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobNotFoundException e) {
            throw new JobNotFoundException("Failed to update job because the specified job does not exist, message=" + e.getMessage());
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobUpdateException e) {
            throw new JobUpdateException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void setRunAsOwner(String jobPath, boolean value) throws JobNotFoundException {
        Assert.hasText((String)jobPath, (String)"Job path is required");
        try {
            RepositoryItem node = this.repositoryService.getByPath(jobPath);
            if (!(node instanceof RepositoryExecutableFile)) {
                throw new IllegalArgumentException("Path is not to a valid job file.");
            }
            RepositoryExecutableFile jobFile = (RepositoryExecutableFile)node;
            jobFile.setRunAsOwner(value);
            this.repositoryService.update((RepositoryItem)jobFile);
        }
        catch (RepositoryItemNotFoundException e) {
            throw new JobNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean getRunAsOwner(String jobPath) throws JobNotFoundException {
        Assert.notNull((Object)jobPath, (String)"Job is required");
        try {
            RepositoryItem node = this.repositoryService.getByPath(jobPath);
            if (!(node instanceof RepositoryExecutableFile)) {
                throw new IllegalArgumentException("Path is not to a valid job file.");
            }
            RepositoryExecutableFile jobFile = (RepositoryExecutableFile)node;
            return jobFile.isRunAsOwner();
        }
        catch (RepositoryItemNotFoundException e) {
            throw new JobNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

